/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.genlink.service;

import com.ibm.as400.access.AS400;
import com.ibm.teami.build.toolkit.genlink.filesystem.LogFactory;
import com.ibm.teami.build.toolkit.genlink.model.SrvpgmInfo;
import com.ibm.teami.build.toolkit.genlink.service.IPgmsrcGenerator;
import com.ibm.teami.build.toolkit.genlink.service.Messages;
import com.ibm.teami.build.toolkit.genlink.sysapi.AbstractBindListApi;
import com.ibm.teami.build.toolkit.genlink.sysapi.GetSrvpgmBndsrcApi;
import com.ibm.teami.build.toolkit.genlink.sysapi.GetSrvpgmBndsrvpgmListApi;
import com.ibm.teami.build.toolkit.genlink.sysapi.GetSrvpgmModListApi;
import org.eclipse.osgi.util.NLS;

public class SrvpgmsrcGenerator
implements IPgmsrcGenerator {
    private String fSrvpgmName;
    private AS400 fSystem;
    private int fRefLibReplace;
    SrvpgmInfo fSrvpgmInfo;

    @Override
    public void setRefLibReplacement(int libReplace) {
        this.fRefLibReplace = libReplace;
    }

    @Override
    public boolean mineData(AS400 system, String libName, String srvpgmName, String workingLib, boolean filterQsysBndsrvpgms) {
        this.fSrvpgmName = srvpgmName;
        this.fSystem = system;
        this.fSrvpgmInfo = this.retrieveAllSrvpgmInfo(this.fSystem, libName, this.fSrvpgmName, workingLib);
        if (filterQsysBndsrvpgms) {
            this.fSrvpgmInfo.removeBoundSrvpgm("QSYS      ");
        }
        if (this.fRefLibReplace == 0) {
            this.fSrvpgmInfo.replaceRefLibsLibl();
        } else if (this.fRefLibReplace == 1) {
            this.fSrvpgmInfo.replaceRefLibsObjlib();
        }
        return false;
    }

    @Override
    public void writeStmf(String outDir) {
        String outFile = String.valueOf(outDir) + this.fSrvpgmName + ".SRVPGMSRC";
        try {
            this.fSrvpgmInfo.writeToFile(outFile);
        }
        catch (Exception e) {
            LogFactory.getLog().println(String.valueOf(Messages.SrvpgmsrcGenerator_ErrorWritingToFile) + outFile);
        }
    }

    @Override
    public void writeMember(String outputLib, String outputSrcf) {
        try {
            this.fSrvpgmInfo.writeToMember(this.fSystem, outputLib, outputSrcf, this.fSrvpgmName);
        }
        catch (Exception e) {
            LogFactory.getLog().println(NLS.bind((String)Messages.SrvpgmsrcGenerator_ErrorWritingToFileMember, (Object[])new Object[]{String.valueOf(outputLib) + "/" + outputSrcf, this.fSrvpgmName}));
        }
    }

    public SrvpgmInfo retrieveAllSrvpgmInfo(AS400 system, String libName, String srvpgmName, String usrspcLib) {
        SrvpgmInfo srvpgmInfo = new SrvpgmInfo(libName, srvpgmName);
        GetSrvpgmBndsrcApi api1 = new GetSrvpgmBndsrcApi(system, libName, srvpgmName);
        GetSrvpgmBndsrcApi.QBNRSPGM_Info apiInfoBndsrc = api1.retrieveApiOutput();
        srvpgmInfo.addApiDataFromQBNRSPGM(apiInfoBndsrc);
        try {
            GetSrvpgmModListApi api2 = new GetSrvpgmModListApi(system, libName, srvpgmName, usrspcLib);
            AbstractBindListApi.BoundModuleInfo apiInfoModList = api2.retrieveModuleApiOutput();
            srvpgmInfo.addBoundModList(apiInfoModList);
        }
        catch (Exception e) {
            LogFactory.getLog().println(String.valueOf(Messages.SrvpgmsrcGenerator_ErrorFetchingModuleList) + libName + "/" + srvpgmName);
        }
        try {
            GetSrvpgmBndsrvpgmListApi api3 = new GetSrvpgmBndsrvpgmListApi(system, libName, srvpgmName, usrspcLib);
            AbstractBindListApi.BoundSrvpgmInfo apiInfoSrvpgmList = api3.retrieveSrvpgmApiOutput();
            srvpgmInfo.addBoundSrvpgmList(apiInfoSrvpgmList);
        }
        catch (Exception e) {
            LogFactory.getLog().println(String.valueOf(Messages.SrvpgmsrcGenerator_ErrorFetchingBndsrvpgmList) + libName + "/" + srvpgmName);
        }
        return srvpgmInfo;
    }
}

