/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.genlink.service;

import com.ibm.as400.access.AS400;
import com.ibm.teami.build.toolkit.genlink.filesystem.LogFactory;
import com.ibm.teami.build.toolkit.genlink.model.PgmInfo;
import com.ibm.teami.build.toolkit.genlink.service.IPgmsrcGenerator;
import com.ibm.teami.build.toolkit.genlink.service.Messages;
import com.ibm.teami.build.toolkit.genlink.sysapi.AbstractBindListApi;
import com.ibm.teami.build.toolkit.genlink.sysapi.GetPgmBndsrvpgmListApi;
import com.ibm.teami.build.toolkit.genlink.sysapi.GetPgmEntryModApi;
import com.ibm.teami.build.toolkit.genlink.sysapi.GetPgmModListApi;
import org.eclipse.osgi.util.NLS;

public class PgmsrcGenerator
implements IPgmsrcGenerator {
    private PgmInfo fPgmInfo;
    private String fPgmName;
    private int fRefLibReplace;
    AS400 fSystem;

    @Override
    public void setRefLibReplacement(int libReplace) {
        this.fRefLibReplace = libReplace;
    }

    @Override
    public boolean mineData(AS400 system, String libName, String pgmName, String workingLib, boolean filterQsysBndsrvpgms) {
        this.fPgmName = pgmName;
        this.fSystem = system;
        this.fPgmInfo = this.retrieveAllPgmInfo(this.fSystem, libName, pgmName, workingLib);
        if (filterQsysBndsrvpgms) {
            this.fPgmInfo.removeBoundSrvpgm("QSYS      ");
        }
        if (this.fRefLibReplace == 0) {
            this.fPgmInfo.replaceRefLibsLibl();
        } else if (this.fRefLibReplace == 1) {
            this.fPgmInfo.replaceRefLibsObjlib();
        }
        return this.fPgmInfo.isOpm();
    }

    @Override
    public void writeStmf(String outDir) {
        String outFile = String.valueOf(outDir) + this.fPgmName + ".PGMSRC";
        try {
            this.fPgmInfo.writeToFile(outFile);
        }
        catch (Exception e) {
            LogFactory.getLog().println(String.valueOf(Messages.PgmsrcGenerator_ErrorWritingToFile) + outFile);
        }
    }

    @Override
    public void writeMember(String outputLib, String outputSrcf) {
        try {
            this.fPgmInfo.writeToMember(this.fSystem, outputLib, outputSrcf, this.fPgmName);
        }
        catch (Exception e) {
            LogFactory.getLog().println(NLS.bind((String)Messages.PgmsrcGenerator_ErrorWritingtoFileMember, (Object[])new Object[]{String.valueOf(outputLib) + "/" + outputSrcf, this.fPgmName}));
        }
    }

    private PgmInfo retrieveAllPgmInfo(AS400 system, String libName, String pgmName, String usrspcLib) {
        PgmInfo pgmInfo = new PgmInfo(libName, pgmName);
        GetPgmEntryModApi api1 = new GetPgmEntryModApi(system, libName, pgmName);
        GetPgmEntryModApi.QCLRPGMI_Info apiInfoEntryMod = api1.retrieveApiOutput();
        pgmInfo.addApiDataFromQCLRPGMI(apiInfoEntryMod);
        if (pgmInfo.pgmType() == 0) {
            return pgmInfo;
        }
        try {
            GetPgmModListApi api2 = new GetPgmModListApi(system, libName, pgmName, usrspcLib);
            AbstractBindListApi.BoundModuleInfo apiInfoModList = api2.retrieveModuleApiOutput();
            pgmInfo.addBoundModList(apiInfoModList);
        }
        catch (Exception e) {
            LogFactory.getLog().println(String.valueOf(Messages.PgmsrcGenerator_ErrorFetchingModList) + libName + "/" + pgmName);
        }
        try {
            GetPgmBndsrvpgmListApi api3 = new GetPgmBndsrvpgmListApi(system, libName, pgmName, usrspcLib);
            AbstractBindListApi.BoundSrvpgmInfo apiInfoSrvpgmList = api3.retrieveSrvpgmApiOutput();
            pgmInfo.addBoundSrvpgmList(apiInfoSrvpgmList);
        }
        catch (Exception e) {
            LogFactory.getLog().println(String.valueOf(Messages.PgmsrcGenerator_ErrorFetchingBndsrvpgmList) + libName + "/" + pgmName);
        }
        return pgmInfo;
    }
}

