/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.genlink.model;

import com.ibm.as400.access.AS400;
import com.ibm.teami.build.toolkit.genlink.filesystem.IIbmiWriter;
import com.ibm.teami.build.toolkit.genlink.filesystem.IfsFileWriter;
import com.ibm.teami.build.toolkit.genlink.filesystem.Log;
import com.ibm.teami.build.toolkit.genlink.filesystem.LogFactory;
import com.ibm.teami.build.toolkit.genlink.filesystem.SourceMemberWriter;
import com.ibm.teami.build.toolkit.genlink.model.AbstractIleObjInfo;
import com.ibm.teami.build.toolkit.genlink.model.BndsrcObj;
import com.ibm.teami.build.toolkit.genlink.sysapi.AbstractBindListApi;
import com.ibm.teami.build.toolkit.genlink.sysapi.GetSrvpgmBndsrcApi;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class SrvpgmInfo
extends AbstractIleObjInfo {
    private boolean fExportAll = false;
    private BndsrcObj fBndsrc;
    private boolean fHasBndsrcData = false;
    private byte[] fSrvpgmSignature;

    public SrvpgmInfo(String libName, String pgmName) {
        super.setLibName(libName);
        super.setObjName(pgmName);
    }

    @Override
    public int pgmType() {
        return 2;
    }

    public byte[] getSignature() {
        return this.fSrvpgmSignature;
    }

    public void addApiDataFromQBNRSPGM(GetSrvpgmBndsrcApi.QBNRSPGM_Info apiData) {
        if (apiData.hasBndsrc()) {
            this.fBndsrc = apiData.getBndsrc();
            this.fExportAll = false;
        } else {
            this.fExportAll = true;
            this.fBndsrc = null;
        }
        this.fSrvpgmSignature = apiData.getSignature();
        this.fHasBndsrcData = true;
    }

    public void addBoundModList(AbstractBindListApi.BoundModuleInfo moduleList) {
        if (moduleList.count() != 0) {
            this.fModules = moduleList.getModules();
            this.fHasModuleListData = true;
        }
    }

    public void addBoundSrvpgmList(AbstractBindListApi.BoundSrvpgmInfo srvpgmList) {
        if (srvpgmList.count() != 0) {
            this.fBndsrvpgms = srvpgmList.getSrvpgms();
            this.fHasBndsrvpgmListData = true;
        }
    }

    public BndsrcObj getBndsrc() {
        return this.fBndsrc;
    }

    public boolean hasCompleteData() {
        return this.fHasBndsrcData && this.fHasModuleListData && this.fHasBndsrvpgmListData;
    }

    @Override
    public void debugPrint() {
        super.debugPrint();
        Log log = LogFactory.getLog();
        log.println(" *** IleSrvPgmInfo ***");
        log.println(" Bound Ile Service Program");
        if (this.fHasBndsrcData && !this.fExportAll) {
            log.println("   Binding Source: " + this.fBndsrc.getLibName() + " / " + this.fBndsrc.getObjName() + "(" + this.fBndsrc.getMember() + ")");
        } else {
            log.println("  Binding Source not retrieved.");
        }
        log.println("   Srvpgm Signature: " + AbstractIleObjInfo.toHexString(this.fSrvpgmSignature));
    }

    public void writeToFile(String fileName) throws Exception {
        IfsFileWriter outFile = new IfsFileWriter(fileName);
        this.writeInfo(outFile);
    }

    public void writeToMember(AS400 system, String library, String fileName, String memberName) throws Exception {
        SourceMemberWriter outFile = new SourceMemberWriter(system, library, fileName, memberName, "SRVPGMSRC");
        this.writeInfo(outFile);
    }

    private void writeInfo(IIbmiWriter outFile) throws Exception {
        outFile.create();
        outFile.open();
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeString = dateFormat.format(cal.getTime());
        outFile.writeRec("/***************************************/");
        outFile.writeRec("/* " + this.fObjName + ".SRVPGMSRC */");
        outFile.writeRec("/* Generated from " + this.fObjLibName + "/" + this.fObjName + " *SRVPGM.  */");
        outFile.writeRec("/* Generated at " + timeString + "  */");
        outFile.writeRec("/* Generator version: 2.0  */");
        outFile.writeRec("/***************************************/");
        outFile.writeRec("PGM PARM(&OBJLIB &SRCLIB)   ");
        outFile.writeRec("  DCL VAR(&OBJLIB) TYPE(*CHAR) LEN(10)");
        outFile.writeRec("  DCL VAR(&SRCLIB) TYPE(*CHAR) LEN(10)");
        outFile.writeRec("  CRTSRVPGM SRVPGM(&OBJLIB/" + this.fObjName.trim() + ") + ");
        this.writeBndsrcToFile(outFile);
        this.writeModulesToFile(outFile);
        this.writeBndsrvpgmsToFile(outFile);
        outFile.writeRec(" ");
        outFile.writeRec("ENDPGM ");
        outFile.close();
    }

    public void writeBndsrcToFile(IIbmiWriter outFile) throws Exception {
        if (this.fHasBndsrcData && !this.fExportAll) {
            outFile.writeRec("   EXPORT(*SRCFILE) +");
            outFile.writeRec("    SRCFILE(" + this.fBndsrc.getLibName().trim() + "/" + this.fBndsrc.getObjName().trim() + ") +");
            outFile.writeRec("    SRCMBR(" + this.fBndsrc.getMember().trim() + ") +");
        } else {
            outFile.writeRec("   EXPORT(*ALL) +");
        }
    }

    public void replaceRefLibsLibl() {
        super.replaceRefLibs(true);
        if (this.fBndsrc != null) {
            this.fBndsrc.setLibName("*LIBL");
        }
    }

    public void replaceRefLibsObjlib() {
        super.replaceRefLibs(false);
        if (this.fBndsrc != null) {
            this.fBndsrc.setLibName("&SRCLIB");
        }
    }
}

