/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.genlink.model;

import com.ibm.as400.access.AS400;
import com.ibm.teami.build.toolkit.genlink.filesystem.IIbmiWriter;
import com.ibm.teami.build.toolkit.genlink.filesystem.IfsFileWriter;
import com.ibm.teami.build.toolkit.genlink.filesystem.Log;
import com.ibm.teami.build.toolkit.genlink.filesystem.LogFactory;
import com.ibm.teami.build.toolkit.genlink.filesystem.SourceMemberWriter;
import com.ibm.teami.build.toolkit.genlink.model.AbstractIleObjInfo;
import com.ibm.teami.build.toolkit.genlink.model.Messages;
import com.ibm.teami.build.toolkit.genlink.model.ModuleObj;
import com.ibm.teami.build.toolkit.genlink.sysapi.AbstractBindListApi;
import com.ibm.teami.build.toolkit.genlink.sysapi.GetPgmEntryModApi;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class PgmInfo
extends AbstractIleObjInfo {
    private boolean fIsIlePgm;
    private ModuleObj fEntryModule;
    private boolean fHasEntryModuleData = false;

    public PgmInfo(String libName, String pgmName) {
        super.setLibName(libName);
        super.setObjName(pgmName);
    }

    @Override
    public int pgmType() {
        if (this.fIsIlePgm) {
            return 1;
        }
        return 0;
    }

    public boolean isOpm() {
        return !this.fIsIlePgm;
    }

    public void addApiDataFromQCLRPGMI(GetPgmEntryModApi.QCLRPGMI_Info apiData) {
        this.fIsIlePgm = apiData.isIlePgm();
        this.fEntryModule = new ModuleObj(apiData.getEntModLib(), apiData.getEntMod());
        this.fHasEntryModuleData = true;
    }

    public void addBoundModList(AbstractBindListApi.BoundModuleInfo moduleList) {
        if (moduleList.count() != 0) {
            this.fModules = moduleList.getModules();
            this.fHasModuleListData = true;
        }
    }

    public void addBoundSrvpgmList(AbstractBindListApi.BoundSrvpgmInfo srvpgmList) {
        if (srvpgmList.count() != 0) {
            this.fBndsrvpgms = srvpgmList.getSrvpgms();
            this.fHasBndsrvpgmListData = true;
        }
    }

    public void setEntryModule(ModuleObj modInfo) {
        this.fEntryModule = modInfo;
        this.fHasEntryModuleData = true;
    }

    public boolean hasEntryModuleData() {
        return this.fHasEntryModuleData;
    }

    public ModuleObj getEntryModule() {
        return this.fEntryModule;
    }

    public boolean hasCompleteData() {
        return this.fHasEntryModuleData && this.fHasModuleListData && this.fHasBndsrvpgmListData;
    }

    @Override
    public void debugPrint() {
        super.debugPrint();
        Log log = LogFactory.getLog();
        log.println(" *** IlePgmInfo ***");
        if (this.fIsIlePgm) {
            log.println(" Bound Ile Program");
            log.println("   EntryModule: " + this.fEntryModule.getLibName() + " / " + this.fEntryModule.getObjName());
        } else {
            log.println(" OPM Program");
        }
    }

    public void writeToFile(String fileName) throws Exception {
        IfsFileWriter outFile = new IfsFileWriter(fileName);
        this.writeInfo(outFile);
    }

    public void writeToMember(AS400 system, String library, String fileName, String memberName) throws Exception {
        SourceMemberWriter outFile = new SourceMemberWriter(system, library, fileName, memberName, "PGMSRC");
        this.writeInfo(outFile);
    }

    public void writeInfo(IIbmiWriter outFile) throws Exception {
        outFile.create();
        outFile.open();
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeString = dateFormat.format(cal.getTime());
        outFile.writeRec("/***************************************/");
        outFile.writeRec("/* " + this.fObjName + ".PGMSRC */");
        outFile.writeRec("/* Generated from " + this.fObjLibName + "/" + this.fObjName + " *PGM.  */");
        outFile.writeRec("/* Generated at " + timeString + " */");
        outFile.writeRec("/* Generator version: 2.0  */");
        outFile.writeRec("/***************************************/");
        outFile.writeRec("PGM PARM(&OBJLIB &SRCLIB)   ");
        outFile.writeRec("  DCL VAR(&OBJLIB) TYPE(*CHAR) LEN(10)");
        outFile.writeRec("  DCL VAR(&SRCLIB) TYPE(*CHAR) LEN(10)");
        outFile.writeRec("  CRTPGM PGM(&OBJLIB/" + this.fObjName.trim() + ") + ");
        this.writeEntmodToFile(outFile);
        this.writeModulesToFile(outFile);
        this.writeBndsrvpgmsToFile(outFile);
        outFile.writeRec(" ");
        outFile.writeRec("ENDPGM ");
        outFile.close();
    }

    public void writeEntmodToFile(IIbmiWriter outFile) throws Exception {
        if (this.fHasEntryModuleData && this.fIsIlePgm) {
            outFile.writeRec("   ENTMOD(" + this.fEntryModule.getLibName().trim() + "/" + this.fEntryModule.getObjName().trim() + ") +");
        } else {
            LogFactory.getLog().println(Messages.PgmInfo_ErrorNoEntryModule);
        }
    }

    public void replaceRefLibsLibl() {
        super.replaceRefLibs(true);
        this.fEntryModule.setLibName("*LIBL");
    }

    public void replaceRefLibsObjlib() {
        super.replaceRefLibs(false);
        if (this.fEntryModule.getLibName().trim().equals(this.fObjLibName.trim())) {
            this.fEntryModule.setLibName("&OBJLIB");
        } else {
            this.fEntryModule.setLibName("*LIBL");
        }
    }
}

