/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.genlink.model;

import com.ibm.teami.build.toolkit.genlink.filesystem.Log;
import com.ibm.teami.build.toolkit.genlink.filesystem.LogFactory;
import com.ibm.teami.build.toolkit.genlink.sysapi.GetFileDescriptionApi;

public class FileInfo {
    private boolean fHasData0100 = false;
    private boolean fHasData0200 = false;
    private boolean fIsPhysicalFile = false;
    private boolean fIsPfSourceFile = false;
    private int fNumMembers = 0;
    private int fRecordLength = 0;
    private String fRecordFormat = null;
    private String fLibrary = null;
    private String fFileName = null;

    public FileInfo(String libName, String fileName) {
        this.fLibrary = new String(libName);
        this.fFileName = new String(fileName);
    }

    public boolean hasData0100() {
        return this.fHasData0100;
    }

    public boolean hasData0200() {
        return this.fHasData0100;
    }

    public boolean hasCompleteData() {
        return this.fHasData0100 && this.fHasData0200;
    }

    public int recordLength() {
        if (this.fHasData0100) {
            return this.fRecordLength;
        }
        return 0;
    }

    public String recordFormat() {
        if (this.fHasData0100) {
            return this.fRecordFormat;
        }
        return null;
    }

    public boolean isPF() {
        return this.fIsPhysicalFile;
    }

    public boolean isSrcpf() {
        return this.fIsPfSourceFile;
    }

    public int numMembers() {
        return this.fNumMembers;
    }

    public void addApiData(GetFileDescriptionApi.QDBRTVFD_Info apiData) {
        this.fRecordLength = apiData.getRecordLength();
        this.fRecordFormat = apiData.getRecordFormat();
        this.fIsPhysicalFile = apiData.isPhysicalFile();
        this.fIsPfSourceFile = apiData.isSourcePf();
        this.fHasData0100 = true;
        this.fHasData0200 = true;
    }

    public void debugPrint() {
        Log log = LogFactory.getLog();
        log.println(" *** FileInfo ***");
        log.println("   File: " + this.fLibrary + "/" + this.fFileName);
        log.println("   Record Length: " + this.fRecordLength);
        log.println("   Record Format: " + this.fRecordFormat);
    }
}

