/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.genlink.model;

import com.ibm.teami.build.toolkit.genlink.filesystem.IIbmiWriter;
import com.ibm.teami.build.toolkit.genlink.filesystem.Log;
import com.ibm.teami.build.toolkit.genlink.filesystem.LogFactory;
import com.ibm.teami.build.toolkit.genlink.model.BaseObj;
import com.ibm.teami.build.toolkit.genlink.model.Messages;
import com.ibm.teami.build.toolkit.genlink.model.ModuleObj;
import com.ibm.teami.build.toolkit.genlink.model.SrvpgmObj;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractIleObjInfo {
    public static final String Copyright = Messages.AbstractIleObjInfo_Copyright;
    public static final String LIBL_STR = "*LIBL";
    public static final String OBJLIB_STR = "&OBJLIB";
    public static final String SRCLIB_STR = "&SRCLIB";
    protected String fObjName;
    protected String fObjLibName;
    protected List<ModuleObj> fModules = null;
    protected List<SrvpgmObj> fBndsrvpgms = null;
    protected List<BaseObj> fBnddirs = null;
    protected boolean fHasModuleListData = false;
    protected boolean fHasBndsrvpgmListData = false;
    static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public void setObjName(String objName) {
        this.fObjName = objName;
    }

    public void setLibName(String libName) {
        this.fObjLibName = libName;
    }

    public String getObjName() {
        return this.fObjName;
    }

    public String getLibName() {
        return this.fObjLibName;
    }

    public List<ModuleObj> getModules() {
        return this.fModules;
    }

    public void setModules(List<ModuleObj> list) {
        this.fModules = list;
    }

    protected abstract int pgmType();

    public void setHasModuleListData(boolean flag) {
        this.fHasModuleListData = flag;
    }

    public void setHasBndsrvpgmListData(boolean flag) {
        this.fHasBndsrvpgmListData = flag;
    }

    public boolean hasModuleListData() {
        return this.fHasModuleListData;
    }

    public boolean hasBndsrvpgmListData() {
        return this.fHasBndsrvpgmListData;
    }

    public void debugPrint() {
        Log log = LogFactory.getLog();
        log.println("**** IleObjInfo ****");
        log.println("Library: " + this.getLibName() + "  Object: " + this.getObjName() + "  pgmType: " + this.pgmType());
        log.println("  HasModuleListData: " + this.hasModuleListData());
        log.println("  HasBndsrvpgmListData: " + this.hasBndsrvpgmListData());
        if (this.hasModuleListData()) {
            log.println("  **Module List**:");
            for (ModuleObj module : this.fModules) {
                log.println("   " + module.getLibName() + "/" + module.getObjName());
            }
        } else {
            log.println("  **Module List is empty**");
        }
        if (this.hasBndsrvpgmListData()) {
            log.println("  **Bndsrvpgm List**:");
            for (SrvpgmObj obj : this.fBndsrvpgms) {
                log.println("   " + obj.getLibName() + "/" + obj.getObjName() + "[Signature: " + AbstractIleObjInfo.toHexString(obj.getSignature()) + "]");
            }
        } else {
            log.println("  **Bndsrvpgm List is empty**");
        }
    }

    protected void writeModulesToFile(IIbmiWriter outFile) throws Exception {
        if (this.hasModuleListData()) {
            outFile.writeRec("   MODULE( +");
            Iterator<ModuleObj> i = this.fModules.iterator();
            while (i.hasNext()) {
                ModuleObj module = i.next();
                if (i.hasNext()) {
                    outFile.writeRec("    " + module.getLibName().trim() + "/" + module.getObjName().trim() + " + ");
                    continue;
                }
                outFile.writeRec("    " + module.getLibName().trim() + "/" + module.getObjName().trim() + ") +");
            }
        } else {
            LogFactory.getLog().println(Messages.AbstractIleObjInfo_ErrorNoModulesFound);
        }
    }

    protected void writeBndsrvpgmsToFile(IIbmiWriter outFile) throws Exception {
        if (this.fHasBndsrvpgmListData) {
            Iterator<SrvpgmObj> i = this.fBndsrvpgms.iterator();
            if (!i.hasNext()) {
                outFile.writeRec("   BNDSRVPGM()");
            } else {
                outFile.writeRec("   BNDSRVPGM( +");
                while (i.hasNext()) {
                    SrvpgmObj srvpgm = i.next();
                    if (i.hasNext()) {
                        outFile.writeRec("    " + srvpgm.getLibName().trim() + "/" + srvpgm.getObjName().trim() + " + ");
                        continue;
                    }
                    outFile.writeRec("    " + srvpgm.getLibName().trim() + "/" + srvpgm.getObjName().trim() + ") ");
                }
            }
        } else {
            LogFactory.getLog().println(Messages.AbstractIleObjInfo_ErrorNoBndsrvpgmInfo);
        }
    }

    public void removeBoundModule(String libName, String modName) {
        if (this.fModules == null) {
            return;
        }
        if (modName == "*ALL      ") {
            this.removeBoundModule(libName);
        }
        Iterator<ModuleObj> i = this.fModules.iterator();
        while (i.hasNext()) {
            ModuleObj iModule = i.next();
            if (iModule.getLibName() != libName || iModule.getObjName() != modName) continue;
            i.remove();
        }
    }

    public void replaceRefLibs(boolean isLibl) {
        this.replaceModuleLibs(isLibl);
        this.replaceSrvpgmLibs(isLibl);
    }

    public void replaceModuleLibs(boolean isLibl) {
        if (this.fModules == null) {
            return;
        }
        for (ModuleObj iModule : this.fModules) {
            if (isLibl) {
                iModule.setLibName(LIBL_STR);
                continue;
            }
            if (this.fObjLibName.equals(iModule.getLibName().trim())) {
                iModule.setLibName(OBJLIB_STR);
                continue;
            }
            iModule.setLibName(LIBL_STR);
        }
    }

    public void replaceSrvpgmLibs(boolean isLibl) {
        if (this.fBndsrvpgms == null) {
            return;
        }
        for (SrvpgmObj iSrvpgm : this.fBndsrvpgms) {
            if (isLibl) {
                iSrvpgm.setLibName(LIBL_STR);
                continue;
            }
            if (this.fObjLibName.equals(iSrvpgm.getLibName().trim())) {
                iSrvpgm.setLibName(OBJLIB_STR);
                continue;
            }
            iSrvpgm.setLibName(LIBL_STR);
        }
    }

    public void removeBoundModule(String libName) {
        if (this.fModules == null) {
            return;
        }
        Iterator<ModuleObj> i = this.fModules.iterator();
        while (i.hasNext()) {
            ModuleObj iModule = i.next();
            if (iModule.getLibName() != libName) continue;
            i.remove();
        }
    }

    public void removeBoundSrvpgm(String libName, String srvpgmName) {
        if (this.fBndsrvpgms == null) {
            return;
        }
        if (srvpgmName == "*ALL      ") {
            this.removeBoundSrvpgm(libName);
        }
        Iterator<SrvpgmObj> i = this.fBndsrvpgms.iterator();
        while (i.hasNext()) {
            SrvpgmObj iSrvpgm = i.next();
            if (iSrvpgm.getLibName() != libName || iSrvpgm.getObjName() != srvpgmName) continue;
            i.remove();
        }
    }

    public void removeBoundSrvpgm(String libName) {
        if (this.fBndsrvpgms == null) {
            return;
        }
        Iterator<SrvpgmObj> i = this.fBndsrvpgms.iterator();
        while (i.hasNext()) {
            SrvpgmObj iSrvpgm = i.next();
            if (!iSrvpgm.getLibName().equals(libName)) continue;
            i.remove();
        }
    }

    public static String toHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        int i = 0;
        while (i < bytes.length) {
            sb.append(hexChar[(bytes[i] & 0xF0) >>> 4]);
            sb.append(hexChar[bytes[i] & 0xF]);
            ++i;
        }
        return sb.toString();
    }
}

