/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.genlink.filesystem;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.SequentialFile;
import com.ibm.teami.build.toolkit.genlink.filesystem.IIbmiWriter;
import com.ibm.teami.build.toolkit.genlink.filesystem.Log;
import com.ibm.teami.build.toolkit.genlink.filesystem.LogFactory;
import com.ibm.teami.build.toolkit.genlink.filesystem.Messages;
import com.ibm.teami.build.toolkit.genlink.filesystem.QsysFileSystem;
import com.ibm.teami.build.toolkit.genlink.model.FileInfo;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.osgi.util.NLS;

public class SourceMemberWriter
implements IIbmiWriter {
    private AS400 fSystem = null;
    private String fLibrary = null;
    private String fFileName = null;
    private String fMemberName = null;
    private String fMemberType = null;
    private int fRecordLength = 132;
    private RecordFormat fRecordFormat = null;
    private final int fSequenceStart = 1;
    private final int fSequenceIncrement = 1;
    private int fCurrentSequence = 0;
    private boolean fExists = false;
    private boolean fOpen = false;
    private SequentialFile fFile = null;
    private BigDecimal fFormattedDate = null;
    private final int SEQ_FIELD = 0;
    private final int SRCDATE_FIELD = 1;
    private final int STATEMENT_FIELD = 2;
    private final int DEFAULT_RECLEN = 92;
    private final String GENERATED_MSG = Messages.SourceMemberWriter_GeneratorVersion;

    public SourceMemberWriter(AS400 system, String library, String fileName, String memberName, String memberType) {
        this.fSystem = system;
        this.fLibrary = library;
        this.fFileName = fileName;
        this.fMemberName = memberName;
        this.fMemberType = memberType;
    }

    public boolean doCmd(String cmdString) throws Exception {
        boolean cmdSucc = true;
        Log log = LogFactory.getLog();
        CommandCall cmd = new CommandCall(this.fSystem, cmdString);
        try {
            cmdSucc = cmd.run();
        }
        catch (Exception e) {
            log.println(Messages.SourceMemberWriter_ErrorOnSysCmd);
            log.println(">>> " + cmdString + " <<<");
            e.printStackTrace();
            throw e;
        }
        if (!cmdSucc) {
            AS400Message[] msgList = cmd.getMessageList();
            log.println(Messages.SourceMemberWriter_ErrorSysCmdDidntRun);
            log.println("  " + cmdString);
            int i = 0;
            while (i < msgList.length) {
                log.println(msgList[i].getText());
                ++i;
            }
        }
        return cmdSucc;
    }

    @Override
    public void create() throws Exception {
        boolean cmdSucc;
        String ifsMemberName = "/QSYS.LIB/" + this.fLibrary + ".LIB/" + this.fFileName + ".FILE/" + this.fMemberName + ".MBR";
        Log log = LogFactory.getLog();
        boolean libExists = QsysFileSystem.checkLibraryExists(this.fSystem, this.fLibrary);
        if (!libExists && !(cmdSucc = this.doCmd("CRTLIB LIB(" + this.fLibrary + ") TEXT('CREATED BY RTVBND UTILITY')"))) {
            throw new Exception(String.valueOf(Messages.SourceMemberWriter_ErrorCreatingLib) + this.fLibrary);
        }
        String textDesc = this.GENERATED_MSG;
        boolean fileExists = QsysFileSystem.checkObjectExists(this.fSystem, this.fLibrary, this.fFileName, "FILE");
        if (!fileExists) {
            this.fFile = new SequentialFile(this.fSystem, ifsMemberName);
            try {
                this.fRecordLength = 92;
                cmdSucc = this.doCmd("CRTSRCPF FILE(" + this.fLibrary + "/" + this.fFileName + ") RCDLEN(" + this.fRecordLength + ") MBR(" + this.fMemberName + ") TEXT('" + textDesc + "') MAXMBRS(*NOMAX)");
                if (!cmdSucc) {
                    throw new Exception(String.valueOf(Messages.SourceMemberWriter_ErrorCreatingSrcpf) + this.fLibrary + "/" + this.fFileName);
                }
                cmdSucc = this.doCmd("CHGPFM FILE(" + this.fLibrary + "/" + this.fFileName + ") MBR(" + this.fMemberName + ") SRCTYPE(" + this.fMemberType + ") TEXT('" + textDesc + "')");
            }
            catch (Exception e) {
                log.println(String.valueOf(Messages.SourceMemberWriter_ErrorCreatingFile) + this.fLibrary + "/" + this.fFileName + " member: " + this.fMemberName);
                throw e;
            }
        }
        FileInfo fileInfo = QsysFileSystem.retrieveFileInfo(this.fSystem, this.fLibrary, this.fFileName);
        if (!fileInfo.isPF()) {
            throw new Exception(NLS.bind((String)Messages.SourceMemberWriter_ErrorNotPfType, (Object)(String.valueOf(this.fLibrary) + "/" + this.fFileName)));
        }
        if (!fileInfo.isSrcpf()) {
            throw new Exception(NLS.bind((String)Messages.SourceMemberWriter_ErrorNotPfsrcType, (Object)(String.valueOf(this.fLibrary) + "/" + this.fFileName)));
        }
        this.fRecordLength = fileInfo.recordLength();
        this.fFile = new SequentialFile(this.fSystem, ifsMemberName);
        boolean memberExists = QsysFileSystem.checkMemberExists(this.fSystem, this.fLibrary, this.fFileName, this.fMemberName);
        if (memberExists) {
            cmdSucc = this.doCmd("CLRPFM FILE(" + this.fLibrary + "/" + this.fFileName + ") MBR(" + this.fMemberName + ")");
            if (!cmdSucc) {
                throw new Exception(String.valueOf(Messages.SourceMemberWriter_ErrorCreatingSrcpfm) + this.fLibrary + "/" + this.fFileName + Messages.SourceMemberWriter_ErrorMember + this.fMemberName);
            }
        } else {
            try {
                cmdSucc = this.doCmd("ADDPFM FILE(" + this.fLibrary + "/" + this.fFileName + ") MBR(" + this.fMemberName + ") SRCTYPE(" + this.fMemberType + ") TEXT('" + textDesc + "')");
            }
            catch (Exception e) {
                log.println(String.valueOf(Messages.SourceMemberWriter_ErrorCouldntCreateFile) + this.fLibrary + "/" + this.fFileName + Messages.SourceMemberWriter_MemberColon + this.fMemberName);
                throw e;
            }
        }
        this.fFile = new SequentialFile(this.fSystem, ifsMemberName);
        this.fFile.setRecordFormat();
        this.fRecordFormat = this.fFile.getRecordFormat();
        this.fExists = true;
    }

    @Override
    public void open() throws Exception {
        Log log = LogFactory.getLog();
        if (!this.fExists) {
            throw new IOException(NLS.bind((String)Messages.SourceMemberWriter_ErrorMemberNotCreated, (Object)this.fMemberName));
        }
        try {
            this.fFile.open(2, 0, 3);
        }
        catch (AS400SecurityException e) {
            log.println(String.valueOf(Messages.SourceMemberWriter_ErrorAS400SecException) + this.fLibrary + "/" + this.fFileName + "." + this.fMemberName);
            e.printStackTrace(log.toPrintStream());
            throw e;
        }
        catch (AS400Exception e) {
            log.println(String.valueOf(Messages.SourceMemberWriter_ErrorAS400Exception) + this.fLibrary + "/" + this.fFileName + "." + this.fMemberName);
            e.printStackTrace(log.toPrintStream());
            throw e;
        }
        catch (InterruptedException e) {
            log.println(String.valueOf(Messages.SourceMemberWriter_ErrorInterruptedException) + this.fLibrary + "/" + this.fFileName + "." + this.fMemberName);
            e.printStackTrace(log.toPrintStream());
            throw e;
        }
        catch (IOException e) {
            log.println(String.valueOf(Messages.SourceMemberWriter_ErrorIoException) + this.fLibrary + "/" + this.fFileName + "." + this.fMemberName);
            e.printStackTrace(log.toPrintStream());
            throw e;
        }
        catch (Exception e) {
            log.println(String.valueOf(Messages.SourceMemberWriter_ErrorGenException) + this.fLibrary + "/" + this.fFileName + "." + this.fMemberName);
            e.printStackTrace(log.toPrintStream());
            throw e;
        }
        this.fOpen = true;
        this.fCurrentSequence = 1;
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMdd", Locale.US);
        String dateString = dateFormat.format(date);
        this.fFormattedDate = new BigDecimal(dateString);
    }

    @Override
    public void writeRec(String statement) throws Exception {
        if (!this.fOpen) {
            throw new IOException(NLS.bind((String)Messages.SourceMemberWriter_ErrorMemberNotOpened, (Object)this.fMemberName));
        }
        Record rec = new Record(this.fRecordFormat);
        int recLen = rec.getRecordLength();
        if (statement.length() > recLen - 12) {
            throw new Exception(NLS.bind((String)Messages.SourceMemberWriter_ErrorTextExceedsReclen, (Object[])new Object[]{statement.length(), recLen}));
        }
        BigDecimal formattedSeqNum = new BigDecimal(this.fCurrentSequence);
        rec.setField(0, (Object)formattedSeqNum);
        rec.setField(1, (Object)this.fFormattedDate);
        rec.setField(2, (Object)statement);
        this.fFile.write(rec);
        ++this.fCurrentSequence;
    }

    @Override
    public void close() throws Exception {
        this.fFile.close();
    }
}

