/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.genlink.filesystem;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.ObjectList;
import com.ibm.teami.build.toolkit.genlink.model.FileInfo;
import com.ibm.teami.build.toolkit.genlink.sysapi.GetFileDescriptionApi;

public class QsysFileSystem {
    public ObjectList getObjectList(AS400 system, String library, String objName, String objType) {
        ObjectList list = new ObjectList(system, library, objName, objType);
        return list;
    }

    public static boolean checkLibraryExists(AS400 system, String library) throws Exception {
        boolean existance = false;
        ObjectDescription objd = new ObjectDescription(system, "QSYS", library, "LIB");
        if (objd.exists()) {
            existance = true;
        }
        return existance;
    }

    public static boolean checkObjectExists(AS400 system, String library, String objectName, String objectType) throws Exception {
        boolean existance = false;
        ObjectDescription objd = new ObjectDescription(system, library, objectName, objectType);
        if (objd.exists()) {
            existance = true;
        }
        return existance;
    }

    public static boolean checkMemberExists(AS400 system, String library, String fileName, String memberName) throws Exception {
        boolean existance = false;
        String ifsFileName = "/QSYS.LIB/" + library + ".LIB/" + fileName + ".FILE/" + memberName + ".MBR";
        IFSFile ifsFile = new IFSFile(system, ifsFileName);
        if (ifsFile.exists()) {
            existance = true;
        }
        return existance;
    }

    public static FileInfo retrieveFileInfo(AS400 system, String library, String fileName) throws Exception {
        FileInfo fileInfo = new FileInfo(library, fileName);
        GetFileDescriptionApi api = new GetFileDescriptionApi(system, library, fileName);
        GetFileDescriptionApi.QDBRTVFD_Info apiRecordInfo = api.retrieveApiOutput();
        fileInfo.addApiData(apiRecordInfo);
        return fileInfo;
    }
}

