/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.genlink.filesystem;

import com.ibm.teami.build.toolkit.genlink.filesystem.IIbmiWriter;
import com.ibm.teami.build.toolkit.genlink.filesystem.LogFactory;
import com.ibm.teami.build.toolkit.genlink.filesystem.Messages;
import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.osgi.util.NLS;

public class IfsFileWriter
implements IIbmiWriter {
    private String fFileName = null;
    private PrintWriter fOutFile = null;
    private boolean fIsOpen = false;

    public IfsFileWriter(String fileName) {
        this.fFileName = fileName;
    }

    @Override
    public void create() throws Exception {
    }

    @Override
    public void open() throws Exception {
        try {
            this.fOutFile = new PrintWriter(this.fFileName);
        }
        catch (IOException e) {
            LogFactory.getLog().println(NLS.bind((String)Messages.IfsFileWriter_ErrorCouldntOpenFile, (Object)this.fFileName));
            throw e;
        }
        this.fIsOpen = true;
    }

    @Override
    public void writeRec(String line) throws Exception {
        if (!this.fIsOpen) {
            throw new IOException(NLS.bind((String)Messages.IfsFileWriter_ErrorWriteToFile, (Object)this.fFileName));
        }
        this.fOutFile.println(line);
    }

    @Override
    public void close() throws Exception {
        this.fOutFile.close();
    }
}

