/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.genlink.cli;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.ObjectList;
import com.ibm.teami.build.toolkit.genlink.cli.ArgTable;
import com.ibm.teami.build.toolkit.genlink.cli.Messages;
import com.ibm.teami.build.toolkit.genlink.filesystem.Log;
import com.ibm.teami.build.toolkit.genlink.filesystem.LogFactory;
import com.ibm.teami.build.toolkit.genlink.service.IPgmsrcGenerator;
import com.ibm.teami.build.toolkit.genlink.service.PgmsrcGenerator;
import com.ibm.teami.build.toolkit.genlink.service.SrvpgmsrcGenerator;
import org.eclipse.osgi.util.NLS;

public class MainCli {
    public static void main(String[] args) {
        ObjectDescription[] objDescs;
        String outputSrcPf;
        String objType;
        Log log = LogFactory.getLog();
        ArgTable argTable = new ArgTable();
        try {
            argTable.parseArgs(args);
        }
        catch (Exception e) {
            log.println(Messages.MainCli_InvalidArgs);
            log.println(e.getMessage());
            ArgTable.printUsageMsg(log);
            return;
        }
        AS400 system = argTable.isRemoteSystem() ? new AS400(argTable.getSystem(), argTable.getUserId(), argTable.getPasswd()) : new AS400();
        boolean isPgmType = argTable.isPgmType();
        if (isPgmType) {
            objType = "*PGM";
            outputSrcPf = "QPGMSRC";
        } else {
            objType = "*SRVPGM";
            outputSrcPf = "QSRVPGMSRC";
        }
        String inputLib = argTable.getInputLib();
        String inputObj = argTable.getInputObj();
        ObjectList objList = new ObjectList(system, inputLib, inputObj, objType);
        try {
            objList.load();
            objDescs = objList.getObjects(-1, 0);
        }
        catch (Exception e) {
            log.println(NLS.bind((String)Messages.MainCli_ErrorGettingList1, (Object[])new Object[]{objType, inputLib}));
            return;
        }
        if (objDescs.length == 0) {
            log.println(NLS.bind((String)Messages.MainCli_ErrorObjectNotFound, (Object[])new Object[]{inputLib, inputObj, objType}));
        }
        String workingLib = argTable.getWorkingLib();
        int i = 0;
        while (i < objDescs.length) {
            boolean isOpmPgm = false;
            IPgmsrcGenerator pgmsrcGen = isPgmType ? new PgmsrcGenerator() : new SrvpgmsrcGenerator();
            pgmsrcGen.setRefLibReplacement(argTable.getRefLibReplaceOption());
            isOpmPgm = pgmsrcGen.mineData(system, inputLib, objDescs[i].getName(), workingLib, true);
            if (isOpmPgm) {
                log.println(NLS.bind((String)Messages.MailCli_OpmSourceNotGenerated, (Object[])new Object[]{String.valueOf(inputLib) + "/" + objDescs[i].getName()}));
            } else {
                if (argTable.getFileSystem() == 1) {
                    pgmsrcGen.writeStmf(argTable.getOutDir());
                } else {
                    pgmsrcGen.writeMember(argTable.getOutputLib(), outputSrcPf);
                }
                log.println(NLS.bind((String)Messages.MainCli_SourceGenerated, (Object[])new Object[]{String.valueOf(inputLib) + "/" + objDescs[i].getName(), objType}));
            }
            ++i;
        }
        system.disconnectAllServices();
    }
}

