/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.genlink.cli;

import com.ibm.teami.build.toolkit.genlink.cli.Messages;
import com.ibm.teami.build.toolkit.genlink.filesystem.Log;
import org.eclipse.osgi.util.NLS;

public class ArgTable {
    public static final int REPLACE_REFLIB_LIBL = 0;
    static final String REPLACE_REFLIB_LIBL_STR = "LIBL";
    public static final int REPLACE_REFLIB_OBJLIB = 1;
    static final String REPLACE_REFLIB_OBJLIB_STR = "OBJLIB";
    public static final int REPLACE_REFLIB_KEEP = 2;
    static final String REPLACE_REFLIB_KEEP_STR = "KEEP";
    static final String PGMTYPE = "*PGM";
    static final String SRVPGMTYPE = "*SRVPGM";
    static final String QPGMSRC = "QPGMSRC";
    static final String QSRVPGMSRC = "QSRVPGMSRC";
    public static final int FS_QSYS = 0;
    public static final int FS_IFS = 1;
    static final String OUTFS_IFS_STR = "IFS";
    static final String OUTFS_QSYS_STR = "QSYS";
    static final String LOCALHOST = "LOCALHOST";
    static final String EQUALS = "=";
    static final String DASH = "-";
    static final String PROP_OS400 = "OS/400";
    static final String ALL = "*ALL";
    static final String KEYWORD_INPUTLIB = "inLib";
    static final int ARGTYPE_INPUTLIB = 0;
    static final String KEYWORD_INPUTOBJ = "inObj";
    static final int ARGTYPE_INPUTOBJ = 1;
    static final String KEYWORD_OUTFS = "outFs";
    static final int ARGTYPE_OUTFS = 2;
    static final String KEYWORD_OUTPUTLIB = "outLib";
    static final int ARGTYPE_OUTPUTLIB = 3;
    static final String KEYWORD_REPLACEREFLIB = "replRefLib";
    static final int ARGTYPE_REPLACEREFLIB = 4;
    static final String KEYWORD_OBJTYPE = "objType";
    static final int ARGTYPE_OBJTYPE = 5;
    static final String KEYWORD_SYSTEM = "system";
    static final int ARGTYPE_SYSTEM = 6;
    static final String KEYWORD_USERID = "userId";
    static final int ARGTYPE_USERID = 7;
    static final String KEYWORD_PASS = "pass";
    static final int ARGTYPE_PASS = 8;
    static final String KEYWORD_OUTDIR = "outDir";
    static final int ARGTYPE_OUTDIR = 9;
    static final String KEYWORD_WORKINGLIB = "workLib";
    static final int ARGTYPE_WORKINGLIB = 10;
    static final int ARGTABLE_SIZE = 11;
    Argument[] fArgTable;

    public static void printUsageMsg(Log log) {
        log.println(Messages.ArgTable_Usage_1);
        log.println(Messages.ArgTable_Usage_2);
        log.println(Messages.ArgTable_Usage_3);
        log.println(Messages.ArgTable_Usage_4);
        log.println(Messages.ArgTable_Usage_5);
        log.println(Messages.ArgTable_Usage_6);
        log.println(Messages.ArgTable_Usage_7);
        log.println(Messages.ArgTable_Usage_8);
        log.println(Messages.ArgTable_Usage_9);
        log.println(Messages.ArgTable_Usage_10);
        log.println(Messages.ArgTable_Usage_11);
        log.println(Messages.ArgTable_Usage_12);
        log.println(Messages.ArgTable_Usage_13);
        log.println(Messages.ArgTable_Usage_14);
        log.println(Messages.ArgTable_Usage_15);
        log.println(Messages.ArgTable_Usage_16);
        log.println(Messages.ArgTable_Usage_17);
        log.println(Messages.ArgTable_Usage_18);
    }

    private Argument parseArg(String argString) throws IllegalArgumentException {
        int argType;
        String argValue;
        String argName;
        if (!argString.startsWith(DASH)) {
            throw new IllegalArgumentException(String.valueOf(Messages.ArgTable_InvalidArg) + argString);
        }
        if (argString.contains(EQUALS)) {
            int delim = argString.indexOf(EQUALS);
            argName = argString.substring(1, delim);
            argValue = argString.substring(delim + 1);
        } else {
            argName = argString;
            argValue = null;
        }
        if (argName.equals(KEYWORD_INPUTLIB)) {
            argType = 0;
        } else if (argName.equals(KEYWORD_INPUTOBJ)) {
            argType = 1;
        } else if (argName.equals(KEYWORD_OUTFS)) {
            argType = 2;
        } else if (argName.equals(KEYWORD_OUTPUTLIB)) {
            argType = 3;
        } else if (argName.equals(KEYWORD_REPLACEREFLIB)) {
            argType = 4;
        } else if (argName.equals(KEYWORD_OBJTYPE)) {
            argType = 5;
        } else if (argName.equals(KEYWORD_SYSTEM)) {
            argType = 6;
        } else if (argName.equals(KEYWORD_USERID)) {
            argType = 7;
        } else if (argName.equals(KEYWORD_PASS)) {
            argType = 8;
        } else if (argName.equals(KEYWORD_OUTDIR)) {
            argType = 9;
        } else if (argName.equals(KEYWORD_WORKINGLIB)) {
            argType = 10;
        } else {
            throw new IllegalArgumentException(String.valueOf(Messages.ArgTable_IllegalArgValue) + argName);
        }
        Argument parsedArg = new Argument(argType, argName, argValue, true);
        return parsedArg;
    }

    private void initializeArgTable() {
        this.fArgTable = new Argument[11];
        this.fArgTable[0] = new Argument(0, KEYWORD_INPUTLIB, null, false);
        this.fArgTable[1] = new Argument(1, KEYWORD_INPUTOBJ, null, false);
        this.fArgTable[2] = new Argument(2, KEYWORD_OUTFS, null, false);
        this.fArgTable[3] = new Argument(3, KEYWORD_OUTPUTLIB, null, false);
        this.fArgTable[4] = new Argument(4, KEYWORD_REPLACEREFLIB, null, false);
        this.fArgTable[5] = new Argument(5, KEYWORD_OBJTYPE, null, false);
        this.fArgTable[6] = new Argument(6, KEYWORD_SYSTEM, null, false);
        this.fArgTable[7] = new Argument(7, KEYWORD_USERID, null, false);
        this.fArgTable[8] = new Argument(8, KEYWORD_PASS, null, false);
        this.fArgTable[9] = new Argument(9, KEYWORD_OUTDIR, null, false);
        this.fArgTable[10] = new Argument(10, KEYWORD_WORKINGLIB, null, false);
    }

    public Argument[] parseArgs(String[] args) throws Exception {
        this.initializeArgTable();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            Argument parsedArg = this.parseArg(arg);
            this.addArgToTable(parsedArg);
            ++n2;
        }
        this.validateArgTable();
        return this.fArgTable;
    }

    public void addArgToTable(Argument arg) {
        this.fArgTable[arg.type()] = arg;
    }

    private void validateArgTable() throws Exception {
        String os = System.getProperty("os.name");
        if (!this.fArgTable[0].exists()) {
            throw new Exception(NLS.bind((String)Messages.ArgTable_ErrorWasNotSpecified, (Object)"-inLib"));
        }
        if (!this.fArgTable[10].exists()) {
            throw new Exception(NLS.bind((String)Messages.ArgTable_ErrorWasNotSpecified, (Object)"-workLib"));
        }
        if (!this.fArgTable[2].exists()) {
            throw new Exception(NLS.bind((String)Messages.ArgTable_ErrorWasNotSpecified, (Object)"-outFs"));
        }
        if (this.fArgTable[2].equals(OUTFS_IFS_STR)) {
            if (!this.fArgTable[9].exists()) {
                throw new Exception(NLS.bind((String)Messages.ArgTable_ErrorWasNotSpecified, (Object)"-outDir"));
            }
        } else if (!this.fArgTable[3].exists()) {
            throw new Exception(NLS.bind((String)Messages.ArgTable_ErrorWasNotSpecified, (Object)"-outLib"));
        }
        if (!(os.equals(PROP_OS400) || this.fArgTable[6].exists() && this.fArgTable[7].exists() && this.fArgTable[8].exists())) {
            throw new Exception(Messages.ArgTable_RemoteArgsNotSpecified);
        }
    }

    private String getStringArg(int argType) {
        Argument arg = this.fArgTable[argType];
        if (arg.exists()) {
            return arg.getValue();
        }
        return null;
    }

    public String getInputLib() {
        return this.getStringArg(0);
    }

    public String getInputObj() {
        String inputObject = this.getStringArg(1);
        if (inputObject == null) {
            return ALL;
        }
        return inputObject.toUpperCase();
    }

    public String getOutputLib() {
        return this.getStringArg(3);
    }

    public int getFileSystem() {
        Argument arg = this.fArgTable[2];
        if (arg.exists() && arg.getValue().toUpperCase().equals(OUTFS_IFS_STR)) {
            return 1;
        }
        return 0;
    }

    public boolean isPgmType() {
        Argument arg = this.fArgTable[5];
        return !arg.exists() || !arg.getValue().toUpperCase().equals(SRVPGMTYPE);
    }

    public boolean isRemoteSystem() {
        String system = this.getSystem();
        return system != null && !system.toUpperCase().equals(LOCALHOST);
    }

    public String getSystem() {
        return this.getStringArg(6);
    }

    public String getUserId() {
        return this.getStringArg(7);
    }

    public String getPasswd() {
        return this.getStringArg(8);
    }

    public String getOutDir() {
        return this.getStringArg(9);
    }

    public int getRefLibReplaceOption() {
        Argument arg = this.fArgTable[4];
        if (arg.exists()) {
            if (arg.getValue().toUpperCase().equals(REPLACE_REFLIB_OBJLIB_STR)) {
                return 1;
            }
            if (arg.getValue().toUpperCase().equals(REPLACE_REFLIB_KEEP_STR)) {
                return 2;
            }
            return 0;
        }
        return 0;
    }

    public String getWorkingLib() {
        return this.getStringArg(10);
    }

    public void dump(Log log) {
        log.println("Argument Table debug");
        int i = 0;
        while (i < 11) {
            String argVal = "Not Specified";
            if (this.fArgTable[i].exists()) {
                argVal = this.fArgTable[i].getValue();
            }
            log.println("ArgTable [" + i + "] Name:" + this.fArgTable[i].getName() + " Value:" + argVal);
            ++i;
        }
    }

    public class Argument {
        int fArgType;
        String fName;
        String fValue;
        boolean fExists = false;

        public Argument(int type, String name, String value, boolean exists) {
            this.fArgType = type;
            this.fName = name;
            this.fValue = value;
            this.fExists = exists;
        }

        public String getName() {
            return this.fName;
        }

        public void setName(String name) {
            this.fName = name;
        }

        public String getValue() {
            return this.fValue;
        }

        public void setValue(String value) {
            this.fValue = value;
        }

        public void setType(int type) {
            this.fArgType = type;
        }

        public int type() {
            return this.fArgType;
        }

        public boolean exists() {
            return this.fExists;
        }

        public void setExists(boolean exists) {
            this.fExists = exists;
        }
    }
}

