/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.internal.generator;

import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.teami.build.internal.generator.IBuildAbstractGenerator;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.IStatus;

public class IBuildAntGenerator
extends IBuildAbstractGenerator {
    public IBuildAntGenerator(IFSFile file, PrintWriter pw) {
        super(file, pw);
    }

    @Override
    public IStatus generate() throws Exception {
        return this.generate(this.replaceLastInstance(this.inputFile.getAbsolutePath(), ".ibuild", "build.xml"));
    }

    public IStatus generateHere() throws Exception {
        return this.generate(this.replaceLastInstance(this.inputFile.getAbsolutePath(), ".ibuild", ".xml"));
    }

    public IStatus generate(String antBuildFileAbsolutePath) throws Exception {
        IFSFile resultFile = new IFSFile(this.inputFile.getSystem(), antBuildFileAbsolutePath);
        if (resultFile.exists()) {
            resultFile.delete();
        }
        if (!resultFile.createNewFile()) {
            throw new Exception();
        }
        resultFile.setCCSID(1208);
        IFSFileOutputStream outputStream = new IFSFileOutputStream(resultFile);
        StreamResult result = new StreamResult((OutputStream)outputStream);
        StreamSource ibuildStream = new StreamSource((InputStream)new IFSFileInputStream(this.inputFile));
        StreamSource xsltStream = new StreamSource(this.getClass().getResourceAsStream("ibuild2ant.xsl"));
        Transformer transformer = TransformerFactory.newInstance().newTransformer(xsltStream);
        transformer.setErrorListener(new GeneratorErrorListener());
        IFSFile parent = new IFSFile(this.inputFile.getSystem(), this.inputFile.getParent());
        parent = new IFSFile(parent.getSystem(), parent.getParent());
        parent = new IFSFile(parent.getSystem(), parent.getParent());
        transformer.setParameter("BASE_DIR", parent.getAbsolutePath());
        transformer.transform(ibuildStream, result);
        return null;
    }

    private String replaceLastInstance(String s, String expr, String newValue) {
        int last = s.lastIndexOf(expr);
        if (last > 0) {
            s = String.valueOf(s.substring(0, last)) + s.substring(last).replace(expr, newValue);
        }
        return s;
    }

    public class GeneratorErrorListener
    implements ErrorListener {
        @Override
        public void error(TransformerException e) throws TransformerException {
            IBuildAntGenerator.this.pw.println(e.getLocalizedMessage());
            e.printStackTrace(IBuildAntGenerator.this.pw);
        }

        @Override
        public void fatalError(TransformerException e) throws TransformerException {
            IBuildAntGenerator.this.pw.println(e.getLocalizedMessage());
            e.printStackTrace(IBuildAntGenerator.this.pw);
        }

        @Override
        public void warning(TransformerException e) throws TransformerException {
            IBuildAntGenerator.this.pw.println(e.getLocalizedMessage());
            e.printStackTrace(IBuildAntGenerator.this.pw);
        }
    }
}

