/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.build.ant.tasks;

import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectBasic;
import com.ibm.team.enterprise.build.ant.tasks.AbstractBuildMapTask;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IOutputBuildFile;
import com.ibm.teamp.build.ant.ibmi.internal.TaskUtils;
import com.ibm.teamp.build.ant.internal.messages.Messages;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class BuildMapIBMiTask
extends AbstractBuildMapTask {
    private static final String LIST_SEPARATOR = ":";
    private static final String LIBRARY_SEPARATOR = "/";
    private static final String LIBRARY_LIST = "*LIBL";
    private static final String PGM_TYPE = "*PGM";
    private static final String SRVPGM_TYPE = "*SRVPGM";

    protected void addIntrospectionInformation(IBuildFile bf) {
        IOutputBuildFile buildFile = (IOutputBuildFile)bf;
        String objectType = buildFile.getOutputType();
        if (objectType != null && (objectType.equalsIgnoreCase(PGM_TYPE) || objectType.equalsIgnoreCase(SRVPGM_TYPE))) {
            List modules = null;
            List srvpgms = null;
            String outputObject = String.valueOf(buildFile.getBuildPath()) + LIBRARY_SEPARATOR + buildFile.getBuildFile() + "." + objectType;
            if (objectType.equalsIgnoreCase(PGM_TYPE)) {
                if (TaskUtils.getIntrospectedPGM() != null) {
                    modules = TaskUtils.getIntrospectedPGM().getModules();
                    srvpgms = TaskUtils.getIntrospectedPGM().getSrvpgms();
                    buildFile.setModule(this.convertList2String(modules));
                    this.log(NLS.bind((String)Messages.TX_MODULES_ADDED, (Object)outputObject, (Object)buildFile.getModule()), 3);
                    buildFile.setServiceProgram(this.convertList2String(srvpgms));
                    this.log(NLS.bind((String)Messages.TX_SRVPGMS_ADDED, (Object)outputObject, (Object)buildFile.getServiceProgram()), 3);
                }
            } else if (TaskUtils.getIntrospectedSRVPGM() != null) {
                modules = TaskUtils.getIntrospectedSRVPGM().getModules();
                srvpgms = TaskUtils.getIntrospectedSRVPGM().getSrvpgms();
                buildFile.setModule(this.convertList2String(modules));
                this.log(NLS.bind((String)Messages.TX_MODULES_ADDED, (Object)outputObject, (Object)buildFile.getModule()), 3);
                buildFile.setServiceProgram(this.convertList2String(srvpgms));
                this.log(NLS.bind((String)Messages.TX_SRVPGMS_ADDED, (Object)outputObject, (Object)buildFile.getServiceProgram()), 3);
            }
        }
    }

    private String convertList2String(List<ISeriesHostObjectBasic> list) {
        StringBuffer sb = new StringBuffer("");
        for (ISeriesHostObjectBasic iso : list) {
            if (sb.length() > 0) {
                sb.append(LIST_SEPARATOR);
            }
            sb.append(String.valueOf(iso.getLibrary().length() == 0 ? LIBRARY_LIST : iso.getLibrary()) + LIBRARY_SEPARATOR + iso.getName());
        }
        return sb.toString();
    }
}

