/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.build.ant.ibmi.utils;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.etools.iseries.util.AS400Factory;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import com.ibm.iant.types.AS400Type;
import com.ibm.team.enterprise.build.ant.AbstractFileSystemUtil;
import com.ibm.team.enterprise.build.ant.IFileSystemUtil;
import com.ibm.team.enterprise.build.ant.internal.utils.SimulationUtil;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IOutputBuildFile;
import com.ibm.team.enterprise.build.common.IDeletedOutputFile;
import com.ibm.team.enterprise.build.common.simulationregistry.ISimulationRegistryFile;
import com.ibm.team.enterprise.scmee.ibmi.IBMiLibraryLocation;
import com.ibm.team.filesystem.client.ILocation;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.Assert;

public class FileSystemUtil
extends AbstractFileSystemUtil {
    private static final String REGEX_TWO_PATH_ELEMENTS = "(\\S+)/(\\S+)";
    private static final String REGEX_LIB_AND_OBJTYPE = "(\\S+)/(\\S+) +OBJTYPE\\(\\*(.+)\\)";
    private static final String REGEX_LIB_AND_MBRTYPE = "(\\S+)/(\\S+)\\((\\S+)\\) +MBRTYPE\\((.+)\\)";
    private static final String FILE_OBJECT = "FILE";
    private static final String DOT = ".";
    private static final String SLASH = "/";
    private static final String LIB_SLASH = ".LIB/";
    private static final String DOT_MBR = ".MBR";
    private static String QSYS_LIB = null;
    private static final String ASTERISK = "*";
    private static IFileSystemUtil singleton = null;
    private static final String OS400 = "OS/400";
    private static final boolean IS_OS400 = "OS/400".equals(System.getProperty("os.name"));
    private static final boolean DEBUG = false;
    AS400 as400;

    private FileSystemUtil() {
    }

    public static IFileSystemUtil getInstance() {
        if (singleton == null) {
            singleton = new FileSystemUtil();
        }
        return singleton;
    }

    public FileSystemUtil(String prefix, String workspaceUuid) {
        super(prefix, workspaceUuid);
    }

    public boolean isNativePlatform() {
        return IS_OS400;
    }

    public void delete(Task task, IBuildFile buildFile) {
        if (this.as400 == null) {
            this.as400 = this.getAS400Connection(task);
        }
        if (SimulationUtil.isSimulationMode()) {
            SimulationUtil.delete((IBuildFile)buildFile);
        } else {
            try {
                this.getIFSFile(buildFile).delete();
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    public boolean exists(Task task, IBuildFile buildFile) {
        if (this.as400 == null) {
            this.as400 = this.getAS400Connection(task);
        }
        if (SimulationUtil.isSimulationMode() && buildFile instanceof IOutputBuildFile) {
            String nativePath;
            IOutputBuildFile clone = this.cloneOutputBuildFile((IOutputBuildFile)buildFile);
            if (SimulationUtil.exists((IBuildFile)clone, (String)(nativePath = FileSystemUtil.getIFSFilePathName((IBuildFile)clone, true)))) {
                return true;
            }
            if (!this.isNativePlatform()) {
                return false;
            }
        }
        try {
            return this.getIFSFile(buildFile).exists();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public boolean fileExists(Task task, ISimulationRegistryFile registryFile) {
        Assert.isNotNull((Object)registryFile);
        Assert.isNotNull((Object)registryFile.getNativePath());
        try {
            if (this.as400 == null) {
                this.as400 = this.getAS400Connection(task);
            }
            return new IFSFile(this.as400, registryFile.getNativePath()).exists();
        }
        catch (IOException e) {
            return false;
        }
    }

    private AS400 getAS400Connection(Task task) {
        AS400Type as400dt = (AS400Type)task.getProject().getReference("SystemInstance");
        if (QSYS_LIB == null && as400dt != null) {
            as400dt.getAS400();
            QSYS_LIB = IAntTaskUtils.getBaseIFSPath((String)as400dt.IASPGroup, (String)"");
        }
        return this.getAS400Connection();
    }

    private AS400 getAS400Connection() {
        AS400 conn = AS400Factory.getInstance().getAS400();
        return conn;
    }

    public void normalize(Task task, IBuildFile buildFile) {
        if (this.as400 == null) {
            this.as400 = this.getAS400Connection(task);
        }
        this.getIFSFile(buildFile, true);
    }

    public long lastModified(Task task, IBuildFile buildFile) {
        return this.lastModified(task, buildFile, false);
    }

    public long lastModified(Task task, IBuildFile buildFile, boolean save) {
        if (this.as400 == null) {
            this.as400 = this.getAS400Connection(task);
        }
        if (!SimulationUtil.isSimulationMode() || this.isNativePlatform()) {
            long value;
            IFSFile ifsFile = this.getIFSFile(buildFile);
            try {
                value = ifsFile.lastModified();
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            if (value > 0L || !SimulationUtil.isSimulationMode()) {
                if (save && SimulationUtil.isSimulationMode()) {
                    SimulationUtil.addToRegistry((IBuildFile)buildFile, (long)value, (String)FileSystemUtil.getIFSFilePathName(buildFile, false));
                }
                return value;
            }
            try {
                if (ifsFile.exists()) {
                    if (save) {
                        SimulationUtil.addToRegistry((IBuildFile)buildFile, (long)value, (String)FileSystemUtil.getIFSFilePathName(buildFile, false));
                    }
                    return value;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        IOutputBuildFile clone = this.cloneOutputBuildFile((IOutputBuildFile)buildFile);
        String nativePath = FileSystemUtil.getIFSFilePathName((IBuildFile)clone, true);
        return SimulationUtil.lastModified((IBuildFile)clone, (boolean)save, (String)nativePath);
    }

    public ILocation createLocation(String prefix) {
        IBMiLibraryLocation location = null;
        if (prefix != null) {
            location = new IBMiLibraryLocation(prefix, null, null, null);
        }
        return location;
    }

    private IFSFile getIFSFile(IBuildFile buildFile) {
        return this.getIFSFile(buildFile, false);
    }

    private IFSFile getIFSFile(IBuildFile buildFile, boolean normalize) {
        Assert.isNotNull((Object)buildFile);
        Assert.isNotNull((Object)buildFile.getBuildPath());
        Assert.isNotNull((Object)buildFile.getBuildFile());
        if (this.as400 == null) {
            this.as400 = this.getAS400Connection();
        }
        return new IFSFile(this.as400, FileSystemUtil.getIFSFilePathName(buildFile, normalize));
    }

    private static String getIFSFilePathName(String outputBuildPath, String outputBuildFile, String outputType) {
        String path = outputBuildPath.toUpperCase(Locale.US);
        String file = outputBuildFile.toUpperCase(Locale.US);
        Matcher mMbr = Pattern.compile(REGEX_LIB_AND_MBRTYPE).matcher(path);
        if (mMbr.matches()) {
            Assert.isTrue((boolean)file.equals(mMbr.group(3)));
            return String.valueOf(QSYS_LIB) + mMbr.group(1) + LIB_SLASH + mMbr.group(2) + DOT + FILE_OBJECT + SLASH + file + DOT_MBR;
        }
        Matcher m = Pattern.compile(REGEX_LIB_AND_OBJTYPE).matcher(path);
        if (m.matches()) {
            Assert.isTrue((boolean)file.equals(m.group(2)));
            return String.valueOf(QSYS_LIB) + m.group(1) + LIB_SLASH + file + DOT + m.group(3);
        }
        String objType = outputType != null && outputType.length() > 1 ? outputType.substring(1) : FILE_OBJECT;
        Matcher m2 = Pattern.compile(REGEX_TWO_PATH_ELEMENTS).matcher(path);
        String ifsFilePath = m2.matches() ? String.valueOf(QSYS_LIB) + m2.group(1) + LIB_SLASH + m2.group(2) + DOT + objType + SLASH + file + DOT_MBR : String.valueOf(QSYS_LIB) + path + LIB_SLASH + file + DOT + objType;
        return ifsFilePath;
    }

    private static String getIFSFilePathName(IBuildFile buildFile, boolean normalize) {
        String path = buildFile.getBuildPath().toUpperCase(Locale.US);
        String file = buildFile.getBuildFile().toUpperCase(Locale.US);
        Matcher mMbr = Pattern.compile(REGEX_LIB_AND_MBRTYPE).matcher(path);
        if (mMbr.matches()) {
            Assert.isTrue((boolean)file.equals(mMbr.group(3)));
            String buildPath = String.valueOf(mMbr.group(1)) + SLASH + mMbr.group(2);
            if (normalize) {
                buildFile.setBuildPath(buildPath);
            }
            return String.valueOf(QSYS_LIB) + mMbr.group(1) + LIB_SLASH + mMbr.group(2) + DOT + FILE_OBJECT + SLASH + file + DOT_MBR;
        }
        Matcher m = Pattern.compile(REGEX_LIB_AND_OBJTYPE).matcher(path);
        if (m.matches()) {
            Assert.isTrue((boolean)file.equals(m.group(2)));
            String buildPath = m.group(1);
            String objType = m.group(3);
            if (normalize) {
                buildFile.setBuildPath(buildPath);
                if (buildFile instanceof IOutputBuildFile) {
                    ((IOutputBuildFile)buildFile).setOutputType(ASTERISK + objType);
                }
            }
            return String.valueOf(QSYS_LIB) + buildPath + LIB_SLASH + file + DOT + objType;
        }
        String outputType = null;
        if (buildFile instanceof IOutputBuildFile) {
            outputType = ((IOutputBuildFile)buildFile).getOutputType();
        }
        String objType = outputType != null && outputType.length() > 1 ? outputType.substring(1) : FILE_OBJECT;
        Matcher m2 = Pattern.compile(REGEX_TWO_PATH_ELEMENTS).matcher(path);
        String ifsFilePath = m2.matches() ? String.valueOf(QSYS_LIB) + m2.group(1) + LIB_SLASH + m2.group(2) + DOT + objType + SLASH + file + DOT_MBR : String.valueOf(QSYS_LIB) + path + LIB_SLASH + file + DOT + objType;
        return ifsFilePath;
    }

    public void delete(Task task, String buildFile, String buildPath, String sequential) {
    }

    public boolean exists(Task task, String buildFile, String buildPath, String sequential) {
        return false;
    }

    private IOutputBuildFile cloneOutputBuildFile(IOutputBuildFile i) {
        if (i == null) {
            return null;
        }
        IOutputBuildFile r = (IOutputBuildFile)IOutputBuildFile.ITEM_TYPE.createItem();
        r.setBuildFile(i.getBuildFile());
        r.setBuildPath(i.getBuildPath());
        r.setPromotionBuildPath(i.getPromotionBuildPath());
        r.setResourceDefinitionStateUUID(i.getResourceDefinitionStateUUID());
        r.setResourceDefinitionUUID(i.getResourceDefinitionUUID());
        r.setTimestamp(i.getTimestamp());
        r.setType(i.getType());
        r.setOutputType(i.getOutputType());
        r.setSequential(i.isSequential());
        r.setHFS(i.isHFS());
        r.setDeployType(i.getDeployType());
        return r;
    }

    public String substituteSystemSymbols(String s) {
        return s;
    }

    public String substituteYenSignIfNeeded(String value) {
        String ret = value;
        if (ret != null && !ret.startsWith("\"") && ret.contains("\u00a5") && !this.keepYenSign()) {
            ret = ret.replace('\u00a5', '$');
        }
        System.out.println("com.ibm.teamp.build.ant.ibmi.utils.FileSystemUtil.substituteYenSignIfNeeded(String):" + value + " " + ret);
        return ret;
    }

    private boolean keepYenSign() {
        String codePage = null;
        try {
            codePage = String.valueOf(this.getPlatformCCSID());
            Charset cs = null;
            try {
                cs = Charset.forName(codePage);
            }
            catch (UnsupportedCharsetException e) {
                return false;
            }
            ByteBuffer bb = cs.encode("\u00a5");
            byte b = bb.get();
            if (b == 91) {
                return true;
            }
        }
        finally {
            return false;
        }
        {
        }
    }

    private int getPlatformCCSID() {
        if (this.as400 == null) {
            this.as400 = this.getAS400Connection();
        }
        return this.as400.getCcsid();
    }

    public long lastModified(Task task, IDeletedOutputFile outputFile) {
        long value;
        if (this.as400 == null) {
            this.as400 = this.getAS400Connection(task);
        }
        String ifsFilePath = FileSystemUtil.getIFSFilePathName(outputFile.getBuildPath(), outputFile.getBuildFile(), outputFile.getOutputType());
        IFSFile ifsFile = new IFSFile(this.as400, ifsFilePath);
        try {
            value = ifsFile.lastModified();
        }
        catch (IOException e) {
            value = 0L;
        }
        return value;
    }
}

