/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.build.ant.ibmi.types;

import com.ibm.as400.access.AS400;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBrief;
import com.ibm.etools.iseries.util.AS400Factory;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import com.ibm.iant.types.AS400Type;
import com.ibm.teamp.build.ant.ibmi.internal.TaskUtils;
import com.ibm.teamp.build.ant.ibmi.tasks.TranslationTask;
import com.ibm.teamp.build.ant.internal.messages.Messages;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class ConnectionType
extends AS400Type {
    private final AS400 _as400 = AS400Factory.getInstance().getAS400();
    private final HashMap<String, IISeriesHostObjectBrief> relationsTable = new HashMap();
    private static final String PROPERTY_PREFIX = "${";
    private String currentLibrary = "";
    private String loadLibrary = "";
    private String searchPath = "";
    private boolean wasLoadLibAlreadyInLibl = false;
    private String placeholderExternalLibrary = "";
    private String[] externalUsrlibl = null;
    private static final String BOTTOM_LIBL = "*BOTTOM";

    public void setSystemname(String systemname) throws PropertyVetoException {
        if (systemname == null || systemname.trim().length() == 0 || systemname.trim().startsWith(PROPERTY_PREFIX)) {
            return;
        }
        this._as400.setSystemName(systemname);
    }

    public void setUserid(String userid) throws PropertyVetoException {
        if (userid == null || userid.trim().length() == 0 || userid.trim().startsWith(PROPERTY_PREFIX)) {
            return;
        }
        if (this._as400.isConnected()) {
            this._as400.resetAllServices();
            TranslationTask.resetBuildTimers();
        }
        this._as400.setUserId(userid);
    }

    public void setUserpassword(String userpw) {
        if (userpw == null || userpw.trim().length() == 0 || userpw.trim().startsWith(PROPERTY_PREFIX)) {
            return;
        }
        this._as400.setPassword(userpw);
    }

    public HashMap<String, IISeriesHostObjectBrief> getRelationsTable() {
        return this.relationsTable;
    }

    public void simpleConfigureLibList(String loadLibrary, String outputLibrary, String searchPath, Task task) throws BuildException {
        task.log("simpleConfigureLibList():[" + loadLibrary + "][" + outputLibrary + "][" + searchPath + "]", 4);
        this.initializeExternalUsrLibl(task);
        if (!outputLibrary.equalsIgnoreCase(this.currentLibrary)) {
            if (!IAntTaskUtils.doesLibraryExist((AS400)this.getAS400(), (String)outputLibrary)) {
                TaskUtils.runCommandWithNoFailure("CRTLIB LIB(" + outputLibrary + ") TEXT('Created by dependency build task')" + IAntTaskUtils.getCRTLIBASPArguments((String)this.IASPGroup), this.getAS400(), task);
            }
            task.log(NLS.bind((String)Messages.C_LIBL_BEFORE, (Object)TaskUtils.getLibraryList(this.getAS400())), 4);
            TaskUtils.runCommandWithNoFailure("CHGCURLIB CURLIB(" + outputLibrary + ")", this.getAS400(), task);
            task.log(NLS.bind((String)Messages.C_LIBL_AFTER, (Object)TaskUtils.getLibraryList(this.getAS400())), 4);
            String externalLiblLocator = this.findLoadLibraryCursor(loadLibrary);
            if (externalLiblLocator == null && !loadLibrary.equalsIgnoreCase(outputLibrary)) {
                task.log(NLS.bind((String)Messages.WARNING_SRCLIB_NOT_IN_PRESET_LIBL, (Object)loadLibrary), 1);
            }
            this.searchPath = searchPath;
            this.loadLibrary = loadLibrary;
            this.currentLibrary = outputLibrary;
        } else {
            task.log(NLS.bind((String)Messages.C_LIBL_CORRECT, (Object)TaskUtils.getLibraryList(this.getAS400())), 4);
        }
    }

    public void simpleConfigureLibList(String loadLibrary, String outputLibrary, Task task) throws BuildException {
        this.simpleConfigureLibList(loadLibrary, outputLibrary, this.searchPath, task);
    }

    public void configureLibList(String loadLibrary, String outputLibrary, Task task) throws BuildException {
        this.configureLibList(loadLibrary, outputLibrary, this.searchPath, task);
    }

    public void configureLibList(String loadLibrary, String outputLibrary, String searchPath, Task task) throws BuildException {
        task.log("configureLibList():[" + loadLibrary + "][" + outputLibrary + "][" + searchPath + "]", 4);
        this.initializeExternalUsrLibl(task);
        Object[] new1 = searchPath.split("[\\s]+");
        Object[] previous = this.searchPath.split("[\\s]+");
        if (loadLibrary == null || outputLibrary == null || loadLibrary.trim().length() == 0 || outputLibrary.trim().length() == 0) {
            String msg = "ERROR: Load and object library names are required attributes.";
            this.log(msg, 0);
            throw new BuildException(msg);
        }
        if (this.currentLibrary.compareToIgnoreCase(outputLibrary) != 0 || this.loadLibrary.compareToIgnoreCase(loadLibrary) != 0 || !Arrays.equals(new1, previous)) {
            if (!IAntTaskUtils.doesLibraryExist((AS400)this.getAS400(), (String)outputLibrary)) {
                TaskUtils.runCommandWithNoFailure("CRTLIB LIB(" + outputLibrary + ") TEXT('Created by dependency build task')" + IAntTaskUtils.getCRTLIBASPArguments((String)this.IASPGroup), this.getAS400(), task);
            }
            task.log(NLS.bind((String)Messages.C_LIBL_BEFORE, (Object)TaskUtils.getLibraryList(this.getAS400())), 4);
            if (!this.loadLibrary.equalsIgnoreCase(loadLibrary)) {
                if (this.loadLibrary != null && !this.loadLibrary.isEmpty()) {
                    TaskUtils.runCommandWithNoFailure("RMVLIBLE LIB(" + this.loadLibrary + ")", this.getAS400(), task);
                }
                task.log("wasLoadLibAlreadyInLibl check 1: " + this.wasLoadLibAlreadyInLibl, 4);
                if (this.wasLoadLibAlreadyInLibl) {
                    if (this.placeholderExternalLibrary.equals(BOTTOM_LIBL)) {
                        TaskUtils.runCommandWithNoFailure("ADDLIBLE LIB(" + this.loadLibrary + ") POSITION(*LAST)", this.getAS400(), task);
                    } else {
                        String cmd = "ADDLIBLE LIB(" + this.loadLibrary + ") POSITION(*BEFORE " + this.placeholderExternalLibrary + ")";
                        TaskUtils.runCommandWithNoFailure(cmd, this.getAS400(), task);
                    }
                }
                this.placeholderExternalLibrary = this.findLoadLibraryCursor(loadLibrary);
                if (this.placeholderExternalLibrary != null) {
                    this.wasLoadLibAlreadyInLibl = true;
                    TaskUtils.runCommandWithNoFailure("RMVLIBLE LIB(" + loadLibrary + ")", this.getAS400(), task);
                } else {
                    this.wasLoadLibAlreadyInLibl = false;
                }
            }
            Object[] objectArray = previous;
            int n = previous.length;
            int n2 = 0;
            while (n2 < n) {
                Object l = objectArray[n2];
                if (!((String)l).isEmpty() && this.findLoadLibraryCursor((String)l) == null) {
                    TaskUtils.runCommandWithNoFailure("RMVLIBLE LIB(" + (String)l + ")", this.getAS400(), task);
                }
                ++n2;
            }
            int liblLength = new1.length;
            if (liblLength != 0) {
                int index = liblLength - 1;
                while (index >= 0) {
                    Object l = new1[index];
                    if (!((String)l).equalsIgnoreCase(loadLibrary)) {
                        TaskUtils.runCommandWithNoFailure("ADDLIBLE LIB(" + (String)l + ")", this.getAS400(), task);
                    }
                    --index;
                }
            }
            TaskUtils.runCommandWithNoFailure("RMVLIBLE LIB(" + loadLibrary + ")", this.getAS400(), task);
            TaskUtils.runCommandWithNoFailure("ADDLIBLE LIB(" + loadLibrary + ")", this.getAS400(), task);
            TaskUtils.runCommandWithNoFailure("CHGCURLIB CURLIB(" + outputLibrary + ")", this.getAS400(), task);
            task.log(NLS.bind((String)Messages.C_LIBL_AFTER, (Object)TaskUtils.getLibraryList(this.getAS400())), 4);
            this.searchPath = searchPath;
            this.loadLibrary = loadLibrary;
            this.currentLibrary = outputLibrary;
        } else {
            task.log(NLS.bind((String)Messages.C_LIBL_CORRECT, (Object)TaskUtils.getLibraryList(this.getAS400())), 4);
        }
    }

    private void initializeExternalUsrLibl(Task task) {
        if (this.externalUsrlibl == null) {
            this.externalUsrlibl = this.getUserLibraryListArray();
        }
    }

    public void finalResetUsrLibl(Task task) {
        if (this.wasLoadLibAlreadyInLibl) {
            if (this.placeholderExternalLibrary.equals(BOTTOM_LIBL)) {
                TaskUtils.runCommandWithNoFailure("ADDLIBLE LIB(" + this.loadLibrary + ") POSITION(*LAST)", this.getAS400(), task);
            } else {
                TaskUtils.runCommandWithNoFailure("ADDLIBLE LIB(" + this.loadLibrary + ") POSITION(*BEFORE " + this.placeholderExternalLibrary + ")", this.getAS400(), task);
            }
        }
        this.wasLoadLibAlreadyInLibl = false;
        this.placeholderExternalLibrary = null;
    }

    private String findLoadLibraryCursor(String loadLibrary) {
        if (loadLibrary == null || loadLibrary.length() == 0 || this.externalUsrlibl == null || this.externalUsrlibl.length == 0) {
            return null;
        }
        int i = 0;
        while (i < this.externalUsrlibl.length) {
            if (this.externalUsrlibl[i].equalsIgnoreCase(loadLibrary)) {
                if (i != this.externalUsrlibl.length - 1) {
                    return this.externalUsrlibl[i + 1];
                }
                return BOTTOM_LIBL;
            }
            ++i;
        }
        return null;
    }

    private String[] getUserLibraryListArray() {
        String libListString = TaskUtils.getUserLibraryList(this.getAS400());
        String[] libraryList = libListString.split("[\\s]+");
        return libraryList;
    }
}

