/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.build.ant.ibmi.tasks;

import com.ibm.as400.access.AS400;
import com.ibm.etools.iseries.comm.filters.ISeriesAbstractFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesLibraryFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesMemberFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesObjectFilterString;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostMemberNameOnly;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBasic;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBrief;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostMemberBasic;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import com.ibm.iant.taskdefs.build.IBMIInputResolver;
import com.ibm.iant.types.ICommand;
import com.ibm.iant.types.IMemberNameEntry;
import com.ibm.iant.types.IMemberPatternSet;
import com.ibm.iant.types.IMemberSet;
import com.ibm.iant.types.IObjectNameEntry;
import com.ibm.iant.types.IObjectPatternSet;
import com.ibm.iant.types.IObjectSet;
import com.ibm.iant.types.IResourceCollection;
import com.ibm.iant.types.ISource;
import com.ibm.iant.types.ITarget;
import com.ibm.iant.types.Members;
import com.ibm.iant.types.Objects;
import com.ibm.iant.types.build.IBMIInclude;
import com.ibm.iant.types.build.IBMIInput;
import com.ibm.iant.types.build.IBMIProcess;
import com.ibm.team.enterprise.build.ant.internal.utils.SimulationUtil;
import com.ibm.team.enterprise.build.ant.internal.utils.VariableUtil;
import com.ibm.teamp.build.ant.ibmi.internal.IBMiIntrospectionPGM;
import com.ibm.teamp.build.ant.ibmi.internal.IBMiIntrospectionSRVPGM;
import com.ibm.teamp.build.ant.ibmi.internal.TaskUtils;
import com.ibm.teamp.build.ant.ibmi.tasks.AbstractDependencyTask;
import com.ibm.teamp.build.ant.ibmi.tasks.CompareIBMiTimestampTask;
import com.ibm.teamp.build.ant.internal.messages.Messages;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class TranslationTask
extends AbstractDependencyTask {
    public static final String copyright = "(C) Copyright IBM Corporation 2011.";
    private boolean checkObject = true;
    private final ArrayList<IBMIProcess> processes = new ArrayList();
    private final ArrayList<IBMIProcess> absentProcessBucket = new ArrayList();
    private final ArrayList<IBMIProcess> outofDateProcessBucket = new ArrayList();
    private String searchpath = "";
    private Object currentIterativeResource;
    private List<IBMIInput> aggregatedInputs;
    private List<IBMIInput> dependencyInputs;
    private IBMIInputResolver inputResolver;
    private String buildSpecTargetName = "";
    private Objects specifiedOutputObject = null;
    private HashMap<String, String> variableSubstitutionMap = new HashMap();
    private static Date baseDateStamp = null;
    private static String tagBuildId = null;
    private static final SimpleDateFormat TAG_FORMAT = new SimpleDateFormat("yyMMddHHmm");
    private boolean needCleanup = true;
    private String loadlibrary = "";
    private String outputlibrary = "";
    private String temporarylibrary = "QTEMP";
    private String translatorname = "";
    private String expectedOutputObjectBuildLibrary = "*CURLIB";
    private Boolean trustOutputs = false;
    private Boolean previewBuild = false;
    private Boolean needsintrospection = false;
    private Boolean includeteamlibs = false;

    public TranslationTask() {
        this.log("[TranslationTask] constructor", 4);
    }

    public void setCheckobject(boolean checkObject) {
        this.checkObject = checkObject;
    }

    public void setTranslatorname(String translatorname) {
        this.translatorname = translatorname;
    }

    public IBMIProcess createProcess() {
        IBMIProcess bMIProcess = new IBMIProcess();
        this.processes.add(bMIProcess);
        return bMIProcess;
    }

    public void setNeedsintrospection(Boolean needsintrospection) {
        this.needsintrospection = needsintrospection;
    }

    public void setIncludeteamlibs(Boolean includeteamlibs) {
        this.includeteamlibs = includeteamlibs;
    }

    @Override
    public void execute() throws BuildException {
        if (SimulationUtil.isSimulationMode()) {
            return;
        }
        String value = this.getProject().getProperty("team.enterprise.build.dependency.trustOutputs");
        if (value != null) {
            this.trustOutputs = Boolean.parseBoolean(value);
        }
        if ((value = this.getProject().getProperty("team.enterprise.build.dependency.previewBuild")) != null) {
            this.previewBuild = Boolean.parseBoolean(value);
        }
        this.cleanUp();
        String sp = this.searchpath;
        if (this.includeteamlibs.booleanValue()) {
            String teamPrefix = this.getProject().getProperty("team.enterprise.scm.resourceTeamPrefix");
            String buildPrefix = this.getProject().getProperty("team.enterprise.scm.resourcePrefix");
            if (this.loadlibrary.startsWith(buildPrefix)) {
                sp = String.valueOf(this.loadlibrary.replaceFirst(buildPrefix, teamPrefix)) + (sp.isEmpty() ? "" : " ") + sp;
            }
            if (this.outputlibrary.startsWith(buildPrefix)) {
                sp = String.valueOf(this.outputlibrary.replaceFirst(buildPrefix, teamPrefix)) + (sp.isEmpty() ? "" : " ") + sp;
            }
        }
        String useExternalLibListProp = this.getProject().getProperty("com.ibm.team.enterprise.ibmi.build.overrideLibl");
        boolean useExternalLibList = false;
        if (useExternalLibListProp != null && useExternalLibListProp.equalsIgnoreCase("true")) {
            useExternalLibList = true;
        }
        if (useExternalLibList) {
            this.simpleConfigureLibList(this.loadlibrary, this.outputlibrary, sp, this);
        } else {
            this.configureLibList(this.loadlibrary, this.outputlibrary, sp, this);
        }
        this.log(NLS.bind((String)Messages.TX_EXECUTE, (Object)this.translatorname, (Object)TaskUtils.getUserLibraryList(this.getAS400())), 3);
        this.queryBaseTimeStamp();
        this.expectedOutputObjectBuildLibrary = IAntTaskUtils.getCurrentLibName((AS400)this.getAS400());
        this.categorizeProcesses();
        this.processLinkInputFile();
        if (!this.checkObject || this.trustOutputs.booleanValue()) {
            this.log(Messages.TX_GENERAL_COMMANDS, 3);
            this.runProcessesWithChecking(this.expectedOutputObjectBuildLibrary, false);
        } else {
            this.log(Messages.TX_CONDITIONAL_COMMANDS, 3);
            this.runProcessesWithChecking(this.expectedOutputObjectBuildLibrary, true);
        }
    }

    private void queryBaseTimeStamp() {
        if (baseDateStamp == null) {
            try {
                baseDateStamp = this.getAS400().getSignonDate().getTime();
            }
            catch (Exception e) {
                this.log(NLS.bind((String)Messages.TX_ERROR_TIMESTAMP, (Object)this.getAS400().getSystemName()), 0);
            }
        }
    }

    protected void cleanUp() {
        if (this.absentProcessBucket != null) {
            this.absentProcessBucket.clear();
        }
        if (this.outofDateProcessBucket != null) {
            this.outofDateProcessBucket.clear();
        }
    }

    protected void categorizeProcesses() {
        IBMIProcess outofdateProcess = null;
        boolean hasAbsentProcess = false;
        boolean hasInheritsAbsentProcess = false;
        for (IBMIProcess process : this.processes) {
            if (process.getState().equals("*OUTOFDATE")) {
                this.outofDateProcessBucket.add(process);
                outofdateProcess = process;
                continue;
            }
            if (!process.getState().equals("*ABSENT")) continue;
            hasAbsentProcess = true;
            if (!process.isInherits()) {
                this.absentProcessBucket.add(process);
                continue;
            }
            hasInheritsAbsentProcess = true;
        }
        if (!hasAbsentProcess || hasInheritsAbsentProcess) {
            if (outofdateProcess != null) {
                this.absentProcessBucket.add(outofdateProcess);
                if (!hasAbsentProcess) {
                    this.log(Messages.TX_NO_REPLACE_COMMANDS, 3);
                }
                if (hasInheritsAbsentProcess) {
                    this.log(Messages.TX_COMMANDS_USED, 3);
                }
            } else if (this.checkObject) {
                this.log(Messages.TX_ERROR_MISSING_COMMANDS, 0);
                return;
            }
        }
    }

    protected void runProcessesWithoutChecking(Collection<IBMIProcess> processes, String expectedOutputObjectBuildLibrary, IBMIInputResolver resolver) {
        if (this.isEmptyProcessBucket(processes)) {
            this.log(Messages.TX_ERROR_NO_COMMANDS, 1);
            return;
        }
        if (this.getCurrentIterativeResource() == null) {
            Objects substitutedOutputObject;
            ArrayList<Object> inputs = new ArrayList<Object>();
            Set<Object> aggregatedInputResources = this.getAggregatedResources();
            if (aggregatedInputResources != null && !aggregatedInputResources.isEmpty()) {
                inputs.addAll(aggregatedInputResources);
            }
            if ((substitutedOutputObject = this.computeSubstitutedOutputObject(this.specifiedOutputObject, this.variableSubstitutionMap)) != null) {
                this.log(NLS.bind((String)Messages.TX_OUTPUT_OBJECT, (Object)this.createQSYSObjectName(substitutedOutputObject.getLibrary(), substitutedOutputObject.getName(), substitutedOutputObject.getType(), substitutedOutputObject.getAttribute())), 2);
            }
            Objects expectedOutputObject = this.computeExpectedOutputObject(substitutedOutputObject, expectedOutputObjectBuildLibrary);
            try {
                this.runProcessCommands(processes, this.variableSubstitutionMap);
                this.checkAndGenerateRelations(expectedOutputObject);
            }
            catch (BuildException e) {
                this.postProcessRun(expectedOutputObject);
                throw e;
            }
            this.postProcessRun(expectedOutputObject);
        } else {
            try {
                Object currentResource = this.getCurrentIterativeResource();
                this.resolveInternalVariables(currentResource, this.variableSubstitutionMap);
                Objects substitutedOutputObject = this.computeSubstitutedOutputObject(this.specifiedOutputObject, this.variableSubstitutionMap);
                if (substitutedOutputObject != null) {
                    this.log(NLS.bind((String)Messages.TX_OUTPUT_OBJECT, (Object)this.createQSYSObjectName(substitutedOutputObject.getLibrary(), substitutedOutputObject.getName(), substitutedOutputObject.getType(), substitutedOutputObject.getAttribute())), 2);
                }
                ArrayList<Object> inputs = new ArrayList<Object>();
                inputs.add(currentResource);
                Objects expectedOutputObject = this.computeExpectedOutputObject(substitutedOutputObject, expectedOutputObjectBuildLibrary);
                try {
                    this.runProcessCommands(processes, this.variableSubstitutionMap);
                    this.checkAndGenerateRelations(expectedOutputObject);
                }
                catch (BuildException e) {
                    this.postProcessRun(expectedOutputObject);
                    throw e;
                }
                this.postProcessRun(expectedOutputObject);
                this.cleanupInternalVariables(this.variableSubstitutionMap);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                this.log("ERROR:" + e.toString(), 0);
                return;
            }
        }
    }

    private Set<Object> getAggregatedResources() {
        HashSet<Object> aggregatedInputResources = new HashSet<Object>();
        if (this.getAggregatedInputs() != null) {
            for (IBMIInput input : this.getAggregatedInputs()) {
                aggregatedInputResources.addAll(this.inputResolver.getResolvedResource(input));
            }
        }
        return aggregatedInputResources;
    }

    protected Objects computeSubstitutedOutputObject(Objects specifiedOutputObject, HashMap<String, String> variableSubstitutionMap) {
        String msg;
        if (specifiedOutputObject == null) {
            return null;
        }
        Objects outputObjectWithSubstitution = new Objects();
        String libraryNames = specifiedOutputObject.getLibrary();
        libraryNames = libraryNames == null ? "" : libraryNames.trim().toUpperCase();
        if (VariableUtil.isVariable((String)libraryNames)) {
            String libraryNameObject = variableSubstitutionMap.get(libraryNames);
            if (libraryNameObject != null) {
                libraryNames = libraryNameObject;
            } else {
                String msg2 = "ERROR: Variable for the output object library: " + libraryNames + " is not resolved.";
                this.log(msg2, 0);
                return null;
            }
        }
        if (VariableUtil.isAntProperty((String)libraryNames)) {
            String msg3 = "ERROR: Ant property not set: " + libraryNames;
            this.log(msg3, 0);
            return null;
        }
        String objectNames = specifiedOutputObject.getName();
        objectNames = objectNames == null ? "" : objectNames.trim().toUpperCase();
        if (VariableUtil.isVariable((String)objectNames)) {
            String objectNameObject = variableSubstitutionMap.get(objectNames);
            if (objectNameObject != null) {
                objectNames = objectNameObject;
            } else {
                String msg4 = "ERROR: Variable for the output object name: " + objectNames + " is not resolved.";
                this.log(msg4, 0);
                return null;
            }
        }
        if (VariableUtil.isAntProperty((String)objectNames)) {
            msg = "ERROR: Ant property not set: " + objectNames;
            this.log(msg, 0);
            return null;
        }
        if (objectNames.trim().length() == 0) {
            msg = "ERROR: The output object name is empty.";
            this.log(msg, 0);
            return null;
        }
        outputObjectWithSubstitution.setLibrary(libraryNames);
        outputObjectWithSubstitution.setName(objectNames);
        outputObjectWithSubstitution.setType(specifiedOutputObject.getType().trim());
        outputObjectWithSubstitution.setAttribute(specifiedOutputObject.getAttribute().trim());
        outputObjectWithSubstitution.setDeployable(specifiedOutputObject.isDeployable());
        return outputObjectWithSubstitution;
    }

    protected Objects computeExpectedOutputObject(Objects substitutedOutputObject, String intendedOutputObjectLibrary) {
        if (substitutedOutputObject == null) {
            return null;
        }
        Objects expected = new Objects();
        expected.setLibrary(intendedOutputObjectLibrary);
        expected.setName(substitutedOutputObject.getName());
        expected.setType(substitutedOutputObject.getType());
        expected.setAttribute(substitutedOutputObject.getAttribute());
        expected.setDeployable(substitutedOutputObject.isDeployable());
        return expected;
    }

    protected void postProcessRun(Objects reportedObject) {
        if (reportedObject == null || this.previewBuild.booleanValue()) {
            return;
        }
        List<IISeriesHostObjectBasic> objects = this.queryObjects(reportedObject);
        if (objects != null && objects.size() > 0) {
            Date d;
            IISeriesHostObjectBasic object = objects.get(0);
            String objectType = object.getType().trim();
            if (tagBuildId == null) {
                tagBuildId = TAG_FORMAT.format(baseDateStamp);
            }
            if ((d = object.getDateModified()) != null && d.compareTo(baseDateStamp) >= 0) {
                TaskUtils.tagOne(object, tagBuildId, this, this.getAS400());
            }
            TaskUtils.setIntrospectedPGM(null);
            TaskUtils.setIntrospectedSRVPGM(null);
            if (this.needsintrospection.booleanValue() && (objectType.equalsIgnoreCase("*PGM") || objectType.equalsIgnoreCase("*SRVPGM"))) {
                if (!IAntTaskUtils.doesLibraryExist((AS400)this.getAS400(), (String)this.temporarylibrary)) {
                    TaskUtils.runCommandWithNoFailure("CRTLIB LIB(" + this.temporarylibrary + ") TEXT('Created by dependency build task')" + IAntTaskUtils.getCRTLIBASPArguments((String)this.getASPGroupName()), this.getAS400(), this);
                }
                if (objectType.equalsIgnoreCase("*PGM")) {
                    IBMiIntrospectionPGM api = new IBMiIntrospectionPGM(this.getAS400(), object.getLibrary(), object.getName(), this.temporarylibrary);
                    try {
                        api.runAPI((Object)this);
                        TaskUtils.setIntrospectedPGM(api);
                    }
                    catch (Exception e) {
                        this.log("ERROR while introspecting a *PGM " + e.toString(), 0);
                        e.printStackTrace();
                    }
                } else {
                    IBMiIntrospectionSRVPGM api = new IBMiIntrospectionSRVPGM(this.getAS400(), object.getLibrary(), object.getName(), this.temporarylibrary);
                    try {
                        api.runAPI((Object)this);
                        TaskUtils.setIntrospectedSRVPGM(api);
                    }
                    catch (Exception e) {
                        this.log("ERROR while introspecting a *SRVPGM " + e.toString(), 0);
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private List<IISeriesHostObjectBasic> queryObjects(Objects expectedObject) {
        String filterString = new StringBuffer(expectedObject.getLibrary()).append("/").append(expectedObject.getName()).append(" OBJTYPE(").append(expectedObject.getType()).append(":").append(expectedObject.getAttribute()).append(")").toString();
        return IAntTaskUtils.getObjectListForFilterString((String)filterString, (AS400)this.getAS400());
    }

    protected void runProcessesWithChecking(String expectedOutputObjectBuildLibrary, Boolean checkTS) {
        if (this.isEmptyProcessBucket(this.processes)) {
            this.log(Messages.TX_ERROR_NO_COMMANDS, 1);
            return;
        }
        if (this.specifiedOutputObject == null) {
            this.log(Messages.TX_ERROR_MISSING_OUTPUT, 0);
            return;
        }
        Set<Object> aggregatedInputResources = this.getAggregatedResources();
        if (this.getCurrentIterativeResource() == null) {
            Objects resolvedOutputObject;
            Objects substitutedOutputObject;
            ArrayList<Object> inputs = new ArrayList<Object>();
            if (aggregatedInputResources != null && !aggregatedInputResources.isEmpty()) {
                inputs.addAll(aggregatedInputResources);
            }
            if ((substitutedOutputObject = this.computeSubstitutedOutputObject(this.specifiedOutputObject, this.variableSubstitutionMap)) != null) {
                this.log(NLS.bind((String)Messages.TX_OUTPUT_OBJECT, (Object)this.createQSYSObjectName(substitutedOutputObject.getLibrary(), substitutedOutputObject.getName(), substitutedOutputObject.getType(), substitutedOutputObject.getAttribute())), 2);
            }
            if ((resolvedOutputObject = this.resolveOutputObject(substitutedOutputObject)) == null) {
                this.logTS(Messages.TX_NO_OUTPUT_NEED_TO_BUILD, 2);
                Objects expectedOutputObject = this.computeExpectedOutputObject(substitutedOutputObject, expectedOutputObjectBuildLibrary);
                try {
                    this.runProcessCommands(this.absentProcessBucket, this.variableSubstitutionMap);
                    this.checkAndGenerateRelations(expectedOutputObject);
                }
                catch (BuildException e) {
                    this.postProcessRun(expectedOutputObject);
                    throw e;
                }
                this.postProcessRun(expectedOutputObject);
            } else {
                IISeriesHostObjectBrief resultSearchInRelationTable = null;
                boolean isUpToDate = true;
                if (checkTS.booleanValue()) {
                    String key;
                    HashMap<String, IISeriesHostObjectBrief> relationsTable = this.getRelationsTable();
                    if (relationsTable != null && (resultSearchInRelationTable = relationsTable.get(key = String.valueOf(resolvedOutputObject.getLibrary()) + resolvedOutputObject.getName())) != null) {
                        isUpToDate = false;
                        relationsTable.remove(key);
                    }
                    if (isUpToDate) {
                        isUpToDate = this.computeUpToDateAgainstAggregateInput(resolvedOutputObject, aggregatedInputResources);
                    }
                    if (isUpToDate) {
                        isUpToDate = this.computeUpToDateAgainstDependencies(resolvedOutputObject, this.dependencyInputs, this.variableSubstitutionMap, false);
                    }
                } else {
                    isUpToDate = false;
                }
                if (!isUpToDate) {
                    if (checkTS.booleanValue()) {
                        this.logTS(Messages.TX_OUT_OF_DATE_NEED_TO_BUILD, 2);
                    }
                    Objects expectedOutputObject = this.computeExpectedOutputObject(resolvedOutputObject, expectedOutputObjectBuildLibrary);
                    try {
                        if (this.isInCurLib(resolvedOutputObject, expectedOutputObjectBuildLibrary)) {
                            this.runProcessCommands(this.outofDateProcessBucket, this.variableSubstitutionMap);
                        } else {
                            this.runProcessCommands(this.absentProcessBucket, this.variableSubstitutionMap);
                        }
                        this.checkAndGenerateRelations(expectedOutputObject);
                    }
                    catch (BuildException e) {
                        this.postProcessRun(expectedOutputObject);
                        throw e;
                    }
                    this.postProcessRun(expectedOutputObject);
                } else {
                    this.log(Messages.TX_NO_NEED_TO_BUILD, 2);
                }
            }
        } else {
            try {
                Objects resolvedOutputObject;
                Object currentResource = this.getCurrentIterativeResource();
                this.resolveInternalVariables(currentResource, this.variableSubstitutionMap);
                Objects substitutedOutputObject = this.computeSubstitutedOutputObject(this.specifiedOutputObject, this.variableSubstitutionMap);
                if (substitutedOutputObject != null) {
                    this.log(NLS.bind((String)Messages.TX_OUTPUT_OBJECT, (Object)this.createQSYSObjectName(substitutedOutputObject.getLibrary(), substitutedOutputObject.getName(), substitutedOutputObject.getType(), substitutedOutputObject.getAttribute())), 2);
                }
                if ((resolvedOutputObject = this.resolveOutputObject(substitutedOutputObject)) == null) {
                    this.logTS(Messages.TX_NO_OUTPUT_NEED_TO_BUILD, 2);
                    ArrayList<Object> inputs = new ArrayList<Object>();
                    inputs.add(currentResource);
                    Objects expectedOutputObject = this.computeExpectedOutputObject(substitutedOutputObject, expectedOutputObjectBuildLibrary);
                    try {
                        this.runProcessCommands(this.absentProcessBucket, this.variableSubstitutionMap);
                        this.checkAndGenerateRelations(expectedOutputObject);
                    }
                    catch (BuildException e) {
                        this.postProcessRun(expectedOutputObject);
                        throw e;
                    }
                    this.postProcessRun(expectedOutputObject);
                } else {
                    boolean isUpToDate = true;
                    if (checkTS.booleanValue()) {
                        String key;
                        IISeriesHostObjectBrief resultSearchInRelationTable;
                        HashMap<String, IISeriesHostObjectBrief> relationsTable = this.getRelationsTable();
                        if (relationsTable != null && (resultSearchInRelationTable = relationsTable.get(key = String.valueOf(resolvedOutputObject.getLibrary()) + resolvedOutputObject.getName() + resolvedOutputObject.getType())) != null) {
                            isUpToDate = false;
                            relationsTable.remove(key);
                        }
                        if (isUpToDate) {
                            isUpToDate = this.computeUpToDateAgainstAggregateInput(resolvedOutputObject, aggregatedInputResources);
                        }
                        if (isUpToDate && (isUpToDate = this.computeUpToDateAgainstResource(resolvedOutputObject, currentResource))) {
                            isUpToDate = this.computeUpToDateAgainstDependencies(resolvedOutputObject, this.dependencyInputs, this.variableSubstitutionMap, false);
                        }
                    } else {
                        isUpToDate = false;
                    }
                    if (!isUpToDate) {
                        if (checkTS.booleanValue()) {
                            this.logTS(Messages.TX_OUT_OF_DATE_NEED_TO_BUILD, 2);
                        }
                        ArrayList<Object> inputs = new ArrayList<Object>();
                        inputs.add(currentResource);
                        Objects expectedOutputObject = this.computeExpectedOutputObject(resolvedOutputObject, expectedOutputObjectBuildLibrary);
                        try {
                            if (this.isInCurLib(resolvedOutputObject, expectedOutputObjectBuildLibrary)) {
                                this.runProcessCommands(this.outofDateProcessBucket, this.variableSubstitutionMap);
                            } else {
                                this.runProcessCommands(this.absentProcessBucket, this.variableSubstitutionMap);
                            }
                            this.checkAndGenerateRelations(expectedOutputObject);
                        }
                        catch (BuildException e) {
                            this.postProcessRun(expectedOutputObject);
                            throw e;
                        }
                        this.postProcessRun(expectedOutputObject);
                    } else {
                        this.log(Messages.TX_NO_NEED_TO_BUILD, 2);
                    }
                }
                this.cleanupInternalVariables(this.variableSubstitutionMap);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                this.log("ERROR: " + e.toString(), 0);
                return;
            }
        }
    }

    protected boolean computeUpToDateAgainstAggregateInput(Objects resolvedOutputObject, Set<Object> aggregatedInputEntries) {
        if (aggregatedInputEntries == null || aggregatedInputEntries.size() == 0) {
            return true;
        }
        boolean isUpToDate = true;
        for (Object currentResource : aggregatedInputEntries) {
            isUpToDate = this.computeUpToDateAgainstResource(resolvedOutputObject, currentResource);
            if (!isUpToDate) break;
        }
        String msg = isUpToDate ? "The existing output object is up-to-date against aggregated input." : "The existing output object is out-of-date against aggregated input.";
        this.log(msg, 3);
        return isUpToDate;
    }

    protected boolean computeUpToDateAgainstResource(Objects resolvedOutputObject, Object currentResource) {
        boolean isUpToDate = true;
        String resourceName = "";
        if (currentResource instanceof IISeriesHostMemberNameOnly) {
            IISeriesHostMemberNameOnly currentMember = (IISeriesHostMemberNameOnly)currentResource;
            isUpToDate = this.checkUpToDateForMemberSource(resolvedOutputObject, currentMember.getLibrary(), currentMember.getFile(), currentMember.getName());
            resourceName = this.createQSYSMemberName(currentMember.getLibrary(), currentMember.getFile(), currentMember.getName());
        } else if (currentResource instanceof IISeriesHostObjectBrief) {
            IISeriesHostObjectBrief currentObject = (IISeriesHostObjectBrief)currentResource;
            isUpToDate = this.checkUpToDateForObjectResource(resolvedOutputObject, currentObject.getLibrary(), currentObject.getName(), currentObject.getType());
            resourceName = this.createQSYSObjectName(currentObject.getLibrary(), currentObject.getName(), currentObject.getType(), currentObject.getSubType());
        }
        String msg = isUpToDate ? "The existing output object is up-to-date against resource: " + resourceName : "The existing output object is out-of-date against resource: " + resourceName;
        this.log(msg, 3);
        return isUpToDate;
    }

    private String createQSYSObjectName(String libName, String objName, String type, String subType) {
        StringBuffer nameBuffer = new StringBuffer(libName).append("/").append(objName).append(" OBJTYPE(").append(type);
        if (subType != null && subType.trim().length() > 0) {
            nameBuffer = nameBuffer.append(":").append(subType);
        }
        nameBuffer = nameBuffer.append(")");
        return nameBuffer.toString();
    }

    private String createQSYSMemberName(String libName, String fileName, String objName) {
        StringBuffer nameBuffer = new StringBuffer(libName).append("/").append(fileName).append("(").append(objName).append(")");
        return nameBuffer.toString();
    }

    private String createSubsitutedObjectName(String libNames, String objName, String type, String subType) {
        StringBuffer nameBuffer = new StringBuffer("Name:").append(objName).append(" Type:").append(type);
        if (subType != null && subType.trim().length() > 0) {
            nameBuffer = nameBuffer.append(" Attribute:").append(subType);
        }
        nameBuffer.append(" in libraries: ").append(libNames);
        return nameBuffer.toString();
    }

    protected boolean computeUpToDateAgainstDependencies(Objects resolvedOutputObject, List<IBMIInput> dependencyInputs, HashMap<String, String> variableSubstitutionMap, boolean auto) {
        if (dependencyInputs == null || dependencyInputs.size() == 0) {
            return true;
        }
        boolean isUpToDate = true;
        int i = 0;
        while (i < dependencyInputs.size()) {
            IBMIInput thisInput = dependencyInputs.get(i);
            Collection<Object> sourceResourceSet = this.resolveDependencyInputResources(thisInput, variableSubstitutionMap, this.inputResolver);
            Iterator<Object> iter = sourceResourceSet.iterator();
            while (isUpToDate && iter != null && iter.hasNext()) {
                Object thisDependentResource = iter.next();
                isUpToDate = this.computeUpToDateAgainstResource(resolvedOutputObject, thisDependentResource);
                if (!isUpToDate) break;
            }
            ++i;
        }
        String msg = isUpToDate ? "The existing output object is up-to-date against " + (auto ? "(auto) " : "") + "dependencies." : "The existing output object is out-of-date against " + (auto ? "(auto) " : "") + "dependencies.";
        this.log(msg, 3);
        return isUpToDate;
    }

    protected Collection<Object> resolveDependencyInputResources(IBMIInput dependencyInput, HashMap<String, String> variableSubstitutionMap, IBMIInputResolver inputResolver) {
        try {
            return inputResolver.resolve(dependencyInput, variableSubstitutionMap);
        }
        catch (Exception e) {
            this.log("Error occured when resolving " + dependencyInput.getId() + ": " + e.toString(), 0);
            return Collections.EMPTY_LIST;
        }
    }

    protected boolean checkUpToDateForMemberSource(Objects resolvedOutputObject, String sourceMemberLibrary, String sourceMemberFile, String sourceMemberName) {
        CompareIBMiTimestampTask upToDateTask = new CompareIBMiTimestampTask(this);
        Project myProject = this.getProject();
        upToDateTask.setProject(myProject);
        this.setupTargetForUpToDateTask(upToDateTask, resolvedOutputObject);
        this.setupMemberSetForUpToDateTask(upToDateTask, sourceMemberLibrary, sourceMemberFile, sourceMemberName);
        upToDateTask.execute();
        return upToDateTask.isUpToDate();
    }

    protected boolean checkUpToDateForObjectResource(Objects resolvedOutputObject, String sourceObjectLibrary, String sourceObjectName, String sourceObjectType) {
        CompareIBMiTimestampTask upToDateTask = new CompareIBMiTimestampTask(this);
        Project myProject = this.getProject();
        upToDateTask.setProject(myProject);
        this.setupTargetForUpToDateTask(upToDateTask, resolvedOutputObject);
        this.setupObjectSetForUpToDateTask(upToDateTask, sourceObjectLibrary, sourceObjectName, sourceObjectType);
        upToDateTask.execute();
        return upToDateTask.isUpToDate();
    }

    private void setupTargetForUpToDateTask(CompareIBMiTimestampTask upToDateTask, Objects resolvedOutputObject) {
        ITarget target = upToDateTask.createITarget();
        IObjectSet targetObjectSet = target.createIObjectSet();
        targetObjectSet.setProject(upToDateTask.getProject());
        targetObjectSet.setSystemref(this._systemref);
        String libraryName = resolvedOutputObject.getLibrary();
        String objectName = resolvedOutputObject.getName();
        targetObjectSet.setLibrary(libraryName);
        IObjectPatternSet objectPatternSet = targetObjectSet.createIObjectPatternSet();
        objectPatternSet.setProject(upToDateTask.getProject());
        IObjectNameEntry filter1 = (IObjectNameEntry)objectPatternSet.createInclude();
        filter1.setName(objectName);
        filter1.setType(resolvedOutputObject.getType());
    }

    private void setupObjectSetForUpToDateTask(CompareIBMiTimestampTask upToDateTask, String sourceObjectLibrary, String sourceObjectName, String sourceObjectType) {
        ISource source = upToDateTask.createISource();
        IObjectSet sourceObject = source.createIObjectSet();
        sourceObject.setProject(upToDateTask.getProject());
        sourceObject.setSystemref(this._systemref);
        sourceObject.setLibrary(sourceObjectLibrary);
        IObjectPatternSet sourceObjectPatternSet = sourceObject.createIObjectPatternSet();
        sourceObjectPatternSet.setProject(upToDateTask.getProject());
        IObjectNameEntry filter2 = (IObjectNameEntry)sourceObjectPatternSet.createInclude();
        filter2.setName(sourceObjectName);
        filter2.setType(sourceObjectType);
    }

    private void setupMemberSetForUpToDateTask(CompareIBMiTimestampTask upToDateTask, String sourceMemberLibrary, String sourceMemberFile, String sourceMemberName) {
        ISource source = upToDateTask.createISource();
        IMemberSet sourceMemberSet = source.createIMemberSet();
        sourceMemberSet.setProject(upToDateTask.getProject());
        sourceMemberSet.setSystemref(this._systemref);
        sourceMemberSet.setLibrary(sourceMemberLibrary);
        sourceMemberSet.setFileName(sourceMemberFile);
        IMemberPatternSet mbrPatternSet = sourceMemberSet.createIMemberPatternSet();
        mbrPatternSet.setProject(upToDateTask.getProject());
        IMemberNameEntry memberFilter = (IMemberNameEntry)mbrPatternSet.createInclude();
        memberFilter.setName(sourceMemberName);
    }

    private boolean isInCurLib(Objects resolvedOutputObject, String curlib) {
        String lib = resolvedOutputObject.getLibrary();
        if (lib.equalsIgnoreCase("*CURLIB")) {
            return true;
        }
        return lib.equalsIgnoreCase(curlib);
    }

    protected Objects resolveOutputObject(Objects substitutedOutputObject) {
        if (substitutedOutputObject == null) {
            return null;
        }
        Objects reslovedOutputObject = null;
        IObjectSet thisObjectSet = (IObjectSet)this.createIResourceCollection((IResourceCollection)new IObjectSet());
        thisObjectSet.setProject(this.getProject());
        thisObjectSet.setSystemref(this._systemref);
        thisObjectSet.setLibrary(substitutedOutputObject.getLibrary());
        IObjectPatternSet thisObjectPatternSet = thisObjectSet.createIObjectPatternSet();
        thisObjectPatternSet.setProject(this.getProject());
        IObjectNameEntry filter1 = (IObjectNameEntry)thisObjectPatternSet.createInclude();
        filter1.setName(substitutedOutputObject.getName());
        filter1.setType(substitutedOutputObject.getType());
        filter1.setObjectAttribute(substitutedOutputObject.getAttribute());
        try {
            StringBuffer libWithDupObj = new StringBuffer();
            if (!this.isValidMultipleOccurance(thisObjectSet)) {
                String msg = new StringBuffer("ERROR: Multiple matches found in library ").append(libWithDupObj).append(" for specified output: ").append(this.createSubsitutedObjectName(substitutedOutputObject.getLibrary(), substitutedOutputObject.getName(), substitutedOutputObject.getType(), substitutedOutputObject.getAttribute())).toString();
                this.log(msg, 0);
                throw new BuildException(msg);
            }
            Iterator thisObjectsIterator = thisObjectSet.iterator();
            if (thisObjectsIterator.hasNext()) {
                Object thisObject = thisObjectsIterator.next();
                IISeriesHostObjectBrief curObject = (IISeriesHostObjectBrief)thisObject;
                reslovedOutputObject = new Objects();
                reslovedOutputObject.setLibrary(curObject.getLibrary());
                reslovedOutputObject.setName(curObject.getName());
                reslovedOutputObject.setType(curObject.getType());
            }
        }
        catch (Exception e) {
            this.log("Error: error occurred when looking up output object: " + e.toString(), 0);
        }
        return reslovedOutputObject;
    }

    private boolean isValidMultipleOccurance(IObjectSet thisObjectSet) {
        try {
            HashMap resolvedObjects = new HashMap();
            Iterator thisObjectsIterator = thisObjectSet.iterator();
            Object thisObject = null;
            IISeriesHostObjectBrief curObject = null;
            String firstMatchLibName = null;
            String objName = null;
            Set nameSet = null;
            if (thisObjectsIterator.hasNext()) {
                thisObject = thisObjectsIterator.next();
                curObject = thisObject;
                firstMatchLibName = curObject.getLibrary().trim();
                objName = curObject.getName();
                nameSet = new HashSet<String>();
                nameSet.add(objName);
                resolvedObjects.put(firstMatchLibName, nameSet);
            }
            boolean isValid = true;
            while (thisObjectsIterator.hasNext()) {
                thisObject = thisObjectsIterator.next();
                curObject = thisObject;
                String libName = curObject.getLibrary();
                if (!libName.trim().equalsIgnoreCase(firstMatchLibName)) continue;
                objName = curObject.getName();
                nameSet = (Set)resolvedObjects.get(firstMatchLibName);
                if (nameSet == null || !nameSet.contains(objName)) continue;
                isValid = false;
                break;
            }
            return isValid;
        }
        catch (Exception e) {
            this.log("Error: " + e.toString(), 0);
            return true;
        }
    }

    protected void resolveInternalVariables(Object currentResource, HashMap<String, String> variableSubstitutionMap) {
        if (currentResource instanceof IISeriesHostMemberNameOnly) {
            IISeriesHostMemberNameOnly currentObject = (IISeriesHostMemberNameOnly)currentResource;
            variableSubstitutionMap.put("&N", currentObject.getName());
            variableSubstitutionMap.put("&F", currentObject.getFile());
            variableSubstitutionMap.put("&L", currentObject.getLibrary());
            IISeriesHostObjectBrief o = (IISeriesHostObjectBrief)currentResource;
            variableSubstitutionMap.put("&X", o != null ? o.getDescription() : "");
        } else if (currentResource instanceof IISeriesHostObjectBrief) {
            IISeriesHostObjectBrief currentObject = (IISeriesHostObjectBrief)currentResource;
            variableSubstitutionMap.put("&N", currentObject.getName());
            variableSubstitutionMap.put("&L", currentObject.getLibrary());
            variableSubstitutionMap.put("&X", currentObject.getDescription());
        }
    }

    protected void cleanupInternalVariables(HashMap<String, String> variableSubstitutionMap) {
        if (variableSubstitutionMap.get("&N") != null) {
            variableSubstitutionMap.remove("&N");
        }
        if (variableSubstitutionMap.get("&F") != null) {
            variableSubstitutionMap.remove("&F");
        }
        if (variableSubstitutionMap.get("&L") != null) {
            variableSubstitutionMap.remove("&L");
        }
        if (variableSubstitutionMap.get("&X") != null) {
            variableSubstitutionMap.remove("&X");
        }
    }

    protected void runProcessCommands(Collection<IBMIProcess> processes, HashMap<String, String> variableSubstitutionMap) {
        for (IBMIProcess process : processes) {
            Vector commands = process.getCommands();
            int i = 0;
            while (i < commands.size()) {
                ICommand thisCommand = (ICommand)commands.get(i);
                String command = thisCommand.getCommandString();
                command = VariableUtil.substituteVars((String)command, variableSubstitutionMap, (Task)this);
                this.runCommand(command);
                ++i;
            }
        }
    }

    public void setResolvedVariablesMap(HashMap<String, String> variableSubstitutionMap) {
        this.variableSubstitutionMap = variableSubstitutionMap;
    }

    public void setCurrentIterativeResource(Object currentIterativeResource) {
        this.currentIterativeResource = currentIterativeResource;
    }

    public void setAggregatedInputs(List<IBMIInput> aggregatedInputs) {
        this.aggregatedInputs = aggregatedInputs;
    }

    public void setDependencyInputs(List<IBMIInput> dependencyInputs) {
        this.dependencyInputs = dependencyInputs;
    }

    public void setInputResolver(IBMIInputResolver inputResolver) {
        this.inputResolver = inputResolver;
    }

    public Object getCurrentIterativeResource() {
        return this.currentIterativeResource;
    }

    public List<IBMIInput> getAggregatedInputs() {
        return this.aggregatedInputs;
    }

    public List<IBMIInput> getDependencyInputs() {
        return this.dependencyInputs;
    }

    public IBMIInputResolver getInputResolver() {
        return this.inputResolver;
    }

    private void processLinkInputFile() {
        Object o = this.getCurrentIterativeResource();
        if (this.needsintrospection.booleanValue() && o != null && o instanceof ISeriesHostMemberBasic) {
            ISeriesHostMemberBasic m = (ISeriesHostMemberBasic)o;
            try {
                Map<String, String> args = TaskUtils.parseLinkFile(this.getAS400(), this.getAS400().getCcsid(), m.getLibrary(), m.getFile(), m.getName());
                for (Map.Entry<String, String> e : args.entrySet()) {
                    this.variableSubstitutionMap.put("&" + e.getKey(), e.getValue());
                    this.log(NLS.bind((String)Messages.TX_LINK_ATTRIBUTE_VARIABLE, (Object)e.getKey(), (Object)e.getValue()), 3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean isEmptyProcessBucket(Collection<IBMIProcess> processes) {
        iter = processes.iterator();
        if (iter.hasNext()) ** GOTO lbl7
        return true;
lbl-1000:
        // 1 sources

        {
            process = iter.next();
            if (process.getCommands().size() <= 0) continue;
            return false;
lbl7:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl8:
        // 1 sources

        return true;
    }

    private void checkAndGenerateRelations(Objects expectedOutputObject) {
    }

    public void setBuildSpecTargetName(String buildSpecTargetName) {
        this.buildSpecTargetName = buildSpecTargetName;
    }

    public String getBuildSpecTargetName() {
        return this.buildSpecTargetName;
    }

    public void setOutputObject(Objects outputObject) {
        this.specifiedOutputObject = outputObject;
    }

    public String getSearchpath() {
        return this.searchpath;
    }

    public void setSearchpath(String searchpath) {
        this.searchpath = searchpath;
    }

    public HashMap<String, String> getSubstitutionMap() {
        return this.variableSubstitutionMap;
    }

    public void setLoadlibrary(String loadLibrary) {
        this.loadlibrary = loadLibrary;
    }

    public void setOutputlibrary(String outputLibrary) {
        this.outputlibrary = outputLibrary;
    }

    public void setTemporarylibrary(String temporaryLibrary) {
        this.temporarylibrary = temporaryLibrary;
    }

    public void setCleanupFlag(boolean needCleanup) {
        this.needCleanup = needCleanup;
    }

    public static void resetBuildTimers() {
        baseDateStamp = null;
        tagBuildId = null;
    }

    protected IBMIInput convertToIBMIInput(List<ISeriesAbstractFilterString> l) {
        IBMIInput iBMIInput = new IBMIInput();
        IBMIInclude inc = iBMIInput.createInclude();
        for (ISeriesAbstractFilterString o : l) {
            if (o instanceof ISeriesMemberFilterString) {
                Members m = inc.createMembers();
                m.setLibrary(((ISeriesMemberFilterString)o).getLibrary());
                m.setFile(((ISeriesMemberFilterString)o).getFile());
                m.setName(((ISeriesMemberFilterString)o).getMember());
                m.setType(((ISeriesMemberFilterString)o).getMemberType());
                this.log("  Member_filter[" + o.toString() + "]", 3);
                continue;
            }
            if (o instanceof ISeriesObjectFilterString) {
                Objects obj = inc.createObjects();
                obj.setLibrary(((ISeriesObjectFilterString)o).getLibrary());
                obj.setName(((ISeriesObjectFilterString)o).getObject());
                String objType = ((ISeriesObjectFilterString)o).getObjectType();
                int indx = objType.indexOf(":");
                obj.setType(indx < 0 ? objType : objType.substring(0, indx));
                obj.setAttribute(indx < 0 ? "*" : objType.substring(indx + 1));
                this.log("  Object_filter[" + o.toString() + "]", 3);
                continue;
            }
            if (!(o instanceof ISeriesLibraryFilterString)) continue;
            Objects lib = inc.createObjects();
            lib.setLibrary(((ISeriesLibraryFilterString)o).getLibrary());
            this.log("  Library_filter[" + o.toString() + "]", 3);
        }
        return iBMIInput;
    }
}

