/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.build.ant.ibmi.tasks;

import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBasic;
import com.ibm.iant.types.AbstractIResourceSet;
import com.ibm.iant.types.ISource;
import com.ibm.iant.types.ITarget;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Condition;

public class CompareIBMiTimestampTask
extends Task
implements Condition {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS ");
    private String value;
    private ITarget target;
    private ISource source;
    private boolean isUpToDate = false;
    private final Task task;

    public CompareIBMiTimestampTask() {
        this.task = this;
    }

    public CompareIBMiTimestampTask(Task t) {
        this.task = t;
    }

    public void setValue(String value) {
        this.value = value;
    }

    private String getValue() {
        return this.value != null ? this.value : "true";
    }

    public ITarget createITarget() {
        this.target = new ITarget();
        return this.target;
    }

    public ISource createISource() {
        this.source = new ISource();
        return this.source;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean eval() throws BuildException {
        AbstractIResourceSet targetResourceSet = this.target.getAbstractResourceSet();
        AbstractIResourceSet sourceResourceSet = this.source.getAbstractResourceSet();
        try {
            Date sourceDate;
            Iterator targetIter = targetResourceSet.iterator();
            if (!targetIter.hasNext()) {
                return false;
            }
            IISeriesHostObjectBasic target = (IISeriesHostObjectBasic)targetIter.next();
            Date targetDate = target.getDateModified();
            Iterator sourceIter = sourceResourceSet.iterator();
            do {
                if (!sourceIter.hasNext()) {
                    return true;
                }
                IISeriesHostObjectBasic source = (IISeriesHostObjectBasic)sourceIter.next();
                sourceDate = source.getDateModified();
                this.task.log("[CompareIBMiTimestampTask] Target: [" + target + "," + DATE_FORMAT.format(targetDate.getTime()) + "], " + "Dep: [" + source + "," + DATE_FORMAT.format(sourceDate.getTime()) + "]", 4);
            } while (targetDate.compareTo(sourceDate) >= 0);
            return false;
        }
        catch (Exception e) {
            this.task.log("[CompareIBMiTimestampTask] " + e.toString(), 0);
            throw new BuildException((Throwable)e);
        }
    }

    public void execute() throws BuildException {
        this.isUpToDate = this.eval();
    }

    public boolean isUpToDate() {
        return this.isUpToDate;
    }
}

