/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.build.ant.ibmi.tasks;

import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.enterprise.build.ant.internal.utils.BuildReportUtils;
import com.ibm.team.enterprise.build.ant.tasks.AbstractCompileTask;
import com.ibm.team.enterprise.build.ant.types.resources.BuildMapLinkCollection;
import com.ibm.team.enterprise.build.ant.types.resources.BuildableResource;
import com.ibm.team.enterprise.build.ant.types.resources.FailedBuildableResourceCollection;
import com.ibm.team.enterprise.build.common.buildreport.BuildReportGenerator;
import com.ibm.team.enterprise.build.common.buildreport.ReturnCodeResourceCollection;
import java.io.File;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class BuildReportTask
extends AbstractTeamBuildTask {
    private static final String BUILDABLE_LIST_ATTRIBUTE = "buildableList";
    private static final String LOAD_DIR_ATTRIBUTE = "loadDir";
    private static final String BUILD_RESULT_UUID_ATTRIBUTE = "buildResultUUID";
    private static final String PREVIEW_ATTRIBUTE = "preview";
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private String loadDir;
    private File fBuildableList;
    private String buildResultUUID;
    private boolean preview;

    protected void collectAntAttributes(List antAttributes) {
        antAttributes.add(new AbstractTeamBuildTask.FileAntAttribute(BUILDABLE_LIST_ATTRIBUTE, this.getBuildableList(), true, true));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(LOAD_DIR_ATTRIBUTE, this.getLoadDir(), true));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(BUILD_RESULT_UUID_ATTRIBUTE, this.getLoadDir(), true));
        antAttributes.add(new AbstractTeamBuildTask.BooleanAntAttribute(PREVIEW_ATTRIBUTE, this.isPreview(), true));
    }

    protected void doExecute() throws Exception {
        String tmpdir = this.getLoadDir() == null ? System.getProperty(JAVA_IO_TMPDIR) : this.getLoadDir();
        File outfile = new File(new File(tmpdir), "buildReport.xml");
        Properties outputsProperties = BuildableResource.loadGeneratedOutputProperties((Project)this.getProject());
        try {
            Hashtable componentsBuildMapLinks = BuildMapLinkCollection.getInstance().getResources();
            Hashtable componentsReturnCodes = ReturnCodeResourceCollection.getInstance().getResources();
            boolean isPersonalBuild = Boolean.valueOf(this.getProject().getProperty(IBuildResult.PROPERTY_PERSONAL_BUILD));
            BuildReportGenerator buildReportGenerator = new BuildReportGenerator(this.fBuildableList, outfile, this.getProject().getProperty("team.enterprise.scm.resourcePrefix"), outputsProperties, (Map)componentsBuildMapLinks, (Map)componentsReturnCodes, AbstractCompileTask.fileUUIDsBuiltSuccessfully, FailedBuildableResourceCollection.getInstance().getFailedUUIDSet(), this.preview, isPersonalBuild);
            buildReportGenerator.run();
            BuildReportUtils.publishBuildReport((File)outfile, (Project)this.getProject(), (String)this.buildResultUUID, (boolean)this.preview);
            if (FailedBuildableResourceCollection.getInstance().getSize() > 0) {
                BuildReportUtils.generateFailedBuildReport((Project)this.getProject(), (String)this.buildResultUUID);
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public File getBuildableList() {
        return this.fBuildableList;
    }

    public void setBuildableList(File buildableList) {
        this.fBuildableList = buildableList;
    }

    public String getLoadDir() {
        return this.loadDir;
    }

    public void setLoadDir(String loadDir) {
        this.loadDir = loadDir;
    }

    public String getBuildResultUUID() {
        return this.buildResultUUID;
    }

    public void setBuildResultUUID(String buildResultUUID) {
        this.buildResultUUID = buildResultUUID;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }
}

