/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.build.ant.ibmi.internal;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.etools.iseries.comm.ISeriesListLibraries;
import com.ibm.etools.iseries.comm.filters.ISeriesAbstractFilterString;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostListBaseFactory;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBasic;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBrief;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostListObjectBriefFactory;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectBasic;
import com.ibm.etools.iseries.util.ISeriesCodepageConverter;
import com.ibm.etools.iseries.util.SequentialFileReader;
import com.ibm.iant.IBMIBuildEvent;
import com.ibm.iant.IIBMICommandListener;
import com.ibm.iant.types.Members;
import com.ibm.iant.types.build.IBMIInput;
import com.ibm.team.enterprise.build.ant.IBuildableResource;
import com.ibm.team.enterprise.build.common.buildreport.BuildFileXMLModel;
import com.ibm.teamp.build.ant.ibmi.internal.IBMiIntrospectionPGM;
import com.ibm.teamp.build.ant.ibmi.internal.IBMiIntrospectionSRVPGM;
import com.ibm.teamp.build.ant.ibmi.tasks.AbstractDependencyTask;
import com.ibm.teamp.build.ant.ibmi.tasks.LanguageDefinitionTask;
import com.ibm.teamp.build.ant.ibmi.tasks.TranslationTask;
import com.ibm.teamp.build.ant.ibmi.utils.FileSystemUtil;
import com.ibm.teamp.build.ant.internal.messages.Messages;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class TaskUtils {
    protected static Set<BuildFileXMLModel> dependencies = null;
    protected static IBuildableResource resource = null;
    protected static boolean trustOutputs;
    protected static boolean mockBuild;
    protected static IBMiIntrospectionPGM introspectedPGM;
    protected static IBMiIntrospectionSRVPGM introspectedSRVPGM;
    private static final String ATTRIBUTE_SUFIX = "_ATTRIBUTE";
    private static final String LINE_CONTINUATION_STRING = "+";
    private static final String COMMENT_START_STRING1 = "//";
    private static final String COMMENT_START_STRING2 = "/*";
    private static final String OPEN_ARGUMENT = "(";
    private static final String CLOSE_ARGUMENT = ")";
    private static final String FIRST_GENERATED_LINE = "PGM";
    private static final List<String> CMDLIST;
    public static final String AS400TYPE_INSTANCE_ID_PROPERTY_NAME = "default.system.id";

    static {
        introspectedPGM = null;
        introspectedSRVPGM = null;
        CMDLIST = Arrays.asList("CRTPGM", "CRTSRVPGM", "UPDPGM", "UPDSRVPGM");
    }

    public static void setDependencies(Set<BuildFileXMLModel> dependencies) {
        TaskUtils.dependencies = dependencies;
    }

    public static void configureTask(LanguageDefinitionTask task) {
        if (dependencies != null && dependencies.size() > 0) {
            for (BuildFileXMLModel i : dependencies) {
                Members m;
                if ("SELF".equals(i.getInputType())) continue;
                IBMIInput ii = task.createInputs().createInput();
                ii.setType("*DEPENDENCY");
                ii.setId("CALCULATED DEPENDENCY in CompileIBMiTask");
                FileSystemUtil util = (FileSystemUtil)FileSystemUtil.getInstance();
                if (i.getInputType() != null && i.getInputType().contains("External")) {
                    m = ii.createInclude().createObjects();
                    m.setLibrary("*LIBL");
                    m.setName(util.substituteYenSignIfNeeded(i.getBuildFile()));
                    m.setType("*");
                    m.setAttribute("");
                    task.log("dependency object:" + m.getLibrary() + "/" + m.getName() + " OBJTYPE(" + m.getType() + ":" + m.getAttribute() + CLOSE_ARGUMENT, 4);
                    continue;
                }
                m = ii.createInclude().createMembers();
                m.setLibrary("*LIBL");
                m.setName(util.substituteYenSignIfNeeded(i.getBuildFile()));
                String[] ps = i.getBuildPath().split("[:/\\s]+");
                m.setFile(util.substituteYenSignIfNeeded(ps.length > 1 ? ps[1] : ""));
                m.setType("*FILE");
                task.log("dependency member:" + m.getLibrary() + "/" + m.getFile() + OPEN_ARGUMENT + m.getName() + CLOSE_ARGUMENT + " MBRTYPE(" + m.getType() + CLOSE_ARGUMENT, 4);
            }
        }
    }

    public static void runCommand(String cmd, AS400 system, Task invokingTask) throws BuildException {
        TaskUtils.runCommand(cmd, system, invokingTask, false);
    }

    public static void runCommand(String cmd, AS400 system, Task invokingTask, boolean failOnError) throws BuildException {
        boolean previewBuild = false;
        String value = invokingTask.getProject().getProperty("team.enterprise.build.dependency.previewBuild");
        if (value != null) {
            previewBuild = Boolean.parseBoolean(value);
        }
        if (previewBuild) {
            return;
        }
        Vector vector = invokingTask.getProject().getBuildListeners();
        Iterator iter = vector.iterator();
        Vector<IIBMICommandListener> commandListeners = new Vector<IIBMICommandListener>();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof IIBMICommandListener)) continue;
            commandListeners.add((IIBMICommandListener)obj);
        }
        Iterator commandListenersIterator = commandListeners.iterator();
        while (commandListenersIterator != null && commandListenersIterator.hasNext()) {
            IIBMICommandListener commandListener = (IIBMICommandListener)commandListenersIterator.next();
            commandListener.beforeCommandRun(TaskUtils.newEvent(invokingTask.getProject(), cmd, system));
        }
        CommandCall cmdCall = new CommandCall();
        try {
            cmdCall.setCommand(cmd);
            cmdCall.setSystem(system);
            cmdCall.setMessageOption(2);
            boolean result = cmdCall.run(cmd);
            ((AbstractDependencyTask)invokingTask).logTS(NLS.bind((String)(result ? Messages.UTIL_COMMAND_RUN_SUCCESS : Messages.UTIL_COMMAND_RUN_FAIL), (Object)cmd), 2);
            AS400Message[] messagelist = cmdCall.getMessageList();
            AS400Message highestSevMessage = null;
            int i = 0;
            while (i < messagelist.length) {
                AS400Message as400Message = messagelist[i];
                TaskUtils.displayAS400Message(as400Message, system, true, invokingTask);
                if (highestSevMessage == null || as400Message.getSeverity() > highestSevMessage.getSeverity()) {
                    highestSevMessage = messagelist[i];
                }
                ++i;
            }
            TaskUtils.setReturnCodeVariable(invokingTask, Integer.toString(highestSevMessage.getSeverity()));
            if (!result && failOnError) {
                throw new BuildException("Failed to run command: " + cmd);
            }
            commandListenersIterator = commandListeners.iterator();
            while (commandListenersIterator != null && commandListenersIterator.hasNext()) {
                IIBMICommandListener commandListener = (IIBMICommandListener)commandListenersIterator.next();
                commandListener.afterCommandRun(TaskUtils.newEvent(invokingTask.getProject(), cmd, system));
            }
            if (!result && highestSevMessage != null) {
                TaskUtils.checkIBMiCmdFailOnError(invokingTask.getProject(), highestSevMessage);
            }
        }
        catch (BuildException e) {
            invokingTask.log("[iTaskUtils] exception: " + e.toString(), 0);
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            invokingTask.log("[iTaskUtils] exception: " + e.toString(), 0);
            invokingTask.log(stackTrace, 0);
            throw new BuildException((Throwable)e);
        }
    }

    public static void checkIBMiCmdFailOnError(Project invokingTask, AS400Message highestSevMessage) throws BuildException {
        boolean failOnError = false;
        int failOnErrorThreshold = 40;
        String propertyString = invokingTask.getProperty("com.ibm.team.enterprise.ibmi.build.ant.icmd.failOnError");
        if (propertyString == null) {
            return;
        }
        failOnError = Boolean.valueOf(propertyString);
        propertyString = invokingTask.getProperty("com.ibm.team.enterprise.ibmi.build.ant.icmd.failOnError.level");
        if (propertyString != null) {
            failOnErrorThreshold = Integer.valueOf(propertyString);
        }
        if (failOnError && highestSevMessage.getSeverity() >= failOnErrorThreshold) {
            throw new BuildException("[IBMiCommand.SeverityThresholdHit]: " + highestSevMessage.toString());
        }
    }

    public static void runCommandWithNoFailure(String cmd, AS400 system, Task invokingTask) {
        CommandCall cmdCall = new CommandCall();
        try {
            cmdCall.setCommand(cmd);
            cmdCall.setSystem(system);
            cmdCall.setMessageOption(2);
            cmdCall.run(cmd);
        }
        catch (Exception e) {
            invokingTask.log("[iTaskUtils] exception: " + e.toString(), 0);
        }
    }

    public static void displayAS400Message(AS400Message as400Message, AS400 as400, boolean withHelp, Task invokingTask) {
        try {
            as400Message.load();
        }
        catch (Exception e) {
            invokingTask.log("[iTaskUtils] Exception while loading AS400Message. " + e.toString(), 0);
            throw new BuildException("Error while oading AS400Message. ", (Throwable)e);
        }
        String msgId = as400Message.getID();
        String msgText = as400Message.getText();
        byte[] subData = as400Message.getSubstitutionData();
        int severity = as400Message.getSeverity();
        String help = "";
        if (msgText.length() == 0 && msgId.trim().length() == 0 && subData != null && subData.length > 0) {
            ISeriesCodepageConverter converter = new ISeriesCodepageConverter(as400);
            try {
                msgText = converter.convHostBytesToClientString(as400.getCcsid(), subData);
            }
            catch (UnsupportedEncodingException e) {
                invokingTask.log("[iTaskUtils] exception: " + e.toString(), 1);
            }
            msgId = "";
        }
        if (msgText.length() == 0 && msgId.trim().length() == 0) {
            invokingTask.log("[iTaskUtils] getSystemMessage: Message returned is empty", 0);
        } else {
            if (withHelp) {
                int indexOfProblemChar;
                help = as400Message.getHelp();
                if (msgId != null && msgId.equalsIgnoreCase("CPFAC11") && (indexOfProblemChar = help.indexOf(0)) > -1) {
                    help = String.valueOf(help.substring(0, indexOfProblemChar)) + ' ' + help.substring(indexOfProblemChar + 1);
                }
            }
            String messageOutput = String.valueOf(msgId) + ": " + msgText;
            if (!msgId.equals("CPD4090")) {
                invokingTask.log(NLS.bind((String)Messages.UTIL_COMMAND_MESSAGE, (Object)messageOutput), severity > 30 ? 0 : 3);
                if (withHelp && help.trim().length() != 0) {
                    invokingTask.log(NLS.bind((String)Messages.UTIL_COMMAND_MESSAGE, (Object)help), severity > 30 ? 0 : 3);
                }
            }
        }
    }

    public static String getLibraryList(AS400 system) {
        ISeriesAbstractFilterString filter = ISeriesAbstractFilterString.createFilterStringObject((String)"*LIBL");
        ISeriesListLibraries api = new ISeriesListLibraries(system);
        List results = new ArrayList();
        String LibraryList = "";
        try {
            api.setInfoLevel(1);
            results = api.getList(filter, (IISeriesHostListBaseFactory)new ISeriesHostListObjectBriefFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < results.size()) {
            LibraryList = LibraryList.concat(String.valueOf(((IISeriesHostObjectBrief)results.get(i)).getName()) + " ");
            ++i;
        }
        return LibraryList;
    }

    public static String getUserLibraryList(AS400 system) {
        ISeriesAbstractFilterString filter = ISeriesAbstractFilterString.createFilterStringObject((String)"*USRLIBL");
        ISeriesListLibraries api = new ISeriesListLibraries(system);
        List results = new ArrayList();
        String LibraryList = "";
        try {
            api.setInfoLevel(1);
            results = api.getList(filter, (IISeriesHostListBaseFactory)new ISeriesHostListObjectBriefFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < results.size()) {
            LibraryList = LibraryList.concat(String.valueOf(((IISeriesHostObjectBrief)results.get(i)).getName()) + " ");
            ++i;
        }
        return LibraryList;
    }

    public static String getCurLib(AS400 system) {
        ISeriesAbstractFilterString filter = ISeriesAbstractFilterString.createFilterStringObject((String)"*CURLIB");
        ISeriesListLibraries api = new ISeriesListLibraries(system);
        String preBuildCurLib = "";
        try {
            api.setInfoLevel(1);
            List results = api.getList(filter, (IISeriesHostListBaseFactory)new ISeriesHostListObjectBriefFactory());
            if (results.size() == 1) {
                preBuildCurLib = ((IISeriesHostObjectBrief)results.get(0)).getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return preBuildCurLib;
    }

    public static ISeriesHostObjectBasic convert2IHOB(String lib, String object, String type) {
        ISeriesHostObjectBasic o = new ISeriesHostObjectBasic();
        o.setLibrary(lib);
        o.setFile(object);
        o.setName(object);
        o.setType(type);
        return o;
    }

    public static boolean tagOne(IISeriesHostObjectBasic o, String buildID, Task t, AS400 conn) {
        Boolean success = true;
        AS400Bin4 ib = new AS400Bin4();
        byte[][] data2 = new byte[][]{ib.toBytes(2), ib.toBytes(9), ib.toBytes(10), new AS400Text(10).toBytes((Object)buildID), ib.toBytes(8), ib.toBytes(1), new AS400Text(1).toBytes((Object)"1")};
        ProgramParameter[] parameterList = new ProgramParameter[5];
        parameterList[0] = new ProgramParameter(new AS400Text(10).toBytes((Object)""));
        parameterList[3] = new ProgramParameter(TaskUtils.convert2to1(data2));
        parameterList[4] = new ProgramParameter(new byte[32], 0);
        try {
            ((AbstractDependencyTask)t).logTS(NLS.bind((String)Messages.TX_TAG_INFO, (Object[])new Object[]{buildID, o.toString(), new ObjectDescription(conn, o.getLibrary(), o.getName(), o.getType().substring(1)).getValueAsString(204)}), 2);
            parameterList[1] = new ProgramParameter(new AS400Text(20).toBytes((Object)String.format("%-10s%-10s", o.getName(), o.getLibrary())));
            parameterList[2] = new ProgramParameter(new AS400Text(10).toBytes((Object)o.getType()));
            ProgramCall pgm = new ProgramCall(conn);
            success = pgm.run("QSYS.LIB/QSYS.LIB/QLICOBJD.PGM", parameterList);
            if (!success.booleanValue()) {
                AS400Message[] msgList = pgm.getMessageList();
                t.log("Unable to tag object: " + o.toString(), 0);
                t.log("  Possible causes if tagging lock is on: Object was only modified (not created) by build, or library included multiple times.", 0);
                int i1 = 0;
                while (i1 < msgList.length) {
                    t.log("  <<" + msgList[i1].getText(), 0);
                    ++i1;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return success;
    }

    private static byte[] convert2to1(byte[][] data2) {
        int size = 0;
        byte[][] byArray = data2;
        int n = data2.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] e = byArray[n2];
            size += e.length;
            ++n2;
        }
        byte[] data1 = new byte[size];
        int i = 0;
        byte[][] byArray2 = data2;
        int n3 = data2.length;
        int n4 = 0;
        while (n4 < n3) {
            byte[] e;
            byte[] byArray3 = e = byArray2[n4];
            int n5 = e.length;
            int n6 = 0;
            while (n6 < n5) {
                byte eb = byArray3[n6];
                data1[i++] = eb;
                ++n6;
            }
            ++n4;
        }
        return data1;
    }

    public static Map<String, String> parseLinkFile(AS400 conn, int ccsid, String lib, String srcpf, String member) throws AS400Exception, AS400SecurityException, InterruptedException, IOException, PropertyVetoException {
        HashMap<String, String> args = new HashMap<String, String>(10);
        SequentialFileReader sr = new SequentialFileReader(conn, ccsid, lib, srcpf, member);
        sr.setRemoveSequenceNumber();
        String l = TaskUtils.getAttributes(sr);
        boolean isGenerated = l.startsWith(FIRST_GENERATED_LINE);
        while (l != null) {
            if (l.length() > 0 && (!isGenerated || CMDLIST.contains(l.split("[\\s]+")[0]))) {
                String[] vars;
                String[] stringArray = vars = l.trim().split("[)]");
                int n = vars.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if ((s = s.trim()).contains(OPEN_ARGUMENT) && s.indexOf(OPEN_ARGUMENT) >= 1) {
                        String[] sa = s.substring(0, s.indexOf(OPEN_ARGUMENT)).split("[\\s]+");
                        s = String.valueOf(sa[sa.length - 1]) + s.substring(s.indexOf(OPEN_ARGUMENT)) + CLOSE_ARGUMENT;
                        args.put(String.valueOf(s.substring(0, s.indexOf(OPEN_ARGUMENT)).toUpperCase().trim()) + ATTRIBUTE_SUFIX, s);
                    }
                    ++n2;
                }
            }
            l = TaskUtils.getAttributes(sr);
        }
        return args;
    }

    private static String getAttributes(SequentialFileReader sr) throws IOException {
        String attribute = "";
        boolean eol = false;
        String l = sr.readNextLine();
        while (l != null && !eol) {
            if (!(l = l.trim()).startsWith(COMMENT_START_STRING1) && !l.startsWith(COMMENT_START_STRING2)) {
                if (attribute.length() == 0) {
                    if (l.contains(OPEN_ARGUMENT) && l.indexOf(OPEN_ARGUMENT) >= 1) {
                        attribute = l;
                    }
                } else {
                    attribute = attribute.replace(LINE_CONTINUATION_STRING.charAt(0), ' ');
                    attribute = String.valueOf(attribute) + l;
                }
                if (!l.endsWith(LINE_CONTINUATION_STRING)) {
                    eol = true;
                    break;
                }
            }
            l = sr.readNextLine().trim();
        }
        return l == null ? null : (attribute.contains(CLOSE_ARGUMENT) ? attribute : "");
    }

    private static IBMIBuildEvent newEvent(Project project, String cmd, AS400 system) {
        if (resource != null) {
            return new IBMIBuildEvent(resource.getComponentName(), resource.getProjectName(), project, cmd, system);
        }
        return new IBMIBuildEvent(project, cmd, system);
    }

    public static IBMiIntrospectionPGM getIntrospectedPGM() {
        return introspectedPGM;
    }

    public static void setIntrospectedPGM(IBMiIntrospectionPGM introspectedPGM) {
        TaskUtils.introspectedPGM = introspectedPGM;
    }

    public static IBMiIntrospectionSRVPGM getIntrospectedSRVPGM() {
        return introspectedSRVPGM;
    }

    public static void setIntrospectedSRVPGM(IBMiIntrospectionSRVPGM introspectedSRVPGM) {
        TaskUtils.introspectedSRVPGM = introspectedSRVPGM;
    }

    public static void setResource(IBuildableResource resource) {
        TaskUtils.resource = resource;
    }

    private static String getReturnCodeVariableName(Task invokingTask) {
        TranslationTask task = null;
        if (!(invokingTask instanceof TranslationTask)) {
            return null;
        }
        task = (TranslationTask)invokingTask;
        HashMap<String, String> variableMap = task.getSubstitutionMap();
        Set<String> keys = variableMap.keySet();
        Iterator<String> iterator = keys.iterator();
        while (iterator != null && iterator.hasNext()) {
            String currentKey = iterator.next();
            if (!currentKey.equals("&" + "RTCReturnCodeForTranslator".toUpperCase())) continue;
            return variableMap.get(currentKey);
        }
        return null;
    }

    private static void setReturnCodeVariable(Task invokingTask, String sRc) {
        String rcVar = TaskUtils.getReturnCodeVariableName(invokingTask);
        if (rcVar != null && !rcVar.isEmpty()) {
            invokingTask.getProject().setProperty(rcVar, sRc);
        }
    }
}

