/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tpt.shared.common.internal.providers.ProbabilityCostProvider");

(function() {

dojo.declare("com.ibm.team.tpt.shared.common.internal.providers.ProbabilityCostProvider", null, {

   getValue: function(attribute, workItem, configuration) {
      var consequenceCost= configuration.getChild("consCostAttribute").getIdentifier();
      var probabilityAttribute= configuration.getChild("probabilityAttribute").getIdentifier();

      var probability= this.__getLastIntSegment(workItem.getValue(probabilityAttribute));
      var consCost = parseInt(workItem.getValue(consequenceCost),10);
      var consCostVal = Math.floor(consCost * probability);
	  return consCostVal ;
   },

   __getLastIntSegment: function(identifier) {
      if (identifier != null) {
	 var lastSeparator= identifier.lastIndexOf('.');
         var numberString= identifier.substring(lastSeparator+2);
         return parseInt(numberString, 10)/100;
      }
      return -1;
   },

   __sentinel: null
});

})();