/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tpt.ide.ui.timesheet.internal.util;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.tpt.ide.ui.timesheet.internal.TimeSheetEntryPartIDE;
import com.ibm.team.tpt.ide.ui.timesheet.internal.UITimeCode;
import com.ibm.team.tpt.ide.ui.timesheet.internal.util.TimesheetMessages;
import com.ibm.team.tpt.internal.client.ITptClient;
import com.ibm.team.tpt.internal.common.items.dto.UIItemDTO;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.IWorkItemCommon;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class TimeCodeUtil {
    public void fetchLiterals(final TimeSheetEntryPartIDE timesheetIDE, final WorkItemWorkingCopy workItem) {
        FoundationJob job = new FoundationJob(TimesheetMessages.LOADING_TIMECODE){

            protected IStatus runProtected(IProgressMonitor monitor) {
                IWorkItemCommon.ITimeCode[] projectTimecodes = null;
                try {
                    IProjectAreaHandle fProjectArea = workItem.getWorkItem().getProjectArea();
                    ITeamRepository repository = workItem.getTeamRepository();
                    ITptClient client = (ITptClient)repository.getClientLibrary(ITptClient.class);
                    UIItemDTO[] timecodeList = client.getProjectAreaTimecodeList(fProjectArea.getItemId().getUuidValue(), monitor);
                    if (timecodeList != null && timecodeList.length > 0) {
                        projectTimecodes = new IWorkItemCommon.ITimeCode[timecodeList.length];
                        int i = 0;
                        while (i < timecodeList.length) {
                            projectTimecodes[i] = new UITimeCode(timecodeList[i].getItemId(), timecodeList[i].getLabel());
                            ++i;
                        }
                    }
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.tpt.ide.ui", e.getMessage());
                }
                timesheetIDE.onTimeCodesLoaded(projectTimecodes);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

