/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tpt.ide.ui.timesheet.internal.util;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.tpt.ide.ui.Activator;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class OperationUtil {
    private String fCurrentUserId = null;
    private String fCurrentUserName = null;
    private String fCurrentUserItemId = null;

    public static String resolveUser(WorkItemWorkingCopy workingCopy, IContributorHandle userHandle) {
        String userName = null;
        ITeamRepository teamRepository = workingCopy.getTeamRepository();
        NullProgressMonitor npm = new NullProgressMonitor();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        try {
            IContributor contributor = (IContributor)auditableClient.resolveAuditable((IAuditableHandle)userHandle, ItemProfile.CONTRIBUTOR_DEFAULT, (IProgressMonitor)npm);
            if (contributor != null) {
                userName = contributor.getUserId();
            }
        }
        catch (TeamRepositoryException e) {
            Activator.log(e);
        }
        return userName;
    }

    public static String resolveUserName(WorkItemWorkingCopy workingCopy, IContributorHandle userHandle) {
        String userName = null;
        ITeamRepository teamRepository = workingCopy.getTeamRepository();
        NullProgressMonitor npm = new NullProgressMonitor();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        try {
            IContributor contributor = (IContributor)auditableClient.resolveAuditable((IAuditableHandle)userHandle, ItemProfile.CONTRIBUTOR_DEFAULT, (IProgressMonitor)npm);
            if (contributor != null) {
                userName = contributor.getName();
            }
        }
        catch (TeamRepositoryException e) {
            Activator.log(e);
        }
        return userName;
    }

    public static HashMap<String, String> resolveUsers(WorkItemWorkingCopy workingCopy, List<IContributorHandle> userHandles) {
        HashMap<String, String> userNameMap = new HashMap<String, String>();
        ITeamRepository teamRepository = workingCopy.getTeamRepository();
        NullProgressMonitor npm = new NullProgressMonitor();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        try {
            List contributors = auditableClient.resolveAuditables(userHandles, ItemProfile.CONTRIBUTOR_DEFAULT, (IProgressMonitor)npm);
            if (contributors != null && contributors.size() > 0) {
                String uName = null;
                for (IContributor contr : contributors) {
                    uName = contr.getUserId();
                    if (userNameMap.containsKey(uName)) continue;
                    userNameMap.put(uName, contr.getName());
                }
            }
        }
        catch (TeamRepositoryException e) {
            Activator.log(e);
        }
        return userNameMap;
    }

    public String getCurrentUser(WorkItemWorkingCopy workingCopy) {
        return this.getCurrentUser(workingCopy, false);
    }

    public String getCurrentUser(WorkItemWorkingCopy workingCopy, boolean invalidateCache) {
        if (this.fCurrentUserId != null && !invalidateCache) {
            return this.fCurrentUserId;
        }
        IWorkItemClient workItemClient = (IWorkItemClient)workingCopy.getTeamRepository().getClientLibrary(IWorkItemClient.class);
        if (workItemClient != null) {
            this.fCurrentUserId = OperationUtil.resolveUser(workingCopy, workItemClient.getAuditableCommon().getUser());
            this.fCurrentUserItemId = workItemClient.getAuditableCommon().getUser().getItemId().toString();
            return this.fCurrentUserId;
        }
        return null;
    }

    public String getCurrentUserName(WorkItemWorkingCopy workingCopy, boolean invalidateCache) {
        if (this.fCurrentUserName != null && !invalidateCache) {
            return this.fCurrentUserName;
        }
        IWorkItemClient workItemClient = (IWorkItemClient)workingCopy.getTeamRepository().getClientLibrary(IWorkItemClient.class);
        if (workItemClient != null) {
            this.fCurrentUserName = OperationUtil.resolveUserName(workingCopy, workItemClient.getAuditableCommon().getUser());
            this.fCurrentUserItemId = workItemClient.getAuditableCommon().getUser().getItemId().toString();
            return this.fCurrentUserName;
        }
        return null;
    }

    public String getCurrentUserItemId(WorkItemWorkingCopy workingCopy) {
        return this.getCurrentUserItemId(workingCopy, false);
    }

    public String getCurrentUserItemId(WorkItemWorkingCopy workingCopy, boolean invalidateCache) {
        if (this.fCurrentUserItemId != null && !invalidateCache) {
            return this.fCurrentUserItemId;
        }
        IWorkItemClient workItemClient = (IWorkItemClient)workingCopy.getTeamRepository().getClientLibrary(IWorkItemClient.class);
        if (workItemClient != null) {
            this.fCurrentUserItemId = workItemClient.getAuditableCommon().getUser().getItemId().toString();
            return this.fCurrentUserItemId;
        }
        return null;
    }

    public String getCurrentWorkItemOwner(IWorkItem workItem, WorkItemWorkingCopy workingCopy) {
        String owner = null;
        if (workItem != null && workingCopy != null) {
            owner = OperationUtil.resolveUser(workingCopy, workItem.getOwner());
        }
        return owner;
    }

    public boolean validateWorkItemOwnerWithUser(IWorkItem workItem, WorkItemWorkingCopy workingCopy) {
        String wiOwner = this.getCurrentWorkItemOwner(workItem, workingCopy);
        String currentUser = this.getCurrentUser(workingCopy, true);
        if (wiOwner != null && currentUser != null) {
            return wiOwner.compareTo(currentUser) == 0;
        }
        return false;
    }
}

