/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tpt.ide.ui.timesheet.internal.util;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.tpt.ide.ui.timesheet.internal.util.TimesheetMessages;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtil {
    public static String formatDateRangeWithHoursMedium(Date startDate, Date endDate, double hours) {
        return DateUtil.formatDateRangeWithHours(startDate, endDate, hours, "medium");
    }

    public static String formatDateRangeWithHoursLong(Date startDate, Date endDate, double hours) {
        return DateUtil.formatDateRangeWithHours(startDate, endDate, hours, "long");
    }

    public static String formatDateRangeWithHours(Date startDate, Date endDate, double hours, String format) {
        MessageFormat messageFormat = new MessageFormat("{0,date," + format + "}", Locale.getDefault());
        String startDate1 = messageFormat.format(new Object[]{startDate});
        String endDate1 = messageFormat.format(new Object[]{endDate});
        String hoursInString = MessageFormat.format("{0}", hours);
        String label = NLS.bind((String)TimesheetMessages.DATE_FROM_TO_HOURS, (Object)startDate1, (Object[])new Object[]{endDate1, hoursInString});
        return label;
    }

    public static String formatDateRangeMedium(Date startDate, Date endDate) {
        return DateUtil.formatDateRange(startDate, endDate, "medium");
    }

    public static String formatDateRangeLong(Date startDate, Date endDate) {
        return DateUtil.formatDateRange(startDate, endDate, "long");
    }

    public static String formatDateRange(Date startDate, Date endDate, String format) {
        MessageFormat messageFormat = new MessageFormat("{0,date," + format + "}", Locale.getDefault());
        String startDate1 = messageFormat.format(new Object[]{startDate});
        String endDate1 = messageFormat.format(new Object[]{endDate});
        String label = NLS.bind((String)TimesheetMessages.DATE_FROM_TO, (Object)startDate1, (Object[])new Object[]{endDate1});
        return label;
    }

    public static boolean compareDatesForDayOnly(Calendar firstDate, Calendar secondDate) {
        return firstDate != null && secondDate != null && firstDate.get(1) == secondDate.get(1) && firstDate.get(2) == secondDate.get(2) && firstDate.get(5) == secondDate.get(5);
    }
}

