/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tpt.ide.ui.timesheet.internal.helper;

import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.tpt.ide.ui.timesheet.internal.TimeSheetEntryPartIDE;
import com.ibm.team.tpt.ide.ui.timesheet.internal.UITimeCode;
import com.ibm.team.tpt.ide.ui.timesheet.internal.helper.TimeSheetEntries;
import com.ibm.team.tpt.ide.ui.timesheet.internal.helper.TimesheetIDEColumnProvider;
import com.ibm.team.tpt.ide.ui.timesheet.internal.util.NumberUtil;
import com.ibm.team.tpt.ide.ui.timesheet.internal.util.OperationUtil;
import com.ibm.team.tpt.ide.ui.timesheet.internal.util.TimesheetMessages;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.ITimeSheetEntry;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TimeSheetTableHelper {
    public Date fWeekDate = null;
    public Table fTable = null;
    public HashMap<String, Integer> fTotalTimeSpent = null;
    private TimesheetIDEColumnProvider fColumnProvider;
    private TimeSheetEntryPartIDE fTimesheetEnrtyPartWidget;
    private String fWorkItemType = "";
    private Boolean fTimesheetRecordPresent = false;
    private TimeSheetEntries fInput;
    private Set<String> fSavedTimeCodes = null;
    public int fSavedrows = 0;
    public boolean fAdded = false;
    public boolean fNoEntryRow = false;
    private IWorkItemCommon.ITimeCode[] fProjectTimeCodes;
    private HashMap<String, String> fOwnerNamesCache = new HashMap();
    private OperationUtil fOperationUtil = new OperationUtil();

    public void initializeTimesheetTableViewer(TimesheetIDEColumnProvider columnProvider, Date weekDate, TimeSheetEntryPartIDE timesheetEnrtyPartWidget, Table table) {
        this.fTotalTimeSpent = new HashMap();
        this.fColumnProvider = columnProvider;
        this.fWeekDate = weekDate;
        this.fWeekDate = TimeSheetTableHelper.formatDate(this.fWeekDate);
        this.fTimesheetEnrtyPartWidget = timesheetEnrtyPartWidget;
        this.fTable = table;
    }

    public void setWeekDate(Date weekDateVal) {
        this.fWeekDate = weekDateVal;
        this.fWeekDate = TimeSheetTableHelper.formatDate(this.fWeekDate);
        if (!this.fTimesheetRecordPresent.booleanValue()) {
            this.refresh();
        } else {
            this.refreshTimesheetTableforNewDate();
        }
    }

    public void setWorkItemType(String workItemType) {
        this.fWorkItemType = workItemType;
    }

    public void setProjectTimecodes(IWorkItemCommon.ITimeCode[] projectTimeCodes) {
        this.fProjectTimeCodes = projectTimeCodes;
    }

    public void setInput(Object timesheet) {
        this.fInput = (TimeSheetEntries)timesheet;
    }

    public TimesheetIDEColumnProvider getColumnProvider() {
        return this.fColumnProvider;
    }

    public void refresh() {
        if (this.fInput != null) {
            this.fTable.removeAll();
            this.createTimesheetRow();
        }
    }

    public void destroy(boolean param) {
        this.fTable.removeAll();
    }

    public String getUserNameForId(String userId) {
        return this.fOwnerNamesCache.get(userId);
    }

    private void refreshOwnerNames(HashMap<String, String> newUserList) {
        String[] newKeys = new String[newUserList.size()];
        newUserList.keySet().toArray(newKeys);
        String[] stringArray = newKeys;
        int n = newKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String newKey = stringArray[n2];
            if (!this.fOwnerNamesCache.containsKey(newKey)) {
                this.fOwnerNamesCache.put(newKey, newUserList.get(newKey));
            }
            ++n2;
        }
    }

    public void createTimesheetRow() {
        String[] timeCodes = this.getTimeCodes();
        if (timeCodes == null || timeCodes.length == 0) {
            this.fTimesheetRecordPresent = false;
            return;
        }
        HashMap<String, String> userNameMap = this.getUsersFromDTOs1();
        this.refreshOwnerNames(userNameMap);
        String[] allUsers1 = new String[userNameMap.size()];
        userNameMap.keySet().toArray(allUsers1);
        String[] stringArray = allUsers1;
        int n = allUsers1.length;
        int n2 = 0;
        while (n2 < n) {
            String userId = stringArray[n2];
            HashMap<IWorkItemCommon.ITimeCode, ITimeSheetEntry[]> validTimesheetDTOs = this.getWeekData(userId);
            Set<IWorkItemCommon.ITimeCode> allKeys = validTimesheetDTOs.keySet();
            for (IWorkItemCommon.ITimeCode timeCode : allKeys) {
                double weekTotal = 0.0;
                TableItem row = new TableItem(this.fTable, 4);
                row.setText(1, timeCode.getTimeCodeLabel());
                ITimeSheetEntry[] validTimesheetDTO = validTimesheetDTOs.get(timeCode);
                row.setText(0, this.fOwnerNamesCache.get(userId));
                HashMap<String, String> rowData = new HashMap<String, String>();
                rowData.put("userId", userId);
                rowData.put("timeCode", (String)timeCode);
                boolean isSaved = false;
                int i = 2;
                int j = 0;
                while (validTimesheetDTO != null && i <= 8) {
                    if (validTimesheetDTO[j] != null) {
                        UUID id = validTimesheetDTO[j].getStateId();
                        if (id != null) {
                            isSaved = true;
                        }
                        double hoursSpent = validTimesheetDTO[j].getHoursSpent();
                        String resultString = NumberUtil.formatHours(hoursSpent);
                        row.setText(i, resultString);
                        weekTotal += hoursSpent;
                    } else {
                        row.setText(i, TimesheetMessages.ZERO_HOURS);
                    }
                    ++i;
                    ++j;
                }
                if (isSaved) {
                    rowData.put("isSaved", "true");
                } else {
                    rowData.put("isSaved", "false");
                }
                row.setData(rowData);
                String weekTotalStr = NumberUtil.formatHours(weekTotal);
                row.setText(9, weekTotalStr);
                String workItemTotalStr = NumberUtil.formatHours(this.fInput.getWorkItemTotalForTimeCodeAndUser(timeCode, userId));
                row.setText(10, workItemTotalStr);
                this.fTimesheetRecordPresent = true;
            }
            ++n2;
        }
    }

    public void addTimesheetRow(double[] weekData, IWorkItemCommon.ITimeCode timeCode) {
        String hoursInString;
        this.fAdded = false;
        if (!this.fTimesheetRecordPresent.booleanValue()) {
            this.fTable.removeAll();
        }
        TableItem row = new TableItem(this.fTable, 4);
        row.setText(1, timeCode.getTimeCodeLabel());
        String ownerUserId = this.getCurrentUser(true);
        if (!this.fOwnerNamesCache.containsKey(ownerUserId)) {
            this.fOwnerNamesCache.put(ownerUserId, this.getCurrentUserName());
        }
        HashMap<String, String> rowData = new HashMap<String, String>();
        rowData.put("userId", ownerUserId);
        rowData.put("isSaved", "false");
        rowData.put("timeCode", (String)timeCode);
        row.setText(0, this.fOwnerNamesCache.get(ownerUserId));
        row.setData(rowData);
        int currentDateIndex = 0;
        double weekTotal = 0.0;
        int i = 2;
        int j = 0;
        while (i <= 8) {
            long currentDateValue = this.fWeekDate.getTime() + (long)(currentDateIndex * 86400000);
            Date startDate = new Date(currentDateValue);
            startDate = TimeSheetTableHelper.formatDate(startDate);
            hoursInString = NumberUtil.formatHours(weekData[j]);
            row.setText(i, hoursInString);
            double timespent = weekData[j];
            weekTotal += timespent;
            ++currentDateIndex;
            if (timespent > 0.0) {
                this.fAdded = true;
                this.fNoEntryRow = false;
                this.fInput.addTimeSheetEntry(startDate, timespent, this.fWorkItemType, timeCode, false);
            }
            ++i;
            ++j;
        }
        if (this.fAdded) {
            this.fInput.updateWorkItemTimeSpent();
        } else {
            this.fNoEntryRow = true;
            this.fAdded = false;
        }
        hoursInString = NumberUtil.formatHours(weekTotal);
        row.setText(9, hoursInString);
        hoursInString = NumberUtil.formatHours(this.fInput.getWorkItemTotalForTimeCodeAndUser(timeCode, this.getCurrentUser(true)));
        row.setText(10, hoursInString);
        this.fTimesheetRecordPresent = true;
        this.fTimesheetEnrtyPartWidget.handleSave(false);
    }

    public void editTimesheetRow(String[] weekData, double[] newWeekData, TableItem row, IWorkItemCommon.ITimeCode oldTimeCode, IWorkItemCommon.ITimeCode newTimeCode) {
        String hrsInString;
        int currentDateIndex = 0;
        Map rowData = (Map)row.getData();
        IWorkItemCommon.ITimeCode timeCode = (IWorkItemCommon.ITimeCode)rowData.get("timeCode");
        if (newTimeCode != null && !oldTimeCode.equals(newTimeCode)) {
            this.modifyExistingTimesheetDate(oldTimeCode, newTimeCode);
            row.setText(1, newTimeCode.getTimeCodeLabel());
            rowData.put("timeCode", newTimeCode);
        }
        String weekTotal = row.getText(9);
        String total = row.getText(10);
        double weekTotalVal = NumberUtil.parseHours(weekTotal, 0.0);
        double totalVal = NumberUtil.parseHours(total, 0.0);
        boolean needsUpdate = false;
        int i = 2;
        int j = 0;
        while (i <= 8) {
            double oldTimeSpent;
            double hoursSpent;
            if (newWeekData[j] == 0.0) {
                newWeekData[j] = 0.0;
            }
            if ((hoursSpent = newWeekData[j]) != (oldTimeSpent = NumberUtil.parseHours(weekData[j], 0.0))) {
                long currentDateValue = this.fWeekDate.getTime() + (long)(currentDateIndex * 86400000);
                Date startDate = new Date(currentDateValue);
                startDate = TimeSheetTableHelper.formatDate(startDate);
                weekTotalVal = weekTotalVal + hoursSpent - oldTimeSpent;
                totalVal = totalVal + hoursSpent - oldTimeSpent;
                if (this.fInput != null) {
                    ITimeSheetEntry timesheetEntry = this.fInput.getTimesheetEntryWithStartDateAndTimecode(startDate, timeCode, this.getCurrentUserItemId());
                    needsUpdate = true;
                    if (timesheetEntry != null) {
                        this.fInput.removeTimeSheetEntry(timesheetEntry, false);
                        ITimeSheetEntry te = (ITimeSheetEntry)timesheetEntry.getWorkingCopy();
                        te.setHoursSpent(hoursSpent);
                        this.fInput.replaceTimeSheetEntry(te, false);
                    } else {
                        this.fInput.addTimeSheetEntry(startDate, hoursSpent, this.fWorkItemType, timeCode, false);
                    }
                    hrsInString = NumberUtil.formatHours(newWeekData[j]);
                    row.setText(i, hrsInString);
                }
            }
            ++currentDateIndex;
            ++i;
            ++j;
        }
        if (needsUpdate) {
            this.fInput.updateWorkItemTimeSpent();
        }
        hrsInString = NumberUtil.formatHours(weekTotalVal);
        row.setText(9, hrsInString);
        hrsInString = NumberUtil.formatHours(totalVal);
        row.setText(10, hrsInString);
        this.fTimesheetEnrtyPartWidget.handleSave(true);
    }

    private String[] getTimeCodes() {
        HashMap<String, String> timeCodes = new HashMap<String, String>();
        ITimeSheetEntry[] timesheetDTOs = this.fInput.getTimeSheetEntries();
        if (timesheetDTOs != null) {
            ITimeSheetEntry[] iTimeSheetEntryArray = timesheetDTOs;
            int n = timesheetDTOs.length;
            int n2 = 0;
            while (n2 < n) {
                ITimeSheetEntry timesheetDTO = iTimeSheetEntryArray[n2];
                if (!timeCodes.containsKey(timesheetDTO.getTimeCodeId())) {
                    timeCodes.put(timesheetDTO.getTimeCodeId(), timesheetDTO.getTimeCodeId());
                    this.fTotalTimeSpent.put(timesheetDTO.getTimeCodeId(), 0);
                }
                ++n2;
            }
        }
        this.fSavedTimeCodes = timeCodes.keySet();
        String[] savedTimeCodes = new String[this.fSavedTimeCodes.size()];
        return this.fSavedTimeCodes.toArray(savedTimeCodes);
    }

    private ArrayList<String> getUsersFromDTOs() {
        ITimeSheetEntry[] timesheetDTO = this.fInput.getTimeSheetEntries();
        ArrayList<String> userList = new ArrayList<String>();
        String tempUser = null;
        ITimeSheetEntry[] iTimeSheetEntryArray = timesheetDTO;
        int n = timesheetDTO.length;
        int n2 = 0;
        while (n2 < n) {
            ITimeSheetEntry singleEntry = iTimeSheetEntryArray[n2];
            if (singleEntry != null && !userList.contains(tempUser = this.resolveUser(this.fInput.getWorkingCopy(), singleEntry.getCreator()))) {
                userList.add(tempUser);
            }
            ++n2;
        }
        return userList;
    }

    private HashMap<String, String> getUsersFromDTOs1() {
        ITimeSheetEntry[] timesheetDTO = this.fInput.getTimeSheetEntries();
        ArrayList<IContributorHandle> contribList = new ArrayList<IContributorHandle>();
        IContributorHandle contribHandle = null;
        ITimeSheetEntry[] iTimeSheetEntryArray = timesheetDTO;
        int n = timesheetDTO.length;
        int n2 = 0;
        while (n2 < n) {
            ITimeSheetEntry singleEntry = iTimeSheetEntryArray[n2];
            if (singleEntry != null && !contribList.contains(contribHandle = singleEntry.getCreator())) {
                contribList.add(contribHandle);
            }
            ++n2;
        }
        HashMap<String, String> userNameMap = OperationUtil.resolveUsers(this.fInput.getWorkingCopy(), contribList);
        return userNameMap;
    }

    private HashMap<IWorkItemCommon.ITimeCode, ITimeSheetEntry[]> getWeekData(String userName) {
        HashMap<IWorkItemCommon.ITimeCode, ITimeSheetEntry[]> timesheetEntriesMap = new HashMap<IWorkItemCommon.ITimeCode, ITimeSheetEntry[]>();
        ITimeSheetEntry[] timesheetDTO = this.fInput.getTimeSheetEntries();
        Date sevenDaysAfterStartDate = new Date(this.fWeekDate.getTime() + 518400000L);
        ITimeSheetEntry[] validTimeSheetEntries = null;
        String user = null;
        int i = 0;
        while (i < timesheetDTO.length) {
            user = this.resolveUser(this.fInput.getWorkingCopy(), timesheetDTO[i].getCreator());
            if (userName.compareTo(user) == 0) {
                Timestamp sDate = timesheetDTO[i].getStartDate();
                Date startDate = new Date(sDate.getTime());
                startDate = TimeSheetTableHelper.formatDate(startDate);
                IWorkItemCommon.ITimeCode timeCode = this.getTimeCode(timesheetDTO[i].getTimeCodeId());
                if (timeCode == null) {
                    timeCode = new UITimeCode(timesheetDTO[i].getTimeCodeId(), timesheetDTO[i].getTimeCodeId());
                }
                if (startDate.compareTo(this.fWeekDate) >= 0 && startDate.compareTo(sevenDaysAfterStartDate) <= 0) {
                    int index = this.getIndex(startDate);
                    validTimeSheetEntries = timesheetEntriesMap.get(timeCode);
                    if (validTimeSheetEntries != null) {
                        validTimeSheetEntries[index] = timesheetDTO[i];
                        timesheetEntriesMap.put(timeCode, validTimeSheetEntries);
                    } else {
                        ITimeSheetEntry[] newEntry = new ITimeSheetEntry[7];
                        newEntry[index] = timesheetDTO[i];
                        timesheetEntriesMap.put(timeCode, newEntry);
                    }
                }
            }
            ++i;
        }
        return timesheetEntriesMap;
    }

    private IWorkItemCommon.ITimeCode getTimeCode(String timeCodeId) {
        IWorkItemCommon.ITimeCode[] iTimeCodeArray = this.fProjectTimeCodes;
        int n = this.fProjectTimeCodes.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkItemCommon.ITimeCode timeCode = iTimeCodeArray[n2];
            if (timeCode.getTimeCodeId().equals(timeCodeId)) {
                return timeCode;
            }
            ++n2;
        }
        return null;
    }

    protected void modifyExistingTimesheetDate(IWorkItemCommon.ITimeCode oldTimeCode, IWorkItemCommon.ITimeCode newTimeCode) {
        if (this.fInput != null) {
            Date sevenDaysAfterStartDate = new Date(this.fWeekDate.getTime() + 518400000L);
            ITimeSheetEntry[] timesheetEntries = this.fInput.getAllTimesheetWithTimeCodes(oldTimeCode, this.getCurrentUserItemId());
            if (timesheetEntries != null && timesheetEntries.length > 0) {
                int i = 0;
                while (i < timesheetEntries.length) {
                    Date timesheetDate = new Date(timesheetEntries[i].getStartDate().getTime());
                    if (timesheetDate.compareTo(this.fWeekDate) >= 0 && timesheetDate.compareTo(sevenDaysAfterStartDate) <= 0) {
                        ITimeSheetEntry te = (ITimeSheetEntry)timesheetEntries[i].getWorkingCopy();
                        te.setTimeCode(newTimeCode.getTimeCodeLabel());
                        te.setTimeCodeId(newTimeCode.getTimeCodeId());
                        this.fInput.removeTimeSheetEntry(timesheetEntries[i], false);
                        this.fInput.replaceTimeSheetEntry(te, false);
                    }
                    ++i;
                }
                this.fInput.updateWorkItemTimeSpent();
            }
        }
    }

    public int getIndex(Date startDate) {
        long startTime = startDate.getTime();
        long weekDateTime = this.fWeekDate.getTime();
        long diff = startTime - weekDateTime;
        int index = (int)(diff / 86400000L);
        return index;
    }

    public static Date formatDate(Date date) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(date);
        cal.set(11, 12);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date d = cal.getTime();
        return d;
    }

    public void deleteRow(int rowNumber) {
        Map rowData = (Map)this.fTable.getItem(rowNumber).getData();
        IWorkItemCommon.ITimeCode timeCode = (IWorkItemCommon.ITimeCode)rowData.get("timeCode");
        if (timeCode != null) {
            Date sevenDaysAfterStartDate = new Date(this.fWeekDate.getTime() + 518400000L);
            ITimeSheetEntry[] timesheetEntry = this.fInput.getAllTimesheetWithTimeCodes(timeCode, this.getCurrentUserItemId());
            if (timesheetEntry != null && timesheetEntry.length > 0) {
                int length = timesheetEntry.length;
                int i = 0;
                while (i < length) {
                    Date timesheetDate = new Date(timesheetEntry[i].getStartDate().getTime());
                    if (timesheetDate.compareTo(this.fWeekDate) >= 0 && timesheetDate.compareTo(sevenDaysAfterStartDate) <= 0) {
                        this.fInput.removeTimeSheetEntry(timesheetEntry[i], false);
                    }
                    ++i;
                }
                this.fInput.updateWorkItemTimeSpent();
                this.fTimesheetEnrtyPartWidget.handleSave(false);
            }
        }
        this.fTable.remove(rowNumber);
        if (this.fTable.getChildren() == null) {
            TableItem emptyRow = new TableItem(this.fTable, 4);
            emptyRow.setText(TimesheetMessages.NO_TIMESHEET_RECORD_PRESENT);
            this.fTimesheetRecordPresent = false;
        }
    }

    private void refreshTimesheetTableforNewDate() {
        if (!this.fTable.isDisposed()) {
            this.fTable.removeAll();
            this.createTimesheetRow();
        }
    }

    private String getCurrentUserItemId() {
        return this.fOperationUtil.getCurrentUserItemId(this.fInput.getWorkingCopy());
    }

    private String getCurrentUser(boolean invalidateCache) {
        return this.fOperationUtil.getCurrentUser(this.fInput.getWorkingCopy(), invalidateCache);
    }

    private String getCurrentUserName() {
        return this.fOperationUtil.getCurrentUserName(this.fInput.getWorkingCopy(), true);
    }

    private String resolveUser(WorkItemWorkingCopy fWorkingCopy, IContributorHandle userHandle) {
        return OperationUtil.resolveUser(fWorkingCopy, userHandle);
    }
}

