/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tpt.ide.ui.timesheet.internal.helper;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.tpt.ide.ui.Activator;
import com.ibm.team.tpt.ide.ui.timesheet.internal.util.DateUtil;
import com.ibm.team.tpt.ide.ui.timesheet.internal.util.OperationUtil;
import com.ibm.team.tpt.ide.ui.timesheet.internal.util.TimesheetMessages;
import com.ibm.team.workitem.client.IDependentItems;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.ITimeSheetEntry;
import com.ibm.team.workitem.common.model.ITimeSheetEntryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class TimeSheetEntries {
    private ArrayList<ITimeSheetEntry> fTimeSheetEntries;
    private HashMap<UUID, ITimeSheetEntry> fOriginalItems;
    private WorkItemWorkingCopy fWorkingCopy;
    IWorkItemReferences fReferences;
    private final String TIME_SPENT = "timeSpent";
    private Boolean fIsTimetrackingSyncEnabled = new Boolean(false);

    public WorkItemWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }

    public void setTimetrackingSyncEnabled(Boolean fIsTimetrackingSyncEnabled) {
    }

    public void initialize(WorkItemWorkingCopy workingCopy, boolean isTimeTrackingSyncEnabled) throws TeamRepositoryException {
        this.fIsTimetrackingSyncEnabled = isTimeTrackingSyncEnabled;
        this.fWorkingCopy = workingCopy;
        ITimeSheetEntry[] timesheetEntry = this.resolveReferences();
        if (timesheetEntry == null) {
            timesheetEntry = new ITimeSheetEntry[]{};
        }
        this.fTimeSheetEntries = new ArrayList();
        this.fOriginalItems = new HashMap();
        ITimeSheetEntry[] iTimeSheetEntryArray = timesheetEntry;
        int n = timesheetEntry.length;
        int n2 = 0;
        while (n2 < n) {
            ITimeSheetEntry entry = iTimeSheetEntryArray[n2];
            this.fTimeSheetEntries.add(entry);
            this.fOriginalItems.put(entry.getItemId(), entry);
            ++n2;
        }
    }

    public void reloadEntries() {
        ITimeSheetEntry[] timesheetEntry = null;
        try {
            timesheetEntry = this.resolveReferences();
            if (timesheetEntry == null) {
                timesheetEntry = new ITimeSheetEntry[]{};
            }
        }
        catch (TeamRepositoryException e) {
            Activator.log(e);
        }
        this.fTimeSheetEntries = new ArrayList();
        this.fOriginalItems = new HashMap();
        if (timesheetEntry.length > 0) {
            ITimeSheetEntry[] iTimeSheetEntryArray = timesheetEntry;
            int n = timesheetEntry.length;
            int n2 = 0;
            while (n2 < n) {
                ITimeSheetEntry entry = iTimeSheetEntryArray[n2];
                if (entry != null && entry.getItemId() != null) {
                    this.fTimeSheetEntries.add(entry);
                    this.fOriginalItems.put(entry.getItemId(), entry);
                }
                ++n2;
            }
        }
    }

    private ITimeSheetEntry[] resolveReferences() throws TeamRepositoryException {
        ITeamRepository teamRepository = this.fWorkingCopy.getTeamRepository();
        IDependentItems alldepItems = this.fWorkingCopy.getDependentItems();
        Collection allAuditables = alldepItems.getAll();
        HashMap<String, Boolean> seenMap = new HashMap<String, Boolean>();
        ArrayList<ITimeSheetEntry> timeSheetEntries = new ArrayList<ITimeSheetEntry>();
        for (IAuditable genericAuditable : allAuditables) {
            if (!(genericAuditable instanceof ITimeSheetEntry)) continue;
            timeSheetEntries.add((ITimeSheetEntry)genericAuditable);
            seenMap.put(genericAuditable.getItemId().toString(), true);
        }
        this.fReferences = this.fWorkingCopy.getReferences();
        List list = this.fReferences.getReferences(WorkItemEndPoints.WORK_TIME);
        ArrayList<ITimeSheetEntryHandle> handlesList = new ArrayList<ITimeSheetEntryHandle>();
        String timesheetEntryUUID = null;
        for (IReference reference : list) {
            IItemHandle obj = ((IItemReference)reference).getReferencedItem();
            if (obj instanceof ITimeSheetEntryHandle) {
                timesheetEntryUUID = ((ITimeSheetEntryHandle)obj).getItemId().toString();
            } else if (obj instanceof ITimeSheetEntry) {
                timesheetEntryUUID = ((ITimeSheetEntry)obj).getItemId().toString();
            }
            if (seenMap.containsKey(timesheetEntryUUID)) continue;
            handlesList.add((ITimeSheetEntryHandle)obj);
        }
        IItemManager itemManager = teamRepository.itemManager();
        List resolvedHandles = itemManager.fetchCompleteItems(handlesList, 1, (IProgressMonitor)new NullProgressMonitor());
        timeSheetEntries.addAll(resolvedHandles);
        if (timeSheetEntries.size() == 0) {
            return null;
        }
        ITimeSheetEntry[] timesheetEntryArray = new ITimeSheetEntry[timeSheetEntries.size()];
        return timeSheetEntries.toArray(timesheetEntryArray);
    }

    public ITimeSheetEntry[] getTimeSheetEntries() {
        ITimeSheetEntry[] timesheetEntryArray = new ITimeSheetEntry[this.fTimeSheetEntries.size()];
        return this.fTimeSheetEntries.toArray(timesheetEntryArray);
    }

    public ITimeSheetEntry addTimeSheetEntry(Date startDate, double hoursSpent, String workType, IWorkItemCommon.ITimeCode timeCode, boolean performUpdate) {
        ITeamRepository teamRepository = this.fWorkingCopy.getTeamRepository();
        IWorkItem workitem = this.fWorkingCopy.getWorkItem();
        IProjectAreaHandle projectArea = workitem.getProjectArea();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        ITimeSheetEntry entry = workItemClient.createTimeSheetEntry(projectArea);
        Timestamp timeStamp = new Timestamp(startDate.getTime());
        entry.setStartDate(timeStamp);
        entry.setHoursSpent(hoursSpent);
        entry.setTimeCode(timeCode.getTimeCodeLabel());
        entry.setTimeCodeId(timeCode.getTimeCodeId());
        Identifier workTypeLiteral = Identifier.create(ILiteral.class, (String)workType);
        entry.setWorkType(workTypeLiteral);
        this.fTimeSheetEntries.add(entry);
        if (performUpdate) {
            this.updateWorkItemTimeSpent();
        }
        return entry;
    }

    public boolean removeTimeSheetEntry(ITimeSheetEntry entry, boolean performUpdate) {
        if (this.fTimeSheetEntries.contains(entry)) {
            this.fTimeSheetEntries.remove(entry);
            if (performUpdate) {
                this.updateWorkItemTimeSpent();
            }
            return true;
        }
        return false;
    }

    public double getWorkItemTotalForTimeCodeAndUser(IWorkItemCommon.ITimeCode timeCode, String user) {
        ITimeSheetEntry[] timesheetDTOs = this.getTimeSheetEntries();
        double total = 0.0;
        int i = 0;
        while (i < timesheetDTOs.length) {
            String timesheetUser = OperationUtil.resolveUser(this.fWorkingCopy, timesheetDTOs[i].getCreator());
            if (timesheetDTOs[i].getTimeCodeId().equals(timeCode.getTimeCodeId()) && timesheetUser.equals(user)) {
                total += timesheetDTOs[i].getHoursSpent();
            }
            ++i;
        }
        return total;
    }

    public boolean replaceTimeSheetEntry(ITimeSheetEntry entry, boolean performUpdate) {
        this.fTimeSheetEntries.add(entry);
        if (performUpdate) {
            this.updateWorkItemTimeSpent();
        }
        return true;
    }

    public boolean findDirty() {
        return this.fWorkingCopy.isDirty();
    }

    public synchronized void saveToWorkingCopy() {
        HashMap<UUID, ITimeSheetEntry> seen = new HashMap<UUID, ITimeSheetEntry>();
        for (ITimeSheetEntry timeSheetEntry : this.fTimeSheetEntries) {
            if (this.fOriginalItems.get(timeSheetEntry.getItemId()) != null) {
                ITimeSheetEntry original = this.fOriginalItems.get(timeSheetEntry.getItemId());
                seen.put(timeSheetEntry.getItemId(), timeSheetEntry);
                if (!this.hasChanged(timeSheetEntry, original)) continue;
                IDependentItems alldepItems = this.fWorkingCopy.getDependentItems();
                alldepItems.remove((IAuditableHandle)timeSheetEntry);
                alldepItems.add((IAuditable)timeSheetEntry);
                continue;
            }
            this.fReferences.add(WorkItemEndPoints.WORK_TIME, (IReference)IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)timeSheetEntry));
            this.fWorkingCopy.getDependentItems().add((IAuditable)timeSheetEntry);
            this.fOriginalItems.put(timeSheetEntry.getItemId(), timeSheetEntry);
            seen.put(timeSheetEntry.getItemId(), timeSheetEntry);
        }
        for (UUID itemId : this.fOriginalItems.keySet()) {
            if (seen.containsKey(itemId)) continue;
            List list = this.fReferences.getReferences(WorkItemEndPoints.WORK_TIME);
            for (IReference reference : list) {
                ITimeSheetEntryHandle entry;
                Object obj = reference.resolve();
                if (!(obj instanceof ITimeSheetEntryHandle) || !(entry = (ITimeSheetEntryHandle)obj).sameItemId((IItemHandle)this.fOriginalItems.get(itemId))) continue;
                this.fReferences.remove(reference);
                this.fWorkingCopy.getDependentItems().remove((IAuditableHandle)entry);
            }
        }
    }

    private boolean hasChanged(ITimeSheetEntry t1, ITimeSheetEntry t2) {
        if (t1 == null || t2 == null) {
            return false;
        }
        double timespent1 = t1.getHoursSpent();
        double timespent2 = t2.getHoursSpent();
        return !t1.getStartDate().equals(t2.getStartDate()) || timespent1 != timespent2 || !t1.getWorkType().equals((Object)t2.getWorkType()) || t1.getTimeCodeId().compareTo(t2.getTimeCodeId()) != 0;
    }

    public ITimeSheetEntry getTimesheetEntryWithStartDateAndTimecode(Date startDate, IWorkItemCommon.ITimeCode timeCode, String currentUserItemId) {
        ITimeSheetEntry timesheet = null;
        GregorianCalendar searchDate = new GregorianCalendar();
        searchDate.setTime(startDate);
        if (this.fTimeSheetEntries != null && this.fTimeSheetEntries.size() > 0) {
            int i = 0;
            while (i < this.fTimeSheetEntries.size()) {
                timesheet = this.fTimeSheetEntries.get(i);
                String iterUserItemId = timesheet.getCreator().getItemId().toString();
                if (timesheet.getTimeCodeId().compareTo(timeCode.getTimeCodeId()) == 0 && iterUserItemId.compareTo(currentUserItemId) == 0) {
                    Timestamp timeStamp = timesheet.getStartDate();
                    GregorianCalendar iterationDatel = new GregorianCalendar();
                    iterationDatel.setTimeInMillis(timeStamp.getTime());
                    if (DateUtil.compareDatesForDayOnly(searchDate, iterationDatel)) {
                        return timesheet;
                    }
                }
                timesheet = null;
                ++i;
            }
        }
        return timesheet;
    }

    public ITimeSheetEntry[] getAllTimesheetWithTimeCodes(IWorkItemCommon.ITimeCode timeCode, String currentUserItemId) {
        ArrayList<ITimeSheetEntry> timesheetArray = new ArrayList<ITimeSheetEntry>();
        if (this.fTimeSheetEntries != null && this.fTimeSheetEntries.size() > 0) {
            ITimeSheetEntry timesheet = null;
            int i = 0;
            while (i < this.fTimeSheetEntries.size()) {
                timesheet = this.fTimeSheetEntries.get(i);
                String iterUserItemId = timesheet.getCreator().getItemId().toString();
                if (timesheet != null && timesheet.getTimeCodeId().compareTo(timeCode.getTimeCodeId()) == 0 && iterUserItemId.compareTo(currentUserItemId) == 0) {
                    timesheetArray.add(timesheet);
                }
                ++i;
            }
        }
        ITimeSheetEntry[] timesheetEntryArray = new ITimeSheetEntry[timesheetArray.size()];
        return timesheetArray.toArray(timesheetEntryArray);
    }

    public void updateWorkItemTimeSpent() {
        if (!this.fIsTimetrackingSyncEnabled.booleanValue()) {
            return;
        }
        FoundationJob job = new FoundationJob(TimesheetMessages.UPDATING_TIMESPENT){

            protected IStatus runProtected(IProgressMonitor monitor) {
                long totalVal = 0L;
                int i = 0;
                while (i < TimeSheetEntries.this.fTimeSheetEntries.size()) {
                    totalVal += ((ITimeSheetEntry)TimeSheetEntries.this.fTimeSheetEntries.get(i)).getTimeSpent().longValue();
                    ++i;
                }
                IWorkItem workitem = TimeSheetEntries.this.fWorkingCopy.getWorkItem();
                IProjectAreaHandle fProjectArea = workitem.getProjectArea();
                ITeamRepository repository = TimeSheetEntries.this.fWorkingCopy.getTeamRepository();
                IWorkItemClient workItemClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
                try {
                    Long workItemTimeSpentValue;
                    IAttribute attr;
                    if (workItemClient != null && (attr = workItemClient.findAttribute(fProjectArea, "timeSpent", null)) != null && ((workItemTimeSpentValue = (Long)workitem.getValue(attr)) == null || workItemTimeSpentValue != totalVal)) {
                        totalVal = totalVal == 0L ? -1L : totalVal;
                        workitem.setValue(attr, (Object)new Long(totalVal));
                    }
                }
                catch (TeamRepositoryException e) {
                    Activator.log(e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void setWorkingCopy(WorkItemWorkingCopy workingCopy) {
        this.fWorkingCopy = workingCopy;
    }
}

