/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tpt.ide.ui.timesheet.internal;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.calendar.DatePicker;
import com.ibm.team.links.common.IReference;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.tpt.ide.ui.Activator;
import com.ibm.team.tpt.ide.ui.internal.TPTHelpContextIds;
import com.ibm.team.tpt.ide.ui.timesheet.internal.helper.TimeSheetEntries;
import com.ibm.team.tpt.ide.ui.timesheet.internal.helper.TimeSheetTableHelper;
import com.ibm.team.tpt.ide.ui.timesheet.internal.helper.TimesheetIDEColumnProvider;
import com.ibm.team.tpt.ide.ui.timesheet.internal.util.DateUtil;
import com.ibm.team.tpt.ide.ui.timesheet.internal.util.NumberUtil;
import com.ibm.team.tpt.ide.ui.timesheet.internal.util.OperationUtil;
import com.ibm.team.tpt.ide.ui.timesheet.internal.util.TimeCodeUtil;
import com.ibm.team.tpt.ide.ui.timesheet.internal.util.TimesheetMessages;
import com.ibm.team.tpt.internal.client.ITptClient;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.ChangeDetails;
import com.ibm.team.workitem.common.model.ITimeSheetEntry;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ReferencesChangeDetails;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedText;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import com.ibm.team.workitem.rcp.ui.UIWorkItemListener;
import com.ibm.team.workitem.rcp.ui.UIWorkItemWorkingCopyListener;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class TimeSheetEntryPartIDE
extends PresentationPart {
    public Table fTable;
    private Button fAddButton;
    private Button fEditButton;
    private Button fDeleteButton;
    private Hyperlink fPreviousLink;
    private Hyperlink fNextLink;
    private ToolItem fCalendarButton;
    public boolean fUnsavedItem = false;
    public TimeSheetTableHelper fTimeSheetViewer = null;
    public TimeSheetEntries fTimesheetEntries = null;
    private IWorkItemCommon.ITimeCode[] fProjectTimeCodes;
    private WorkItemWorkingCopy fWorkingCopy;
    private IWorkItem fWorkItem = null;
    private Date fWeekSelected = new Date();
    private TimeCodeUtil fTimeCodeUtil;
    private Text fDateTextBox;
    private Date fMaxDate = new Date();
    private Date fStartDateOfWeek;
    private Date fEndDateOfWeek;
    private DatePicker fPicker;
    private static final int DATE_FORMAT = 2;
    private Date fSelectedDate = new Date();
    private UUID workitemUUID = null;
    private Composite parent = null;
    private Listener fListener = null;
    private Boolean fIsTimetrackingEnabled = new Boolean(false);
    private OperationUtil fOperationUtil = new OperationUtil();
    public static WorkItemEditorToolkit fToolkit = null;
    private WorkItemListener fWorkItemListener = new WorkItemListener();
    private Label fNotOwnerWarningLabel = null;

    public void createContent(ITeamFormLayout formLayout) {
        Composite parent;
        fToolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        this.parent = parent = formLayout.getContainer();
        this.fTimeSheetViewer = new TimeSheetTableHelper();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        this.createDateToolBar(parent);
        this.fListener = new Listener(){

            public void handleEvent(Event event) {
                TimeSheetTableHelper timesheetHelperForEvent = TimeSheetEntryPartIDE.this.getTimesheetTableHelper();
                String currWorkitemUUID = TimeSheetEntryPartIDE.this.getWorkItemId();
                String text = event.text;
                if (text == null || text.compareTo("") == 0 || text.compareTo("Timesheet_Entry_Clicked") != 0) {
                    return;
                }
                HashMap eventData = (HashMap)event.data;
                if (eventData == null) {
                    return;
                }
                Object[] dateKeySet = eventData.keySet().toArray();
                if (dateKeySet != null && dateKeySet.length != 1 && dateKeySet[0] != null) {
                    return;
                }
                String eventWorkitemUUID = (String)dateKeySet[0];
                if (!currWorkitemUUID.equalsIgnoreCase(eventWorkitemUUID)) {
                    return;
                }
                Date startDate = (Date)eventData.get(eventWorkitemUUID);
                TimeSheetEntryPartIDE.this.findWeek(startDate);
                TimeSheetEntryPartIDE.this.setDateTextBox(TimeSheetEntryPartIDE.this.fStartDateOfWeek, TimeSheetEntryPartIDE.this.fEndDateOfWeek);
                TimeSheetEntryPartIDE.this.fWeekSelected = TimeSheetEntryPartIDE.this.fStartDateOfWeek;
                TimeSheetEntryPartIDE.this.fSelectedDate = startDate;
                timesheetHelperForEvent.setWeekDate(TimeSheetEntryPartIDE.this.fWeekSelected);
            }
        };
        parent.getShell().addListener(3, this.fListener);
        parent.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                TimeSheetEntryPartIDE.this.getParent().getShell().removeListener(3, TimeSheetEntryPartIDE.this.fListener);
            }
        });
        Composite composite = fToolkit.createComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        fToolkit.paintBordersFor(composite);
        this.fTable = new Table(composite, 67584);
        this.fTable.setLinesVisible(true);
        this.fTable.setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = 1;
        data.heightHint = 100;
        this.fTable.setLayoutData((Object)data);
        this.fTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selection = TimeSheetEntryPartIDE.this.fTable.getSelectionIndex();
                TableItem row = TimeSheetEntryPartIDE.this.fTable.getItem(selection);
                String currUser = TimeSheetEntryPartIDE.this.fOperationUtil.getCurrentUser(TimeSheetEntryPartIDE.this.fTimesheetEntries.getWorkingCopy(), true);
                TimeSheetEntryPartIDE.this.fDeleteButton.setEnabled(false);
                TimeSheetEntryPartIDE.this.fUnsavedItem = false;
                HashMap rowData = (HashMap)row.getData();
                if (((String)rowData.get("isSaved")).compareTo("false") == 0) {
                    TimeSheetEntryPartIDE.this.fUnsavedItem = true;
                }
                if (((String)rowData.get("userId")).compareTo(currUser) == 0) {
                    TimeSheetEntryPartIDE.this.fEditButton.setEnabled(true);
                    TimeSheetEntryPartIDE.this.fDeleteButton.setEnabled(true);
                } else {
                    TimeSheetEntryPartIDE.this.fEditButton.setEnabled(false);
                    TimeSheetEntryPartIDE.this.fDeleteButton.setEnabled(false);
                }
            }
        });
        this.fTimeSheetViewer.initializeTimesheetTableViewer(new TimesheetIDEColumnProvider(), this.fWeekSelected, this, this.fTable);
        this.createToolPanel(composite);
        this.createTimesheetTableHeader();
        this.findWeek(this.fMaxDate);
        this.setDateTextBox(this.fStartDateOfWeek, this.fEndDateOfWeek);
        TPTHelpContextIds.hookHelpListener((Control)parent, "com.ibm.team.workitem.ide.ui.tab_plan_timetracking");
        UIWorkItemWorkingCopyListener uiCopyListener = (UIWorkItemWorkingCopyListener)this.getSite().getAdapter(UIWorkItemWorkingCopyListener.class);
        UIWorkItemListener uiWorkItemListener = (UIWorkItemListener)this.getSite().getAdapter(UIWorkItemListener.class);
        if (uiCopyListener != null) {
            uiCopyListener.addListener((IWorkingCopyListener)this.fWorkItemListener);
        }
        if (uiWorkItemListener != null) {
            uiWorkItemListener.addListener((IWorkItemListener)this.fWorkItemListener);
        }
        this.createNotOwnerWarningLabel(parent);
    }

    protected TimeSheetTableHelper getTimesheetTableHelper() {
        return this.fTimeSheetViewer;
    }

    protected String getWorkItemId() {
        return this.workitemUUID.getUuidValue();
    }

    private void createNotOwnerWarningLabel(Composite parent) {
        this.fNotOwnerWarningLabel = new Label(parent, 0);
        this.fNotOwnerWarningLabel.setText(TimesheetMessages.NOT_WI_OWNER_WARNING);
        this.fNotOwnerWarningLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fNotOwnerWarningLabel.setVisible(false);
    }

    private void createDateToolBar(Composite parent) {
        final Composite composite = fToolkit.createComposite(parent);
        GridLayout layout = new GridLayout(10, false);
        layout.marginHeight = 0;
        layout.marginWidth = 200;
        composite.setLayout((Layout)layout);
        fToolkit.paintBordersFor(composite);
        HyperlinkGroup fHyperlinkGroup = new HyperlinkGroup(Display.getCurrent());
        fHyperlinkGroup.setBackground(fToolkit.getColors().getBackground());
        this.fPreviousLink = new Hyperlink(composite, 0);
        GridData gridData = new GridData(131072, 0x1000000, false, false, 1, 1);
        this.fPreviousLink.setLayoutData((Object)gridData);
        this.fPreviousLink.setText(TimesheetMessages.PREVIOUS);
        this.fPreviousLink.setToolTipText(TimesheetMessages.PREVIOUS);
        fHyperlinkGroup.add(this.fPreviousLink);
        this.fPreviousLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Date date = TimeSheetEntryPartIDE.this.fSelectedDate;
                Date previousWeek = new Date(date.getTime() - 604800000L);
                TimeSheetEntryPartIDE.this.findWeek(previousWeek);
                TimeSheetEntryPartIDE.this.setDateTextBox(TimeSheetEntryPartIDE.this.fStartDateOfWeek, TimeSheetEntryPartIDE.this.fEndDateOfWeek);
                TimeSheetEntryPartIDE.this.fWeekSelected = TimeSheetEntryPartIDE.this.fStartDateOfWeek;
                TimeSheetEntryPartIDE.this.fSelectedDate = previousWeek;
                TimeSheetEntryPartIDE.this.fTimeSheetViewer.setWeekDate(TimeSheetEntryPartIDE.this.fWeekSelected);
            }
        });
        this.fDateTextBox = new Text(composite, 12);
        GridData griddata3 = new GridData(16384, 0x1000000, false, false, 1, 1);
        griddata3.widthHint = 52;
        this.fDateTextBox.setData((Object)griddata3);
        int columns = 52;
        GC gc = new GC((Drawable)this.fDateTextBox);
        FontMetrics fm = gc.getFontMetrics();
        int width = columns * fm.getAverageCharWidth();
        int height = fm.getHeight();
        gc.dispose();
        this.fDateTextBox.setSize(this.fDateTextBox.computeSize(width, height));
        final ToolBar toolBar = new ToolBar(composite, 0x800000);
        toolBar.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.fCalendarButton = new ToolItem(toolBar, 8);
        this.fCalendarButton.setToolTipText(TimesheetMessages.PICK_DATE);
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)toolBar);
        Image image = JazzResources.getImageWithDefault((ResourceManager)resourceManager, (ImageDescriptor)ImagePool.DATE);
        this.fCalendarButton.setImage(image);
        this.fCalendarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeSheetEntryPartIDE.this.fCalendarButton.setEnabled(false);
                Rectangle rect = TimeSheetEntryPartIDE.this.fCalendarButton.getBounds();
                Point pt = toolBar.toDisplay(new Point(rect.x, rect.y + rect.height));
                TimeSheetEntryPartIDE.this.fPicker = new DatePicker(composite.getShell(), 2);
                TimeSheetEntryPartIDE.this.fPicker.setLocation(pt.x, pt.y);
                TimeSheetEntryPartIDE.this.fPicker.setDate(TimeSheetEntryPartIDE.this.fSelectedDate);
                TimeSheetEntryPartIDE.this.fPicker.open();
                Date date = TimeSheetEntryPartIDE.this.fPicker.getDateObject();
                TimeSheetEntryPartIDE.this.fCalendarButton.setEnabled(true);
                if (date != null) {
                    date = TimeSheetTableHelper.formatDate(date);
                    TimeSheetEntryPartIDE.this.findWeek(date);
                    TimeSheetEntryPartIDE.this.setDateTextBox(TimeSheetEntryPartIDE.this.fStartDateOfWeek, TimeSheetEntryPartIDE.this.fEndDateOfWeek);
                    TimeSheetEntryPartIDE.this.fWeekSelected = TimeSheetEntryPartIDE.this.fStartDateOfWeek;
                    TimeSheetEntryPartIDE.this.fSelectedDate = date;
                    TimeSheetEntryPartIDE.this.fTimeSheetViewer.setWeekDate(TimeSheetEntryPartIDE.this.fWeekSelected);
                }
            }
        });
        this.fNextLink = new Hyperlink(composite, 0);
        GridData gridData2 = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.fNextLink.setLayoutData((Object)gridData2);
        this.fNextLink.setText(TimesheetMessages.NEXT);
        this.fNextLink.setToolTipText(TimesheetMessages.NEXT);
        fHyperlinkGroup.add(this.fNextLink);
        this.fNextLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Date date = TimeSheetEntryPartIDE.this.fSelectedDate;
                Date nextWeek = new Date(date.getTime() + 604800000L);
                TimeSheetEntryPartIDE.this.findWeek(nextWeek);
                TimeSheetEntryPartIDE.this.setDateTextBox(TimeSheetEntryPartIDE.this.fStartDateOfWeek, TimeSheetEntryPartIDE.this.fEndDateOfWeek);
                TimeSheetEntryPartIDE.this.fWeekSelected = TimeSheetEntryPartIDE.this.fStartDateOfWeek;
                TimeSheetEntryPartIDE.this.fSelectedDate = nextWeek;
                TimeSheetEntryPartIDE.this.fTimeSheetViewer.setWeekDate(TimeSheetEntryPartIDE.this.fWeekSelected);
            }
        });
        this.findWeek(this.fMaxDate);
        this.setDateTextBox(this.fStartDateOfWeek, this.fEndDateOfWeek);
        this.fWeekSelected = this.fStartDateOfWeek;
    }

    private void createToolPanel(final Composite parent) {
        Composite composite = fToolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        fToolkit.paintBordersFor(composite);
        this.fAddButton = new Button(composite, 8);
        this.fAddButton.setText(TimesheetMessages.ADD_TIME_ENTRY);
        GridData gridData = new GridData(4, 128, false, false);
        this.fAddButton.setLayoutData((Object)gridData);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeSheetEntryPartIDE.this.displayAddTimeEntryDialog(parent);
            }
        });
        this.fEditButton = new Button(composite, 8);
        this.fEditButton.setText(TimesheetMessages.EDIT_TIME_ENTRY);
        gridData = new GridData(4, 128, false, false);
        this.fEditButton.setLayoutData((Object)gridData);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeSheetEntryPartIDE.this.displayEditTimeEntryDialog(parent);
            }
        });
        this.fEditButton.setEnabled(false);
        this.fDeleteButton = new Button(composite, 8);
        this.fDeleteButton.setText(TimesheetMessages.DELETE_TIME_ENTRY);
        GridData gridData1 = new GridData(4, 128, false, false);
        this.fDeleteButton.setLayoutData((Object)gridData1);
        this.fDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeSheetEntryPartIDE.this.deleteRow(parent);
            }
        });
        this.fDeleteButton.setEnabled(false);
        composite.setLayoutData((Object)new GridData(4, 128, false, false));
    }

    private void createTimesheetTableHeader() {
        int count = TimesheetIDEColumnProvider.getColumnCount();
        int index = 0;
        while (index < count) {
            TableColumn header = new TableColumn(this.fTable, 16384);
            header.setText(TimesheetIDEColumnProvider.getLabel(index));
            switch (index) {
                case 1: {
                    header.setWidth(120);
                    header.setAlignment(16384);
                    break;
                }
                case 9: {
                    header.setWidth(80);
                    header.setAlignment(131072);
                    break;
                }
                case 10: {
                    header.setWidth(80);
                    header.setAlignment(131072);
                    break;
                }
                default: {
                    header.setWidth(60);
                    header.setAlignment(131072);
                }
            }
            ++index;
        }
    }

    private void findWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int day = cal.get(7);
        int beginOffset = day - 1;
        int endOffset = 7 - day;
        this.fStartDateOfWeek = new Date(date.getTime() - (long)(beginOffset * 86400000));
        this.fEndDateOfWeek = new Date(date.getTime() + (long)(endOffset * 86400000));
    }

    private void setDateTextBox(Date startDate, Date endDate) {
        String label = DateUtil.formatDateRangeMedium(startDate, endDate);
        if (!this.fDateTextBox.isDisposed()) {
            this.fDateTextBox.setText(label);
        }
    }

    public void setInput(Object input) {
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)input;
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.fWorkItem = workItemEditorInput.getWorkItem();
            this.workitemUUID = this.fWorkingCopy.getWorkItem().getItemId();
        } else {
            this.fWorkingCopy = null;
        }
        this.fNotOwnerWarningLabel.setVisible(!this.checkValidation());
        this.fTimesheetEntries = new TimeSheetEntries();
        FoundationJob job0 = new FoundationJob(TimesheetMessages.FETCHING_TIMETRACK_INFO){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                IProjectAreaHandle projectAreaHandle = TimeSheetEntryPartIDE.this.fWorkingCopy.getWorkItem().getProjectArea();
                ITeamRepository repository = TimeSheetEntryPartIDE.this.fWorkingCopy.getTeamRepository();
                ITptClient client = (ITptClient)repository.getClientLibrary(ITptClient.class);
                TimeSheetEntryPartIDE.this.fIsTimetrackingEnabled = client.getTimetrackingInfo(projectAreaHandle.getItemId().getUuidValue(), monitor);
                try {
                    TimeSheetEntryPartIDE.this.fTimesheetEntries.initialize(TimeSheetEntryPartIDE.this.fWorkingCopy, TimeSheetEntryPartIDE.this.fIsTimetrackingEnabled);
                }
                catch (TeamRepositoryException e) {
                    Activator.log(e);
                }
                TimeSheetEntryPartIDE.this.onTimesheetEntriesInitialized();
                return null;
            }
        };
        job0.schedule();
    }

    private void onTimesheetEntriesInitialized() {
        this.checkAndUpdateTimeSpent();
        this.fTimeCodeUtil = new TimeCodeUtil();
        this.fTimeCodeUtil.fetchLiterals(this, this.fWorkingCopy);
    }

    public void onTimeCodesLoaded(IWorkItemCommon.ITimeCode[] projectTimeCodes) {
        this.fProjectTimeCodes = projectTimeCodes;
        this.fTimeSheetViewer.setProjectTimecodes(this.fProjectTimeCodes);
        this.fTimeSheetViewer.setInput(this.fTimesheetEntries);
        new FoundationUIJob(""){

            protected IStatus runProtectedInUI(IProgressMonitor monitor) throws Exception {
                String workItemType = TimeSheetEntryPartIDE.this.fWorkingCopy.getWorkItem().getWorkItemType();
                TimeSheetEntryPartIDE.this.fTimeSheetViewer.setWorkItemType(workItemType);
                TimeSheetEntryPartIDE.this.fTimeSheetViewer.refresh();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void checkAndUpdateTimeSpent() {
        if (this.fIsTimetrackingEnabled.booleanValue()) {
            this.fTimesheetEntries.updateWorkItemTimeSpent();
        }
    }

    public void handleSave(boolean notify) {
        TimeSheetEntries entries = this.fTimesheetEntries;
        entries.saveToWorkingCopy();
        if (notify) {
            Event e1 = new Event();
            e1.text = "Timesheet_Entry_Modified";
            e1.data = this.getWorkItemId();
            this.parent.getShell().notifyListeners(4, e1);
        }
    }

    protected Composite getParent() {
        return this.parent;
    }

    private void displayAddTimeEntryDialog(Composite parent) {
        String currUser = this.fOperationUtil.getCurrentUser(this.fTimesheetEntries.getWorkingCopy(), true);
        IWorkItemCommon.ITimeCode[] availableTimeCodes = this.getAvailableTimeCodesFor(currUser, null);
        if (availableTimeCodes == null) {
            this.displayErrorDialog(TimesheetMessages.NO_TIMECODE_PRESENT);
            return;
        }
        AddTimeCodeDialog addTimeCodeDialog = new AddTimeCodeDialog(parent.getShell(), false, true, availableTimeCodes, null);
        double[] weekData = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        addTimeCodeDialog.setWeekData(weekData);
        if (addTimeCodeDialog.open() != 0) {
            return;
        }
        double[] weekData1 = addTimeCodeDialog.getWeekData();
        IWorkItemCommon.ITimeCode selectedTimeCode = addTimeCodeDialog.getSelectedTimeCode();
        this.fTimeSheetViewer.addTimesheetRow(weekData1, selectedTimeCode);
    }

    private void displayEditTimeEntryDialog(Composite parent) {
        String currUser;
        int[] rowNumbers = this.fTable.getSelectionIndices();
        int rowNumber = -1;
        if (rowNumbers.length == 1) {
            rowNumber = rowNumbers[0];
        } else if (rowNumber < 0 || rowNumbers.length > 1) {
            this.displayErrorDialog(TimesheetMessages.SELECT_ROW_EDIT);
        }
        TableItem row = this.fTable.getItem(rowNumber);
        if (!this.preCheckUserAuthorization(row)) {
            this.displayErrorDialog(TimesheetMessages.INVALID_USER);
            this.deSelectButton(rowNumber);
            return;
        }
        Map rowData = (Map)row.getData();
        IWorkItemCommon.ITimeCode currentTimeCode = (IWorkItemCommon.ITimeCode)rowData.get("timeCode");
        double[] weekData = new double[7];
        String[] oldData = new String[7];
        int i = 2;
        int j = 0;
        while (i <= 8) {
            weekData[j] = NumberUtil.parseHours(row.getText(i), 0.0);
            ++i;
            ++j;
        }
        IWorkItemCommon.ITimeCode[] availableTimeCodes = new IWorkItemCommon.ITimeCode[]{currentTimeCode};
        if (this.fUnsavedItem && (availableTimeCodes = this.getAvailableTimeCodesFor(currUser = this.fOperationUtil.getCurrentUser(this.fTimesheetEntries.getWorkingCopy(), true), currentTimeCode)) == null) {
            this.displayErrorDialog(TimesheetMessages.NO_TIMECODE_PRESENT);
            return;
        }
        AddTimeCodeDialog editTimeCodeDialog = new AddTimeCodeDialog(parent.getShell(), true, this.checkValidation(), availableTimeCodes, currentTimeCode);
        editTimeCodeDialog.setWeekData(weekData);
        if (editTimeCodeDialog.open() != 0) {
            this.deSelectButton(rowNumber);
            return;
        }
        double[] newWeekData = editTimeCodeDialog.getWeekData();
        IWorkItemCommon.ITimeCode selectedTimeCode = editTimeCodeDialog.getSelectedTimeCode();
        int i2 = 2;
        int j2 = 0;
        while (i2 <= 8) {
            oldData[j2] = row.getText(i2);
            ++i2;
            ++j2;
        }
        this.fTimeSheetViewer.editTimesheetRow(oldData, newWeekData, row, currentTimeCode, selectedTimeCode);
        this.deSelectButton(rowNumber);
    }

    private void deSelectButton(int rowNum) {
        this.fEditButton.setEnabled(false);
        this.fDeleteButton.setEnabled(false);
        this.fTable.deselect(rowNum);
    }

    private void deleteRow(Composite parent) {
        int[] rowNumbers = this.fTable.getSelectionIndices();
        int rowNumber = -1;
        if (rowNumbers.length > 0) {
            rowNumber = rowNumbers[0];
        }
        if (rowNumber < 0 || rowNumbers.length > 1) {
            this.displayErrorDialog(TimesheetMessages.SELECT_ROW_DELETE);
            return;
        }
        this.fTimeSheetViewer.deleteRow(rowNumber);
        this.deSelectButton(rowNumber);
    }

    private IWorkItemCommon.ITimeCode[] getAvailableTimeCodesFor(String user, IWorkItemCommon.ITimeCode include) {
        List<IWorkItemCommon.ITimeCode> selectedTimeCodes = this.getSelectedTimeCodesFor(user);
        if (this.fProjectTimeCodes == null) {
            return null;
        }
        if (selectedTimeCodes == null) {
            return this.fProjectTimeCodes;
        }
        if (this.fProjectTimeCodes.length == selectedTimeCodes.size()) {
            IWorkItemCommon.ITimeCode[] iTimeCodeArray;
            if (include != null) {
                IWorkItemCommon.ITimeCode[] iTimeCodeArray2 = new IWorkItemCommon.ITimeCode[1];
                iTimeCodeArray = iTimeCodeArray2;
                iTimeCodeArray2[0] = include;
            } else {
                iTimeCodeArray = null;
            }
            return iTimeCodeArray;
        }
        ArrayList<IWorkItemCommon.ITimeCode> availableTimeCodes = new ArrayList<IWorkItemCommon.ITimeCode>();
        IWorkItemCommon.ITimeCode[] iTimeCodeArray = this.fProjectTimeCodes;
        int n = this.fProjectTimeCodes.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkItemCommon.ITimeCode timeCode = iTimeCodeArray[n2];
            if (!selectedTimeCodes.contains(timeCode) || timeCode.equals(include)) {
                availableTimeCodes.add(timeCode);
            }
            ++n2;
        }
        return availableTimeCodes.toArray(new IWorkItemCommon.ITimeCode[availableTimeCodes.size()]);
    }

    private List<IWorkItemCommon.ITimeCode> getSelectedTimeCodesFor(String user) {
        ArrayList<IWorkItemCommon.ITimeCode> selectedTimeCodes = null;
        int rowCount = this.fTable.getItemCount();
        TableItem[] rows = this.fTable.getItems();
        HashMap rowData = null;
        if (user != null) {
            selectedTimeCodes = new ArrayList<IWorkItemCommon.ITimeCode>();
            int i = 0;
            while (i < rowCount) {
                rowData = (HashMap)rows[i].getData();
                if (user.compareTo((String)rowData.get("userId")) == 0) {
                    selectedTimeCodes.add((IWorkItemCommon.ITimeCode)rowData.get("timeCode"));
                }
                ++i;
            }
        }
        return selectedTimeCodes;
    }

    private Date getMaxDate() {
        ITimeSheetEntry[] timesheetEntry = this.fTimesheetEntries.getTimeSheetEntries();
        Date maxDate = new Date(0L);
        int i = 0;
        while (i < timesheetEntry.length) {
            Timestamp sDate;
            Date startDate;
            if (timesheetEntry[i] != null && timesheetEntry[i].getStartDate() != null && (startDate = new Date((sDate = timesheetEntry[i].getStartDate()).getTime())).compareTo(maxDate) >= 0) {
                maxDate = startDate;
            }
            ++i;
        }
        if (maxDate.compareTo(new Date(0L)) == 0) {
            return null;
        }
        return maxDate;
    }

    private Date formatDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 12);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date d = cal.getTime();
        return d;
    }

    public void dispose() {
        UIWorkItemWorkingCopyListener uiCopyListener = (UIWorkItemWorkingCopyListener)this.getSite().getAdapter(UIWorkItemWorkingCopyListener.class);
        if (uiCopyListener != null) {
            uiCopyListener.removeListener((IWorkingCopyListener)this.fWorkItemListener);
        }
        this.fTable.dispose();
        super.dispose();
    }

    private void displayErrorDialog(String message) {
        MessageBox messageBox = new MessageBox(this.parent.getShell(), 33);
        messageBox.setText(TimesheetMessages.ALERT);
        messageBox.setMessage(message);
        messageBox.open();
    }

    private boolean preCheckUserAuthorization(TableItem row) {
        HashMap rowData = (HashMap)row.getData();
        String rowUser = (String)rowData.get("userId");
        return rowUser != null && rowUser.compareTo(this.fOperationUtil.getCurrentUser(this.fWorkingCopy, true)) == 0;
    }

    private boolean checkValidation() {
        return this.fOperationUtil.validateWorkItemOwnerWithUser(this.fWorkItem, this.fWorkingCopy);
    }

    private static String[] getWeekDayNames() {
        DateFormatSymbols symbols = new DateFormatSymbols(Locale.getDefault());
        return symbols.getWeekdays();
    }

    private void reloadTimeTrackingData() {
        if (this.fTimesheetEntries != null && this.fTimeSheetViewer != null) {
            new FoundationJob(""){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    TimeSheetEntryPartIDE.this.fTimesheetEntries.reloadEntries();
                    return Status.OK_STATUS;
                }
            }.schedule();
            this.fDeleteButton.setEnabled(false);
            this.fEditButton.setEnabled(false);
            this.fTimeSheetViewer.setWeekDate(this.fWeekSelected);
        }
    }

    protected boolean isDirty() {
        return this.fWorkingCopy != null ? this.fWorkingCopy.isDirty() : false;
    }

    protected void doUpdateReadOnly(boolean readOnly) {
    }

    public class AddTimeCodeDialog
    extends Dialog {
        private final IWorkItemCommon.ITimeCode[] fUserTimeCodes;
        private CCombo fCombo;
        Label[] labelArray;
        DecoratedText[] textArray;
        private double[] ftimeSpent;
        private boolean fedit;
        private FocusListener fTextFocusListener;
        private IWorkItemCommon.ITimeCode fSelectedTimeCode;

        protected AddTimeCodeDialog(Shell parentShell, boolean edit, boolean isCurrentUserTheOwner, IWorkItemCommon.ITimeCode[] timeCodes, IWorkItemCommon.ITimeCode selectTimeCode) {
            super(parentShell);
            this.labelArray = new Label[7];
            this.textArray = new DecoratedText[7];
            this.fedit = edit;
            this.fUserTimeCodes = timeCodes;
            this.fSelectedTimeCode = selectTimeCode;
            this.fTextFocusListener = new FocusListener(){

                public void focusLost(FocusEvent e) {
                    Text textInput = (Text)e.widget;
                    if (!textInput.isDisposed()) {
                        textInput.clearSelection();
                    }
                }

                public void focusGained(FocusEvent e) {
                    Text textInput = (Text)e.widget;
                    if (!textInput.isDisposed()) {
                        textInput.selectAll();
                    }
                }
            };
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this.fedit ? TimesheetMessages.EDIT_TIME_ENTRY_DIALOG : TimesheetMessages.ADD_TIME_ENTRY_DIALOG);
        }

        public IWorkItemCommon.ITimeCode getSelectedTimeCode() {
            return this.fSelectedTimeCode;
        }

        public void setWeekData(double[] weekData) {
            this.ftimeSpent = new double[7];
            int i = 0;
            while (i < 7) {
                this.ftimeSpent[i] = weekData[i];
                ++i;
            }
        }

        public double[] getWeekData() {
            return this.ftimeSpent;
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            Composite composite = new Composite(container, 0);
            GridData data = new GridData(4, 4, true, true);
            composite.setLayoutData((Object)data);
            GridLayout layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 9;
            composite.setLayout((Layout)layout);
            Label timeCodeLabel = new Label(composite, 0);
            timeCodeLabel.setText(String.valueOf(TimesheetMessages.TIME_CODE) + " :");
            timeCodeLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            if (this.fSelectedTimeCode == null) {
                this.fSelectedTimeCode = this.fUserTimeCodes[0];
            }
            if (this.fUserTimeCodes.length > 1) {
                this.fCombo = new CCombo(composite, 2060);
                this.fCombo.setBackground(composite.getDisplay().getSystemColor(1));
                data = new GridData(4, 0x1000000, true, false);
                data.horizontalIndent = 10;
                this.fCombo.setLayoutData((Object)data);
                int selectionIndex = 0;
                int i = 0;
                while (i < this.fUserTimeCodes.length) {
                    this.fCombo.add(this.fUserTimeCodes[i].getTimeCodeLabel());
                    if (this.fSelectedTimeCode.equals(this.fUserTimeCodes[i])) {
                        selectionIndex = i;
                    }
                    ++i;
                }
                this.fCombo.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        AddTimeCodeDialog.this.fSelectedTimeCode = AddTimeCodeDialog.this.fUserTimeCodes[AddTimeCodeDialog.this.fCombo.getSelectionIndex()];
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                this.fCombo.select(selectionIndex);
            } else {
                Label timeCode = new Label(composite, 0);
                timeCode.setText(this.fUserTimeCodes[0].getTimeCodeLabel());
                data = new GridData(16384, 0x1000000, false, false);
                data.horizontalIndent = 10;
                timeCode.setLayoutData((Object)data);
            }
            Label hours = new Label(composite, 0);
            hours.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            String[] weekDayNames = TimeSheetEntryPartIDE.getWeekDayNames();
            this.createLabel(weekDayNames[1], composite);
            Text text = this.createText(composite, 0);
            this.createHours(TimesheetMessages.HOUR_UNIT, composite);
            this.createLabel(weekDayNames[2], composite);
            this.createText(composite, 1);
            this.createHours(TimesheetMessages.HOUR_UNIT, composite);
            this.createLabel(weekDayNames[3], composite);
            this.createText(composite, 2);
            this.createHours(TimesheetMessages.HOUR_UNIT, composite);
            this.createLabel(weekDayNames[4], composite);
            this.createText(composite, 3);
            this.createHours(TimesheetMessages.HOUR_UNIT, composite);
            this.createLabel(weekDayNames[5], composite);
            this.createText(composite, 4);
            this.createHours(TimesheetMessages.HOUR_UNIT, composite);
            this.createLabel(weekDayNames[6], composite);
            this.createText(composite, 5);
            this.createHours(TimesheetMessages.HOUR_UNIT, composite);
            this.createLabel(weekDayNames[7], composite);
            this.createText(composite, 6);
            this.createHours(TimesheetMessages.HOUR_UNIT, composite);
            text.setFocus();
            return container;
        }

        private Text createText(final Composite composite, final int index) {
            final Text textBox = new Text(composite, 2052);
            GridData data = new GridData(16384, 0x1000000, false, false);
            data.horizontalIndent = 10;
            data.widthHint = 50;
            textBox.setLayoutData((Object)data);
            int columns = 3;
            GC gc = new GC((Drawable)textBox);
            FontMetrics fm = gc.getFontMetrics();
            int width = columns * fm.getAverageCharWidth();
            int height = fm.getHeight();
            gc.dispose();
            textBox.setSize(textBox.computeSize(width, height));
            if (this.ftimeSpent[index] == -1.0) {
                String hrsInString = NumberUtil.formatHours(0.0);
                textBox.setText(hrsInString);
            } else {
                String hrsInString = NumberUtil.formatHours(this.ftimeSpent[index]);
                textBox.setText(hrsInString);
            }
            textBox.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String value = textBox.getText();
                    double hoursSpent = AddTimeCodeDialog.this.validateTimeSpent(value);
                    if (hoursSpent != -1.0) {
                        ((AddTimeCodeDialog)AddTimeCodeDialog.this).ftimeSpent[index] = hoursSpent;
                        AddTimeCodeDialog.this.changeColor(textBox, true, composite);
                    } else {
                        ((AddTimeCodeDialog)AddTimeCodeDialog.this).ftimeSpent[index] = 0.0;
                        AddTimeCodeDialog.this.changeColor(textBox, false, composite);
                    }
                }
            });
            textBox.addFocusListener(this.fTextFocusListener);
            return textBox;
        }

        private Label createLabel(String name, Composite composite) {
            Label label = new Label(composite, 0);
            label.setText(name);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            return label;
        }

        private Label createHours(String name, Composite composite) {
            Label hours = new Label(composite, 0);
            hours.setText(TimesheetMessages.HOUR_UNIT);
            hours.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            return hours;
        }

        private double validateTimeSpent(String value) {
            double hoursSpent = NumberUtil.parseHours(value, -1.0);
            if (hoursSpent == -1.0) {
                return hoursSpent;
            }
            if (hoursSpent > 24.0 || hoursSpent < 0.0) {
                hoursSpent = -1.0;
            }
            return hoursSpent;
        }

        private void changeColor(Text text, boolean valid, Composite composite) {
            if (valid) {
                Color col = fToolkit.getColors().getForeground();
                text.setForeground(col);
            } else {
                Color red = composite.getDisplay().getSystemColor(3);
                text.setForeground(red);
            }
        }
    }

    private class WorkItemListener
    implements IWorkingCopyListener,
    IWorkItemListener {
        private WorkItemListener() {
        }

        public void workingCopyEvent(WorkingCopyEvent event) {
            if (TimeSheetEntryPartIDE.this.fWorkingCopy == null) {
                return;
            }
            if (event.hasType("saved")) {
                TimeSheetEntryPartIDE.this.reloadTimeTrackingData();
            }
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            String[] allAttribs;
            if (event.affects((IWorkItemHandle)TimeSheetEntryPartIDE.this.fWorkItem) && (allAttribs = event.getChangedAttributes()) != null && allAttribs.length > 0) {
                String[] stringArray = allAttribs;
                int n = allAttribs.length;
                int n2 = 0;
                while (n2 < n) {
                    String attributeType = stringArray[n2];
                    if (attributeType.compareTo("references") == 0) {
                        ReferencesChangeDetails changes = (ReferencesChangeDetails)event.getAttributeChangeDetails("references");
                        if (changes == null) break;
                        List added = changes.getAdded();
                        List removed = changes.getRemoved();
                        if (!this.checkListForTimeTrackingEntries(added) && !this.checkListForTimeTrackingEntries(removed)) break;
                        TimeSheetEntryPartIDE.this.reloadTimeTrackingData();
                        break;
                    }
                    if (attributeType.compareTo("owner") == 0) {
                        IContributorHandle o = (IContributorHandle)((ChangeDetails)event.getAttributeChangeDetails(attributeType)).getNewValue();
                        TimeSheetEntryPartIDE.this.fNotOwnerWarningLabel.setVisible(o.getItemId().toString().compareTo(TimeSheetEntryPartIDE.this.fOperationUtil.getCurrentUserItemId(TimeSheetEntryPartIDE.this.fWorkingCopy, true).toString()) != 0);
                    }
                    ++n2;
                }
            }
        }

        private boolean checkListForTimeTrackingEntries(List<IReference> allRefs) {
            for (IReference iter : allRefs) {
                String typeId = iter.getLink().getLinkType().getLinkTypeId();
                if (typeId == null || typeId.compareTo("com.ibm.team.workitem.linktype.timeSheetEntry") != 0) continue;
                return true;
            }
            return false;
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    }
}

