/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tpt.ide.ui.timesheet.internal;

import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.tpt.ide.ui.Activator;
import com.ibm.team.tpt.ide.ui.timesheet.internal.util.DateUtil;
import com.ibm.team.tpt.ide.ui.timesheet.internal.util.NumberUtil;
import com.ibm.team.tpt.ide.ui.timesheet.internal.util.TimesheetMessages;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.common.model.ITimeSheetEntry;
import com.ibm.team.workitem.common.model.ITimeSheetEntryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.ReferencesChangeDetails;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import com.ibm.team.workitem.rcp.ui.UIWorkItemListener;
import com.ibm.team.workitem.rcp.ui.UIWorkItemWorkingCopyListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class TimeSheetEntriesSectionIDE
extends PresentationPart {
    private WorkItemWorkingCopy fWorkingCopy;
    private Composite fParent = null;
    private IWorkItem fWorkItem = null;
    private WorkItemEditorToolkit fToolkit;
    private UUID fWorkitemUUID = null;
    private ResourceManager fResourceManager = null;
    private Listener fListener = null;
    private final WorkItemListener fWorkItemListener = new WorkItemListener();

    public void createContent(ITeamFormLayout formLayout) {
        Composite parent;
        WorkItemEditorToolkit toolkit;
        this.fToolkit = toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        this.fParent = parent = formLayout.getContainer();
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        GridData gd = new GridData(1808);
        GC gc = new GC((Drawable)parent);
        FontMetrics metrics = gc.getFontMetrics();
        int widthHint = 33 * metrics.getAverageCharWidth();
        gc.dispose();
        gd.widthHint = widthHint;
        parent.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginTop = 3;
        layout.marginBottom = 3;
        layout.marginWidth = 6;
        layout.verticalSpacing = 3;
        final WorkItemEditorToolkit tk = this.fToolkit;
        parent.setLayout((Layout)layout);
        parent.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle clArea = TimeSheetEntriesSectionIDE.this.getParent().getClientArea();
                GC gc = e.gc;
                gc.setAntialias(1);
                gc.setForeground(tk.getColors().getColor("org.eclipse.ui.forms.TB_BORDER"));
                gc.drawRoundRectangle(0, 0, clArea.width - 1, clArea.height - 1, 6, 6);
                gc.setForeground(TimeSheetEntriesSectionIDE.this.getParent().getDisplay().getSystemColor(1));
                gc.drawPoint(2, 2);
                gc.drawPoint(1, 2);
                gc.drawPoint(1, 3);
                gc.drawPoint(2, 1);
                gc.drawPoint(3, 1);
                gc.drawPoint(clArea.width - 3, 2);
                gc.drawPoint(clArea.width - 2, 2);
                gc.drawPoint(clArea.width - 2, 3);
                gc.drawPoint(clArea.width - 3, 1);
                gc.drawPoint(clArea.width - 4, 1);
                gc.drawPoint(2, clArea.height - 3);
                gc.drawPoint(1, clArea.height - 3);
                gc.drawPoint(1, clArea.height - 4);
                gc.drawPoint(2, clArea.height - 2);
                gc.drawPoint(3, clArea.height - 2);
                gc.drawPoint(clArea.width - 3, clArea.height - 3);
                gc.drawPoint(clArea.width - 2, clArea.height - 3);
                gc.drawPoint(clArea.width - 2, clArea.height - 4);
                gc.drawPoint(clArea.width - 3, clArea.height - 2);
                gc.drawPoint(clArea.width - 4, clArea.height - 2);
                gc.setAntialias(0);
            }
        });
        final Color start = toolkit.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START");
        final Color end = toolkit.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END");
        parent.setBackgroundMode(1);
        parent.setBackground(start);
        TimeSheetEntriesSectionIDE.setBackgroundImage(parent, start, end);
        parent.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                TimeSheetEntriesSectionIDE.setBackgroundImage(TimeSheetEntriesSectionIDE.this.getParent(), start, end);
            }
        });
        UIWorkItemWorkingCopyListener uiCopyListener = (UIWorkItemWorkingCopyListener)this.getSite().getAdapter(UIWorkItemWorkingCopyListener.class);
        UIWorkItemListener uiWorkItemListener = (UIWorkItemListener)this.getSite().getAdapter(UIWorkItemListener.class);
        if (uiCopyListener != null) {
            uiCopyListener.addListener((IWorkingCopyListener)this.fWorkItemListener);
        }
        if (uiWorkItemListener != null) {
            uiWorkItemListener.addListener((IWorkItemListener)this.fWorkItemListener);
        }
        this.fListener = new Listener(){

            public void handleEvent(Event event) {
                String eventData = (String)event.data;
                String text = event.text;
                if (text == null || text == "") {
                    return;
                }
                if (text.compareTo("Timesheet_Entry_Modified") != 0) {
                    return;
                }
                String workitemUUID = TimeSheetEntriesSectionIDE.this.getWorkItemId();
                if (eventData == null) {
                    return;
                }
                if (!workitemUUID.equalsIgnoreCase(eventData)) {
                    return;
                }
                TimeSheetEntriesSectionIDE.this.clearAndDisplayEntries();
            }
        };
        parent.getShell().addListener(4, this.fListener);
        this.fParent.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                Composite par = TimeSheetEntriesSectionIDE.this.getParent();
                par.getShell().removeListener(4, TimeSheetEntriesSectionIDE.this.fListener);
            }
        });
    }

    private void clearAndDisplayEntries() {
        if (!this.getParent().isDisposed()) {
            Control[] controlArray = this.getParent().getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control cur = controlArray[n2];
                cur.dispose();
                ++n2;
            }
            this.displayWeekEntries();
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected String getWorkItemId() {
        return this.fWorkitemUUID.getUuidValue();
    }

    protected Composite getParent() {
        return this.fParent;
    }

    private static void setBackgroundImage(Composite control, Color start, Color end) {
        Rectangle rect = control.getClientArea();
        if (!rect.isEmpty()) {
            int height = Math.max(3, rect.height);
            int width = Math.max(4, rect.width);
            Image newImage = new Image((Device)control.getDisplay(), width, height);
            GC gc = new GC((Drawable)newImage);
            gc.setForeground(start);
            gc.setBackground(end);
            gc.fillGradientRectangle(rect.x + 2, rect.y + 2, width - 4, height - 3, true);
            gc.dispose();
            Image oldImage = control.getBackgroundImage();
            control.setBackgroundImage(newImage);
            if (oldImage != null && !oldImage.isDisposed()) {
                oldImage.dispose();
            }
        }
    }

    private void checkAndAddToAppropriateList(IReference reference, List<ITimeSheetEntry> resolvedEntries, List<ITimeSheetEntryHandle> unResolvedEntres) {
        ITimeSheetEntryHandle handle = (ITimeSheetEntryHandle)reference.resolve();
        IAuditable auditable = this.fWorkingCopy.getDependentItems().get((IAuditableHandle)handle);
        if (auditable != null) {
            resolvedEntries.add((ITimeSheetEntry)auditable);
        } else {
            unResolvedEntres.add(handle);
        }
    }

    private ITimeSheetEntry[] resolveReferences() throws TeamRepositoryException {
        ArrayList<ITimeSheetEntry> resolvedEntries = new ArrayList<ITimeSheetEntry>();
        IWorkItemReferences workItemReferences = this.fWorkingCopy.getReferences();
        List currentEntries = workItemReferences.getReferences(WorkItemEndPoints.WORK_TIME);
        List removedEntries = workItemReferences.getDeletedReferences(WorkItemEndPoints.WORK_TIME);
        removedEntries = removedEntries != null ? removedEntries : new ArrayList();
        ArrayList<ITimeSheetEntryHandle> unResolvedEntres = new ArrayList<ITimeSheetEntryHandle>();
        if (currentEntries != null) {
            for (IReference reference : currentEntries) {
                if (removedEntries.contains(reference)) continue;
                this.checkAndAddToAppropriateList(reference, resolvedEntries, unResolvedEntres);
            }
        }
        if (unResolvedEntres.size() > 0) {
            IItemManager itemManager = this.fWorkingCopy.getTeamRepository().itemManager();
            List resolvedHandles = itemManager.fetchCompleteItems(unResolvedEntres, 1, (IProgressMonitor)new NullProgressMonitor());
            resolvedEntries.addAll(resolvedHandles);
        }
        return resolvedEntries.toArray(new ITimeSheetEntry[resolvedEntries.size()]);
    }

    private void displayWeekEntries() {
        Label quickInfoLabel = this.fToolkit.createLabel(this.getParent(), TimesheetMessages.QUICK_INFO_LABEL);
        quickInfoLabel.setLayoutData((Object)new GridData(16384, 1, false, false, 2, 1));
        quickInfoLabel.setForeground(this.fToolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        quickInfoLabel.setBackground(null);
        quickInfoLabel.setFont((Font)this.fResourceManager.get((DeviceResourceDescriptor)JFaceResources.getFontDescriptor((String)"").withStyle(1)));
        UIUpdaterJob quickInfoUIUpdateJob = new UIUpdaterJob(TimesheetMessages.DISPLAY_TIMESHEET_ENTRY){
            private ITimeSheetEntry[] timeSheetEntries;
            {
                this.timeSheetEntries = null;
            }

            public IStatus runInBackground(IProgressMonitor monitor) {
                try {
                    this.timeSheetEntries = TimeSheetEntriesSectionIDE.this.resolveReferences();
                }
                catch (TeamRepositoryException e) {
                    Activator.log(e);
                }
                return Status.OK_STATUS;
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                TimeSheetEntriesSectionIDE.this.updateQuickSection(this.timeSheetEntries);
                return Status.OK_STATUS;
            }
        };
        quickInfoUIUpdateJob.schedule();
    }

    private void updateQuickSection(ITimeSheetEntry[] timeSheetEntries) {
        HashMap<Date, Double> weekEntriesMap = new HashMap<Date, Double>();
        HashMap<Date, Date> weekDateMap = new HashMap<Date, Date>();
        double workItemTotal = 0.0;
        if (timeSheetEntries == null) {
            timeSheetEntries = new ITimeSheetEntry[]{};
        }
        if (timeSheetEntries.length == 0) {
            this.showEmpty();
            this.getParent().layout(true, true);
            this.getParent().layout(this.getParent().getChildren());
        } else {
            int i = 0;
            while (i < timeSheetEntries.length) {
                Timestamp startDate = timeSheetEntries[i].getStartDate();
                Date date = new Date(startDate.getTime());
                date = this.formatDate(date);
                Date[] startAndEndDates = this.findWeek(date);
                double hoursSpent = timeSheetEntries[i].getHoursSpent();
                if (!weekEntriesMap.containsKey(startAndEndDates[0])) {
                    weekEntriesMap.put(startAndEndDates[0], hoursSpent);
                } else {
                    weekEntriesMap.put(startAndEndDates[0], (Double)weekEntriesMap.get(startAndEndDates[0]) + hoursSpent);
                }
                if (!weekDateMap.containsKey(startAndEndDates[0])) {
                    weekDateMap.put(startAndEndDates[0], date);
                }
                workItemTotal += hoursSpent;
                ++i;
            }
            if (weekEntriesMap != null) {
                Set weekValues = weekEntriesMap.keySet();
                Date[] weekArray = new Date[weekValues.size()];
                Iterator iterator = weekValues.iterator();
                int j = 0;
                while (iterator.hasNext()) {
                    weekArray[j] = (Date)iterator.next();
                    ++j;
                }
                Arrays.sort(weekArray, new Comparator<Date>(){

                    @Override
                    public int compare(Date leftEntry, Date rightEntry) {
                        if (leftEntry.compareTo(rightEntry) >= 0) {
                            return 1;
                        }
                        return 0;
                    }
                });
                if (weekValues != null) {
                    int i2 = 0;
                    while (i2 < weekArray.length) {
                        HyperlinkGroup fHyperlinkGroup = new HyperlinkGroup(Display.getCurrent());
                        final Hyperlink weekLink = new Hyperlink(this.fParent, 0);
                        GridData gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
                        weekLink.setLayoutData((Object)gridData);
                        weekLink.setBackground(null);
                        Date[] startAndEndDates = this.findWeek(weekArray[i2]);
                        String dateString = DateUtil.formatDateRangeWithHoursMedium(startAndEndDates[0], startAndEndDates[1], (Double)weekEntriesMap.get(weekArray[i2]));
                        String toolTip = DateUtil.formatDateRangeWithHoursLong(startAndEndDates[0], startAndEndDates[1], (Double)weekEntriesMap.get(weekArray[i2]));
                        weekLink.setText(dateString);
                        weekLink.setToolTipText(toolTip);
                        weekLink.setData((Object)startAndEndDates[0]);
                        fHyperlinkGroup.add(weekLink);
                        final UUID workitemID = this.fWorkitemUUID;
                        weekLink.setUnderlined(false);
                        weekLink.addListener(6, new Listener(){

                            public void handleEvent(Event event) {
                                weekLink.setUnderlined(true);
                            }
                        });
                        weekLink.addListener(7, new Listener(){

                            public void handleEvent(Event event) {
                                weekLink.setUnderlined(false);
                            }
                        });
                        weekLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                            public void linkActivated(HyperlinkEvent event) {
                                Hyperlink weekLink = (Hyperlink)event.getSource();
                                Date startDayOfWeek = (Date)weekLink.getData();
                                Event e1 = new Event();
                                e1.text = "Timesheet_Entry_Clicked";
                                HashMap<String, Date> eventData = new HashMap<String, Date>();
                                eventData.put(workitemID.getUuidValue(), startDayOfWeek);
                                e1.data = eventData;
                                TimeSheetEntriesSectionIDE.this.fParent.getShell().notifyListeners(3, e1);
                            }
                        });
                        ++i2;
                    }
                }
                Label horizontalLine = new Label(this.fParent, 258);
                horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                horizontalLine.setFont(this.fParent.getFont());
                Label workItemTotalLabel = new Label(this.fParent, 4);
                GridData data = new GridData(0x1000000, 0x1000000, false, false);
                workItemTotalLabel.setData((Object)data);
                String weekTotalInStr = NumberUtil.formatHours(workItemTotal);
                workItemTotalLabel.setText(String.valueOf(TimesheetMessages.WORK_ITEM_TOTAL) + " " + weekTotalInStr + " " + TimesheetMessages.HOURS);
                this.getParent().layout(true, true);
                SharedScrolledComposite form = this.getScrolledComposite();
                if (form != null) {
                    form.reflow(true);
                    form.layout(true, true);
                }
            }
        }
    }

    private SharedScrolledComposite getScrolledComposite() {
        Composite parent = this.getParent().getParent();
        while (parent != null) {
            if (parent instanceof SharedScrolledComposite) {
                return (SharedScrolledComposite)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private Date[] findWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int day = cal.get(7);
        int beginOffset = day - 1;
        int endOffset = 7 - day;
        Date[] retVal = new Date[]{new Date(date.getTime() - (long)(beginOffset * 86400000)), new Date(date.getTime() + (long)(endOffset * 86400000))};
        return retVal;
    }

    public Date formatDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 12);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date d = cal.getTime();
        return d;
    }

    private void showEmpty() {
        Label noEntryLabel = new Label(this.fParent, 4);
        noEntryLabel.setText(TimesheetMessages.NO_TIMESHEET_RECORD_PRESENT);
        this.getParent().layout(true, true);
        SharedScrolledComposite form = this.getScrolledComposite();
        if (form != null) {
            form.reflow(true);
            form.layout(true, true);
            return;
        }
    }

    public void setInput(Object input) {
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)input;
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.fWorkItem = this.fWorkingCopy.getWorkItem();
            if (this.fWorkItem != null) {
                this.fWorkitemUUID = this.fWorkItem.getItemId();
            }
        } else {
            this.fWorkingCopy = null;
        }
        this.displayWeekEntries();
    }

    protected boolean isDirty() {
        return this.fWorkingCopy != null ? this.fWorkingCopy.isDirty() : false;
    }

    protected void doUpdateReadOnly(boolean readOnly) {
    }

    private class WorkItemListener
    implements IWorkingCopyListener,
    IWorkItemListener {
        private WorkItemListener() {
        }

        public void workingCopyEvent(WorkingCopyEvent event) {
            UUID uuid;
            if (TimeSheetEntriesSectionIDE.this.fWorkingCopy == null) {
                return;
            }
            if (event.hasType("saved") && (uuid = event.getSource().getWorkItem().getItemId()) != null && uuid.getUuidValue().compareTo(TimeSheetEntriesSectionIDE.this.fWorkitemUUID.getUuidValue()) == 0) {
                TimeSheetEntriesSectionIDE.this.clearAndDisplayEntries();
            }
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            String[] allAttribs;
            if (event.affects((IWorkItemHandle)TimeSheetEntriesSectionIDE.this.fWorkItem) && (allAttribs = event.getChangedAttributes()) != null && allAttribs.length > 0) {
                String[] stringArray = allAttribs;
                int n = allAttribs.length;
                int n2 = 0;
                while (n2 < n) {
                    String attributeType = stringArray[n2];
                    if (attributeType.compareTo("references") == 0) {
                        ReferencesChangeDetails changes = (ReferencesChangeDetails)event.getAttributeChangeDetails("references");
                        if (changes == null) break;
                        List added = changes.getAdded();
                        List removed = changes.getRemoved();
                        if (!this.checkListForTimeTrackingEntries(added) && !this.checkListForTimeTrackingEntries(removed)) break;
                        TimeSheetEntriesSectionIDE.this.clearAndDisplayEntries();
                        break;
                    }
                    ++n2;
                }
            }
        }

        private boolean checkListForTimeTrackingEntries(List<IReference> allRefs) {
            for (IReference iter : allRefs) {
                String typeId = iter.getLink().getLinkType().getLinkTypeId();
                if (typeId == null || typeId.compareTo("com.ibm.team.workitem.linktype.timeSheetEntry") != 0) continue;
                return true;
            }
            return false;
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    }
}

