/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tpt.ide.ui.risk.internal.resource.widgets;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.DoubleBufferPainter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.tpt.ide.ui.Activator;
import com.ibm.team.tpt.ide.ui.risk.internal.util.GCState;
import com.ibm.team.tpt.ide.ui.risk.internal.util.Messages;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.WorkItemClient;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import com.ibm.team.workitem.rcp.ui.UIWorkItemListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class RiskMatrixPart
extends PresentationPart {
    private final int RED_CELL_THRESHOLD = 4800;
    private final int GREEN_CELL_THRESHOLD = 1601;
    private final int INVALID_IDENTIFIER_VALUE = -1;
    private final int IDENTIFIER_MAX_VALUE = 100;
    private static final int TEXT_MARGIN = 10;
    private static final int ERR_MARGIN = 25;
    private final String RISK_IMPACT_IDENTIFIER = "com.ibm.team.workitem.workItemType.risk.impact";
    private final String RISK_PROBABILITY_IDENTIFIER = "com.ibm.team.workitem.workItemType.risk.probability";
    private final String RISK_PRECISION_IDENTIFIER = "com.ibm.team.workitem.workItemType.risk.precision";
    private WorkItemListener fWorkItemListener = new WorkItemListener();
    private WorkItemWorkingCopy fWorkingCopy;
    private IAttribute fImpactAttribute;
    private IAttribute fProbabilityAttribute;
    private IAttribute fPrecisionAttribute;
    private Object[] fImpactArray = null;
    private Object[] fProbabilityArray = null;
    private Identifier<?> fImpactSelectedValue = null;
    private Identifier<?> fProbabilitySelectedValue = null;
    private Identifier<?> fPrecisionSelectedValue = null;
    private IEnumeration<?> fPrecisionList = null;
    private ILiteral fPrecisionLiteral = null;
    private Composite fLabelArea = null;
    private Canvas fCvsMatrix;
    private static Color fThemeColor;
    private static Color fWhiteColorCell;
    private String fPrecisionMarkValue = null;
    private IProgressMonitor fCreateMatrixMonitor;
    private IProgressMonitor fRedrawMatrixMonitor;
    ArrayList<Color> fColorList = new ArrayList();
    private int fCellDimension = 0;
    private int fCharWidth = 0;
    private static final int MIN_CELL_WIDTH = 13;
    private static final int OFFSET_1 = 2;
    private static final int OFFSET_2 = 3;
    private static final int OFFSET_3 = 8;
    private int fLastXPosition = 0;
    private int fLastYPosition = 0;

    public void createContent(ITeamFormLayout formLayout) {
        Assert.isNotNull((Object)formLayout);
        Assert.isNotNull((Object)this.getSite());
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        this.fLabelArea = toolkit.createComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        Composite riskContainer = toolkit.createComposite(parent, 0);
        riskContainer.setLayoutData((Object)new GridData(1808));
        riskContainer.setLayout((Layout)layout);
        this.fCvsMatrix = new Canvas(riskContainer, 262144){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                if (RiskMatrixPart.this.fImpactArray == null || RiskMatrixPart.this.fProbabilityArray == null) {
                    GC gc = new GC((Drawable)RiskMatrixPart.this.fCvsMatrix);
                    try {
                        Point size = gc.textExtent(Messages.LOADING_MATRIX_ATTRIBUTES);
                        Point point = new Point(size.x + 10, size.y + 10);
                        return point;
                    }
                    finally {
                        gc.dispose();
                    }
                }
                int cellDimension = RiskMatrixPart.this.getCellDimension();
                int width = (RiskMatrixPart.this.fImpactArray.length + 1) * cellDimension;
                int height = (RiskMatrixPart.this.fProbabilityArray.length + 3) * cellDimension;
                return new Point(width, height);
            }
        };
        this.initAccessible((Control)this.fCvsMatrix);
        new DoubleBufferPainter(this.fCvsMatrix){

            public void doPaint(PaintEvent event) {
                RiskMatrixPart.this.doPaintMatrix(event);
            }
        };
        fThemeColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE");
        fWhiteColorCell = toolkit.getColors().getBackground();
        toolkit.adapt((Control)this.fCvsMatrix, true, true);
        this.addWidgetSelectionListener();
        this.addMouseTrackListener();
        this.installMouseClickListener();
    }

    public void setInput(Object input) {
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)input;
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.computeInputForMatrix();
            this.addListeners();
        } else {
            this.fWorkingCopy = null;
        }
    }

    private void computeInputForMatrix() {
        FoundationJob job = new FoundationJob(Messages.LOADING_MATRIX){

            protected IStatus runProtected(IProgressMonitor monitor) {
                try {
                    RiskMatrixPart.this.fCreateMatrixMonitor = monitor;
                    IWorkItem workitem = RiskMatrixPart.this.fWorkingCopy.getWorkItem();
                    ITeamRepository repository = (ITeamRepository)workitem.getOrigin();
                    WorkItemClient workItemClient = (WorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
                    RiskMatrixPart.this.fetchWorkitemAttributes(workItemClient, workitem, monitor);
                    RiskMatrixPart.this.forceRedraw();
                }
                catch (TeamRepositoryException e) {
                    Activator.log(e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        this.fCreateMatrixMonitor = null;
    }

    private void forceRedraw() {
        FoundationUIJob uijob = new FoundationUIJob(Messages.REDRAW_MATRIX){

            public IStatus runProtectedInUI(IProgressMonitor uimonitor) {
                RiskMatrixPart.this.fRedrawMatrixMonitor = uimonitor;
                RiskMatrixPart.this.fCvsMatrix.redraw();
                return Status.OK_STATUS;
            }
        };
        uijob.schedule();
        this.fRedrawMatrixMonitor = null;
    }

    private void fetchWorkitemAttributes(WorkItemClient workItemClient, IWorkItem workitem, IProgressMonitor progressmonitor) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressmonitor, (int)9);
        try {
            this.fImpactAttribute = workItemClient.findAttribute(this.fWorkingCopy.getWorkItem().getProjectArea(), "com.ibm.team.workitem.workItemType.risk.impact", (IProgressMonitor)monitor.newChild(1));
            this.fImpactSelectedValue = (Identifier)this.fImpactAttribute.getValue(workItemClient.getAuditableCommon(), workitem, (IProgressMonitor)monitor.newChild(1));
            List<Identifier<String>> returnedList = this.createAttributeValueSet(this.fImpactAttribute.getValueSet(workItemClient.getAuditableCommon(), workitem, (IProgressMonitor)monitor.newChild(1)));
            if (!returnedList.isEmpty()) {
                this.fImpactArray = returnedList.toArray(new Object[returnedList.size()]);
            }
            this.fProbabilityAttribute = workItemClient.findAttribute(this.fWorkingCopy.getWorkItem().getProjectArea(), "com.ibm.team.workitem.workItemType.risk.probability", (IProgressMonitor)monitor.newChild(1));
            this.fProbabilitySelectedValue = (Identifier)this.fProbabilityAttribute.getValue(workItemClient.getAuditableCommon(), workitem, (IProgressMonitor)monitor.newChild(1));
            returnedList = this.createAttributeValueSet(this.fProbabilityAttribute.getValueSet(workItemClient.getAuditableCommon(), workitem, (IProgressMonitor)monitor.newChild(1)));
            if (!returnedList.isEmpty()) {
                this.fProbabilityArray = returnedList.toArray(new Object[returnedList.size()]);
            }
            this.fPrecisionAttribute = workItemClient.findAttribute(this.fWorkingCopy.getWorkItem().getProjectArea(), "com.ibm.team.workitem.workItemType.risk.precision", (IProgressMonitor)monitor.newChild(1));
            this.fPrecisionSelectedValue = (Identifier)this.fPrecisionAttribute.getValue(workItemClient.getAuditableCommon(), workitem, (IProgressMonitor)monitor.newChild(1));
            this.fPrecisionList = workItemClient.resolveEnumeration((IAttributeHandle)this.fPrecisionAttribute, (IProgressMonitor)monitor.newChild(1));
            if (this.fPrecisionList != null) {
                this.fPrecisionMarkValue = this.getPrecisionName(this.fPrecisionAttribute, this.fPrecisionSelectedValue);
                if (this.fPrecisionMarkValue == null) {
                    Activator.log((IStatus)new Status(4, "com.ibm.team.tpt.ide.ui", NLS.bind((String)Messages.MISSING_PRECISION_LOG_MESSAGE, (Object)this.fPrecisionAttribute.getDisplayName(), (Object[])new Object[0])));
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private void doPaintMatrix(PaintEvent event) {
        if (this.fImpactArray == null || this.fProbabilityArray == null) {
            event.gc.drawText(Messages.LOADING_MATRIX_ATTRIBUTES, 10, 10);
        } else if (this.fPrecisionMarkValue == null) {
            event.gc.drawText(NLS.bind((String)Messages.MISSING_PRECISION_MESSAGE, (Object)this.fPrecisionAttribute.getDisplayName(), (Object[])new Object[0]), 25, 25);
        } else {
            GC gc = event.gc;
            this.setGCProperties(gc);
            int width = (this.fImpactArray.length + 1) * this.fCellDimension;
            int height = (this.fProbabilityArray.length + 3) * this.fCellDimension;
            ((Canvas)event.widget).setBounds(15, 0, width + 20, height);
            GridData gd = new GridData(1);
            gd.heightHint = height;
            this.fLabelArea.setLayoutData((Object)gd);
            int probabilityVal = this.getLastIntSegment(this.fProbabilitySelectedValue.getStringIdentifier());
            int impactVal = this.getLastIntSegment(this.fImpactSelectedValue.getStringIdentifier());
            this.createMatrix(gc, this.fCvsMatrix.getClientArea(), impactVal, probabilityVal, this.fPrecisionMarkValue);
        }
    }

    private void createMatrix(GC gc, Rectangle bounds, int xCell, int yRow, String mark) {
        GCState state = GCState.save(gc, 268);
        try {
            int yAxisCellStart = 0;
            if (this.fProbabilityArray != null && this.fProbabilityArray.length > 0 && this.fImpactArray != null && this.fImpactArray.length > 0) {
                yAxisCellStart = this.drawMatrix(gc, xCell, yRow, mark, yAxisCellStart);
                this.setThemeBasedColor(gc);
                this.drawXAxisCellLabel(gc, yAxisCellStart);
            }
            gc.setAntialias(0);
        }
        finally {
            state.restore();
        }
    }

    private int drawMatrix(GC gc, int xCell, int yRow, String mark, int yAxisCellStart) {
        int row = this.fProbabilityArray.length - 1;
        while (row >= 0) {
            Identifier probabilityIdetifier = (Identifier)this.fProbabilityArray[this.fProbabilityArray.length - row - 1];
            int probabilityLitVal = this.getLastIntSegment(probabilityIdetifier.getStringIdentifier());
            yAxisCellStart = (row + 1) * this.fCellDimension;
            this.drawVAxisCellLabel(gc, probabilityLitVal, yAxisCellStart);
            int column = 0;
            while (column < this.fImpactArray.length) {
                this.setThemeBasedColor(gc);
                boolean markflag = false;
                int xAxisCellStart = 0;
                xAxisCellStart = (column + 1) * this.fCellDimension;
                if (row == 0 && column == 0) {
                    gc.drawText(Messages.RISK_MATRIX_PROBABILITY_LABEL, 6, 5);
                }
                Identifier impactIdetifier = (Identifier)this.fImpactArray[column];
                int impactLitVal = this.getLastIntSegment(impactIdetifier.getStringIdentifier());
                int cellValue = impactLitVal * probabilityLitVal;
                if (xCell == impactLitVal && yRow == probabilityLitVal) {
                    markflag = true;
                }
                this.setCellBorderColor(gc);
                this.paintRectangle(gc, xAxisCellStart, yAxisCellStart, cellValue, mark, markflag);
                ++column;
            }
            --row;
        }
        return yAxisCellStart;
    }

    private void drawVAxisCellLabel(GC gc, int probabilityLitVal, int yAxisCellStart) {
        this.setThemeBasedColor(gc);
        int length = String.valueOf(probabilityLitVal).length();
        gc.drawText(String.valueOf(probabilityLitVal), this.fCellDimension - this.fCharWidth * length - 5, yAxisCellStart + this.fCellDimension / 4);
    }

    private void drawXAxisCellLabel(GC gc, int yCellStart) {
        int x = 0;
        yCellStart = (this.fProbabilityArray.length + 1) * this.fCellDimension;
        int length = 0;
        int column = 0;
        while (column < this.fImpactArray.length) {
            x = (column + 1) * this.fCellDimension;
            Identifier impactIdetifier = (Identifier)this.fImpactArray[column];
            int impactLitVal = this.getLastIntSegment(impactIdetifier.getStringIdentifier());
            length = String.valueOf(impactLitVal).length();
            gc.drawText("" + impactLitVal, x + this.fCellDimension - this.fCharWidth * length - 8, yCellStart);
            ++column;
        }
        yCellStart = (this.fProbabilityArray.length + 2) * this.fCellDimension;
        x = (this.fImpactArray.length + 2) * this.fCellDimension;
        gc.drawText(Messages.RISK_MATRIX_IMPACT_LABEL, x / 3, yCellStart - 8);
    }

    private void paintRectangle(GC gc, int x, int y, int cellValue, String mark, boolean markflag) {
        Color cellColor;
        gc.drawRectangle(x, y, this.fCellDimension - 2, this.fCellDimension - 2);
        int colorCellEndPoint = this.fCellDimension - 3;
        if (cellValue < 1601) {
            cellColor = new Color(gc.getDevice(), 173, 215, 152);
            gc.setBackground(cellColor);
            gc.fillRectangle(x + 1, y + 1, colorCellEndPoint, colorCellEndPoint);
            this.fColorList.add(cellColor);
        }
        if (cellValue >= 1601 && cellValue <= 4800) {
            cellColor = new Color(gc.getDevice(), 240, 226, 183);
            gc.setBackground(cellColor);
            gc.fillRectangle(x + 1, y + 1, colorCellEndPoint, colorCellEndPoint);
            this.fColorList.add(cellColor);
        }
        if (cellValue > 4800) {
            cellColor = new Color(gc.getDevice(), 237, 176, 176);
            gc.setBackground(cellColor);
            gc.fillRectangle(x + 1, y + 1, colorCellEndPoint, colorCellEndPoint);
            this.fColorList.add(cellColor);
        }
        if (markflag) {
            this.fLastXPosition = x;
            this.fLastYPosition = y;
            gc.drawText(mark, x + this.fCellDimension / 3 - 1, y + this.fCellDimension / 4, true);
        }
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        if (this.fRedrawMatrixMonitor != null) {
            this.fRedrawMatrixMonitor.setCanceled(true);
        }
        if (this.fCreateMatrixMonitor != null) {
            this.fCreateMatrixMonitor.setCanceled(true);
        }
        if (!this.fColorList.isEmpty()) {
            for (Color c : this.fColorList) {
                if (c.isDisposed()) continue;
                c.dispose();
            }
        }
        super.dispose();
    }

    private String getPrecisionName(IAttribute attribute, Identifier precisionIdentifier) {
        if (precisionIdentifier != null && attribute != null && this.fPrecisionList != null) {
            this.fPrecisionLiteral = this.fPrecisionList.findEnumerationLiteral(precisionIdentifier);
            return this.getLastStringSegment(this.fPrecisionLiteral.getName());
        }
        return null;
    }

    private void addListeners() {
        UIWorkItemListener uiWorkItemListener;
        if (this.getSite() != null && (uiWorkItemListener = (UIWorkItemListener)this.getSite().getAdapter(UIWorkItemListener.class)) != null) {
            uiWorkItemListener.addListener((IWorkItemListener)this.fWorkItemListener);
        }
    }

    private void removeListeners() {
        UIWorkItemListener uiWorkItemListener;
        if (this.getSite() != null && (uiWorkItemListener = (UIWorkItemListener)this.getSite().getAdapter(UIWorkItemListener.class)) != null) {
            uiWorkItemListener.removeListener((IWorkItemListener)this.fWorkItemListener);
        }
    }

    private void installMouseClickListener() {
        this.fCvsMatrix.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                RiskMatrixPart.this.performMouseDown(event);
            }
        });
    }

    private List<Identifier<String>> createAttributeValueSet(Object[] valueSet) {
        ArrayList<Identifier<String>> validLiteralList = new ArrayList<Identifier<String>>();
        if (valueSet != null && valueSet.length > 0) {
            int cnt = 0;
            while (cnt < valueSet.length) {
                Identifier identifierVal = (Identifier)valueSet[cnt];
                int identVal = this.getLastIntSegment(identifierVal.getStringIdentifier());
                if (identVal != -1 && identVal <= 100) {
                    validLiteralList.add((Identifier<String>)identifierVal);
                }
                ++cnt;
            }
        }
        return validLiteralList;
    }

    private int getLastIntSegment(String identfier) {
        int literalNumber = -1;
        if (identfier != null) {
            int indx = identfier.lastIndexOf(46);
            String literalId = identfier.substring(indx + 2);
            try {
                literalNumber = Integer.parseInt(literalId);
            }
            catch (NumberFormatException e) {
                Activator.log(e);
            }
        }
        return literalNumber;
    }

    private String getLastStringSegment(String identfier) {
        String literalMark = identfier.substring(0, 1);
        return literalMark;
    }

    private void performOnAttributeChange(WorkItemChangeEvent event, String[] changedAttributes) {
        boolean redrawFlag = false;
        int cnt = 0;
        while (cnt < changedAttributes.length) {
            redrawFlag = false;
            if (changedAttributes[cnt].equals("com.ibm.team.workitem.workItemType.risk.impact")) {
                this.fImpactSelectedValue = (Identifier)event.getWorkItem().getValue(this.fImpactAttribute);
                redrawFlag = true;
            }
            if (changedAttributes[cnt].equals("com.ibm.team.workitem.workItemType.risk.probability")) {
                this.fProbabilitySelectedValue = (Identifier)event.getWorkItem().getValue(this.fProbabilityAttribute);
                redrawFlag = true;
            }
            if (changedAttributes[cnt].equals("com.ibm.team.workitem.workItemType.risk.precision")) {
                this.fPrecisionSelectedValue = (Identifier)event.getWorkItem().getValue(this.fPrecisionAttribute);
                this.fPrecisionMarkValue = this.getPrecisionName(this.fPrecisionAttribute, this.fPrecisionSelectedValue);
                redrawFlag = true;
            }
            if (redrawFlag) {
                this.forceRedraw();
            }
            ++cnt;
        }
    }

    private void performMouseDown(Event event) {
        if (this.fImpactArray != null && this.fProbabilityArray != null) {
            int width = (this.fImpactArray.length + 1) * this.fCellDimension;
            int height = (this.fProbabilityArray.length + 1) * this.fCellDimension;
            if (event.x >= this.fCellDimension && event.x < width && event.y < height && event.y > this.fCellDimension) {
                int xPosition = event.x / this.fCellDimension;
                int yPosition = event.y / this.fCellDimension;
                if (xPosition > this.fImpactArray.length) {
                    xPosition = this.fImpactArray.length;
                }
                if (yPosition > this.fProbabilityArray.length) {
                    yPosition = this.fProbabilityArray.length;
                }
                if (yPosition == 0) {
                    yPosition = 1;
                }
                if (xPosition == 0) {
                    xPosition = 1;
                }
                this.fImpactSelectedValue = (Identifier)this.fImpactArray[xPosition - 1];
                this.fProbabilitySelectedValue = (Identifier)this.fProbabilityArray[this.fProbabilityArray.length - yPosition];
                this.fWorkingCopy.getWorkItem().setValue(this.fImpactAttribute, this.fImpactSelectedValue);
                this.fWorkingCopy.getWorkItem().setValue(this.fProbabilityAttribute, this.fProbabilitySelectedValue);
                this.forceRedraw();
            }
        }
    }

    private void setThemeBasedColor(GC gc) {
        gc.setForeground(fThemeColor);
        gc.setBackground(fWhiteColorCell);
    }

    private void setCellBorderColor(GC gc) {
        gc.setForeground(this.fCvsMatrix.getDisplay().getSystemColor(16));
    }

    private void setGCProperties(GC gc) {
        gc.setAntialias(1);
        this.fCharWidth = gc.getFontMetrics().getAverageCharWidth();
        this.fCellDimension = this.getCellDimension();
        gc.setFont(JFaceResources.getDefaultFont());
    }

    private int getCellDimension() {
        Font defaultFont = JFaceResources.getDefaultFont();
        int cellDimension = defaultFont.getFontData()[0].getHeight();
        cellDimension = cellDimension <= 13 ? 26 : (cellDimension *= 2);
        return cellDimension;
    }

    private void addWidgetSelectionListener() {
        this.fCvsMatrix.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = Messages.RISK_MATRIX;
                }
            }
        });
        this.fCvsMatrix.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
    }

    private void addMouseTrackListener() {
        this.fCvsMatrix.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                if (e.x > RiskMatrixPart.this.fLastXPosition && e.x < RiskMatrixPart.this.fLastXPosition + RiskMatrixPart.this.fCellDimension && e.y > RiskMatrixPart.this.fLastYPosition && e.y < RiskMatrixPart.this.fLastYPosition + RiskMatrixPart.this.fCellDimension) {
                    RiskMatrixPart.this.fCvsMatrix.setToolTipText(RiskMatrixPart.this.fPrecisionLiteral.getName());
                } else {
                    RiskMatrixPart.this.fCvsMatrix.setToolTipText(Messages.RISK_MATRIX);
                }
            }

            public void mouseExit(MouseEvent e) {
                RiskMatrixPart.this.fCvsMatrix.setToolTipText(Messages.RISK_MATRIX);
            }

            public void mouseEnter(MouseEvent e) {
                if (e.x > RiskMatrixPart.this.fLastXPosition && e.x < RiskMatrixPart.this.fLastXPosition + RiskMatrixPart.this.fCellDimension && e.y > RiskMatrixPart.this.fLastYPosition && e.y < RiskMatrixPart.this.fLastYPosition + RiskMatrixPart.this.fCellDimension) {
                    RiskMatrixPart.this.fCvsMatrix.setToolTipText(RiskMatrixPart.this.fPrecisionLiteral.getName());
                } else {
                    RiskMatrixPart.this.fCvsMatrix.setToolTipText(Messages.RISK_MATRIX);
                }
            }
        });
    }

    protected boolean isDirty() {
        return this.fWorkingCopy != null ? this.fWorkingCopy.isDirty() : false;
    }

    protected void doUpdateReadOnly(boolean readOnly) {
    }

    private class WorkItemListener
    implements IWorkItemListener {
        private WorkItemListener() {
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            String[] changedAttributes = event.getChangedAttributes();
            RiskMatrixPart.this.performOnAttributeChange(event, changedAttributes);
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    }
}

