/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tpt.ide.ui.risk.internal.parts;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.tpt.ide.ui.Activator;
import com.ibm.team.tpt.ide.ui.risk.internal.util.Messages;
import com.ibm.team.tpt.internal.client.ITptClient;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedFormsText;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedText;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.internal.util.NumberVerifyListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public final class RiskCostAttributePart
extends AttributePart {
    private static final ISchedulingRule EXCLUSIVE_SCHEDULING_RULE = new ExclusiveSchedulingRule();
    private static final Status INFO_STATUS = new Status(1, "com.ibm.team.tpt.ide.ui.risk", "Info");
    private static final int STATUS_CODE_PARSE_ERROR = 4;
    private Text fText;
    private DecoratedText fTextField;
    private RequiredPropertyLabel fTextLabel;
    private final AtomicInteger fUpdateToken = new AtomicInteger(0);
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        public void setVisible(boolean visible) {
        }

        public void dependencyChanged(List<String> dependencies) {
        }

        public void attributeChanged(WorkItemChangeEvent event) {
            RiskCostAttributePart.this.updateTextField();
        }

        public void setRequired(boolean required) {
        }

        public void setReadOnly(boolean readOnly) {
            RiskCostAttributePart.this.updateReadOnly(readOnly);
        }

        public void setStatus(IStatus status) {
        }
    };

    private static IStatus getIdleStatus(DecoratedText field) {
        IStatus status = field.getStatus();
        if (status.matches(6)) {
            return status;
        }
        Text text = field.getText();
        if (text.isFocusControl() && text.isEnabled()) {
            return INFO_STATUS;
        }
        return Status.OK_STATUS;
    }

    private static void syncExec(DecoratedText field, final Runnable runnable) {
        Display display;
        final Text text = field.getText();
        if (!text.isDisposed() && !(display = text.getDisplay()).isDisposed()) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!text.isDisposed()) {
                        runnable.run();
                    }
                }
            });
        }
    }

    private static void syncExec(final RequiredPropertyLabel text, final Runnable runnable) {
        Display display;
        if (!text.isDisposed() && !(display = text.getLayoutControl().getDisplay()).isDisposed()) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!text.isDisposed()) {
                        runnable.run();
                    }
                }
            });
        }
    }

    private void addListeners() {
        PresentationHandlerManager mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class);
        if (mgr != null) {
            mgr.addPresentationUpdater(this.fPresentationUpdater, Util.addDependencies((PresentationDescriptor)this.getPresentation(), (String[])new String[]{IWorkItem.DURATION_PROPERTY, WorkItem.CORRECTED_ESTIMATE_PROPERTY}));
        }
    }

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        this.fTextLabel = new RequiredPropertyLabel(parent, toolkit, this.getBackgroundStyle());
        formLayout.add(this.fTextLabel.getLayoutControl(), "label");
        this.fTextLabel.setText(NLS.bind((String)ATTRNAME_COLON, (Object)this.getLabel(), (Object[])new Object[0]));
        if (this.isReadOnly()) {
            this.fText = toolkit.createReadOnlyText(parent, "", 0, this.getBackgroundStyle());
            this.initAccessible((Control)this.fText);
            TeamFormLayouts.setLayoutData((Control)this.fText, (ITeamFormData)SINGLE_LINE_GROW_READONLY_TEXT);
            Util.addWidthHint((Control)this.fText);
            formLayout.add((Control)this.fText, "content");
        } else {
            int styles = "carbon".equals(SWT.getPlatform()) ? 16384 : 131072;
            this.fTextField = new DecoratedFormsText(parent, this.getSite(), styles, 0, this.getBackgroundStyle());
            this.initAccessible((Control)this.fTextField.getText());
            formLayout.add(this.fTextField.getLayoutControl(), "content");
            this.fTextField.setStatus(RiskCostAttributePart.getIdleStatus(this.fTextField));
            this.fText = this.fTextField.getText();
            this.fText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    RiskCostAttributePart.this.updateAttribute(true);
                }
            });
            this.fText.addVerifyListener((VerifyListener)new NumberVerifyListener(Long.class));
            this.fTextField.setStatus(RiskCostAttributePart.getIdleStatus(this.fTextField));
            if (this.isReadOnly()) {
                this.fTextField.getText().setEnabled(false);
            }
        }
    }

    public void dispose() {
        this.fUpdateToken.set(-1);
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    public IAttribute getAttribute() {
        return this.getAttribute(this.getWorkingCopy());
    }

    private void removeListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.removePresentationUpdater(this.fPresentationUpdater);
        }
    }

    public void setFocus() {
        this.fTextField.getText().setFocus();
    }

    public void setInput(Object input) {
        this.fUpdateToken.getAndIncrement();
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved() && this.getAttribute() != null) {
            WorkItemEditorInput extended = (WorkItemEditorInput)input;
            this.fWorkingCopy = extended.getWorkingCopy();
            this.addListeners();
            this.updateLabel();
            this.updateTextField();
        } else {
            this.fWorkingCopy = null;
        }
    }

    private void updateLabel() {
        AttributePartUpdateJob job = new AttributePartUpdateJob(this, Messages.FETCHING_ATTRIBUTES){

            @Override
            protected IStatus doRunProtected(IProgressMonitor monitor) {
                IProjectAreaHandle projectAreaHandle = fWorkingCopy.getWorkItem().getProjectArea();
                ITeamRepository repository = fWorkingCopy.getTeamRepository();
                ITptClient client = (ITptClient)repository.getClientLibrary(ITptClient.class);
                try {
                    final String currency = client.getProjectAreaCurrency(projectAreaHandle.getItemId().getUuidValue(), monitor);
                    this.runWithToken(fTextLabel, new Runnable(){

                        @Override
                        public void run() {
                            if (currency != null) {
                                fTextLabel.setText(NLS.bind((String)ATTRNAME_COLON, (Object)(String.valueOf(this.getLabel()) + " (" + currency + ")"), (Object[])new Object[0]));
                                fTextLabel.layout();
                                fTextLabel.getLayoutControl().getShell().layout(new Control[]{fTextLabel.getLayoutControl()});
                            }
                        }
                    });
                }
                catch (TeamRepositoryException e) {
                    Activator.log(e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setRule(EXCLUSIVE_SCHEDULING_RULE);
        job.setSystem(true);
        job.schedule();
    }

    private void updateAttribute(final boolean dirtyOnly) {
        if (this.isReadOnly()) {
            this.fText.setText(this.getNonNullValue());
            return;
        }
        final String trimmed = this.fTextField.getText().getText().trim();
        AttributePartUpdateJob job = new AttributePartUpdateJob(this, Messages.STORING_ATTRIBUTES){

            @Override
            protected IStatus doRunProtected(IProgressMonitor monitor) {
                this.runWithToken(fTextField, new Runnable(){

                    @Override
                    public void run() {
                        IStatus currentStatus;
                        if (!dirtyOnly) {
                            fTextField.setValue(trimmed);
                        }
                        if ((currentStatus = fTextField.getStatus()).getCode() == 4) {
                            fTextField.setStatus(Status.OK_STATUS);
                        }
                    }
                });
                this.runWithToken(new Runnable(){

                    @Override
                    public void run() {
                        if (fWorkingCopy != null && fWorkingCopy.getWorkItem().hasAttribute(this.getAttribute())) {
                            Long attribValue = null;
                            try {
                                attribValue = trimmed.equals("") ? new Long(0L) : Long.valueOf(Long.parseLong(trimmed));
                                fWorkingCopy.getWorkItem().setValue(this.getAttribute(), (Object)attribValue);
                            }
                            catch (NumberFormatException exception) {
                                fTextField.setStatus((IStatus)new Status(4, "com.ibm.team.tpt.ide.ui", 4, exception.getLocalizedMessage(), (Throwable)exception));
                            }
                        }
                        this.runWithToken(fTextField, new Runnable(){

                            @Override
                            public void run() {
                                IStatus currentStatus = fTextField.getStatus();
                                if (currentStatus.getCode() != 4) {
                                    fTextField.setStatus(Status.OK_STATUS);
                                }
                            }
                        });
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setRule(EXCLUSIVE_SCHEDULING_RULE);
        job.setSystem(true);
        job.schedule();
    }

    private void updateTextField() {
        if (this.isReadOnly()) {
            this.fText.setText(this.getNonNullValue());
            return;
        }
        final String trimmed = this.fTextField.getText().getText().trim();
        AttributePartUpdateJob job = new AttributePartUpdateJob(this, Messages.DISPLAYING_ATTRIBUTES){

            @Override
            protected IStatus doRunProtected(IProgressMonitor monitor) {
                final String textValue = this.getNonNullValue();
                if (textValue.compareTo(trimmed) != 0) {
                    this.runWithToken(fTextField, new Runnable(){

                        @Override
                        public void run() {
                            Text text = fTextField.getText();
                            text.setText(textValue);
                            if (!this.isReadOnly()) {
                                text.setEnabled(true);
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setRule(EXCLUSIVE_SCHEDULING_RULE);
        job.setSystem(true);
        job.schedule();
    }

    private String getNonNullValue() {
        WorkItemUIWorkingCopy uiCopy;
        ResolvedWorkItem workItem;
        Long l;
        String value = null;
        if (this.fWorkingCopy != null && this.getAttribute() != null && this.fWorkingCopy.getWorkItem().hasAttribute(this.getAttribute()) && (l = (Long)(workItem = (uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class)).getResolvedWorkItem()).getValue(this.getAttribute())) != null) {
            value = l.toString();
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    protected void doUpdateReadOnly(boolean readOnly) {
    }

    private abstract class AttributePartUpdateJob
    extends FoundationJob {
        private final int fToken;
        public static final String PLUGIN_ID = "com.ibm.team.tpt.ide.ui";

        AttributePartUpdateJob(String name) {
            super(name);
            this.fToken = RiskCostAttributePart.this.fUpdateToken.get();
        }

        protected abstract IStatus doRunProtected(IProgressMonitor var1) throws Exception;

        protected final IStatus runProtected(IProgressMonitor monitor) throws Exception {
            if (this.fToken == RiskCostAttributePart.this.fUpdateToken.get()) {
                return this.doRunProtected(monitor);
            }
            return Status.OK_STATUS;
        }

        protected final void runWithToken(DecoratedText field, final Runnable runnable) {
            Assert.isNotNull((Object)runnable);
            RiskCostAttributePart.syncExec(field, new Runnable(){

                @Override
                public void run() {
                    if (AttributePartUpdateJob.this.fToken == RiskCostAttributePart.this.fUpdateToken.get()) {
                        runnable.run();
                    }
                }
            });
        }

        protected final void runWithToken(RequiredPropertyLabel field, final Runnable runnable) {
            Assert.isNotNull((Object)runnable);
            RiskCostAttributePart.syncExec(field, new Runnable(){

                @Override
                public void run() {
                    if (AttributePartUpdateJob.this.fToken == RiskCostAttributePart.this.fUpdateToken.get()) {
                        runnable.run();
                    }
                }
            });
        }

        protected final void runWithToken(Runnable runnable) {
            Assert.isNotNull((Object)runnable);
            if (this.fToken == RiskCostAttributePart.this.fUpdateToken.get()) {
                runnable.run();
            }
        }
    }

    private static final class ExclusiveSchedulingRule
    implements ISchedulingRule {
        private ExclusiveSchedulingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof ExclusiveSchedulingRule;
        }
    }
}

