/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tpt.ide.ui.internal.aspecteditor.timetracking;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.ModelElement;
import java.util.List;

public class TimetrackingElement {
    public static final String ID = "com.ibm.team.tpt.timetracking";
    private static final String ATTR_NAME = "syncTimeSpentWithTimeTracking";
    private static final String TIMETRACKING_SPECIFICATION = "timeTrackingSpecification";
    public static final boolean SYNC_TIMETRACKING_DEFAULT = true;
    private boolean fSyncTimetrackingValue = true;

    public TimetrackingElement() {
    }

    public TimetrackingElement(IProcessConfigurationData data) {
        if (data != null) {
            this.parseData(data.getElements());
        }
    }

    public TimetrackingElement(ModelElement data) {
        List elements;
        if (data != null && (elements = data.getChildElements()) != null) {
            this.parseData(elements.toArray(new IProcessConfigurationElement[elements.size()]));
        }
    }

    private void parseData(IProcessConfigurationElement[] elements) {
        IProcessConfigurationElement[] iProcessConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessConfigurationElement element = iProcessConfigurationElementArray[n2];
            if (TIMETRACKING_SPECIFICATION.equals(element.getName())) {
                String value = element.getAttribute(ATTR_NAME);
                this.fSyncTimetrackingValue = Boolean.parseBoolean(value);
            }
            ++n2;
        }
    }

    public boolean getTimespentSync() {
        return this.fSyncTimetrackingValue;
    }

    public void setTimespentSync(boolean value) {
        this.fSyncTimetrackingValue = value;
    }

    public void writeTo(IMemento memento) {
        IMemento child = memento.createChild(TIMETRACKING_SPECIFICATION);
        child.putString(ATTR_NAME, String.valueOf(this.fSyncTimetrackingValue));
    }
}

