/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tpt.ide.ui.internal.aspecteditor.timetracking;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.AbstractTptAspectEditor;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.IAspectEditor;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.TptAspectPart;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.TptElement;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.TptManager;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.timetracking.Messages;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.timetracking.TimetrackingElement;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.ui.editor.TeamFormSectionPart;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class TimetrackingAspectEditor
extends AbstractTptAspectEditor
implements IAspectEditor {
    public static final String ASPECT_ID = "com.ibm.team.tpt.timetracking";
    private TimetrackingElement fTimetrackingConfiguration;
    private Composite fContainer;
    private ManagedForm fManagedForm;
    private TptAspectPart fTptPart;

    @Override
    public void init(IProcessAspectEditorSite site, ProcessAspect aspect) {
        super.init(site, aspect);
        ModelElement element = aspect.getConfigurationElement();
        this.fTimetrackingConfiguration = element == null ? new TimetrackingElement() : new TimetrackingElement(element);
    }

    public TimetrackingAspectEditor(String dataId) {
        super(dataId);
        this.setHelpContextId("com.ibm.team.workitem.ide.ui.aspect_time_tracking");
    }

    @Override
    protected void createEditorArea(Composite parent, FormToolkit toolkit) {
        this.fContainer = parent;
        GridLayoutFactory.fillDefaults().applyTo(parent);
        Composite timeTrackingComposite = this.createTimetrackingSection(toolkit);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)timeTrackingComposite);
        this.createTimecodeSection(toolkit);
    }

    private void createTimecodeSection(FormToolkit toolkit) {
        this.fManagedForm = new ManagedForm(toolkit, toolkit.createScrolledForm(this.fContainer));
        ScrolledForm form = this.fManagedForm.getForm();
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 400).applyTo((Control)form);
        Composite body = form.getBody();
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        body.setLayout((Layout)layout);
        this.fTptPart = new TptAspectPart(this, this);
        TeamFormSectionPart enumerationSection = new TeamFormSectionPart((IManagedForm)this.fManagedForm, 256, Messages.TptAspectEditor_TIMECODE, new TeamFormPart[]{this.fTptPart});
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        enumerationSection.getSection().setLayoutData((Object)formData);
        this.fManagedForm.addPart((IFormPart)enumerationSection);
    }

    private Composite createTimetrackingSection(FormToolkit toolkit) {
        Section section = toolkit.createSection(this.fContainer, 256);
        section.setText(Messages.TimeTrackingAspectEditor_SYNC_TIMESPENTWITHTIMETRACKINGLABEL);
        Composite container = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(container);
        section.setClient((Control)container);
        Label label = new Label(container, 131072);
        label.setText(Messages.TimeTrackingAspectEditor_SYNC_TIMESPENTWITHTIMETRACKING);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)label);
        final Button button = new Button(container, 32);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)button);
        button.setSelection(this.fTimetrackingConfiguration.getTimespentSync());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimetrackingAspectEditor.this.setDirty();
                if (TimetrackingAspectEditor.this.fTimetrackingConfiguration != null) {
                    TimetrackingAspectEditor.this.fTimetrackingConfiguration.setTimespentSync(button.getSelection());
                    TimetrackingAspectEditor.this.showPopMessage(button.getSelection());
                }
            }
        });
        return section;
    }

    private void showPopMessage(boolean timeSpentFlag) {
        if (timeSpentFlag) {
            MessageDialog.openInformation((Shell)this.fContainer.getShell(), (String)Messages.TptAspectEditor_SYNC_TIMESPENTWITHTIMETRACKING_INFO, (String)Messages.TptAspectEditor_SYNC_TIMESPENTWITHTIMETRACKING_TRUE);
        }
        if (!timeSpentFlag) {
            MessageDialog.openInformation((Shell)this.fContainer.getShell(), (String)Messages.TptAspectEditor_SYNC_TIMESPENTWITHTIMETRACKING_INFO, (String)Messages.TptAspectEditor_SYNC_TIMESPENTWITHTIMETRACKING_FALSE);
        }
    }

    @Override
    protected List<TptElement> readElements(ModelElement configurationElement) {
        List<TptElement> elementList = TptManager.readEnumerations(configurationElement);
        if (elementList.isEmpty()) {
            TptElement ele = new TptElement("timecode");
            elementList = new ArrayList<TptElement>();
            elementList.add(ele);
        }
        return elementList;
    }

    @Override
    protected void inputChanged(List<TptElement> newElement) {
        this.fManagedForm.setInput(newElement);
    }

    @Override
    protected void commit(List<TptElement> elements, IMemento memento) {
        if (this.fTimetrackingConfiguration != null) {
            this.fTimetrackingConfiguration.writeTo(memento);
        }
        if (!elements.isEmpty()) {
            TptManager.writeEnumerations(memento, elements);
        }
    }

    @Override
    public void doDispose() {
        if (this.fContainer != null && !this.fContainer.isDisposed()) {
            this.fContainer.dispose();
            this.fContainer = null;
        }
    }
}

