/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tpt.ide.ui.internal.aspecteditor;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.TptElement;
import java.util.ArrayList;
import java.util.List;

public class TptManager {
    private static final String ENUMERATION = "configuration";
    public static final String ATTRIBUTE_NAME = "name";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String DEFAULT = "default";
    public static final String TIMECODE = "timecode";
    private static final String TIMECODES = "timecodes";
    public static final String CURRENCY = "currency";
    private static final String CURRENCIES = "currencies";

    public static List<TptElement> readEnumerations(ModelElement configurationElement) {
        ArrayList<TptElement> enumerations = new ArrayList<TptElement>();
        if (configurationElement != null) {
            for (ModelElement element : configurationElement.getChildElements()) {
                if (!ENUMERATION.equals(element.getName())) continue;
                enumerations.add(TptManager.readEnumeration(element));
            }
        }
        return enumerations;
    }

    private static TptElement readEnumeration(ModelElement element) {
        String attributeTypeId = element.getAttribute(ID);
        TptElement enumeration = new TptElement(attributeTypeId);
        for (ModelElement pres : element.getChildElements()) {
            for (ModelElement prop : pres.getChildElements()) {
                String id = prop.getAttribute(ID);
                String name = prop.getAttribute("name");
                String def = prop.getAttribute(DEFAULT);
                boolean d = false;
                if (def != null) {
                    d = Boolean.valueOf(def);
                }
                new TptElement.TptFinancialLiteral(enumeration, id, name, d);
            }
        }
        return enumeration;
    }

    public static void writeEnumerations(IMemento memento, List<TptElement> enumerations) {
        for (TptElement e : enumerations) {
            IMemento configPoint = memento.createChild(ENUMERATION);
            configPoint.putString(ID, e.getAttributeTypeId());
            if (e.getAttributeTypeId().equals(CURRENCY)) {
                TptManager.writeCurrencyInfo(configPoint.createChild(CURRENCIES), e);
            }
            if (!e.getAttributeTypeId().equals(TIMECODE)) continue;
            TptManager.writeTimecodeInfo(configPoint.createChild(TIMECODES), e);
        }
    }

    private static void writeCurrencyInfo(IMemento memento, TptElement enumeration) {
        for (TptElement.TptFinancialLiteral literal : enumeration.getLiterals()) {
            IMemento lit = memento.createChild(CURRENCY);
            lit.putString(ID, literal.getId());
            lit.putString("name", literal.getName());
            if (!literal.isDefault()) continue;
            lit.putString(DEFAULT, Boolean.toString(literal.isDefault()));
        }
    }

    private static void writeTimecodeInfo(IMemento memento, TptElement enumeration) {
        for (TptElement.TptFinancialLiteral literal : enumeration.getLiterals()) {
            IMemento lit = memento.createChild(TIMECODE);
            lit.putString(ID, literal.getId());
            lit.putString("name", literal.getName());
        }
    }
}

