/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tpt.ide.ui.internal.aspecteditor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TptElement {
    static final String LITERAL_PREFIX = ".literal.l";
    private final String fAttributeTypeId;
    private final List<TptFinancialLiteral> fLiterals = new ArrayList<TptFinancialLiteral>();
    private final List<ComboChangeListener> fListeners = new ArrayList<ComboChangeListener>();
    private Object fIdLock = new Object();
    private int fMaxId = 0;

    public TptElement(String attributeTypeId) {
        this.fAttributeTypeId = attributeTypeId;
    }

    public String getIdentifier() {
        return this.getAttributeTypeId();
    }

    public String getAttributeTypeId() {
        return this.fAttributeTypeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLiteral(TptFinancialLiteral literal) {
        int id = TptElement.getIdNumberSuffix(literal.getId());
        Object object = this.fIdLock;
        synchronized (object) {
            if (id > this.fMaxId) {
                this.fMaxId = id;
            }
        }
        this.fLiterals.add(literal);
        this.notifyListeners(literal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLiteral(TptFinancialLiteral literal, TptFinancialLiteral beforeIt) {
        int id = TptElement.getIdNumberSuffix(literal.getId());
        Object object = this.fIdLock;
        synchronized (object) {
            if (id > this.fMaxId) {
                this.fMaxId = id;
            }
        }
        if (beforeIt != null && this.fLiterals.indexOf(beforeIt) > -1) {
            this.fLiterals.add(this.fLiterals.indexOf(beforeIt) + 1, literal);
        } else {
            this.fLiterals.add(literal);
        }
        this.notifyListeners(literal);
    }

    public String getObjectsId(Object object) {
        if (object instanceof TptFinancialLiteral) {
            return ((TptFinancialLiteral)object).getId();
        }
        return null;
    }

    public List<Object> getCurrentObjects() {
        return Collections.unmodifiableList(this.fLiterals);
    }

    public int indexOf(Object object) {
        if (object instanceof TptFinancialLiteral) {
            return this.fLiterals.indexOf((TptFinancialLiteral)object);
        }
        return -1;
    }

    public void removeLiteral(TptFinancialLiteral literal) {
        this.fLiterals.remove(literal);
        this.notifyListeners(literal);
    }

    public List<TptFinancialLiteral> getLiterals() {
        return this.fLiterals;
    }

    public TptFinancialLiteral getLiteral(String id) {
        for (TptFinancialLiteral literal : this.fLiterals) {
            if (!literal.getId().equals(id)) continue;
            return literal;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateLiteralId() {
        int id;
        Object object = this.fIdLock;
        synchronized (object) {
            ++this.fMaxId;
            id = this.fMaxId;
        }
        return String.valueOf(this.getAttributeTypeId()) + LITERAL_PREFIX + id;
    }

    public void notifyListeners(Object changed) {
        ComboChangeEvent event = new ComboChangeEvent(changed);
        for (ComboChangeListener listener : this.fListeners) {
            listener.enumerationChanged(event);
        }
    }

    public void addListener(ComboChangeListener listener) {
        this.fListeners.add(listener);
    }

    public void removeListener(ComboChangeListener listener) {
        this.fListeners.remove(listener);
    }

    public static int getIdNumberSuffix(String id) {
        int dot = id.lastIndexOf(".");
        if (id.length() < dot + 2) {
            return -1;
        }
        String number = id.substring(dot + 2);
        try {
            int i = Integer.valueOf(number);
            return i;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static class ComboChangeEvent {
        private Object fChanged;

        public ComboChangeEvent(Object changed) {
            this.fChanged = changed;
        }

        public Object getChanged() {
            return this.fChanged;
        }
    }

    public static interface ComboChangeListener {
        public void enumerationChanged(ComboChangeEvent var1);
    }

    public static class TptFinancialLiteral {
        private String fId;
        private String fName;
        private boolean isDefault;
        private TptElement fElement;

        public TptFinancialLiteral(TptElement enumeration, String id, String name, boolean isDefault) {
            this(enumeration, id, name, isDefault, null);
        }

        public TptFinancialLiteral(TptElement enumeration, String id, String name, boolean isDefault, TptFinancialLiteral beforeIt) {
            this.fElement = enumeration;
            this.fId = id;
            this.fName = name;
            this.isDefault = isDefault;
            if (beforeIt != null) {
                this.fElement.addLiteral(this, beforeIt);
            } else {
                this.fElement.addLiteral(this);
            }
        }

        public String getId() {
            return this.fId;
        }

        public void setId(String id) {
            this.fId = id;
        }

        public String getName() {
            return this.fName;
        }

        public void setName(String name) {
            this.fName = name;
            this.fElement.notifyListeners(this);
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public void setDefault(boolean isDefault) {
            this.isDefault = isDefault;
            this.fElement.notifyListeners(null);
        }
    }
}

