/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tpt.ide.ui.internal.aspecteditor;

import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.FinancialAspectEditor;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.IAspectEditor;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.IDirtyStateTracker;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.Messages;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.TptElement;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ProcessAttachmentIconSelectionDialog;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TptAspectPart
extends TeamFormPart {
    private final ExecutorService fExecutor = Executors.newSingleThreadExecutor();
    private TptElement fElement;
    private TableViewer fTableViewer;
    private EnumerationCombo fDefaultCombo;
    private Button fAddElement;
    private IAspectEditor fPrefixProvider;
    private IDirtyStateTracker fTracker;
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private static final String NAME_LABEL = Messages.TptAspectPart_NAME_LABEL;
    private static final String NONE = Messages.TptAspectPart_NONE;
    private List<TeamFormPart> fTeamFormPartsInSameAspectEditor;
    private TptElement.ComboChangeListener fListener = new TptElement.ComboChangeListener(){

        @Override
        public void enumerationChanged(final TptElement.ComboChangeEvent e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TptAspectPart.this.fTableViewer.refresh();
                    if (e.getChanged() instanceof TptElement.TptFinancialLiteral) {
                        TptAspectPart.this.fTableViewer.setSelection((ISelection)new StructuredSelection(e.getChanged()));
                        TptAspectPart.this.fTableViewer.getTable().setFocus();
                        if (TptAspectPart.this.fDefaultCombo != null) {
                            TptAspectPart.this.fDefaultCombo.updateValueSet();
                            TptAspectPart.this.fDefaultCombo.updateErrorDecoration();
                        }
                    }
                }
            });
        }
    };

    public TptAspectPart(IAspectEditor prefixProvider, IDirtyStateTracker tracker) {
        this.fPrefixProvider = prefixProvider;
        this.fTracker = tracker;
    }

    private void setDirty() {
        this.fTracker.setDirty();
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    public void createContent(Composite parent) {
        FormToolkit toolkit = this.getSite().getToolkit();
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.createDefaultComboIfCurrencyAspectEditor(parent, toolkit, layout);
        Composite viewer = toolkit.createComposite(parent, 0);
        viewer.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonBar = toolkit.createComposite(parent, 0);
        GridData data = new GridData(16384, 1, false, false);
        buttonBar.setLayoutData((Object)data);
        this.createViewer(viewer, buttonBar);
    }

    private void createDefaultComboIfCurrencyAspectEditor(Composite parent, FormToolkit toolkit, GridLayout layout) {
        if (this.fTracker instanceof FinancialAspectEditor) {
            Composite defaultLit = toolkit.createComposite(parent, 0);
            defaultLit.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.verticalSpacing = 0;
            defaultLit.setLayout((Layout)layout);
            Label l = toolkit.createLabel(defaultLit, Messages.TptAspectPart_DEFAULT_LITERAL);
            l.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.fDefaultCombo = new EnumerationCombo(this, defaultLit, false){

                @Override
                protected boolean isDefault(TptElement.TptFinancialLiteral literal) {
                    return literal.isDefault();
                }

                @Override
                protected void setDefault(TptElement.TptFinancialLiteral literal, boolean value) {
                    literal.setDefault(value);
                }
            };
            toolkit.adapt((Composite)this.fDefaultCombo.getDecoratedCombo().getCombo());
        }
    }

    private void createViewer(Composite viewer, Composite buttonBar) {
        FormToolkit toolkit = this.getSite().getToolkit();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        viewer.setLayout((Layout)layout);
        Table t = new Table(viewer, 67586);
        t.setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = t.getItemHeight() * 6;
        data.heightHint = t.getItemHeight() * 16;
        t.setLayoutData((Object)data);
        TableColumn c = new TableColumn(t, 0);
        c.setWidth(180);
        c.setResizable(true);
        c.setText(NAME_LABEL);
        t.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = Messages.TptAspectPart_LITERALS_TABLE;
                }
            }
        });
        this.fTableViewer = new TableViewer(t);
        this.fTableViewer.setColumnProperties(new String[]{NAME_LABEL});
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof TptElement.TptFinancialLiteral) {
                    TptElement.TptFinancialLiteral lit = (TptElement.TptFinancialLiteral)element;
                    return lit.getName();
                }
                return null;
            }
        });
        this.fTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof TptElement) {
                    return ((TptElement)inputElement).getLiterals().toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        layout = new GridLayout();
        layout.marginTop = this.fTableViewer.getTable().getHeaderHeight();
        buttonBar.setLayout((Layout)layout);
        this.fAddElement = this.createButton(buttonBar, Messages.TptAspectPart_ADD, toolkit, true);
        this.fAddElement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TptAspectPart.this.addElement();
            }
        });
        final Button editEnumeration = this.createButton(buttonBar, Messages.TptAspectPart_EDIT, toolkit, false);
        editEnumeration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TptAspectPart.this.editElement();
            }
        });
        final Button removeEnumeration = this.createButton(buttonBar, Messages.TptAspectPart_REMOVE, toolkit, false);
        removeEnumeration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TptAspectPart.this.removeElement();
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeEnumeration.setEnabled(!TptAspectPart.this.fTableViewer.getSelection().isEmpty());
                editEnumeration.setEnabled(((IStructuredSelection)TptAspectPart.this.fTableViewer.getSelection()).size() == 1);
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (((IStructuredSelection)TptAspectPart.this.fTableViewer.getSelection()).size() == 1) {
                    TptAspectPart.this.editElement();
                }
            }
        });
        this.updateEnablement();
        this.createContextMenu();
        Utils.updateColumnWidths((Table)this.fTableViewer.getTable(), (int[])new int[]{1});
    }

    private void editElement() {
        String name;
        TptElement.TptFinancialLiteral selected = (TptElement.TptFinancialLiteral)((IStructuredSelection)this.fTableViewer.getSelection()).getFirstElement();
        AddEditLiteralDialog d = new AddEditLiteralDialog(Display.getCurrent().getActiveShell(), Messages.TptAspectPart_EDIT_LITERAL, selected.getName(), this.fPrefixProvider, this.fResourceManager);
        if (d.open() == 0 && !(name = d.getName()).equals(selected.getName())) {
            selected.setName(name);
            this.setDirty();
        }
    }

    public List<String> getIconUsage(String iconPath) {
        return null;
    }

    private void addLiteralToList(String name, String preferredId) {
        String bestId;
        String string = bestId = preferredId == null ? this.fElement.generateLiteralId() : preferredId;
        if (!this.fTableViewer.getSelection().isEmpty()) {
            new TptElement.TptFinancialLiteral(this.fElement, bestId, name, false, (TptElement.TptFinancialLiteral)((IStructuredSelection)this.fTableViewer.getSelection()).getFirstElement());
        } else {
            new TptElement.TptFinancialLiteral(this.fElement, bestId, name, false);
        }
        if (this.fDefaultCombo != null) {
            this.fDefaultCombo.updateValueSet();
        }
        this.setDirty();
    }

    private void addElement() {
        final Future<String> futureUnusedId = this.fExecutor.submit(new GetUniqueLiteralID());
        AddEditLiteralDialog d = new AddEditLiteralDialog(Display.getCurrent().getActiveShell(), Messages.TptAspectPart_ADD_LITERAL, null, this.fPrefixProvider, this.fResourceManager);
        int openResult = d.open();
        if (openResult == 1) {
            futureUnusedId.cancel(true);
        } else if (openResult == 0) {
            final String name = d.getName();
            if (name == null || name.trim().equals("")) {
                return;
            }
            try {
                String literalId = futureUnusedId.get(100L, TimeUnit.MILLISECONDS);
                this.addLiteralToList(name, literalId);
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (ExecutionException e) {
                this.addLiteralToList(name, null);
            }
            catch (TimeoutException e) {
                UIUpdaterJob job = new UIUpdaterJob(Messages.TptAspectPart_ADDING_LITERAL){
                    private volatile String fUnusedLiteralId;

                    /*
                     * Loose catch block
                     */
                    public IStatus runInBackground(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.TptAspectPart_CHECKING_CONFLICTING_LITERALS, 1);
                        try {
                            try {
                                this.fUnusedLiteralId = (String)futureUnusedId.get(120000L, TimeUnit.MILLISECONDS);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                IStatus iStatus = Status.CANCEL_STATUS;
                                monitor.done();
                                return iStatus;
                            }
                            catch (Exception e) {
                                IStatus iStatus = Status.OK_STATUS;
                                monitor.done();
                                return iStatus;
                            }
                            monitor.worked(1);
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }

                    public IStatus runInUI(IProgressMonitor monitor) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        TptAspectPart.this.addLiteralToList(name, this.fUnusedLiteralId);
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
            }
        }
    }

    private void removeElement() {
        if (this.fTableViewer.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)this.fTableViewer.getSelection();
            ArrayList<TptElement.TptFinancialLiteral> selectedLiterals = new ArrayList<TptElement.TptFinancialLiteral>();
            for (Object o : sel.toList()) {
                if (!(o instanceof TptElement.TptFinancialLiteral)) continue;
                selectedLiterals.add((TptElement.TptFinancialLiteral)o);
            }
            if (selectedLiterals.isEmpty()) {
                return;
            }
            Shell shell = Display.getCurrent().getActiveShell();
            boolean remove = false;
            MessageDialog md = new MessageDialog(shell, Messages.TptAspectPart_REMOVE_LITERAL, null, Messages.TptAspectPart_REMOVE_LITERAL_MESSAGE, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            switch (md.open()) {
                case 0: {
                    remove = true;
                    break;
                }
            }
            if (remove) {
                for (TptElement.TptFinancialLiteral literal : selectedLiterals) {
                    if (this.fDefaultCombo != null) {
                        this.fDefaultCombo.handleRemoved(literal);
                    }
                    this.fElement.removeLiteral(literal);
                }
                this.setDirty();
            }
        }
    }

    private Button createButton(Composite buttonBar, String Label2, FormToolkit toolkit, boolean enabled) {
        Button button = toolkit.createButton(buttonBar, Label2, 0x800000);
        GridData buttonGridData = new GridData(4, 0x1000000, false, false);
        buttonGridData.minimumWidth = 50;
        button.setLayoutData((Object)buttonGridData);
        button.setEnabled(enabled);
        return button;
    }

    private void createContextMenu() {
        final MenuManager contextMenuMgr = new MenuManager("#PopupMenu");
        contextMenuMgr.setRemoveAllWhenShown(true);
        contextMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)TptAspectPart.this.fTableViewer.getSelection();
                Action add = new Action(Messages.TptAspectPart_ADD){

                    public void run() {
                        TptAspectPart.this.addElement();
                    }
                };
                contextMenuMgr.add((IAction)add);
                if (selection.size() == 1) {
                    Action edit = new Action(Messages.TptAspectPart_EDIT){

                        public void run() {
                            TptAspectPart.this.editElement();
                        }
                    };
                    contextMenuMgr.add((IAction)edit);
                }
                if (!selection.isEmpty()) {
                    Action remove = new Action(Messages.TptAspectPart_REMOVE){

                        public void run() {
                            TptAspectPart.this.removeElement();
                        }
                    };
                    contextMenuMgr.add((IAction)remove);
                }
            }
        });
        this.fTableViewer.getTable().setMenu(contextMenuMgr.createContextMenu(this.fTableViewer.getControl()));
    }

    private void updateEnablement() {
        if (this.fAddElement != null && !this.fAddElement.isDisposed()) {
            this.fAddElement.setEnabled(this.fElement != null);
            this.fTableViewer.getControl().setEnabled(this.fElement != null);
        }
    }

    public void setInput(Object input) {
        if (this.fElement != null) {
            this.fElement.removeListener(this.fListener);
        }
        if (input instanceof List && ((List)input).size() > 0) {
            List a = (List)input;
            this.fElement = (TptElement)a.get(0);
            this.fTableViewer.setInput((Object)((TptElement)a.get(0)));
            this.fElement.addListener(this.fListener);
        } else {
            this.fElement = null;
            this.fTableViewer.setInput(null);
        }
        if (this.fDefaultCombo != null) {
            this.fDefaultCombo.updateCombo();
        }
        this.updateEnablement();
    }

    public void dispose() {
        if (this.fElement != null) {
            this.fElement.removeListener(this.fListener);
        }
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        this.fExecutor.shutdown();
        super.dispose();
    }

    public void setTeamFormPartsInSameAspectEditor(List<TeamFormPart> fAssociatedTeamFormParts) {
        this.fTeamFormPartsInSameAspectEditor = fAssociatedTeamFormParts;
    }

    private static class AddEditLiteralDialog
    extends ProcessAttachmentIconSelectionDialog {
        private Text fNameField;
        private String fName;

        protected AddEditLiteralDialog(Shell parentShell, String title, String name, IAspectEditor prefixProvider, ResourceManager resourceManager) {
            super(parentShell, title, null, null, resourceManager);
            this.fName = name;
            this.setValidator(new ProcessAttachmentIconSelectionDialog.IDialogValidator(){

                public IStatus isValid() {
                    String n;
                    if ((fName == null || "".equals(fName.trim())) && fNameField != null && !fNameField.isDisposed() && (n = fNameField.getText()).trim().equals("")) {
                        return new Status(4, "com.ibm.team.tpt.ide.ui", Messages.TptAspectPart_EMPTY_NAME);
                    }
                    return Status.OK_STATUS;
                }
            });
        }

        protected void okPressed() {
            this.fName = this.fNameField.getText();
            super.okPressed();
        }

        protected void iconChanged() {
            this.validate();
        }

        public String getName() {
            return this.fName.trim();
        }

        protected void createUpperDialogPart(Composite parent) {
            Label l = new Label(parent, 0);
            l.setText(Messages.TptAspectPart_NAME);
            l.setLayoutData((Object)new GridData());
            this.fNameField = new Text(parent, 2048);
            if (this.fName != null) {
                this.fNameField.setText(this.fName);
            }
            this.fNameField.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    this.validate();
                }
            });
        }

        protected void createIconDialogPart(Composite parent) {
        }
    }

    private abstract class EnumerationCombo {
        private final DecoratedCombo fCombo;
        private final boolean fIsNoneAllowed;

        public EnumerationCombo(Composite parent, boolean isNoneAllowed) {
            this.fIsNoneAllowed = isNoneAllowed;
            this.fCombo = new DecoratedCombo(parent, 8, 1);
            this.fCombo.getLayoutControl().setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.fCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    EnumerationCombo.this.handleComboChanged();
                }
            });
            this.fCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (NONE.equals(element)) {
                        return NONE;
                    }
                    if (element instanceof TptElement.TptFinancialLiteral) {
                        return ((TptElement.TptFinancialLiteral)element).getName();
                    }
                    return null;
                }

                public Image getImage(Object element) {
                    return null;
                }

                private void updateElement(Object element) {
                    if (EnumerationCombo.this.fCombo != null && !EnumerationCombo.this.fCombo.getCombo().isDisposed()) {
                        EnumerationCombo.this.fCombo.setValue(EnumerationCombo.this.fCombo.getValue());
                    }
                }
            });
        }

        public DecoratedCombo getDecoratedCombo() {
            return this.fCombo;
        }

        public void handleRemoved(TptElement.TptFinancialLiteral literal) {
            if (this.isDefault(literal)) {
                this.fCombo.setValue((Object)NONE);
            }
        }

        public void updateCombo() {
            TptElement.TptFinancialLiteral defaultLiteral = this.updateValueSet();
            if (defaultLiteral != null) {
                this.fCombo.setValue((Object)defaultLiteral);
            } else {
                this.fCombo.setValue((Object)NONE);
            }
            this.fCombo.getLayoutControl().getParent().layout(new Control[]{this.fCombo.getCombo()});
            if (TptAspectPart.this.fElement != null && TptAspectPart.this.fElement.getAttributeTypeId().equals("currency")) {
                this.updateErrorDecoration();
            }
        }

        public void updateErrorDecoration() {
            if (TptAspectPart.this.fElement == null) {
                return;
            }
            if (!this.fIsNoneAllowed && NONE.equals(this.fCombo.getValue()) && TptAspectPart.this.fElement.getLiterals().size() > 0) {
                this.fCombo.setStatus((IStatus)new Status(4, "com.ibm.team.tpt.ide.ui", Messages.TptAspectPart_NO_DEFAULT_LITERAL));
            } else {
                this.fCombo.setStatus(Status.OK_STATUS);
            }
        }

        private void handleComboChanged() {
            if (TptAspectPart.this.fElement == null) {
                return;
            }
            Object selected = this.fCombo.getValue();
            boolean dirty = false;
            for (TptElement.TptFinancialLiteral lit : TptAspectPart.this.fElement.getLiterals()) {
                if (lit.equals(selected)) {
                    if (this.isDefault(lit)) continue;
                    this.setDefault(lit, true);
                    dirty = true;
                    continue;
                }
                if (!this.isDefault(lit)) continue;
                this.setDefault(lit, false);
                dirty = true;
            }
            if (dirty) {
                TptAspectPart.this.setDirty();
                this.updateErrorDecoration();
            }
        }

        private TptElement.TptFinancialLiteral updateValueSet() {
            Object[] valueSet;
            TptElement.TptFinancialLiteral defaultLiteral = null;
            if (TptAspectPart.this.fElement != null) {
                List<TptElement.TptFinancialLiteral> literals = TptAspectPart.this.fElement.getLiterals();
                valueSet = new Object[literals.size() + 1];
                valueSet[0] = NONE;
                int i = 0;
                while (i < literals.size()) {
                    TptElement.TptFinancialLiteral literal = literals.get(i);
                    if (this.isDefault(literal)) {
                        defaultLiteral = literal;
                    }
                    valueSet[i + 1] = literal;
                    ++i;
                }
            } else {
                valueSet = new Object[]{NONE};
            }
            this.fCombo.setValueSet(valueSet);
            return defaultLiteral;
        }

        protected abstract void setDefault(TptElement.TptFinancialLiteral var1, boolean var2);

        protected abstract boolean isDefault(TptElement.TptFinancialLiteral var1);
    }

    private class GetUniqueLiteralID
    implements Callable<String> {
        private GetUniqueLiteralID() {
        }

        @Override
        public String call() throws Exception {
            return TptAspectPart.this.fElement.generateLiteralId();
        }
    }
}

