/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tpt.ide.ui.internal.aspecteditor;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.AbstractTptAspectEditor;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.IAspectEditor;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.Messages;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.TptAspectPart;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.TptElement;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.TptManager;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.ui.editor.TeamFormSectionPart;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class FinancialAspectEditor
extends AbstractTptAspectEditor
implements IAspectEditor {
    public static final String ASPECT_ID = "com.ibm.team.tpt.configuration";
    private TptAspectPart fEnumeration;
    private ManagedForm fManagedForm;

    public FinancialAspectEditor(String dataId) {
        super(dataId);
        this.setHelpContextId("com.ibm.team.workitem.ide.ui.aspect_financial");
    }

    @Override
    protected void commit(List<TptElement> elements, IMemento memento) {
        if (!elements.isEmpty()) {
            TptManager.writeEnumerations(memento, elements);
        }
    }

    @Override
    protected void createEditorArea(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.fManagedForm = new ManagedForm(toolkit, toolkit.createScrolledForm(parent));
        ScrolledForm form = this.fManagedForm.getForm();
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 200).applyTo((Control)form);
        Composite body = form.getBody();
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        body.setLayout((Layout)layout);
        this.fEnumeration = new TptAspectPart(this, this);
        TeamFormSectionPart enumerationSection = new TeamFormSectionPart((IManagedForm)this.fManagedForm, 256, Messages.TptAspectEditor_CURRENCY, new TeamFormPart[]{this.fEnumeration});
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        enumerationSection.getSection().setLayoutData((Object)formData);
        this.fManagedForm.addPart((IFormPart)enumerationSection);
    }

    @Override
    protected void doDispose() {
        if (this.fManagedForm != null) {
            this.fManagedForm.dispose();
            this.fManagedForm = null;
        }
    }

    @Override
    protected void inputChanged(List<TptElement> elements) {
        this.fManagedForm.setInput(elements);
    }

    @Override
    protected List<TptElement> readElements(ModelElement configurationElement) {
        List<TptElement> elementList = TptManager.readEnumerations(configurationElement);
        if (elementList.isEmpty()) {
            TptElement ele = new TptElement("currency");
            elementList = new ArrayList<TptElement>();
            elementList.add(ele);
        }
        return elementList;
    }
}

