/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tpt.ide.ui.internal.aspecteditor;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.client.workingcopies.IProcessContainerWorkingCopy;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.AbstractConfigurationDataAspectEditor;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.tpt.ide.ui.internal.TPTHelpContextIds;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.IDirtyStateTracker;
import com.ibm.team.tpt.ide.ui.internal.aspecteditor.TptElement;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractTptAspectEditor
extends AbstractConfigurationDataAspectEditor
implements IDirtyStateTracker {
    private List<TptElement> fElements;
    private Composite fContainer;
    private String fConfigurationDataId;
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private String fHelpContextId = null;

    public AbstractTptAspectEditor(String dataId) {
        this.fConfigurationDataId = dataId;
    }

    public final void dispose() {
        this.doDispose();
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.init();
    }

    private void init() {
        this.fElements = this.readElements(this.getAspect().getConfigurationElement());
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.fContainer = new Composite(parent, 0);
        parent.setLayout((Layout)new GridLayout(1, false));
        this.fContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.fContainer.setLayout((Layout)layout);
        Composite editorContent = toolkit.createComposite(this.fContainer);
        editorContent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createEditorArea(editorContent, toolkit);
        this.inputChanged(this.fElements);
        if (this.fHelpContextId != null) {
            TPTHelpContextIds.hookHelpListener((Control)parent, this.fHelpContextId);
        }
    }

    public void revert() {
        this.init();
        this.setDirty(false);
    }

    public IProcessContainerWorkingCopy getProcessContainerWorkingCopy() {
        return this.getAspect().getProcessContainerWorkingCopy();
    }

    protected ResourceManager getResourceManager() {
        return this.fResourceManager;
    }

    @Override
    public void setDirty() {
        super.setDirty();
    }

    protected void setHelpContextId(String helpContextId) {
        this.fHelpContextId = helpContextId;
    }

    protected abstract List<TptElement> readElements(ModelElement var1);

    protected abstract void inputChanged(List<TptElement> var1);

    protected abstract void doDispose();

    protected abstract void createEditorArea(Composite var1, FormToolkit var2);

    protected abstract void commit(List<TptElement> var1, IMemento var2);

    public final boolean saveState(IMemento memento) {
        memento.putString("id", this.fConfigurationDataId);
        String namespace = this.getAspect().getSchemaNamespaceURI();
        if (namespace != null) {
            memento.putString("xmlns", namespace);
        }
        this.commit(this.fElements, memento);
        return true;
    }

    public boolean needsApplyAndRevertButtons() {
        return false;
    }
}

