<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:msp="http://schemas.microsoft.com/project"
xmlns:cpf="http://schema.ibm.com/epm/resources/1.0/Project">

<xsl:param name="Name"/>
<xsl:param name="MappedMSPSummaryTask"/>
<xsl:param name="MappedMSPTask"/>
<xsl:param name="MSPCreateNewTasksOnly"/>
<xsl:param name="MSPResolveCompletedTasks"/>
<xsl:param name="MSPSummaryTaskMappedDoneStateId"/>
<xsl:param name="MSPTaskMappedDoneStateId"/>
<xsl:variable name="empty_string"/>
<xsl:param name="INTERNAL"/>

<xsl:template match="msp:Project">
  <msp>
  	<cpf:project>
  		<xsl:choose>
			<xsl:when test="msp:UID and msp:UID != $empty_string">
				<ID><xsl:value-of select="msp:UID"/></ID>
			</xsl:when>
			<xsl:otherwise>
				<ID>0</ID>
			</xsl:otherwise>
		</xsl:choose>
		<ProjectName><xsl:value-of select="msp:Name"/></ProjectName>
		<summary><xsl:value-of select="$Name"/></summary>
		<xsl:if test="msp:Manager and msp:Manager != $empty_string">
			<owner><xsl:value-of select="msp:Manager"/></owner>
		</xsl:if>
		<xsl:if test="msp:Description">
			<comments><xsl:value-of select="msp:Description"/></comments>
		</xsl:if>		
  	</cpf:project>
	<cpf:plan>
		<ID>0</ID>
		<summary><xsl:value-of select="$Name"/></summary>
		<xsl:call-template name="PlannedSchedule"/>
  	</cpf:plan>
  	<xsl:apply-templates select="msp:Tasks"/>
  	<xsl:apply-templates select="msp:Assignments"/>
	<xsl:apply-templates select="msp:Resources"/>
  </msp>
</xsl:template>

<xsl:template match="msp:Tasks">
	<xsl:for-each select="msp:Task">
		<xsl:if test="msp:UID='0'">
			<xsl:for-each select="msp:ExtendedAttribute">
		 		<xsl:if test="msp:FieldID='188743740' and msp:Value != $empty_string">
					<PlanIDinXML><xsl:value-of select="msp:Value"/></PlanIDinXML>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
	
		<xsl:if test="msp:OutlineNumber and msp:UID != 0">
			<cpf:workitem>
				<xsl:if test="contains(msp:OutlineNumber, '.')">
					<Parent>
						<xsl:call-template name="FindParent">
					    	<xsl:with-param name="theString" select="msp:OutlineNumber"/>
					    </xsl:call-template>
					</Parent>			
				</xsl:if>
				<ID><xsl:value-of select="msp:UID"/></ID>
				<summary>				
					<xsl:choose>
						<xsl:when test="msp:Name"><xsl:value-of select="msp:Name"/></xsl:when>
						<xsl:otherwise>...</xsl:otherwise>
					</xsl:choose>
				</summary>
				<PercentComplete><xsl:value-of select="msp:PercentComplete"/></PercentComplete>
				<state>New</state>
				<xsl:choose>
					<xsl:when test="msp:Summary=1 or count(../../msp:Assignments/msp:Assignment[msp:TaskUID = current()/msp:UID])>1">
						<workItemType><xsl:value-of select="$MappedMSPSummaryTask"/></workItemType>
						<createNewTasksOnly><xsl:value-of select="$MSPCreateNewTasksOnly"/></createNewTasksOnly>
						<resolveCompletedTasks><xsl:value-of select="$MSPResolveCompletedTasks"/></resolveCompletedTasks>										
						<doneState><xsl:value-of select="$MSPSummaryTaskMappedDoneStateId"/></doneState>				
					</xsl:when>
					<xsl:otherwise>
						<workItemType><xsl:value-of select="$MappedMSPTask"/></workItemType>
						<createNewTasksOnly><xsl:value-of select="$MSPCreateNewTasksOnly"/></createNewTasksOnly>
						<resolveCompletedTasks><xsl:value-of select="$MSPResolveCompletedTasks"/></resolveCompletedTasks>
						<doneState><xsl:value-of select="$MSPTaskMappedDoneStateId"/></doneState>
						<setEstimate>TRUE</setEstimate>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:if test="msp:HyperlinkAddress and msp:HyperlinkAddress  != $empty_string">
					<hyperlinkAddress><xsl:value-of select="msp:HyperlinkAddress"/></hyperlinkAddress>
				</xsl:if>
				<xsl:call-template name="PlannedSchedule"/>
				<xsl:call-template name="Constraint">
					<xsl:with-param name="ConstraintType" select="msp:ConstraintType"/>
					<xsl:with-param name="ConstraintDate" select="msp:ConstraintDate"/>
				</xsl:call-template>
				<xsl:if test="msp:Deadline">
					<duedate><xsl:value-of select="concat(substring-before(msp:Deadline, 'T'), ' 00:00:00')"/></duedate>
				</xsl:if>
				<!-- User attribute in task -->
				<xsl:choose>
					<xsl:when test="count(../../msp:Assignments/msp:Assignment[msp:TaskUID = current()/msp:UID])=1">
						<xsl:variable name="ownerID" select="../../msp:Assignments/msp:Assignment[msp:TaskUID = current()/msp:UID]/msp:ResourceUID"/>
						<owner><xsl:value-of select="../../msp:Resources/msp:Resource[msp:UID = $ownerID]/msp:Name"/></owner>
					</xsl:when>
				</xsl:choose>
				<xsl:if test="msp:Notes">
						<comments><xsl:value-of select="msp:Notes"/></comments>
				</xsl:if>
				<xsl:for-each select="msp:ExtendedAttribute">
			 		<xsl:if test="msp:FieldID='188743767'">
						<WorkItemID><xsl:value-of select="msp:Value"/></WorkItemID>
					</xsl:if>
				</xsl:for-each>
			</cpf:workitem>
			<xsl:choose>
				<xsl:when test="count(../../msp:Assignments/msp:Assignment[msp:TaskUID = current()/msp:UID])>1">
					<xsl:if test="msp:Summary=0"> 
						<Message>Multiple assignments found for task <xsl:value-of select="msp:Name"/>. Converting to Summary Task.</Message>
					</xsl:if>
					<xsl:if test="msp:Summary=1"> 
						<Message>Multiple assignments found for Summary Task <xsl:value-of select="msp:Name"/>. Splitting into tasks.</Message>
					</xsl:if>
					<xsl:variable name="constraintType" select="msp:ConstraintType" />
					<xsl:variable name="constraintDate" select="msp:ConstraintDate" />
					<xsl:for-each select="../../msp:Assignments/msp:Assignment[msp:TaskUID = current()/msp:UID]">
						<xsl:variable name="cur" select='position()' />
						<cpf:workitem>
							<Parent><xsl:value-of select="msp:TaskUID"/></Parent>
							<ID><xsl:value-of select="concat(concat(msp:TaskUID, '.'), msp:UID)"/></ID>
							<summary>				
							<xsl:choose>
								<xsl:when test="../../msp:Tasks/msp:Task[msp:UID = current()/msp:TaskUID]/msp:Name">
									<xsl:value-of select="concat(concat(../../msp:Tasks/msp:Task[msp:UID = current()/msp:TaskUID]/msp:Name, '_'), $cur)"/>
								</xsl:when>
								<xsl:otherwise><xsl:value-of select="concat(concat('...', '_'), $cur)"/></xsl:otherwise>
							</xsl:choose>
							</summary>
							<state>New</state>
							<workItemType><xsl:value-of select="$MappedMSPTask"/></workItemType>
							<createNewTasksOnly><xsl:value-of select="$MSPCreateNewTasksOnly"/></createNewTasksOnly>
							<resolveCompletedTasks><xsl:value-of select="$MSPResolveCompletedTasks"/></resolveCompletedTasks>							
							<doneState><xsl:value-of select="$MSPTaskMappedDoneStateId"/></doneState>						
							<setEstimate>TRUE</setEstimate>
							<xsl:call-template name="PlannedSchedule"/>
							<xsl:call-template name="Constraint">
								<xsl:with-param name="ConstraintType" select="$constraintType"/>
								<xsl:with-param name="ConstraintDate" select="$constraintDate"/>
							</xsl:call-template>
							<xsl:variable name="ownerID" select="msp:ResourceUID"/>
							<owner><xsl:value-of select="../../msp:Resources/msp:Resource[msp:UID = $ownerID]/msp:Name"/></owner>
						</cpf:workitem>							
					</xsl:for-each>					
				</xsl:when>
				<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:for-each>
	<xsl:for-each select="msp:Task">
		<xsl:choose>
			<xsl:when test="count(../../msp:Assignments/msp:Assignment[msp:TaskUID = current()/msp:UID])>1">
				<xsl:for-each select="../../msp:Assignments/msp:Assignment[msp:TaskUID = current()/msp:UID]">
					<xsl:variable name="IDValue" select="concat(concat(msp:TaskUID, '.'), msp:UID)" />
					<xsl:for-each select="../../msp:Tasks/msp:Task[msp:UID = current()/msp:TaskUID]/msp:PredecessorLink">
						<xsl:if test="msp:Type=1 and count(../../../msp:Assignments/msp:Assignment[msp:TaskUID = current()/msp:PredecessorUID]) > 1 and ../../../msp:Tasks/msp:Task[msp:UID = current()/msp:PredecessorUID]/msp:Summary=0">
							<xsl:for-each select="../../../msp:Assignments/msp:Assignment[msp:TaskUID = current()/msp:PredecessorUID]">
								<cpf:updateworkitem>
									<ID><xsl:value-of select="$IDValue"/></ID>
									<xsl:variable name="PredecessorID" select="concat(concat(msp:TaskUID, '.'), msp:UID)" />
									<DependsOn><xsl:value-of select="$PredecessorID"/></DependsOn>								
								</cpf:updateworkitem>
							</xsl:for-each>
						</xsl:if>
						<xsl:if test="msp:Type=1 and count(../../../msp:Assignments/msp:Assignment[msp:TaskUID = current()/msp:PredecessorUID]) &lt;= 1 and ../../../msp:Tasks/msp:Task[msp:UID = current()/msp:PredecessorUID]/msp:Summary=0">
							<cpf:updateworkitem>
								<ID><xsl:value-of select="$IDValue"/></ID>
								<DependsOn><xsl:value-of select="msp:PredecessorUID"/></DependsOn>
							</cpf:updateworkitem>
			        	</xsl:if>
					</xsl:for-each>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
		<xsl:if test="count(../../msp:Assignments/msp:Assignment[msp:TaskUID = current()/msp:UID]) &lt;= 1">
			<xsl:for-each select="msp:PredecessorLink">
				<xsl:if test="msp:Type=1 and count(../../../msp:Assignments/msp:Assignment[msp:TaskUID = current()/msp:PredecessorUID]) &lt;= 1 and ../../../msp:Tasks/msp:Task[msp:UID = current()/msp:PredecessorUID]/msp:Summary=0">
					<cpf:updateworkitem>
						<ID><xsl:value-of select="../msp:UID"/></ID>
						<DependsOn><xsl:value-of select="msp:PredecessorUID"/></DependsOn>
					</cpf:updateworkitem>
	        	</xsl:if>	
				<xsl:if test="msp:Type=1 and count(../../../msp:Assignments/msp:Assignment[msp:TaskUID = current()/msp:PredecessorUID]) > 1 and ../../../msp:Tasks/msp:Task[msp:UID = current()/msp:PredecessorUID]/msp:Summary=0">
					<xsl:variable name="SuccessorID" select="../msp:UID" />
					<xsl:for-each select="../../../msp:Assignments/msp:Assignment[msp:TaskUID = current()/msp:PredecessorUID]">
						<cpf:updateworkitem>
							<ID><xsl:value-of select="$SuccessorID"/></ID>
							<DependsOn><xsl:value-of select="concat(concat(msp:TaskUID, '.'), msp:UID)"/></DependsOn>
						</cpf:updateworkitem>
					</xsl:for-each>
	        	</xsl:if>
			</xsl:for-each>			
        </xsl:if>
	</xsl:for-each>
</xsl:template>

<xsl:template match="msp:Resources">
	<xsl:for-each select="msp:Resource">
		<xsl:if test="../../msp:Assignments/msp:Assignment[msp:ResourceUID = current()/msp:UID]">
			<cpf:projectAssignment>
				<ID><xsl:value-of select="msp:UID"/></ID>
				<AvailableFrom><xsl:value-of select="msp:AvailableFrom"/></AvailableFrom>
				<AvailableTo><xsl:value-of select="msp:AvailableTo"/></AvailableTo>
				<StartDate><xsl:value-of select="msp:Start"/></StartDate>
				<FinishDate><xsl:value-of select="msp:Finish"/></FinishDate>				
			</cpf:projectAssignment>
		</xsl:if>
	</xsl:for-each>
</xsl:template>

<xsl:template match="msp:Start|msp:StartDate|msp:Finish|msp:FinishDate">
    <xsl:call-template name="Date"/>
</xsl:template>

<xsl:template name="Date">
    <xsl:value-of select="concat(substring-before(., 'T'), ' 00:00:00')"/>
</xsl:template>

<xsl:template name="PlannedSchedule">
   	<startDate><xsl:apply-templates select="msp:Start|msp:StartDate"/></startDate>
	<finishDate><xsl:apply-templates select="msp:Finish|msp:FinishDate"/></finishDate>
	<xsl:choose>
	<xsl:when test="msp:Work">
		<xsl:choose>
			<xsl:when test="substring-after(substring-before(msp:Work, 'H'), 'T') = 0 and msp:Duration">
					<effort><xsl:value-of select="substring-after(substring-before(msp:Duration, 'H'), 'T')"/></effort>
			</xsl:when>
			<xsl:otherwise>
				<effort><xsl:value-of select="substring-after(substring-before(msp:Work, 'H'), 'T')"/></effort>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:when>
	<xsl:otherwise>
		<effort><xsl:value-of select="substring-after(substring-before(msp:Duration, 'H'), 'T')"/></effort>		
	</xsl:otherwise>
	</xsl:choose>
	<xsl:choose>
	<xsl:when test="msp:ActualWork">
		<xsl:choose>
			<xsl:when test="substring-after(substring-before(msp:ActualWork, 'H'), 'T') = 0 and msp:ActualDuration">
				<actualEffort><xsl:value-of select="substring-after(substring-before(msp:ActualDuration, 'H'), 'T')"/></actualEffort>
			</xsl:when>
			<xsl:otherwise>
				<actualEffort><xsl:value-of select="substring-after(substring-before(msp:ActualWork, 'H'), 'T')"/></actualEffort>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:when>
	<xsl:otherwise>
		<actualEffort><xsl:value-of select="substring-after(substring-before(msp:ActualDuration, 'H'), 'T')"/></actualEffort>		
	</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="Constraint">
	<xsl:param name="ConstraintType"/>
	<xsl:param name="ConstraintDate"/>
	<constraintType>
			<xsl:choose>
				<xsl:when test="$ConstraintType=0">AsSoonAsPossible</xsl:when>
				<!--xsl:when test="msp:ConstraintType=6">FinishNoEarlierThan</xsl:when-->
				<xsl:when test="$ConstraintType=6">AsSoonAsPossible</xsl:when>
				<!--xsl:when test="msp:ConstraintType=1">AsLateAsPossible</xsl:when-->
				<xsl:when test="$ConstraintType=1">AsSoonAsPossible</xsl:when>
				<!--xsl:when test="msp:ConstraintType=2">MustStartOn</xsl:when-->
				<xsl:when test="$ConstraintType=2">AsSoonAsPossible</xsl:when>
				<!--xsl:when test="msp:ConstraintType=3">MustFinishOn</xsl:when-->
				<xsl:when test="$ConstraintType=3">AsSoonAsPossible</xsl:when>
				<!--xsl:when test="msp:ConstraintType=4">StartNoEarlierThan</xsl:when-->
				<xsl:when test="$ConstraintType=4">StartNoEarlierThan</xsl:when>
				<!--xsl:when test="msp:ConstraintType=5">StartNoLaterThan</xsl:when-->
				<xsl:when test="$ConstraintType=5">AsSoonAsPossible</xsl:when>
				<xsl:when test="$ConstraintType=7">FinishNoLaterThan</xsl:when>
				<xsl:otherwise>AsSoonAsPossible</xsl:otherwise>
			</xsl:choose>
	</constraintType>
	<xsl:choose>
		<xsl:when test="$ConstraintType=4">
			<constraintDate><xsl:value-of select="concat(substring-before($ConstraintDate, 'T'), ' 00:00:00')"/></constraintDate>
		</xsl:when>
		<xsl:when test="$ConstraintType=7">
			<constraintDate><xsl:value-of select="concat(substring-before($ConstraintDate, 'T'), ' 00:00:00')"/></constraintDate>
		</xsl:when>
		<xsl:otherwise></xsl:otherwise>
	</xsl:choose>	
</xsl:template>

<xsl:template name="FindParent">
    <xsl:param name="theString" />
    <xsl:param name="reversedString" />
    <xsl:choose>
       <xsl:when test="$theString">
          <xsl:call-template name="FindParent">
             <xsl:with-param name="theString"
                             select="substring($theString, 2)" />
             <xsl:with-param name="reversedString" select="concat(substring($theString, 1, 1),$reversedString)" />
          </xsl:call-template>
       </xsl:when>
       <xsl:otherwise>
       		<xsl:value-of select="../msp:Task[msp:OutlineNumber=substring(current()/msp:OutlineNumber, 1, string-length(substring-after($reversedString, '.')))]/msp:UID"/>
       </xsl:otherwise>
    </xsl:choose>
</xsl:template>
</xsl:stylesheet>