<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:msp="http://schemas.microsoft.com/project"
xmlns:tara="http://schema.ibm.com/tara/resources/1.0">

<xsl:param name="Project"/>
<xsl:variable name="empty_string"/>

<xsl:template match="msp:Project">
  <Project>
  	<Name><xsl:value-of select="substring-before(msp:Name, '.')"/></Name>
	<Types></Types>	
	<xsl:apply-templates select="msp:Resources"/>
	<FileName></FileName>
	<xsl:apply-templates select="msp:Tasks"/>
  </Project>
</xsl:template>

<xsl:template match="msp:Tasks">
	<Tasks>
	<xsl:for-each select="msp:Task">
		<xsl:if test="msp:UID='0'">
			<xsl:for-each select="msp:ExtendedAttribute">
		 		<xsl:if test="msp:FieldID='188743740' and msp:Value != $empty_string">
					<PlanIDinXML><xsl:value-of select="msp:Value"/></PlanIDinXML>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
	
		<xsl:if test="msp:OutlineNumber and msp:UID != 0">
			<Task>
				<ID><xsl:value-of select="msp:UID"/></ID>
			</Task>
			<xsl:choose>
				<xsl:when test="count(../../msp:Assignments/msp:Assignment[msp:TaskUID = current()/msp:UID])>1">
					<xsl:for-each select="../../msp:Assignments/msp:Assignment[msp:TaskUID = current()/msp:UID]">
						<Task>
							<ID><xsl:value-of select="concat(concat(msp:TaskUID, '.'), msp:UID)"/></ID>
						</Task>							
					</xsl:for-each>					
				</xsl:when>
			</xsl:choose>
		</xsl:if>
	</xsl:for-each>
	</Tasks>
</xsl:template>	

<xsl:template match="msp:Resources">
	<Resources>
	<xsl:for-each select="msp:Resource">
		<xsl:choose>
			<xsl:when test="msp:UID>0">
				<Resource>
					<UID><xsl:value-of select="msp:UID"/></UID>
					<Name><xsl:value-of select="msp:Name"/></Name>
				</Resource>					
			</xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>				
	</xsl:for-each>
	</Resources>
</xsl:template>

<xsl:template match="projects">
  <Flag>
	<xsl:choose>
		<xsl:when test="link[contains(@title, $Project)]">TRUE</xsl:when>
		<xsl:otherwise>FALSE</xsl:otherwise>
	</xsl:choose>
  </Flag>
</xsl:template>

</xsl:stylesheet>