<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:msp="http://schemas.microsoft.com/project">

<xsl:param name="ProjectStart"/>
<xsl:param name="UID"/>
<xsl:param name="WBS"/>
<xsl:param name="TaraID"/>
<xsl:param name="AssUID"/>
<xsl:param name="ResUID"/>
<xsl:variable name="empty_string"/>

<xsl:template match="project">
	<xsl:choose>
		<xsl:when test="$TaraID">
			<xsl:call-template name="WBS"/>
		</xsl:when>
		<xsl:otherwise>
			<Project>
		  	   	<Name><xsl:value-of select="concat(translate(summary, ' ', ''), '.xml')"/></Name>
		  	   	<Manager><xsl:value-of select="owner"/></Manager>
		  	   	<xsl:call-template name="ProjectSchedule"/>
		  	   	<ExtendedAttributes>
		  	   		<!--refer to http://msdn.microsoft.com/en-us/library/bb221982.aspx for fieldId #s -->
					<ExtendedAttribute>
						<FieldID>188743734</FieldID>
						<FieldName>Text2</FieldName>
						<Alias>State</Alias>
					</ExtendedAttribute>
					<ExtendedAttribute>
						<FieldID>188743784</FieldID>
						<FieldName>Duration2</FieldName>
						<Alias>PlannedEffort</Alias>
					</ExtendedAttribute>
					<ExtendedAttribute>
  						<FieldID>188743732</FieldID> 
  						<FieldName>Start1</FieldName> 
						<Alias>ProposedStart</Alias>
  						<SecondaryPID>255869018</SecondaryPID> 
  					</ExtendedAttribute>
 					<ExtendedAttribute>
  						<FieldID>188743733</FieldID> 
  						<FieldName>Finish1</FieldName> 
						<Alias>ProposedFinish</Alias>
  						<SecondaryPID>255868978</SecondaryPID> 
  					</ExtendedAttribute>
 					<ExtendedAttribute>
  						<FieldID>188743783</FieldID> 
  						<FieldName>Duration1</FieldName> 
						<Alias>ProposedDuration</Alias>
  						<SecondaryPID>255868968</SecondaryPID> 
  					</ExtendedAttribute>
 					<ExtendedAttribute>
  						<FieldID>188743767</FieldID> 
  						<FieldName>Number1</FieldName> 
						<Alias>WorkItemId</Alias>
  					</ExtendedAttribute>
  					<ExtendedAttribute>
  						<FieldID>188743740</FieldID> 
  						<FieldName>Text4</FieldName> 
						<Alias>PlanId</Alias>
  					</ExtendedAttribute>
  					<xsl:if test="integrationLink and integrationLink != $empty_string">	
	  					<ExtendedAttribute>
  							<FieldID>188743737</FieldID>
  							<FieldName>Text3</FieldName>
  							<Alias>FPLink</Alias>
  						</ExtendedAttribute>
  					</xsl:if>
				</ExtendedAttributes>
				<!--ExtendedAttributes>
					<ExtendedAttribute>
					<FieldID>188743731</FieldID>
					<FieldName>Text1</FieldName>
					<Alias>Element ID</Alias>
					<SecondaryPID>255868988</SecondaryPID>
					</ExtendedAttribute>
				</ExtendedAttributes-->
		  		<Tasks>
		  			<Task>
						<UID>0</UID>
						<ID>0</ID>
						<Type>0</Type>
						<IsNull>0</IsNull>
						<WBS>0</WBS>
						<OutlineNumber>0</OutlineNumber>
						<OutlineLevel>0</OutlineLevel>
						<Milestone>0</Milestone>
						<Summary>1</Summary>
						<FixedCostAccrual>3</FixedCostAccrual>
						<xsl:call-template name="PercentComplete"/>
						<xsl:call-template name="ActualSchedule"/>
						<HyperlinkAddress><xsl:value-of select="@uiHref"/></HyperlinkAddress>
						<ExtendedAttribute>
							<FieldID>188743734</FieldID>
							<Alias>State</Alias>
							<Value><xsl:value-of select="state"/></Value>
						</ExtendedAttribute>
	  					<ExtendedAttribute>
	  						<FieldID>188743740</FieldID> 
	  						<FieldName>Text4</FieldName> 
							<Alias>PlanId</Alias>
							<Value></Value>
	  					</ExtendedAttribute>
						<xsl:if test="integrationLink and integrationLink != $empty_string">	
							<ExtendedAttribute>
								<FieldID>188743737</FieldID>
								<Value><xsl:value-of select="integrationLink"/></Value>
							</ExtendedAttribute>
						</xsl:if>
						<xsl:call-template name="ExtendedSchedule"/>			
						<!--ExtendedAttribute>
							<FieldID>188743731</FieldID>
							<Value><xsl:value-of select="@relativeHref"/></Value>
						</ExtendedAttribute-->
					</Task>
				</Tasks>
				<Resources>
				</Resources>
				<Assignments>
				</Assignments>
			</Project>	
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="schedule">
	<xsl:choose>
		<xsl:when test="contains(selfuri, 'projects')">
			<xsl:call-template name="ProjectSchedule"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="TaskSchedule"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="ProjectSchedule">
	<StartDate><xsl:value-of select="concat(substring-before(plannedSchedule/startDate, ' '), 'T08:00:00')"/></StartDate>
	<FinishDate><xsl:value-of select="concat(substring-before(plannedSchedule/finishDate, ' '), 'T17:00:00')"/></FinishDate>
</xsl:template>

<xsl:template match="workitem|risk|iteration">
	<xsl:call-template name="WBS"/>
</xsl:template>

<xsl:template name="WBS">
	<Task>
		<UID><xsl:value-of select="$UID"/></UID>
		<ID><xsl:value-of select="$UID"/></ID>
  	   	<Name><xsl:value-of select="summary"/></Name>
  	   	<Type>0</Type>
  	   	<IsNull>0</IsNull>
  	   	<WBS><xsl:value-of select="$WBS"/></WBS>
  	   	<OutlineNumber><xsl:value-of select="$WBS"/></OutlineNumber>
		<xsl:variable name="level" select="string-length(translate($WBS, '1234567890', ''))" />
		<xsl:choose>
			<xsl:when test="$level = 0">
				<OutlineLevel>1</OutlineLevel>
			</xsl:when>
			<xsl:otherwise>
				<OutlineLevel><xsl:value-of select="$level + 1"/></OutlineLevel>
			</xsl:otherwise>
		</xsl:choose>  	   	
  	   	<xsl:call-template name="TaskSchedule"/>
  	   	<xsl:call-template name="ActualSchedule"/>
		<Milestone>0</Milestone>
		<xsl:choose>
			<xsl:when test="Children">
				<Summary>1</Summary>
			</xsl:when>
			<xsl:otherwise>
				<Summary>0</Summary>
			</xsl:otherwise>
		</xsl:choose>
  	   	<!--xsl:choose>
			<xsl:when test="workItemType='summarytask' or workItemType='risk'">
				<Milestone>0</Milestone>
				<xsl:choose>
					<xsl:when test="Children">
						<Summary>1</Summary>
					</xsl:when>
					<xsl:otherwise>
						<Summary>0</Summary>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="workItemType='milestone'">
				<Milestone>1</Milestone>
				<Summary>0</Summary>
			</xsl:when>
			<xsl:otherwise>
				<Milestone>0</Milestone>
				<Summary>0</Summary>
			</xsl:otherwise>
	    </xsl:choose-->
  	   	<FixedCostAccrual>3</FixedCostAccrual>
  	   	<xsl:call-template name="PercentComplete"/>
		<xsl:if test="count(DependsOn) = 0">
  	   		<xsl:call-template name="Constraint"/>
  	   	</xsl:if>
  	   	<HyperlinkAddress><xsl:value-of select="@uiHref"/></HyperlinkAddress>
  	   	<xsl:if test="integrationLink and integrationLink != $empty_string">	
			<ExtendedAttribute>
				<FieldID>188743737</FieldID>
				<Value><xsl:value-of select="integrationLink"/></Value>
			</ExtendedAttribute>
		</xsl:if>		
		<!--ExtendedAttribute>
			<FieldID>188743731</FieldID>
			<Value><xsl:value-of select="@relativeHref"/></Value>
		</ExtendedAttribute-->
	</Task>
</xsl:template>

<xsl:template name="TaskSchedule">
	<Start><xsl:value-of select="concat(substring-before(plannedSchedule/startDate, ' '), 'T08:00:00')"/></Start>
	<Finish><xsl:value-of select="concat(substring-before(plannedSchedule/finishDate, ' '), 'T17:00:00')"/></Finish>
	<Duration><xsl:value-of select="concat(concat('PT', plannedSchedule/duration * 8), 'H0M0S')"/></Duration>
	<RemainingDuration><xsl:value-of select="concat(concat('PT', plannedSchedule/duration * 8), 'H0M0S')"/></RemainingDuration>
	<xsl:call-template name="ExtendedSchedule"/>
</xsl:template>

<xsl:template name="ExtendedSchedule">
	<!--If the planned schedule exists, fill in effort-->
	<xsl:if test="plannedSchedule">
		<ExtendedAttribute><FieldID>188743784</FieldID><Value><xsl:value-of select="concat(concat('PT', plannedSchedule/effort), 'H0M0S')"/></Value></ExtendedAttribute>
	</xsl:if>
	<!--Process the proposed schedule if it exists-->
	<xsl:if test="proposedSchedule">
		<ExtendedAttribute><FieldID>188743732</FieldID><Value><xsl:value-of select="concat(substring-before(proposedSchedule/startDate, ' '), 'T08:00:00')"/></Value></ExtendedAttribute>
		<ExtendedAttribute><FieldID>188743733</FieldID><Value><xsl:value-of select="concat(substring-before(proposedSchedule/finishDate, ' '), 'T17:00:00')"/></Value></ExtendedAttribute>
		<ExtendedAttribute><FieldID>188743783</FieldID><Value><xsl:value-of select="concat(concat('PT', proposedSchedule/duration * 8), 'H0M0S')"/></Value></ExtendedAttribute>
	</xsl:if>
</xsl:template>

<xsl:template name="ActualSchedule">
<!--Process the actual schedule if it exists-->
	<xsl:if test="actualSchedule">
		<xsl:if test="string-length(actualSchedule/startDate) > 1 and not(contains(actualSchedule/startDate, '1970')) and not(contains(actualSchedule/startDate, '1969'))">
			<ActualStart><xsl:value-of select="concat(substring-before(actualSchedule/startDate, ' '), 'T08:00:00')"/></ActualStart>
		</xsl:if>
		<xsl:if test="actualSchedule/duration !='0' and (percentC >= '100' or percentEC >= '100' or percentDC >= '100')">
			<xsl:if test="actualSchedule/finishDate and not(contains(actualSchedule/finishDate, '1970')) and not(contains(actualSchedule/finishDate, '1969'))">
				<ActualFinish><xsl:value-of select="concat(substring-before(actualSchedule/finishDate, ' '), 'T17:00:00')"/></ActualFinish>
			</xsl:if>
			<ActualDuration><xsl:value-of select="concat(concat('PT', actualSchedule/duration * 8), 'H0M0S')"/></ActualDuration>
		</xsl:if>
		<xsl:if test="actualSchedule/effort !='0'">
			<ActualWork><xsl:value-of select="concat(concat('PT', actualSchedule/effort), 'H0M0S')"/></ActualWork>
		</xsl:if>
		<xsl:if test="actualSchedule/effort = '0'">
			<ActualWork><xsl:value-of select="concat(concat('PT', actualSchedule/duration * 8), 'H0M0S')"/></ActualWork>
		</xsl:if>
	</xsl:if>
</xsl:template>

<xsl:template name="AssignmentActualSchedule">
<!--Process the actual schedule if it exists-->
	<xsl:if test="actualSchedule">
		<xsl:if test="string-length(actualSchedule/finishDate) > 1  and not(contains(actualSchedule/finishDate, '1970')) and not(contains(actualSchedule/finishDate, '1969'))">
			<ActualStart><xsl:value-of select="concat(substring-before(actualSchedule/startDate, ' '), 'T08:00:00')"/></ActualStart>
			<ActualFinish><xsl:value-of select="concat(substring-before(actualSchedule/finishDate, ' '), 'T17:00:00')"/></ActualFinish>
			<xsl:if test="actualSchedule/effort !='0'">
				<ActualWork><xsl:value-of select="concat(concat('PT', actualSchedule/effort), 'H0M0S')"/></ActualWork>
			</xsl:if>
			<xsl:if test="actualSchedule/effort = '0'">
				<ActualWork><xsl:value-of select="concat(concat('PT', actualSchedule/duration * 8), 'H0M0S')"/></ActualWork>
			</xsl:if>
		</xsl:if>		
	</xsl:if>
</xsl:template>

<xsl:template name="Constraint">
	<ConstraintType>
		<xsl:choose>
			<xsl:when test="substring-before(plannedSchedule/startDate, ' ')!=substring-before($ProjectStart, 'T') and constraint/constraintType!='FinishNoLaterThan'">4</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="constraint/constraintType='AsSoonAsPossible'">0</xsl:when>
					<!--xsl:when test="constraint/constraintType='AsLateAsPossible'">1</xsl:when>
					<xsl:when test="constraint/constraintType='MustStartOn'">2</xsl:when>
					<xsl:when test="constraint/constraintType='MustFinishOn'">3</xsl:when>
					<xsl:when test="constraint/constraintType='StartNoEarlierThan'">4</xsl:when>
					<xsl:when test="constraint/constraintType='StartNoLaterThan'">5</xsl:when>
					<xsl:when test="constraint/constraintType='FinishNoEarlierThan'">6</xsl:when-->
					<xsl:when test="constraint/constraintType='FinishNoLaterThan'">7</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
    </ConstraintType>
	<xsl:choose>
		<xsl:when test="substring-before(plannedSchedule/startDate, ' ')!=substring-before($ProjectStart, 'T') and constraint/constraintType!='FinishNoLaterThan'">
			<ConstraintDate><xsl:value-of select="concat(substring-before(plannedSchedule/startDate, ' '), 'T08:00:00')"/></ConstraintDate>
		</xsl:when>
		<xsl:otherwise>
			<xsl:choose>
				<xsl:when test="constraint/constraintType='AsSoonAsPossible'"></xsl:when>
				<xsl:otherwise>
					<xsl:if test="constraint/constraintDate">
						<ConstraintDate><xsl:value-of select="constraint/constraintDate"/>T17:00:00</ConstraintDate>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="predecessor">
	<PredecessorLink>
		<PredecessorUID><xsl:value-of select="$UID"/></PredecessorUID>
		<Type>1</Type>
		<CrossProject>0</CrossProject>
		<LinkLag>0</LinkLag>
		<LagFormat>7</LagFormat>
	</PredecessorLink>
</xsl:template>

<xsl:template match="user">
	<Resource>
		<UID><xsl:value-of select="$ResUID"/></UID>
		<ID><xsl:value-of select="$ResUID"/></ID>
		<Name><xsl:value-of select="$TaraID"/></Name>
		<Type>1</Type>
	</Resource>
</xsl:template>

<xsl:template match="projectAssignment">
	<xsl:choose>
		<xsl:when test="profile">
			<Resource>
				<UID><xsl:value-of select="$ResUID"/></UID>
				<ID><xsl:value-of select="$ResUID"/></ID>
				<Name><xsl:value-of select="profile/name"/></Name>
				<Type>1</Type>
				<xsl:call-template name="Rates"/>
			</Resource>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="Rates"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="Rates">
	<Rates>
		<xsl:choose>
			<xsl:when test="count(rate)=1">
				<Rate>
					<RatesTo>2049-12-31T23:59:06</RatesTo>
					<RatesFrom>1984-01-01T00:00:00</RatesFrom>
					<RateTable>0</RateTable>
					<StandardRate><xsl:value-of select="rate/costRate"/></StandardRate>
					<StandardRateFormat>2</StandardRateFormat>
					<OvertimeRate>0</OvertimeRate>
					<OvertimeRateFormat>2</OvertimeRateFormat>
					<CostPerUse>0</CostPerUse>
				</Rate>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="rate">
					<Rate>
					<xsl:choose>
							<xsl:when test="position()=1">
									<RatesTo><xsl:value-of select="concat(substring-before(toDate, ' '), 'T08:00:00')"/></RatesTo>
									<RatesFrom>1984-01-01T00:00:00</RatesFrom>
							</xsl:when>
							<xsl:when test="position()=last()">
									<RatesTo>2049-12-31T23:59:06</RatesTo>
									<RatesFrom><xsl:value-of select="concat(substring-before(fromDate, ' '), 'T08:00:00')"/></RatesFrom>
							</xsl:when>
							<xsl:otherwise>
									<RatesTo><xsl:value-of select="concat(substring-before(toDate, ' '), 'T08:00:00')"/></RatesTo>
									<RatesFrom><xsl:value-of select="concat(substring-before(fromDate, ' '), 'T08:00:00')"/></RatesFrom>
							</xsl:otherwise>				
						</xsl:choose>
						<RateTable>0</RateTable>
						<StandardRate><xsl:value-of select="costRate"/></StandardRate>
						<StandardRateFormat>2</StandardRateFormat>
						<OvertimeRate>0</OvertimeRate>
						<OvertimeRateFormat>2</OvertimeRateFormat>
						<CostPerUse>0</CostPerUse>
					</Rate>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</Rates>
</xsl:template>

<xsl:template match="taskAssignment">
	<Assignment>
		<UID><xsl:value-of select="$AssUID"/></UID>
		<TaskUID><xsl:value-of select="$UID"/></TaskUID>
		<ResourceUID><xsl:value-of select="$ResUID"/></ResourceUID>
		<Start><xsl:value-of select="concat(substring-before(plannedSchedule/startDate, ' '), 'T08:00:00')"/></Start>
		<Finish><xsl:value-of select="concat(substring-before(plannedSchedule/finishDate, ' '), 'T17:00:00')"/></Finish>
		<WorkContour>0</WorkContour>
		<Units><xsl:value-of select="contourValue div 8"/></Units>
		<Work><xsl:value-of select="concat(concat('PT', plannedSchedule/effort), 'H0M0S')"/></Work>
		<xsl:call-template name="AssignmentActualSchedule"/>
	</Assignment>
</xsl:template>

<xsl:template match="Project|Task|Assignment">
	<xsl:copy>
   		<xsl:apply-templates select="node()"/>
   	</xsl:copy>
</xsl:template>

<xsl:template match="Schedule|Constraint">
    <xsl:apply-templates select="*"/>
</xsl:template>

<xsl:template match="node()">
  	<xsl:copy>
    	<xsl:apply-templates select="node()"/>
  	</xsl:copy>
</xsl:template>

<xsl:template name="PercentComplete">
	<xsl:choose>
		<xsl:when test="constraint/assignmentType='Effort'">
			<xsl:call-template name="percentCheck">
				<xsl:with-param name="percent" select="percentEC"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="percentCheck">
				<xsl:with-param name="percent" select="percentDC"/>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="percentCheck">
	<xsl:param name="percent"/>
		<xsl:choose>
			<xsl:when test="$percent > 100">
				<PercentComplete>100</PercentComplete>
			</xsl:when>
			<xsl:otherwise>
				<PercentComplete><xsl:value-of select="$percent"/></PercentComplete>
			</xsl:otherwise>
		</xsl:choose>
</xsl:template>

</xsl:stylesheet>