/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tpt.internal.client;

import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.tpt.common.internal.ITptService;
import com.ibm.team.tpt.internal.client.ITptClient;
import com.ibm.team.tpt.internal.common.items.dto.UIItemDTO;
import org.eclipse.core.runtime.IProgressMonitor;

public final class TptClient
implements ITptClient {
    private final IClientLibraryContext fContext;

    TptClient(IClientLibraryContext context) {
        this.fContext = context;
    }

    @Override
    public String getProjectAreaCurrency(final String projectAreaId, IProgressMonitor monitor) throws TeamRepositoryException {
        return (String)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<String>(){

            public String run(IProgressMonitor progress) throws TeamRepositoryException {
                ITptService service = (ITptService)TptClient.this.fContext.getServiceInterface(ITptService.class);
                String currency = service.fetchDefaultCurrencyName(projectAreaId);
                return currency;
            }
        }, monitor);
    }

    @Override
    public UIItemDTO[] getProjectAreaTimecodeList(final String projectAreaId, IProgressMonitor monitor) throws TeamRepositoryException {
        return (UIItemDTO[])this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<UIItemDTO[]>(){

            public UIItemDTO[] run(IProgressMonitor progress) throws TeamRepositoryException {
                ITptService service = (ITptService)TptClient.this.fContext.getServiceInterface(ITptService.class);
                UIItemDTO[] timecodeList = service.fetchProjectAreaTimecode(projectAreaId);
                return timecodeList;
            }
        }, monitor);
    }

    @Override
    public Boolean getTimetrackingInfo(final String projectAreaId, IProgressMonitor monitor) throws TeamRepositoryException {
        return (Boolean)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Boolean>(){

            public Boolean run(IProgressMonitor progress) throws TeamRepositoryException {
                ITptService service = (ITptService)TptClient.this.fContext.getServiceInterface(ITptService.class);
                boolean isTimetrackingEnabled = service.fetchTimeTrackingInfo(projectAreaId);
                return new Boolean(isTimetrackingEnabled);
            }
        }, monitor);
    }
}

