/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2010, 2013. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.tempo.shared.client.TriangularEstimate"); //$NON-NLS-1$

dojo.require("com.ibm.team.tempo.shared.client.Estimate"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.ProbabilityDistribution"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.TriangularDistribution"); //$NON-NLS-1$

(function() {
var client= com.ibm.team.tempo.shared.client;
var Estimate= client.Estimate;
var ProbabilityDistribution= client.ProbabilityDistribution;
var TriangularDistribution= client.TriangularDistribution;

dojo.declare("com.ibm.team.tempo.shared.client.TriangularEstimate", Estimate, { //$NON-NLS-1$

	//pd: null,

	lowerBound: 0,

	middle: 0,

	upperBound: 0,

	constructor: function(lowerbound, middle, upperbound, type) {
		this.inherited(arguments, []);
		this.lowerBound= lowerbound;
		this.middle= middle;
		this.upperBound= upperbound;
		this.setRandomVariate(true);
		if (type == null || type === TriangularDistribution.NAME) 
			this.pd= new TriangularDistribution(this.lowerBound, middle, this.upperBound);
	},

	/**
	 * API
	 */
	computeCost: function() {
		this.setCost(this.pd.randomCost(Math.random()));
	},

	getLowerBound: function() {
		return this.lowerBound;
	},

	getMiddle: function() {
		return this.middle;
	},

	getUpperBound: function() {
		return this.upperBound;
	},

	scale: function(r) {
		return this.pd.scale(r);
	},

	getPd: function() {
		return this.pd;
	},

	toString: function() {
		var buf= "lowerBound="; //$NON-NLS-1$
		buf+= this.lowerBound;
		buf+= " middle="; //$NON-NLS-1$
		buf+= this.middle;
		buf+= " upperBound="; //$NON-NLS-1$
		buf+= this.upperBound;
		buf+= " type="; //$NON-NLS-1$
		buf+= this.pd.getName().substring(0, 3);
		buf+= " isRandomVariate = " + this.isRandomVariate(); //$NON-NLS-1$
		return buf;
	},

	equals: function(o) {
		if (this === o) 
			return true;
		if (o instanceof ProbabilityDistribution) {
			return ((this.getLowerBound() === this.pd.getLowerbound()) && (this.getMiddle() === this.pd.getMiddle()) && (this.getUpperBound() === this.pd.getUpperbound()));
		}
		return false;
	}
});

})();
