/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2010, 2012. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.tempo.shared.client.TriangularDistribution"); //$NON-NLS-1$

dojo.require("com.ibm.team.tempo.shared.client.ProbabilityDistribution"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.ProbabilityDistributionType"); //$NON-NLS-1$

(function() {
var client= com.ibm.team.tempo.shared.client;
var ProbabilityDistribution= client.ProbabilityDistribution;
var ProbabilityDistributionType= client.ProbabilityDistributionType;

var TriangularDistribution= dojo.declare("com.ibm.team.tempo.shared.client.TriangularDistribution", ProbabilityDistribution, { //$NON-NLS-1$

	lowerbound: 0,

	middle: 0,

	upperbound: 0,

	constructor: function(lb, m, ub) {
		this.inherited(arguments, []);
		this.lowerbound= lb;
		this.middle= m;
		this.upperbound= ub;
	},

	/**
	 * API
	 */
	randomCost: function(rand) {
		var cost= 0.0;
		if (this.upperbound === this.lowerbound) 
			return this.upperbound;
		var delta= this.middle - this.lowerbound;
		var a1= delta / (this.upperbound - this.lowerbound);
		if (rand <= a1) 
			cost= Math.sqrt(rand / a1) * delta + this.lowerbound;
		else 
			cost= this.upperbound - Math.sqrt((1.0 - rand) / (1.0 - a1)) * (this.upperbound - this.middle);
		return cost;
	},

	scale: function(r) {
		var m;
		var lb;
		var ub;
		if (r >= 0.0) {
			m= this.middle * r;
			lb= this.lowerbound * r;
			ub= this.upperbound * r;
		} else {
			m= this.middle * r;
			lb= this.upperbound * r;
			ub= this.lowerbound * r;
		}
		var result= new TriangularDistribution(lb, m, ub);
		return result;
	},

	convolute: function(tdvector) {
		var gammaOut= new Array(4);
		gammaOut[0]= 1.0;
		gammaOut[1]= 0.0;
		gammaOut[2]= 0.0;
		gammaOut[3]= 0.0;
		for (var i= 0; i < tdvector.length; i++){
			var gamma= tdvector[i].gammas();
			for (var j= 1; j < gamma.length; j++)
				gammaOut[j]+= gamma[j];
		}
		return this.fromGammas(gammaOut);
	},

	fromGammas: function(gamma) {
		var x= 0.0;
		var y= 0.0;
		var discriminant= 8.0 * gamma[2] * gamma[2] * gamma[2] - 25.0 * gamma[3] * gamma[3];
		if (discriminant < 0.0) {
			y= 3.0 * Math.sqrt(gamma[2] / 2.0) * Math.signum(gamma[3]);
			x= Math.abs(y);
		} else {
			var ymax= 3.0 * Math.sqrt(gamma[2] / 2.0);
			var ymin= -ymax;
			var fy= this.F2(ymax, gamma);
			fy= this.F2(ymin, gamma);
			for (var i= 0; i < 100; i++){
				y= (ymax + ymin) / 2.0;
				fy= this.F2(y, gamma);
				if (fy <= 0.0) 
					ymax= y;
				if (fy >= 0.0) 
					ymin= y;
				if (ymax === ymin) 
					break;
			}
			x= Math.sqrt(6 * gamma[2] - y * y / 3.0);
		}
		var m= gamma[1] - 2.0 * y / 3.0;
		var u= m + x + y;
		var l= m - x + y;
		return new TriangularDistribution(l, m, u);
	},

	/**
	 * @param y
	 * @param gamma
	 * @return The cubic to be satisfied by y in fromMoments
	 */
	F2: function(y, gamma) {
		return (4.0 * y * y * y - 54.0 * gamma[2] * y + 135.0 * gamma[3]);
	},

	gammas: function() {
		var gamma= new Array(4);
		gamma[0]= 1.0;
		gamma[1]= (this.lowerbound + this.middle + this.upperbound) / 3.0;
		gamma[2]= (this.upperbound * this.upperbound + this.middle * this.middle + this.lowerbound * this.lowerbound - this.upperbound * this.middle - this.middle * this.lowerbound - this.lowerbound * this.upperbound) / 18.0;
		gamma[3]= ((this.upperbound - 2.0 * this.middle + this.lowerbound) * (this.upperbound + this.middle - 2.0 * this.lowerbound) * (2.0 * this.upperbound - this.middle - this.lowerbound)) / 270.0;
		return gamma;
	},

	fromMoments: function(p) {
		var p1= p[1] / p[0];
		var p2= p[2] / p[0];
		var p3= p[3] / p[0];
		var gamma1= p1;
		var gamma2= p2 - p1 * p1;
		var gamma3= p3 - 3.0 * p1 * p2 + 2.0 * p1 * p1 * p1;
		var x= 0.0;
		var y= 0.0;
		var discriminant= 8.0 * gamma2 * gamma2 * gamma2 - 25.0 * gamma3 * gamma3;
		if (discriminant < 0.0) {
			y= 3.0 * Math.sqrt(gamma2 / 2.0) * Math.signum(gamma3);
			x= Math.abs(y);
		} else {
			var ymax= 3.0 * Math.sqrt(gamma2 / 2.0);
			var ymin= -ymax;
			var fy= this.F3(ymax, gamma2, gamma3);
			fy= this.F3(ymin, gamma2, gamma3);
			for (var i= 0; i < 100; i++){
				y= (ymax + ymin) / 2.0;
				fy= this.F3(y, gamma2, gamma3);
				if (fy <= 0.0) 
					ymax= y;
				if (fy >= 0.0) 
					ymin= y;
				if (ymax === ymin) 
					break;
			}
			x= Math.sqrt(6 * gamma2 - y * y / 3.0);
		}
		var m= gamma1 - 2.0 * y / 3.0;
		var u= m + x + y;
		var l= m - x + y;
		return new TriangularDistribution(l, m, u);
	},

	/**
	 * @param y
	 * @param gamma2
	 * @param gamma3
	 * @return The cubic to be satisfied by y in fromMoments
	 */
	F3: function(y, gamma2, gamma3) {
		return (4.0 * y * y * y - 54.0 * gamma2 * y + 135.0 * gamma3);
	}
});

TriangularDistribution.NAME= ProbabilityDistributionType.TRIANGULAR;

})();
