/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2010, 2012. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.tempo.shared.client.Traverser"); //$NON-NLS-1$

dojo.require("com.ibm.team.tempo.shared.client.OwnerNodeListUtil"); //$NON-NLS-1$

(function() {
var OwnerNodeListUtil= com.ibm.team.tempo.shared.client.OwnerNodeListUtil;

dojo.declare("com.ibm.team.tempo.shared.client.Traverser", null, { //$NON-NLS-1$
	"-chains-": { constructor: "manual" },

	constructor: function() {
	},

	batchOptimization: function(graphNode, ownerNodeLst) {
		if (graphNode.getSlack() > 0) {
			var nextFreeNode= OwnerNodeListUtil.getNextFreeNode(graphNode, ownerNodeLst);
			if (nextFreeNode != null) {
				var prevOwnerNode= OwnerNodeListUtil.getPreviousOwnerNode(graphNode, ownerNodeLst);
				var successors= prevOwnerNode.getSuccessors();
				var successorPos= dojo.indexOf(successors, graphNode.getId());
				if (successorPos > -1) {
					successors.splice(successorPos, 1);
				}
				prevOwnerNode.addSuccessor(nextFreeNode.getId());
				var nextFreeNodeCumulativeCost= prevOwnerNode.getCumulativeCost() + nextFreeNode.getTotalCost();
				nextFreeNode.setCumulativeCost(nextFreeNodeCumulativeCost);
				var predecessors= nextFreeNode.getPredecessors();
				var predecessorPos= dojo.indexOf(predecessors, graphNode);
				if (predecessorPos > -1) {
					predecessors.splice(predecessorPos, 1);
				}
				this.computeSlack(nextFreeNode, prevOwnerNode);
				graphNode.setCumulativeCost(nextFreeNodeCumulativeCost + graphNode.getTotalCost());
				successors= graphNode.getSuccessors();
				successorPos= dojo.indexOf(successors, nextFreeNode.getId());
				if (successorPos > -1) {
					successors.splice(successorPos, 1);
				}
				graphNode.addSuccessor(OwnerNodeListUtil.getNextOwnerNode(graphNode, ownerNodeLst).getId());
				this.computeSlack(graphNode, nextFreeNode);
			}
		}
	},

	computeSlack: function(graphNode, prevOwnerNode) {
		var slack;
		if (prevOwnerNode != null) {
			if (graphNode.getOwner() === prevOwnerNode.getOwner()) {
				if (graphNode.getConstraintPredecessor() == null) {
					graphNode.setSlack(0);
				} else {
					slack= 0.0;
					slack= graphNode.getConstraintPredecessor().getCumulativeCost() - prevOwnerNode.getCumulativeCost();
					if (slack < 0.0) {
						slack= 0.0;
					}
					graphNode.setSlack(slack);
				}
			}
		} else {
			slack= 0.0;
			var constraintPredecessor= graphNode.getConstraintPredecessor();
			if (constraintPredecessor != null) {
				slack= graphNode.getConstraintPredecessor().getCumulativeCost();
			}
			if (slack < 0.0) {
				slack= 0.0;
			}
			graphNode.setSlack(slack);
		}
	}
});

})();
