/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2010, 2012. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.tempo.shared.client.ScheduleByOwner"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.lang.Runtime"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.ImpactFunc"); //$NON-NLS-1$

(function() {
var jdojo= com.ibm.jdojo.lang.Runtime;
var ImpactFunc= com.ibm.team.tempo.shared.client.ImpactFunc;

dojo.declare("com.ibm.team.tempo.shared.client.ScheduleByOwner", null, { //$NON-NLS-1$
	"-chains-": { constructor: "manual" },

	//ownerScheduledGraph: null,

	//scheduleResult: null,

	constructor: function(ownerScheduledGraph) {
		this.ownerScheduledGraph= ownerScheduledGraph;
	},

	/**
	 * API
	 */
	load: function() {
		this.scheduleResult= [];
		var ownerNodeTbl= this.ownerScheduledGraph.getOwnerGraphNodeTbl();
		var $subject= jdojo.getProperties(ownerNodeTbl);
		var $length= $subject.length;
		for (var $count= 0; $count < $length; $count++){
			var ownerId= $subject[$count];
			var ownerNodes= ownerNodeTbl[ownerId];
			for (var j= 0; j < ownerNodes.length; j++){
				var graphNode= ownerNodes[j];
				this.scheduleResult.push(graphNode);
				this.populateImpact(graphNode);
			}
		}
	},

	getScheduleResult: function() {
		return this.scheduleResult;
	},

	getGraph: function() {
		return this.ownerScheduledGraph;
	},

	populateImpact: function(graphNode) {
		var estimate= graphNode.getEstimate();
		var impactDbl= ImpactFunc.getValue(estimate.getPd());
		graphNode.setImpact(impactDbl);
	}
});

})();
