/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2010, 2012. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.tempo.shared.client.ProbabilityAttribute"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.lang.Runtime"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.api.client.IPlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.api.client.IPlanModel"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.client.internal.model.attributes.SharedPlanningAttribute"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.PlanModelAdapter"); //$NON-NLS-1$

(function() {
var jdojo= com.ibm.jdojo.lang.Runtime;
var team= com.ibm.team;
var apt= team.apt;
var client= apt.api.client;
var IPlanItem= client.IPlanItem;
var IPlanModel= client.IPlanModel;
var SharedPlanningAttribute= apt.shared.client.internal.model.attributes.SharedPlanningAttribute;
var PlanModelAdapter= team.tempo.shared.client.PlanModelAdapter;

var ProbabilityAttribute= dojo.declare("com.ibm.team.tempo.shared.client.ProbabilityAttribute", SharedPlanningAttribute, { //$NON-NLS-1$

	//planModel: null,

	//planElementCompletionProbMap: null,

	//planModelAdapter: null,

	constructor: function(description, planningClient, planContext) {
		this.inherited(arguments, [description, planningClient, planContext]);
		this.planElementCompletionProbMap= {};
		this.planModelAdapter= null;
	},

	getDependentAttributes: function() {
		return ProbabilityAttribute.ATTRIBUTE_DEPENDENCIES;
	},

	getValue: function(receiver) {
		return this.planElementCompletionProbMap[receiver.getIdentifier()];
	},

	getValueSet: function(planElement) {
		return null;
	},

	setValue: function(receiver, value) {
		this.planElementCompletionProbMap[receiver.getIdentifier()]= value;
	},

	initialize: function(planModel, planElements, future /*, flags... */ ) {
		if (this.planModel == null) {
			this.planModel= planModel;
			this.planModelAdapter= new PlanModelAdapter(planModel);
			this.planModelAdapter.initialize();
			this.computeCompletionProbabilities();
		}
		future.callback(null);
	},

	onChange: function(deltaBuilder, delta) {
	},

	/**
	 * Implementation
	 */
	computeCompletionProbabilities: function() {
		this.planElementCompletionProbMap= this.planModelAdapter.computeCompletionProbabilities();
	},

	indicateChange: function(deltaBuilder, oldProbabilities) {
		var $subject= jdojo.getProperties(this.planElementCompletionProbMap);
		var $length= $subject.length;
		for (var $count= 0; $count < $length; $count++){
			var planItemId= $subject[$count];
			var planItem= this.planModel.getPlanElement(planItemId);
			var oldProbability= oldProbabilities[planItem.getIdentifier()];
			var newProbability= this.planElementCompletionProbMap[planItem.getIdentifier()];
			deltaBuilder.changed(planItem, IPlanItem.COMPLETION_PROBABILITY, oldProbability, newProbability);
		}
	},

	$interfaces: {
		'com.ibm.team.apt.api.client.IPlanningAttributeDependent': true, //$NON-NLS-1$
		'com.ibm.team.apt.api.client.IPlanningAttributeListener': true //$NON-NLS-1$
	}
});

ProbabilityAttribute.ATTRIBUTE_DEPENDENCIES= [IPlanItem.SEQUENCE_VALUE, IPlanItem.OWNER, IPlanItem.ITEM_TYPE, IPlanItem.RESOLVED, IPlanItem.TARGET, IPlanItem.MINIMAL_ESTIMATE, IPlanItem.ESTIMATE, IPlanItem.MAXIMAL_ESTIMATE, IPlanItem.PARENT, IPlanItem.CHILDREN, IPlanModel.AGILE_WORKTIME_SCHEDULER, IPlanModel.REFERENCE_TIME];

})();
