/*******************************************************************************
 * Licensed Materials - Property of IBM
 * © Copyright IBM Corporation 2010, 2019. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.tempo.shared.client.PlanModelAdapter"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.lang.Runtime"); //$NON-NLS-1$
dojo.require("com.ibm.jdojo.util.Assert"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.api.client.IPlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.api.client.IPlanModel"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.api.client.IWorktimeProvider"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.api.common.UIItemHandle"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.api.common.workitem.Duration"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.client.internal.duration.Instant"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.client.internal.duration.Timespan"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.Graph"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.GraphNode"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.GraphOptimization"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.OwnerScheduledGraph"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.ProbabilityDistributionType"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.ScheduleByOwner"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.TriangularEstimate"); //$NON-NLS-1$

(function() {
var jdojo2= com.ibm.jdojo;
var jdojo= jdojo2.lang.Runtime;
var Assert= jdojo2.util.Assert;
var team= com.ibm.team;
var apt= team.apt;
var api= apt.api;
var client= api.client;
var IPlanItem= client.IPlanItem;
var IPlanModel= client.IPlanModel;
var IWorktimeProvider= client.IWorktimeProvider;
var common= api.common;
var UIItemHandle= common.UIItemHandle;
var Duration= common.workitem.Duration;
var duration= apt.shared.client.internal.duration;
var Instant= duration.Instant;
var Timespan= duration.Timespan;
var client2= team.tempo.shared.client;
var Graph= client2.Graph;
var GraphNode= client2.GraphNode;
var GraphOptimization= client2.GraphOptimization;
var OwnerScheduledGraph= client2.OwnerScheduledGraph;
var ProbabilityDistributionType= client2.ProbabilityDistributionType;
var ScheduleByOwner= client2.ScheduleByOwner;
var TriangularEstimate= client2.TriangularEstimate;

/**
 * Adapts the PlanModel to a graph representation used to simulate the probability of completion 
 * for an execution item.  After construction call{@link initialize()} to create the graph and 
 * auxilliary structures necessary for the simulation.
 * 
 * @author klingert weizhao
 *
 */
var PlanModelAdapter= dojo.declare("com.ibm.team.tempo.shared.client.PlanModelAdapter", null, { //$NON-NLS-1$
	"-chains-": { constructor: "manual" },

	//deadlineCache: null,

	//ownerElementMap: null,

	//topLevelItems: null,

	//planModel: null,

	//scheduler: null,

	//graphOptimization: null,

	//planElements: null,

	/**
	 * Construct the mediator.  Call {@link #initialize()} to
	 * set up the appropriate structures.
	 * @param planModel
	 */
	constructor: function(planModel) {
		this.planModel= planModel;
		this.topLevelItems= [];
		this.ownerElementMap= {};
		this.deadlineCache= {};
		this.graphOptimization= null;
	},

	/**
	 * Initialize the structures necessary for the simulation
	 */
	initialize: function() {
		this.processPlanElements();
		this.createGraph();
	},

	/**
	 * Compute the probabilities of completion of all plan elements
	 * in the model
	 * @return a map of plan items to their probabilities
	 */
	computeCompletionProbabilities: function() {
		var result= {};
		var optimizationResults= this.graphOptimization.simulate(PlanModelAdapter.NUM_SIMULATION_ITERATIONS);
		var graphNodeTable= optimizationResults.getMonteCarloNodeTbl();
		var $subject= jdojo.getProperties(graphNodeTable);
		var $length= $subject.length;
		for (var $count= 0; $count < $length; $count++){
			var planItemId= $subject[$count];
			var planItem= this.planModel.getPlanElement(planItemId);
			var graphNode= graphNodeTable[planItemId];
			var probOfCompletion= graphNode.getProbabilityToComplete();
			result[planItem.getIdentifier()]= probOfCompletion;
		}
		this.computeTopLevelItemProbabilities(result, graphNodeTable);
		return result;
	},

	/**
	 * @param owner 
	 * @return the amount of time remaining in the supplied iteration
	 * TODO: replace this with the appropriate API call
	 */
	getRemainingWorkTime: function(owner, iteration) {
		if (owner == null || iteration == null) {
			return 0;
		}
		var startDate= iteration.getStartDate();
		var now= this.planModel.getAttributeValue(IPlanModel.REFERENCE_TIME);
		if (now == null) {
			now= Instant.currentTime();
		}
		if (startDate == null || startDate.before(now)) 
			startDate= now;
		var endDate= iteration.getEndDate();
		if (endDate == null || endDate.before(startDate)) 
			return 0;
		var iterationDuration= new Timespan(startDate, endDate);
		var attribute= this.planModel.findAttribute(IPlanModel.AGILE_WORKTIME_SCHEDULER);
		var worktimeProvider= attribute.getAdapter(IWorktimeProvider);
		return worktimeProvider.getWorktime(UIItemHandle.itemHandleFor(owner), iterationDuration, null);
	},

	/**
	 * Process all plan elements to create the owner element map
	 * and top-level items
	 */
	processPlanElements: function() {
		this.planElements= this.planModel.getAllPlanElements();
		for (var i= 0; i < this.planElements.length; i++){
			var planElement= this.planElements[i];
			if (planElement.getAdapter(IPlanItem) == null) 
				continue;
			if (this.isResolved(planElement)) 
				continue;
			if (this.isTopLevelItem(planElement)) {
				this.topLevelItems.push(planElement);
				continue;
			}
			var owner= this.getOwner(planElement);
			var ownerId= owner == null ? PlanModelAdapter.NO_OWNER_ID : owner.getItemId();
			var ownerElts= this.ownerElementMap[ownerId];
			if (ownerElts == null) {
				ownerElts= [];
				this.ownerElementMap[ownerId]= ownerElts;
			}
			ownerElts.push(planElement);
		}
		this.sortOwnerElements();
	},

	/**
	 * Sort each owner's elements according to their sequence value
	 */
	sortOwnerElements: function() {
		var $subject2= jdojo.getProperties(this.ownerElementMap);
		var $length2= $subject2.length;
		for (var $count2= 0; $count2 < $length2; $count2++){
			var ownerId= $subject2[$count2];
			var ownerElts= this.ownerElementMap[ownerId];
			ownerElts.sort(dojo.hitch(this, function(left, right) {
				var leftValue= this.getSequenceValue(left);
				var rightValue= this.getSequenceValue(right);
				if (leftValue === rightValue) {
					return 0;
				} else if (leftValue == null) {
					return rightValue.compareTo(leftValue);
				} else {
					return leftValue.compareTo(rightValue);
				}
			}));
		}
	},

	/**
	 * Create a graph containing the plan elements for each owner
	 */
	createGraph: function() {
		var graph= new Graph();
		var $subject3= jdojo.getProperties(this.ownerElementMap);
		var $length3= $subject3.length;
		for (var $count3= 0; $count3 < $length3; $count3++){
			var ownerId= $subject3[$count3];
			var ownerElts= this.ownerElementMap[ownerId];
			this.createGraphNodes(graph, ownerElts);
		}
		var ownerScheduledGraph= new OwnerScheduledGraph(graph.getOrigNodeLst());
		var scheduleGenerator= new ScheduleByOwner(ownerScheduledGraph);
		scheduleGenerator.load();
		this.graphOptimization= new GraphOptimization(scheduleGenerator);
	},

	dumpGraph: function(graph) {
		var ownerGraphNodeTbl= graph.getOwnerGraphNodeTbl();
		var buf= ""; //$NON-NLS-1$
		var $subject4= jdojo.getProperties(ownerGraphNodeTbl);
		var $length4= $subject4.length;
		for (var $count4= 0; $count4 < $length4; $count4++){
			var ownerId= $subject4[$count4];
			var ownerNodes= ownerGraphNodeTbl[ownerId];
			buf= buf + "Nodes for owner: " + ownerId + "\n"; //$NON-NLS-1$ //$NON-NLS-2$
			for (var i= 0; i < ownerNodes.length; i++){
				var node= ownerNodes[i];
				var te= node.getEstimate();
				buf= buf + node.getId() + " [" + te.getLowerBound() + ", " + te.getMiddle() + ", " + te.getUpperBound() + "]\n"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			}
			buf= buf + "\n"; //$NON-NLS-1$
		}
		buf= buf + ""; //$NON-NLS-1$
		console.log(buf);
	},

	/**
	 * Create {@link GraphNode}s for each {@link IPlanElement} provided and
	 * add them to the graph.
	 * @param elts
	 */
	createGraphNodes: function(graph, elts) {
		var $subject5= elts;
		var $length5= $subject5.length;
		for (var $count5= 0; $count5 < $length5; $count5++){
			var e= $subject5[$count5];
			var graphNode= this.createGraphNode(e);
			graph.add(graphNode);
		}
	},

	/**
	 * Create a {@link GraphNode} for the supplied {@link IPlanElement}
	 */
	createGraphNode: function(e) {
		var minimal= this.getMinimalEstimate(e);
		var nominal= this.getEstimate(e);
		var maximal= this.getMaximalEstimate(e);
		if (!nominal.isSpecified() || !minimal.isSpecified() || !maximal.isSpecified()) {
			if (!nominal.isSpecified()) {
				if (minimal.isSpecified() || maximal.isSpecified()) {
					if (minimal.isSpecified() && maximal.isSpecified()) {
						nominal= new Duration((minimal.getMilliseconds() + maximal.getMilliseconds()) / 2);
					} else if (minimal.isSpecified()) {
						nominal= new Duration(minimal.getMilliseconds() * 2);
					} else {
						nominal= new Duration(maximal.getMilliseconds() / 2);
					}
				} else {
					nominal= new Duration(0);
				}
			}
			if (!minimal.isSpecified()) {
				minimal= new Duration(nominal.getMilliseconds() / 2);
			}
			if (!maximal.isSpecified()) {
				maximal= new Duration(nominal.getMilliseconds() * 2);
			}
		}
		if (minimal.getMilliseconds() > nominal.getMilliseconds()) {
			minimal= nominal;
		}
		if (maximal.getMilliseconds() < nominal.getMilliseconds()) {
			maximal= nominal;
		}
		var estimate= new TriangularEstimate(minimal.getMilliseconds(), nominal.getMilliseconds(), maximal.getMilliseconds(), ProbabilityDistributionType.TRIANGULAR);
		var result= new GraphNode(e.getIdentifier(), estimate);
		var owner= this.getOwner(e);
		var ownerId= owner == null ? PlanModelAdapter.NO_OWNER_ID : owner.getItemId();
		result.setOwner(ownerId);
		var targetIteration= this.getTarget(e);
		var deadline= this.getDeadline(owner, targetIteration);
		result.setTargetCost(deadline);
		result.setEffectiveTargetCost(deadline);
		var parent= this.getParent(e);
		if (parent != null && jdojo.implementsInterface(parent, "com.ibm.team.apt.api.client.IPlanItem")) {
			var p= parent;
			result.setParent(p);
		}
		return result;
	},

	/**
	 * @param owner
	 * @param targetIteration
	 * @return the amount of time left in the supplied iteration for the supplied owner (in ms).
	 */
	getDeadline: function(owner, targetIteration) {
		var cacheKey= (owner == null ? PlanModelAdapter.NO_OWNER_ID : owner.getItemId()).toString();
		cacheKey= cacheKey + "," + (targetIteration != null ? targetIteration.getItemId() : "NoIteration").toString(); //$NON-NLS-1$ //$NON-NLS-2$
		var result= this.deadlineCache[cacheKey];
		if (result == null) {
			result= this.getRemainingWorkTime(owner, targetIteration);
			this.deadlineCache[cacheKey]= result;
		}
		return result;
	},

	/**
	 * Compute the probabilities of any top-level item parents of tasks
	 */
	computeTopLevelItemProbabilities: function(result, graphNodeTable) {
		var parentToLastChildMap= this.createParentToLastChildMap(graphNodeTable);
		var $subject6= jdojo.getProperties(parentToLastChildMap);
		var $length6= $subject6.length;
		for (var $count6= 0; $count6 < $length6; $count6++){
			var planItemId= $subject6[$count6];
			var topLevelItem= this.planModel.getPlanElement(planItemId);
			var children= parentToLastChildMap[planItemId];
			var probOfAllChildrenCompleting= this.computeProbabilityOfCompletionOfAll(children);
			result[topLevelItem.getIdentifier()]= probOfAllChildrenCompleting;
		}
	},

	createParentToLastChildMap: function(graphNodeTable) {
		var result= {};
		for (var i= 0; i < this.topLevelItems.length; i++){
			var topLevelItem= this.topLevelItems[i];
			var children= this.findLastDescendants(topLevelItem, graphNodeTable);
			result[topLevelItem.getIdentifier()]= children;
		}
		return result;
	},

	findLastDescendants: function(topLevelItem, graphNodeTable) {
		var ownerToLastDescendantMap= {};
		var ownerToLastDescendantIndexMap= {};
		var descendants= [];
		this.findNonTopLevelDescendants(topLevelItem, descendants);
		for (var i= 0; i < descendants.length; i++){
			var descendant= descendants[i];
			var owner= this.getOwner(descendant);
			var ownerId= owner == null ? PlanModelAdapter.NO_OWNER_ID : owner.getItemId();
			var ownersChildren= this.ownerElementMap[ownerId];
			var currIndex= ownerToLastDescendantIndexMap[ownerId];
			var newIndex= dojo.indexOf(ownersChildren, descendant);
			if (!(newIndex !== -1)) Assert.fail("newIndex !== -1", "PlanModelAdapter:431");
			if (currIndex == null || newIndex > currIndex) {
				ownerToLastDescendantIndexMap[ownerId]= newIndex;
				var newChild= ownersChildren[newIndex];
				var newChildNode= graphNodeTable[newChild.getIdentifier()];
				ownerToLastDescendantMap[ownerId]= newChildNode;
			}
		}
		var result= [];
		var $subject7= jdojo.getProperties(ownerToLastDescendantMap);
		var $length7= $subject7.length;
		for (var $count7= 0; $count7 < $length7; $count7++){
			var ownerId= $subject7[$count7];
			var lastChildNode= ownerToLastDescendantMap[ownerId];
			result.push(lastChildNode);
		}
		return result;
	},

	/**
	 * Finds the non top-level descendants of the supplied item and stores them in the
	 * supplied descendant array.  Only finds descendants that are in the plan and
	 * are not resolved.
	 * @param item
	 * @param descendants
	 */
	findNonTopLevelDescendants: function(item, descendants) {
		if (!this.isPlanItem(item) || this.isResolved(item)) {
			return ;
		}
		if (!this.isTopLevelItem(item)) {
			descendants.push(item);
			return ;
		}
		var children= this.getChildren(item);
		if (children == null) 
			return ;
		for (var j= 0; j < children.length; j++){
			var child= children[j];
			this.findNonTopLevelDescendants(child, descendants);
		}
	},

	/**
	 * Computes the probability of all the supplied nodes completing by their
	 * schedule end dates, assuming they are all independent.
	 */
	computeProbabilityOfCompletionOfAll: function(nodes) {
		var result= 1.0;
		for (var i= 0; i < nodes.length; i++){
			var child= nodes[i];
			var childProb= child.getProbabilityToComplete();
			result= result * childProb;
		}
		return result;
	},

	isPlanItem: function(item) {
		return dojo.indexOf(this.planElements, item) !== -1;
	},

	getSequenceValue: function(planElement) {
		return planElement.getAttributeValue(IPlanItem.SEQUENCE_VALUE);
	},

	getOwner: function(planElement) {
		return planElement.getAttributeValue(IPlanItem.OWNER);
	},

	isTopLevelItem: function(planElement) {
		var itemType= planElement.getAttributeValue(IPlanItem.ITEM_TYPE);
		if (itemType == null) {
			return false;
		}
		return itemType.isTopLevel();
	},

	isResolved: function(planElement) {
		return planElement.getAttributeValue(IPlanItem.RESOLVED);
	},

	getTarget: function(planElement) {
		if (planElement == null) 
			return null;
		return planElement.getAttributeValue(IPlanItem.TARGET);
	},

	getMinimalEstimate: function(planItem) {
		var result= planItem.getAttributeValue(IPlanItem.MINIMAL_ESTIMATE);
		return result != null ? result : Duration.UNSPECIFIED;
	},

	getEstimate: function(planItem) {
		var result= planItem.getAttributeValue(IPlanItem.ESTIMATE);
		return result != null ? result : Duration.UNSPECIFIED;
	},

	getMaximalEstimate: function(planItem) {
		var result= planItem.getAttributeValue(IPlanItem.MAXIMAL_ESTIMATE);
		return result != null ? result : Duration.UNSPECIFIED;
	},

	getParent: function(planElement) {
		var parentrfs= planElement.getAttributeValue(IPlanItem.PARENT);
		if (parentrfs == null) 
			return null;
		var references= parentrfs.getReferences();
		if (references == null || references.length === 0) 
			return null;
		if (!(references.length <= 1)) Assert.fail("references.length <= 1", "PlanModelAdapter:552");
		if (references[0] == null) 
			return null;
		return this.planModel.getPlanElement(references[0].getItemHandle().getItemId());
	},

	getChildren: function(planElement) {
		var children= [];
		var childrenrfs= planElement.getAttributeValue(IPlanItem.CHILDREN);
		if (childrenrfs == null) 
			return null;
		var references= childrenrfs.getReferences();
		if (references == null || references.length === 0) 
			return null;
		for (var i= 0; i < references.length; i++){
			children[i]= this.planModel.getPlanElement(references[i].getItemHandle().getItemId());
		}
		return children;
	}
});

PlanModelAdapter.NUM_SIMULATION_ITERATIONS= 1000;
PlanModelAdapter.NO_OWNER_ID= "NoOwner"; //$NON-NLS-1$

})();
