/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2010, 2012. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.tempo.shared.client.OwnerScheduledGraph"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.lang.Runtime"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.Graph"); //$NON-NLS-1$

(function() {
var jdojo= com.ibm.jdojo.lang.Runtime;
var Graph= com.ibm.team.tempo.shared.client.Graph;

dojo.declare("com.ibm.team.tempo.shared.client.OwnerScheduledGraph", Graph, { //$NON-NLS-1$

	//ownerGraphNodeTbl: null,

	//graphNodeLst: null,

	constructor: function(graphNodeLst) {
		this.inherited(arguments, []);
		this.ownerGraphNodeTbl= {};
		this.graphNodeLst= graphNodeLst;
		this.buildOwnerGraphNodeTbl(this.graphNodeLst);
		for (var i= 0; i < this.graphNodeLst.length; i++){
			var graphNode= this.graphNodeLst[i];
			graphNode.clearPredecessors();
			this.add(graphNode);
		}
	},

	/**
	 * API
	 */
	getOwnerGraphNodeTbl: function() {
		return this.ownerGraphNodeTbl;
	},

	run: function() {
		this.run_graph(this.getOwnerGraphNodeTbl());
	},

	getGraphNodeLst: function() {
		return this.graphNodeLst;
	},

	buildOwnerGraphNodeTbl: function(graphNodeLst) {
		for (var i= 0; i < graphNodeLst.length; i++){
			var graphNode= graphNodeLst[i];
			if (graphNode.getOwner() == null) {
				graphNode.setOwner("Unknown"); //$NON-NLS-1$
			}
			if (this.ownerGraphNodeTbl[graphNode.getOwner()] != null) {
				this.ownerGraphNodeTbl[graphNode.getOwner()].push(graphNode);
			} else {
				var ownerNodeLst= [];
				ownerNodeLst.push(graphNode);
				this.ownerGraphNodeTbl[graphNode.getOwner()]= ownerNodeLst;
			}
		}
		this.buildResourceDependencies();
	},

	buildResourceDependencies: function() {
		var $subject= jdojo.getProperties(this.ownerGraphNodeTbl);
		var $length= $subject.length;
		for (var $count= 0; $count < $length; $count++){
			var key= $subject[$count];
			var prevGraphNode= null;
			var ownerNodeLst= this.ownerGraphNodeTbl[key];
			for (var j= 0; j < ownerNodeLst.length; j++){
				var graphNode= ownerNodeLst[j];
				var graphNodeId= graphNode.getId();
				var isSuccessor= prevGraphNode != null && !dojo.some(prevGraphNode.getSuccessors(), function(successorKey, index, o) {
					return successorKey === graphNodeId;
				});
				if (isSuccessor) {
					prevGraphNode.addSuccessor(graphNodeId);
				}
				prevGraphNode= graphNode;
			}
		}
	}
});

})();
