/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2010, 2013. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.tempo.shared.client.OptimizationResults"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.lang.Runtime"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.CostDistributionRpt"); //$NON-NLS-1$

(function() {
var jdojo= com.ibm.jdojo.lang.Runtime;
var CostDistributionRpt= com.ibm.team.tempo.shared.client.CostDistributionRpt;

var OptimizationResults= dojo.declare("com.ibm.team.tempo.shared.client.OptimizationResults", null, { //$NON-NLS-1$
	"-chains-": { constructor: "manual" },

	//monteCarloNodeTbl: null,

	//probabilityToComplete: null,

	//costDistribution: null,

	lookupCount: 0,

	constructor: function(costDistribution, lookupCount) {
		this.probabilityToComplete= 0.0;
		this.costDistribution= costDistribution;
		this.lookupCount= lookupCount;
	},

	/**
	 * Returns a table that maps a Work Item ID to a MonteCarlo node
	 */
	getMonteCarloNodeTbl: function() {
		return this.monteCarloNodeTbl;
	},

	setMonteCarloNodeTbl: function(monteCarloNodeTbl) {
		this.monteCarloNodeTbl= monteCarloNodeTbl;
	},

	getCostDistribution: function() {
		return this.costDistribution;
	},

	getLookupCount: function() {
		return this.lookupCount;
	},

	getProbabilityToComplete: function() {
		return this.probabilityToComplete;
	},

	setProbabilityToComplete: function(probabilityToComplete) {
		this.probabilityToComplete= probabilityToComplete;
	},

	getNodeResults: function(graphNode) {
		return this.getMonteCarloNodeTbl()[graphNode.getId()];
	},

	showMonteCarloNodes: function() {
		var str= ""; //$NON-NLS-1$
		var msg= ""; //$NON-NLS-1$
		var monteCarloNodeTbl= this.getMonteCarloNodeTbl();
		str+= msg + "\n"; //$NON-NLS-1$
		var $subject= jdojo.getProperties(monteCarloNodeTbl);
		var $length= $subject.length;
		for (var $count= 0; $count < $length; $count++){
			var id= $subject[$count];
			msg= monteCarloNodeTbl[id].showResults();
			str+= msg + "\n"; //$NON-NLS-1$
		}
		return str;
	},

	toString: function() {
		var buf= ""; //$NON-NLS-1$
		var rpt= new CostDistributionRpt(this.costDistribution);
		rpt.run();
		buf+= rpt.getRptText();
		buf+= "\n\n lookups=" + this.getLookupCount(); //$NON-NLS-1$
		buf+= " probToComplete=" + this.getProbabilityToComplete(); //$NON-NLS-1$
		return buf;
	},

	equals: function(other) {
		if (this === other) 
			return true;
		if (!(other instanceof OptimizationResults)) 
			return false;
		var o= other;
		return ((this.getCostDistribution() === o.getCostDistribution()) && (this.getLookupCount() === o.getLookupCount()));
	}
});

})();
