/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2010, 2012. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.tempo.shared.client.MonteCarloGraphNode"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.lang.Runtime"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.CostDistribution"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.CostDistributionRpt"); //$NON-NLS-1$

(function() {
var jdojo= com.ibm.jdojo.lang.Runtime;
var client= com.ibm.team.tempo.shared.client;
var CostDistribution= client.CostDistribution;
var CostDistributionRpt= client.CostDistributionRpt;

dojo.declare("com.ibm.team.tempo.shared.client.MonteCarloGraphNode", null, { //$NON-NLS-1$
	"-chains-": { constructor: "manual" },

	//modeTbl: null,

	modeCost: 0,

	totCost: 0,

	totSlack: 0,

	targetCost: 0,

	totSlackPlusTotCost: 0,

	effectiveAbilityToCompleteCount: 0,

	ableToCompleteCount: 0,

	onCritPathCount: 0,

	onTargetCount: 0,

	//isWithNodeDistributions: null,

	//costDistribution: null,

	//id: null,

	//estimate: null,

	n: 0,

	//cumulativeCosts: null,

	avgCumulativeCost: 0,

	computedProbabilityOfCompletionPercentage: 0,

	computedAverageSlack: 0,

	averageSlack: 0,

	computedAverageTime: 0,

	//parent: null,

	//ownerId: null,

	constructor: function(graphNode, n, isWithNodeDistributions) {
		this.modeTbl= {};
		this.modeCost= -1.0;
		this.totCost= 0.0;
		this.totSlack= 0.0;
		this.targetCost= 0.0;
		this.totSlackPlusTotCost= 0.0;
		this.effectiveAbilityToCompleteCount= 0;
		this.ableToCompleteCount= 0;
		this.onCritPathCount= 0;
		this.onTargetCount= 0;
		this.isWithNodeDistributions= isWithNodeDistributions;
		this.costDistribution= new CostDistribution(n, null);
		this.cumulativeCosts= [];
		this.avgCumulativeCost= -1.0;
		this.n= n;
		this.parent= graphNode.getParent();
		this.ownerId= graphNode.getOwner();
	},

	/**
	 * API
	 */
	getParent: function() {
		return this.parent;
	},

	setParent: function(parent) {
		this.parent= parent;
	},

	getId: function() {
		return this.id;
	},

	getOnTargetCount: function() {
		return this.onTargetCount;
	},

	getAbleToCompleteCount: function() {
		return this.ableToCompleteCount;
	},

	getOnCritPathCount: function() {
		return this.onCritPathCount;
	},

	getModeCost: function() {
		if (this.modeCost < 0.0) {
			this.computeMode();
		}
		return this.modeCost;
	},

	getAvgCost: function() {
		return this.totCost / this.n;
	},

	getAvgSlack: function() {
		return this.totSlack / this.n;
	},

	getAvgSlackPlusTotCost: function() {
		return this.totSlackPlusTotCost / this.n;
	},

	updateSlack: function(slack) {
		this.totSlack= this.totSlack + slack;
	},

	updateSlackPlusTotCost: function(slackPlusTotCost) {
		this.totSlackPlusTotCost= this.totSlackPlusTotCost + slackPlusTotCost;
	},

	getProbabilityOfOnTime: function() {
		return (this.getOnTargetCount() - 0.0) / (this.n - 0.0);
	},

	getProbabilityToComplete: function() {
		return (this.getAbleToCompleteCount() - 0.0) / (this.n - 0.0);
	},

	/**
	 * @return The probability that this node will complete within the targeted 
	 * duration since the beginning (i.e. node cost + previous node cost + slack time).
	 */
	getEffectiveProbabilityToComplete: function() {
		return (this.effectiveAbilityToCompleteCount - 0.0) / (this.n - 0.0);
	},

	getTargetCost: function() {
		return this.targetCost;
	},

	sortNumber: function(a, b) {
		return a - b;
	},

	getAvgCumulativeCost: function() {
		if (this.avgCumulativeCost < 0.0) {
			var avg= 0.0;
			for (var i= 0; i < this.cumulativeCosts.length; i++){
				avg+= this.cumulativeCosts[i];
			}
			this.avgCumulativeCost= avg / this.cumulativeCosts.length;
		}
		return this.avgCumulativeCost;
	},

	showResults: function() {
		var L= this.estimate.getLowerBound();
		var N= this.estimate.getMiddle();
		var H= this.estimate.getUpperBound();
		var buf= ""; //$NON-NLS-1$
		buf+= " NodeId=" + this.getId(); //$NON-NLS-1$
		buf+= " L/N/H=" + L + "/" + N + "/" + H + " target=" + this.targetCost; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
		buf+= " mode=" + this.getModeCost(); //$NON-NLS-1$
		buf+= " critPathCt=" + this.getOnCritPathCount(); //$NON-NLS-1$
		buf+= " targetCt=" + this.getOnTargetCount(); //$NON-NLS-1$
		buf+= " avgSlack=" + this.getAvgSlack(); //$NON-NLS-1$
		buf+= " avg completion time=" + this.getAvgCumulativeCost(); //$NON-NLS-1$
		buf+= " probToComplete=" + this.getProbabilityToComplete(); //$NON-NLS-1$
		buf+= " effProbToComplete=" + this.getEffectiveProbabilityToComplete(); //$NON-NLS-1$
		return buf;
	},

	updateAbleToCompleteCount: function(overallCost, overallTargetCost) {
		if (overallCost <= overallTargetCost) {
			this.ableToCompleteCount++;
		}
	},

	/**
	 * 
	 * @param effectiveCost The total cost for this node which may include any slack times.
	 * @param effectiveTargetCost
	 */
	updateEffectiveAbilityToCompleteCount: function(cumulativeCost, effectiveTargetCost) {
		if (cumulativeCost <= effectiveTargetCost) {
			this.effectiveAbilityToCompleteCount++;
		}
		this.cumulativeCosts.push(cumulativeCost);
	},

	updateCostFields: function(cost) {
		if (this.isWithNodeDistributions) 
			this.costDistribution.update(cost);
		this.updateModeTbl(cost);
		if (cost <= this.targetCost) 
			this.onTargetCount++;
		this.totCost= this.totCost + cost;
	},

	incrementOnCritPathCount: function() {
		this.onCritPathCount++;
	},

	resetCounters: function() {
		this.effectiveAbilityToCompleteCount= 0;
		this.ableToCompleteCount= 0;
		this.onCritPathCount= 0;
		this.onTargetCount= 0;
		this.modeTbl= {};
		this.modeCost= Number.NaN;
		this.cumulativeCosts= [];
		this.avgCumulativeCost= -1.0;
	},

	updateModeTbl: function(cost) {
		var costStr= Math.round(cost) + ""; //$NON-NLS-1$
		if (this.modeTbl[costStr] != null) {
			var count= Math.round(this.modeTbl[costStr]);
			this.modeTbl[costStr]= count++;
		} else {
			this.modeTbl[costStr]= 1.0;
		}
	},

	/**
	 * Compute which cost appears most frequently.
	 */
	computeMode: function() {
		var prevCount= 0;
		var $subject= jdojo.getProperties(this.modeTbl);
		var $length= $subject.length;
		for (var $count= 0; $count < $length; $count++){
			var key= $subject[$count];
			var count= this.modeTbl[key];
			if (count > prevCount) {
				var d= key;
				this.modeCost= d;
			}
			prevCount= ((count)|0);
		}
	},

	showDistribution: function() {
		var buf= ""; //$NON-NLS-1$
		var rpt= new CostDistributionRpt(this.costDistribution);
		rpt.run();
		return buf;
	},

	setComputedProbabilityOfCompletionPercentage: function(computedProbabilityOfCompletionPercentage) {
		this.computedProbabilityOfCompletionPercentage= computedProbabilityOfCompletionPercentage;
	},

	getComputedProbabilityOfCompletionPercentage: function() {
		return this.computedProbabilityOfCompletionPercentage;
	},

	setComputedAverageSlack: function(computedAverageSlack) {
		this.computedAverageSlack= computedAverageSlack;
	},

	getComputedAverageSlack: function() {
		return this.averageSlack;
	},

	setComputedAverageTime: function(computedAverageTime) {
		this.computedAverageTime= computedAverageTime;
	},

	getComputedAverageTime: function() {
		return this.computedAverageTime;
	}
});

})();
