/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2010, 2012. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  
 * Use, duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp. 
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.tempo.shared.client.ImpactFunc"); //$NON-NLS-1$


(function() {
var ImpactFunc= dojo.declare("com.ibm.team.tempo.shared.client.ImpactFunc", null, { //$NON-NLS-1$
	"-chains-": { constructor: "manual" },

	constructor: function() {
	}
});

ImpactFunc.getVariance= function(pd) {
	return pd.getUpperbound() - pd.getLowerbound();
};
ImpactFunc.getValue= function(pd) {
	var value= ImpactFunc.getVariance(pd);
	return value;
};
ImpactFunc.computeImpact2= function(graphNode, graphNodeTbl) {
	var estimate= graphNode.getEstimate();
	var impactDbl;
	if (!graphNode.isRandomVariate()) {
		impactDbl= 0.0;
	} else {
		if (graphNode.getSuccessors().length === 0) {
			impactDbl= 0.0;
		} else {
			impactDbl= ImpactFunc.getValue(estimate.getPd());
			var successors= graphNode.getSuccessors();
			for (var i= 0; i < successors.length; i++){
				var successor= graphNodeTbl[successors[i]];
				var successorImpact= ImpactFunc.computeImpact2(successor, graphNodeTbl);
				impactDbl= impactDbl + successorImpact / (successors.length - 0.0);
			}
		}
	}
	return impactDbl;
};

})();
